/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.telecom.AudioState;
import android.telecom.CameraCapabilities;
import android.telecom.Conference;
import android.telecom.ConnectionService;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.StatusHints;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.internal.telecom.IVideoCallback;
import com.android.internal.telecom.IVideoProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Connection {
    public static final int STATE_INITIALIZING = 0;
    public static final int STATE_NEW = 1;
    public static final int STATE_RINGING = 2;
    public static final int STATE_DIALING = 3;
    public static final int STATE_ACTIVE = 4;
    public static final int STATE_HOLDING = 5;
    public static final int STATE_DISCONNECTED = 6;
    private static final boolean PII_DEBUG = Log.isLoggable(3);
    private final Listener mConnectionDeathListener = new Listener(){

        @Override
        public void onDestroyed(Connection c) {
            if (Connection.this.mConferenceableConnections.remove(c)) {
                Connection.this.fireOnConferenceableConnectionsChanged();
            }
        }
    };
    private final Set<Listener> mListeners = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
    private final List<Connection> mConferenceableConnections = new ArrayList<Connection>();
    private final List<Connection> mUnmodifiableConferenceableConnections = Collections.unmodifiableList(this.mConferenceableConnections);
    private int mState = 1;
    private AudioState mAudioState;
    private Uri mAddress;
    private int mAddressPresentation;
    private String mCallerDisplayName;
    private int mCallerDisplayNamePresentation;
    private boolean mRingbackRequested = false;
    private int mCallCapabilities;
    private VideoProvider mVideoProvider;
    private boolean mAudioModeIsVoip;
    private StatusHints mStatusHints;
    private int mVideoState;
    private DisconnectCause mDisconnectCause;
    private Conference mConference;
    private ConnectionService mConnectionService;

    public final Uri getAddress() {
        return this.mAddress;
    }

    public final int getAddressPresentation() {
        return this.mAddressPresentation;
    }

    public final String getCallerDisplayName() {
        return this.mCallerDisplayName;
    }

    public final int getCallerDisplayNamePresentation() {
        return this.mCallerDisplayNamePresentation;
    }

    public final int getState() {
        return this.mState;
    }

    public final int getVideoState() {
        return this.mVideoState;
    }

    public final AudioState getAudioState() {
        return this.mAudioState;
    }

    public final Conference getConference() {
        return this.mConference;
    }

    public final boolean isRingbackRequested() {
        return this.mRingbackRequested;
    }

    public final boolean getAudioModeIsVoip() {
        return this.mAudioModeIsVoip;
    }

    public final StatusHints getStatusHints() {
        return this.mStatusHints;
    }

    public final Connection addConnectionListener(Listener l) {
        this.mListeners.add(l);
        return this;
    }

    public final Connection removeConnectionListener(Listener l) {
        if (l != null) {
            this.mListeners.remove(l);
        }
        return this;
    }

    public final DisconnectCause getDisconnectCause() {
        return this.mDisconnectCause;
    }

    final void setAudioState(AudioState state) {
        Log.d(this, "setAudioState %s", state);
        this.mAudioState = state;
        this.onAudioStateChanged(state);
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "STATE_INITIALIZING";
            }
            case 1: {
                return "STATE_NEW";
            }
            case 2: {
                return "STATE_RINGING";
            }
            case 3: {
                return "STATE_DIALING";
            }
            case 4: {
                return "STATE_ACTIVE";
            }
            case 5: {
                return "STATE_HOLDING";
            }
            case 6: {
                return "DISCONNECTED";
            }
        }
        Log.wtf(Connection.class, "Unknown state %d", state);
        return "UNKNOWN";
    }

    public final int getCallCapabilities() {
        return this.mCallCapabilities;
    }

    public final void setAddress(Uri address, int presentation) {
        Log.d(this, "setAddress %s", address);
        this.mAddress = address;
        this.mAddressPresentation = presentation;
        for (Listener l : this.mListeners) {
            l.onAddressChanged(this, address, presentation);
        }
    }

    public final void setCallerDisplayName(String callerDisplayName, int presentation) {
        Log.d(this, "setCallerDisplayName %s", callerDisplayName);
        this.mCallerDisplayName = callerDisplayName;
        this.mCallerDisplayNamePresentation = presentation;
        for (Listener l : this.mListeners) {
            l.onCallerDisplayNameChanged(this, callerDisplayName, presentation);
        }
    }

    public final void setVideoState(int videoState) {
        Log.d(this, "setVideoState %d", videoState);
        this.mVideoState = videoState;
        for (Listener l : this.mListeners) {
            l.onVideoStateChanged(this, this.mVideoState);
        }
    }

    public final void setActive() {
        this.setRingbackRequested(false);
        this.setState(4);
    }

    public final void setRinging() {
        this.setState(2);
    }

    public final void setInitializing() {
        this.setState(0);
    }

    public final void setInitialized() {
        this.setState(1);
    }

    public final void setDialing() {
        this.setState(3);
    }

    public final void setOnHold() {
        this.setState(5);
    }

    public final void setVideoProvider(VideoProvider videoProvider) {
        this.mVideoProvider = videoProvider;
        for (Listener l : this.mListeners) {
            l.onVideoProviderChanged(this, videoProvider);
        }
    }

    public final VideoProvider getVideoProvider() {
        return this.mVideoProvider;
    }

    public final void setDisconnected(DisconnectCause disconnectCause) {
        this.mDisconnectCause = disconnectCause;
        this.setState(6);
        Log.d(this, "Disconnected with cause %s", disconnectCause);
        for (Listener l : this.mListeners) {
            l.onDisconnected(this, disconnectCause);
        }
    }

    public final void setPostDialWait(String remaining) {
        for (Listener l : this.mListeners) {
            l.onPostDialWait(this, remaining);
        }
    }

    public final void setRingbackRequested(boolean ringback) {
        if (this.mRingbackRequested != ringback) {
            this.mRingbackRequested = ringback;
            for (Listener l : this.mListeners) {
                l.onRingbackRequested(this, ringback);
            }
        }
    }

    public final void setCallCapabilities(int callCapabilities) {
        if (this.mCallCapabilities != callCapabilities) {
            this.mCallCapabilities = callCapabilities;
            for (Listener l : this.mListeners) {
                l.onCallCapabilitiesChanged(this, this.mCallCapabilities);
            }
        }
    }

    public final void destroy() {
        for (Listener l : this.mListeners) {
            l.onDestroyed(this);
        }
    }

    public final void setAudioModeIsVoip(boolean isVoip) {
        this.mAudioModeIsVoip = isVoip;
        for (Listener l : this.mListeners) {
            l.onAudioModeIsVoipChanged(this, isVoip);
        }
    }

    public final void setStatusHints(StatusHints statusHints) {
        this.mStatusHints = statusHints;
        for (Listener l : this.mListeners) {
            l.onStatusHintsChanged(this, statusHints);
        }
    }

    public final void setConferenceableConnections(List<Connection> conferenceableConnections) {
        this.clearConferenceableList();
        for (Connection c : conferenceableConnections) {
            if (this.mConferenceableConnections.contains(c)) continue;
            c.addConnectionListener(this.mConnectionDeathListener);
            this.mConferenceableConnections.add(c);
        }
        this.fireOnConferenceableConnectionsChanged();
    }

    public final List<Connection> getConferenceableConnections() {
        return this.mUnmodifiableConferenceableConnections;
    }

    public final void setConnectionService(ConnectionService connectionService) {
        if (this.mConnectionService != null) {
            Log.e(this, (Throwable)new Exception(), "Trying to set ConnectionService on a connection which is already associated with another ConnectionService.", new Object[0]);
        } else {
            this.mConnectionService = connectionService;
        }
    }

    public final void unsetConnectionService(ConnectionService connectionService) {
        if (this.mConnectionService != connectionService) {
            Log.e(this, (Throwable)new Exception(), "Trying to remove ConnectionService from a Connection that does not belong to the ConnectionService.", new Object[0]);
        } else {
            this.mConnectionService = null;
        }
    }

    public final ConnectionService getConnectionService() {
        return this.mConnectionService;
    }

    public final boolean setConference(Conference conference) {
        if (this.mConference == null) {
            this.mConference = conference;
            if (this.mConnectionService != null && this.mConnectionService.containsConference(conference)) {
                this.fireConferenceChanged();
            }
            return true;
        }
        return false;
    }

    public final void resetConference() {
        if (this.mConference != null) {
            Log.d(this, "Conference reset", new Object[0]);
            this.mConference = null;
            this.fireConferenceChanged();
        }
    }

    public void onAudioStateChanged(AudioState state) {
    }

    public void onStateChanged(int state) {
    }

    public void onPlayDtmfTone(char c) {
    }

    public void onStopDtmfTone() {
    }

    public void onDisconnect() {
    }

    public void onSeparate() {
    }

    public void onAbort() {
    }

    public void onHold() {
    }

    public void onUnhold() {
    }

    public void onAnswer(int videoState) {
    }

    public void onAnswer() {
        this.onAnswer(0);
    }

    public void onReject() {
    }

    public void onPostDialContinue(boolean proceed) {
    }

    public void onConferenceWith(Connection otherConnection) {
    }

    static String toLogSafePhoneNumber(String number) {
        if (number == null) {
            return "";
        }
        if (PII_DEBUG) {
            return number;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < number.length(); ++i) {
            char c = number.charAt(i);
            if (c == '-' || c == '@' || c == '.') {
                builder.append(c);
                continue;
            }
            builder.append('x');
        }
        return builder.toString();
    }

    private void setState(int state) {
        if (this.mState == 6 && this.mState != state) {
            Log.d(this, "Connection already DISCONNECTED; cannot transition out of this state.", new Object[0]);
            return;
        }
        if (this.mState != state) {
            Log.d(this, "setState: %s", Connection.stateToString(state));
            this.mState = state;
            this.onStateChanged(state);
            for (Listener l : this.mListeners) {
                l.onStateChanged(this, state);
            }
        }
    }

    public static Connection createFailedConnection(DisconnectCause disconnectCause) {
        return new FailureSignalingConnection(disconnectCause);
    }

    public static Connection createCanceledConnection() {
        return new FailureSignalingConnection(new DisconnectCause(4));
    }

    private final void fireOnConferenceableConnectionsChanged() {
        for (Listener l : this.mListeners) {
            l.onConferenceableConnectionsChanged(this, this.getConferenceableConnections());
        }
    }

    private final void fireConferenceChanged() {
        for (Listener l : this.mListeners) {
            l.onConferenceChanged(this, this.mConference);
        }
    }

    private final void clearConferenceableList() {
        for (Connection c : this.mConferenceableConnections) {
            c.removeConnectionListener(this.mConnectionDeathListener);
        }
        this.mConferenceableConnections.clear();
    }

    private static class FailureSignalingConnection
    extends Connection {
        public FailureSignalingConnection(DisconnectCause disconnectCause) {
            this.setDisconnected(disconnectCause);
        }
    }

    public static abstract class VideoProvider {
        public static final int SESSION_EVENT_RX_PAUSE = 1;
        public static final int SESSION_EVENT_RX_RESUME = 2;
        public static final int SESSION_EVENT_TX_START = 3;
        public static final int SESSION_EVENT_TX_STOP = 4;
        public static final int SESSION_EVENT_CAMERA_FAILURE = 5;
        public static final int SESSION_EVENT_CAMERA_READY = 6;
        public static final int SESSION_MODIFY_REQUEST_SUCCESS = 1;
        public static final int SESSION_MODIFY_REQUEST_FAIL = 2;
        public static final int SESSION_MODIFY_REQUEST_INVALID = 3;
        private static final int MSG_SET_VIDEO_CALLBACK = 1;
        private static final int MSG_SET_CAMERA = 2;
        private static final int MSG_SET_PREVIEW_SURFACE = 3;
        private static final int MSG_SET_DISPLAY_SURFACE = 4;
        private static final int MSG_SET_DEVICE_ORIENTATION = 5;
        private static final int MSG_SET_ZOOM = 6;
        private static final int MSG_SEND_SESSION_MODIFY_REQUEST = 7;
        private static final int MSG_SEND_SESSION_MODIFY_RESPONSE = 8;
        private static final int MSG_REQUEST_CAMERA_CAPABILITIES = 9;
        private static final int MSG_REQUEST_CALL_DATA_USAGE = 10;
        private static final int MSG_SET_PAUSE_IMAGE = 11;
        private final VideoProviderHandler mMessageHandler = new VideoProviderHandler();
        private final VideoProviderBinder mBinder = new VideoProviderBinder();
        private IVideoCallback mVideoCallback;

        public final IVideoProvider getInterface() {
            return this.mBinder;
        }

        public abstract void onSetCamera(String var1);

        public abstract void onSetPreviewSurface(Surface var1);

        public abstract void onSetDisplaySurface(Surface var1);

        public abstract void onSetDeviceOrientation(int var1);

        public abstract void onSetZoom(float var1);

        public abstract void onSendSessionModifyRequest(VideoProfile var1);

        public abstract void onSendSessionModifyResponse(VideoProfile var1);

        public abstract void onRequestCameraCapabilities();

        public abstract void onRequestCallDataUsage();

        public abstract void onSetPauseImage(String var1);

        public void receiveSessionModifyRequest(VideoProfile videoProfile) {
            if (this.mVideoCallback != null) {
                try {
                    this.mVideoCallback.receiveSessionModifyRequest(videoProfile);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        public void receiveSessionModifyResponse(int status, VideoProfile requestedProfile, VideoProfile responseProfile) {
            if (this.mVideoCallback != null) {
                try {
                    this.mVideoCallback.receiveSessionModifyResponse(status, requestedProfile, responseProfile);
                }
                catch (RemoteException ignored) {
                    // empty catch block
                }
            }
        }

        public void handleCallSessionEvent(int event) {
            if (this.mVideoCallback != null) {
                try {
                    this.mVideoCallback.handleCallSessionEvent(event);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        public void changePeerDimensions(int width, int height) {
            if (this.mVideoCallback != null) {
                try {
                    this.mVideoCallback.changePeerDimensions(width, height);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        public void changeCallDataUsage(int dataUsage) {
            if (this.mVideoCallback != null) {
                try {
                    this.mVideoCallback.changeCallDataUsage(dataUsage);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        public void changeCameraCapabilities(CameraCapabilities cameraCapabilities) {
            if (this.mVideoCallback != null) {
                try {
                    this.mVideoCallback.changeCameraCapabilities(cameraCapabilities);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        private final class VideoProviderBinder
        extends IVideoProvider.Stub {
            private VideoProviderBinder() {
            }

            @Override
            public void setVideoCallback(IBinder videoCallbackBinder) {
                VideoProvider.this.mMessageHandler.obtainMessage(1, videoCallbackBinder).sendToTarget();
            }

            @Override
            public void setCamera(String cameraId) {
                VideoProvider.this.mMessageHandler.obtainMessage(2, cameraId).sendToTarget();
            }

            @Override
            public void setPreviewSurface(Surface surface) {
                VideoProvider.this.mMessageHandler.obtainMessage(3, surface).sendToTarget();
            }

            @Override
            public void setDisplaySurface(Surface surface) {
                VideoProvider.this.mMessageHandler.obtainMessage(4, surface).sendToTarget();
            }

            @Override
            public void setDeviceOrientation(int rotation) {
                VideoProvider.this.mMessageHandler.obtainMessage(5, rotation).sendToTarget();
            }

            @Override
            public void setZoom(float value) {
                VideoProvider.this.mMessageHandler.obtainMessage(6, Float.valueOf(value)).sendToTarget();
            }

            @Override
            public void sendSessionModifyRequest(VideoProfile requestProfile) {
                VideoProvider.this.mMessageHandler.obtainMessage(7, requestProfile).sendToTarget();
            }

            @Override
            public void sendSessionModifyResponse(VideoProfile responseProfile) {
                VideoProvider.this.mMessageHandler.obtainMessage(8, responseProfile).sendToTarget();
            }

            @Override
            public void requestCameraCapabilities() {
                VideoProvider.this.mMessageHandler.obtainMessage(9).sendToTarget();
            }

            @Override
            public void requestCallDataUsage() {
                VideoProvider.this.mMessageHandler.obtainMessage(10).sendToTarget();
            }

            @Override
            public void setPauseImage(String uri) {
                VideoProvider.this.mMessageHandler.obtainMessage(11, uri).sendToTarget();
            }
        }

        private final class VideoProviderHandler
        extends Handler {
            private VideoProviderHandler() {
            }

            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        VideoProvider.this.mVideoCallback = IVideoCallback.Stub.asInterface((IBinder)msg.obj);
                        break;
                    }
                    case 2: {
                        VideoProvider.this.onSetCamera((String)msg.obj);
                        break;
                    }
                    case 3: {
                        VideoProvider.this.onSetPreviewSurface((Surface)msg.obj);
                        break;
                    }
                    case 4: {
                        VideoProvider.this.onSetDisplaySurface((Surface)msg.obj);
                        break;
                    }
                    case 5: {
                        VideoProvider.this.onSetDeviceOrientation(msg.arg1);
                        break;
                    }
                    case 6: {
                        VideoProvider.this.onSetZoom(((Float)msg.obj).floatValue());
                        break;
                    }
                    case 7: {
                        VideoProvider.this.onSendSessionModifyRequest((VideoProfile)msg.obj);
                        break;
                    }
                    case 8: {
                        VideoProvider.this.onSendSessionModifyResponse((VideoProfile)msg.obj);
                        break;
                    }
                    case 9: {
                        VideoProvider.this.onRequestCameraCapabilities();
                        break;
                    }
                    case 10: {
                        VideoProvider.this.onRequestCallDataUsage();
                        break;
                    }
                    case 11: {
                        VideoProvider.this.onSetPauseImage((String)msg.obj);
                        break;
                    }
                }
            }
        }
    }

    public static abstract class Listener {
        public void onStateChanged(Connection c, int state) {
        }

        public void onAddressChanged(Connection c, Uri newAddress, int presentation) {
        }

        public void onCallerDisplayNameChanged(Connection c, String callerDisplayName, int presentation) {
        }

        public void onVideoStateChanged(Connection c, int videoState) {
        }

        public void onDisconnected(Connection c, DisconnectCause disconnectCause) {
        }

        public void onPostDialWait(Connection c, String remaining) {
        }

        public void onRingbackRequested(Connection c, boolean ringback) {
        }

        public void onDestroyed(Connection c) {
        }

        public void onCallCapabilitiesChanged(Connection c, int callCapabilities) {
        }

        public void onVideoProviderChanged(Connection c, VideoProvider videoProvider) {
        }

        public void onAudioModeIsVoipChanged(Connection c, boolean isVoip) {
        }

        public void onStatusHintsChanged(Connection c, StatusHints statusHints) {
        }

        public void onConferenceableConnectionsChanged(Connection c, List<Connection> conferenceableConnections) {
        }

        public void onConferenceChanged(Connection c, Conference conference) {
        }
    }
}

