/*
 * Decompiled with CFR 0.152.
 */
package android.speech.srec;

import java.io.IOException;
import java.io.InputStream;

public final class UlawEncoderInputStream
extends InputStream {
    private static final String TAG = "UlawEncoderInputStream";
    private static final int MAX_ULAW = 8192;
    private static final int SCALE_BITS = 16;
    private InputStream mIn;
    private int mMax = 0;
    private final byte[] mBuf = new byte[1024];
    private int mBufCount = 0;
    private final byte[] mOneByte = new byte[1];

    public static void encode(byte[] pcmBuf, int pcmOffset, byte[] ulawBuf, int ulawOffset, int length, int max) {
        if (max <= 0) {
            max = 8192;
        }
        int coef = 0x20000000 / max;
        for (int i = 0; i < length; ++i) {
            int pcm = (0xFF & pcmBuf[pcmOffset++]) + (pcmBuf[pcmOffset++] << 8);
            int ulaw = (pcm = pcm * coef >> 16) >= 0 ? (pcm <= 0 ? 255 : (pcm <= 30 ? 240 + (30 - pcm >> 1) : (pcm <= 94 ? 224 + (94 - pcm >> 2) : (pcm <= 222 ? 208 + (222 - pcm >> 3) : (pcm <= 478 ? 192 + (478 - pcm >> 4) : (pcm <= 990 ? 176 + (990 - pcm >> 5) : (pcm <= 2014 ? 160 + (2014 - pcm >> 6) : (pcm <= 4062 ? 144 + (4062 - pcm >> 7) : (pcm <= 8158 ? 128 + (8158 - pcm >> 8) : 128))))))))) : (-1 <= pcm ? 127 : (-31 <= pcm ? 112 + (pcm - -31 >> 1) : (-95 <= pcm ? 96 + (pcm - -95 >> 2) : (-223 <= pcm ? 80 + (pcm - -223 >> 3) : (-479 <= pcm ? 64 + (pcm - -479 >> 4) : (-991 <= pcm ? 48 + (pcm - -991 >> 5) : (-2015 <= pcm ? 32 + (pcm - -2015 >> 6) : (-4063 <= pcm ? 16 + (pcm - -4063 >> 7) : (-8159 <= pcm ? 0 + (pcm - -8159 >> 8) : 0)))))))));
            ulawBuf[ulawOffset++] = (byte)ulaw;
        }
    }

    public static int maxAbsPcm(byte[] pcmBuf, int offset, int length) {
        int max = 0;
        for (int i = 0; i < length; ++i) {
            int pcm;
            if ((pcm = (0xFF & pcmBuf[offset++]) + (pcmBuf[offset++] << 8)) < 0) {
                pcm = -pcm;
            }
            if (pcm <= max) continue;
            max = pcm;
        }
        return max;
    }

    public UlawEncoderInputStream(InputStream in, int max) {
        this.mIn = in;
        this.mMax = max;
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        int n;
        if (this.mIn == null) {
            throw new IllegalStateException("not open");
        }
        while (this.mBufCount < 2) {
            n = this.mIn.read(this.mBuf, this.mBufCount, Math.min(length * 2, this.mBuf.length - this.mBufCount));
            if (n == -1) {
                return -1;
            }
            this.mBufCount += n;
        }
        n = Math.min(this.mBufCount / 2, length);
        UlawEncoderInputStream.encode(this.mBuf, 0, buf, offset, n, this.mMax);
        this.mBufCount -= n * 2;
        for (int i = 0; i < this.mBufCount; ++i) {
            this.mBuf[i] = this.mBuf[i + n * 2];
        }
        return n;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.mOneByte, 0, 1);
        if (n == -1) {
            return -1;
        }
        return 0xFF & this.mOneByte[0];
    }

    @Override
    public void close() throws IOException {
        if (this.mIn != null) {
            InputStream in = this.mIn;
            this.mIn = null;
            in.close();
        }
    }

    @Override
    public int available() throws IOException {
        return (this.mIn.available() + this.mBufCount) / 2;
    }
}

