/*
 * Decompiled with CFR 0.152.
 */
package android.service.trust;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.service.trust.ITrustAgentService;
import android.service.trust.ITrustAgentServiceCallback;
import android.util.Log;
import android.util.Slog;

public class TrustAgentService
extends Service {
    private final String TAG = TrustAgentService.class.getSimpleName() + "[" + this.getClass().getSimpleName() + "]";
    private static final boolean DEBUG = false;
    public static final String SERVICE_INTERFACE = "android.service.trust.TrustAgentService";
    public static final String TRUST_AGENT_META_DATA = "android.service.trust.trustagent";
    public static final String KEY_FEATURES = "trust_agent_features";
    private static final int MSG_UNLOCK_ATTEMPT = 1;
    private static final int MSG_SET_TRUST_AGENT_FEATURES_ENABLED = 2;
    private static final int MSG_TRUST_TIMEOUT = 3;
    private ITrustAgentServiceCallback mCallback;
    private Runnable mPendingGrantTrustTask;
    private boolean mManagingTrust;
    private final Object mLock = new Object();
    private Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    TrustAgentService.this.onUnlockAttempt(msg.arg1 != 0);
                    return;
                }
                case 2: {
                    Bundle features = msg.peekData();
                    IBinder token = (IBinder)msg.obj;
                    boolean result = TrustAgentService.this.onSetTrustAgentFeaturesEnabled(features);
                    try {
                        Object object = TrustAgentService.this.mLock;
                        synchronized (object) {
                            TrustAgentService.this.mCallback.onSetTrustAgentFeaturesEnabledCompleted(result, token);
                            return;
                        }
                    }
                    catch (RemoteException e) {
                        TrustAgentService.this.onError("calling onSetTrustAgentFeaturesEnabledCompleted()");
                    }
                    return;
                }
                case 3: {
                    TrustAgentService.this.onTrustTimeout();
                }
            }
        }
    };

    @Override
    public void onCreate() {
        super.onCreate();
        ComponentName component = new ComponentName((Context)this, this.getClass());
        try {
            ServiceInfo serviceInfo = this.getPackageManager().getServiceInfo(component, 0);
            if (!"android.permission.BIND_TRUST_AGENT".equals(serviceInfo.permission)) {
                throw new IllegalStateException(component.flattenToShortString() + " is not declared with the permission " + "\"" + "android.permission.BIND_TRUST_AGENT" + "\"");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(this.TAG, "Can't get ServiceInfo for " + component.toShortString());
        }
    }

    public void onUnlockAttempt(boolean successful) {
    }

    public void onTrustTimeout() {
    }

    private void onError(String msg) {
        Slog.v(this.TAG, "Remote exception while " + msg);
    }

    public boolean onSetTrustAgentFeaturesEnabled(Bundle options) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void grantTrust(final CharSequence message, final long durationMs, final boolean initiatedByUser) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mManagingTrust) {
                throw new IllegalStateException("Cannot grant trust if agent is not managing trust. Call setManagingTrust(true) first.");
            }
            if (this.mCallback != null) {
                try {
                    this.mCallback.grantTrust(message.toString(), durationMs, initiatedByUser);
                }
                catch (RemoteException e) {
                    this.onError("calling enableTrust()");
                }
            } else {
                this.mPendingGrantTrustTask = new Runnable(){

                    @Override
                    public void run() {
                        TrustAgentService.this.grantTrust(message, durationMs, initiatedByUser);
                    }
                };
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void revokeTrust() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPendingGrantTrustTask != null) {
                this.mPendingGrantTrustTask = null;
            }
            if (this.mCallback != null) {
                try {
                    this.mCallback.revokeTrust();
                }
                catch (RemoteException e) {
                    this.onError("calling revokeTrust()");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setManagingTrust(boolean managingTrust) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mManagingTrust != managingTrust) {
                this.mManagingTrust = managingTrust;
                if (this.mCallback != null) {
                    try {
                        this.mCallback.setManagingTrust(managingTrust);
                    }
                    catch (RemoteException e) {
                        this.onError("calling setManagingTrust()");
                    }
                }
            }
        }
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return new TrustAgentServiceWrapper();
    }

    private final class TrustAgentServiceWrapper
    extends ITrustAgentService.Stub {
        private TrustAgentServiceWrapper() {
        }

        @Override
        public void onUnlockAttempt(boolean successful) {
            TrustAgentService.this.mHandler.obtainMessage(1, successful ? 1 : 0, 0).sendToTarget();
        }

        @Override
        public void onTrustTimeout() {
            TrustAgentService.this.mHandler.sendEmptyMessage(3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCallback(ITrustAgentServiceCallback callback) {
            Object object = TrustAgentService.this.mLock;
            synchronized (object) {
                TrustAgentService.this.mCallback = callback;
                if (TrustAgentService.this.mManagingTrust) {
                    try {
                        TrustAgentService.this.mCallback.setManagingTrust(TrustAgentService.this.mManagingTrust);
                    }
                    catch (RemoteException e) {
                        TrustAgentService.this.onError("calling setManagingTrust()");
                    }
                }
                if (TrustAgentService.this.mPendingGrantTrustTask != null) {
                    TrustAgentService.this.mPendingGrantTrustTask.run();
                    TrustAgentService.this.mPendingGrantTrustTask = null;
                }
            }
        }

        @Override
        public void setTrustAgentFeaturesEnabled(Bundle features, IBinder token) {
            Message msg = TrustAgentService.this.mHandler.obtainMessage(2, token);
            msg.setData(features);
            msg.sendToTarget();
        }
    }
}

