/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.Matrix4f;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Script;
import android.renderscript.ScriptIntrinsic;

public final class ScriptIntrinsicLUT
extends ScriptIntrinsic {
    private final Matrix4f mMatrix = new Matrix4f();
    private Allocation mTables;
    private final byte[] mCache = new byte[1024];
    private boolean mDirty = true;

    private ScriptIntrinsicLUT(long id2, RenderScript rs) {
        super(id2, rs);
        this.mTables = Allocation.createSized(rs, Element.U8(rs), 1024);
        for (int ct = 0; ct < 256; ++ct) {
            this.mCache[ct] = (byte)ct;
            this.mCache[ct + 256] = (byte)ct;
            this.mCache[ct + 512] = (byte)ct;
            this.mCache[ct + 768] = (byte)ct;
        }
        this.setVar(0, this.mTables);
    }

    public static ScriptIntrinsicLUT create(RenderScript rs, Element e) {
        long id2 = rs.nScriptIntrinsicCreate(3, e.getID(rs));
        return new ScriptIntrinsicLUT(id2, rs);
    }

    private void validate(int index, int value) {
        if (index < 0 || index > 255) {
            throw new RSIllegalArgumentException("Index out of range (0-255).");
        }
        if (value < 0 || value > 255) {
            throw new RSIllegalArgumentException("Value out of range (0-255).");
        }
    }

    public void setRed(int index, int value) {
        this.validate(index, value);
        this.mCache[index] = (byte)value;
        this.mDirty = true;
    }

    public void setGreen(int index, int value) {
        this.validate(index, value);
        this.mCache[index + 256] = (byte)value;
        this.mDirty = true;
    }

    public void setBlue(int index, int value) {
        this.validate(index, value);
        this.mCache[index + 512] = (byte)value;
        this.mDirty = true;
    }

    public void setAlpha(int index, int value) {
        this.validate(index, value);
        this.mCache[index + 768] = (byte)value;
        this.mDirty = true;
    }

    public void forEach(Allocation ain, Allocation aout) {
        this.forEach(ain, aout, null);
    }

    public void forEach(Allocation ain, Allocation aout, Script.LaunchOptions opt) {
        if (this.mDirty) {
            this.mDirty = false;
            this.mTables.copyFromUnchecked(this.mCache);
        }
        this.forEach(0, ain, aout, null, opt);
    }

    public Script.KernelID getKernelID() {
        return this.createKernelID(0, 3, null, null);
    }
}

