/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.provider.BaseColumns;
import android.text.TextUtils;
import java.util.Locale;

public class UserDictionary {
    public static final String AUTHORITY = "user_dictionary";
    public static final Uri CONTENT_URI = Uri.parse("content://user_dictionary");
    private static final int FREQUENCY_MIN = 0;
    private static final int FREQUENCY_MAX = 255;

    public static class Words
    implements BaseColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://user_dictionary/words");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/vnd.google.userword";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.google.userword";
        public static final String _ID = "_id";
        public static final String WORD = "word";
        public static final String FREQUENCY = "frequency";
        public static final String LOCALE = "locale";
        public static final String APP_ID = "appid";
        public static final String SHORTCUT = "shortcut";
        @Deprecated
        public static final int LOCALE_TYPE_ALL = 0;
        @Deprecated
        public static final int LOCALE_TYPE_CURRENT = 1;
        public static final String DEFAULT_SORT_ORDER = "frequency DESC";

        @Deprecated
        public static void addWord(Context context, String word, int frequency, int localeType) {
            if (localeType != 0 && localeType != 1) {
                return;
            }
            Locale locale = localeType == 1 ? Locale.getDefault() : null;
            Words.addWord(context, word, frequency, null, locale);
        }

        public static void addWord(Context context, String word, int frequency, String shortcut, Locale locale) {
            ContentResolver resolver = context.getContentResolver();
            if (TextUtils.isEmpty(word)) {
                return;
            }
            if (frequency < 0) {
                frequency = 0;
            }
            if (frequency > 255) {
                frequency = 255;
            }
            int COLUMN_COUNT = 5;
            ContentValues values = new ContentValues(5);
            values.put(WORD, word);
            values.put(FREQUENCY, frequency);
            values.put(LOCALE, null == locale ? null : locale.toString());
            values.put(APP_ID, 0);
            values.put(SHORTCUT, shortcut);
            Uri result = resolver.insert(CONTENT_URI, values);
        }
    }
}

