/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Looper;
import android.os.Process;

public class HandlerThread
extends Thread {
    int mPriority;
    int mTid = -1;
    Looper mLooper;

    public HandlerThread(String name) {
        super(name);
        this.mPriority = 0;
    }

    public HandlerThread(String name, int priority) {
        super(name);
        this.mPriority = priority;
    }

    protected void onLooperPrepared() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.mTid = Process.myTid();
        Looper.prepare();
        HandlerThread handlerThread = this;
        synchronized (handlerThread) {
            this.mLooper = Looper.myLooper();
            this.notifyAll();
        }
        Process.setThreadPriority(this.mPriority);
        this.onLooperPrepared();
        Looper.loop();
        this.mTid = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Looper getLooper() {
        if (!this.isAlive()) {
            return null;
        }
        HandlerThread handlerThread = this;
        synchronized (handlerThread) {
            while (this.isAlive() && this.mLooper == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.mLooper;
    }

    public boolean quit() {
        Looper looper = this.getLooper();
        if (looper != null) {
            looper.quit();
            return true;
        }
        return false;
    }

    public boolean quitSafely() {
        Looper looper = this.getLooper();
        if (looper != null) {
            looper.quitSafely();
            return true;
        }
        return false;
    }

    public int getThreadId() {
        return this.mTid;
    }
}

