/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.FileUtils;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.storage.IMountService;
import android.os.storage.StorageVolume;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class Environment {
    private static final String TAG = "Environment";
    private static final String ENV_EXTERNAL_STORAGE = "EXTERNAL_STORAGE";
    private static final String ENV_EMULATED_STORAGE_SOURCE = "EMULATED_STORAGE_SOURCE";
    private static final String ENV_EMULATED_STORAGE_TARGET = "EMULATED_STORAGE_TARGET";
    private static final String ENV_MEDIA_STORAGE = "MEDIA_STORAGE";
    private static final String ENV_SECONDARY_STORAGE = "SECONDARY_STORAGE";
    private static final String ENV_ANDROID_ROOT = "ANDROID_ROOT";
    private static final String ENV_OEM_ROOT = "OEM_ROOT";
    private static final String ENV_VENDOR_ROOT = "VENDOR_ROOT";
    public static final String DIR_ANDROID = "Android";
    private static final String DIR_DATA = "data";
    private static final String DIR_MEDIA = "media";
    private static final String DIR_OBB = "obb";
    private static final String DIR_FILES = "files";
    private static final String DIR_CACHE = "cache";
    @Deprecated
    public static final String DIRECTORY_ANDROID = "Android";
    private static final File DIR_ANDROID_ROOT = Environment.getDirectory("ANDROID_ROOT", "/system");
    private static final File DIR_OEM_ROOT = Environment.getDirectory("OEM_ROOT", "/oem");
    private static final File DIR_VENDOR_ROOT = Environment.getDirectory("VENDOR_ROOT", "/vendor");
    private static final File DIR_MEDIA_STORAGE = Environment.getDirectory("MEDIA_STORAGE", "/data/media");
    private static final String CANONCIAL_EMULATED_STORAGE_TARGET = Environment.getCanonicalPathOrNull("EMULATED_STORAGE_TARGET");
    private static final String SYSTEM_PROPERTY_EFS_ENABLED = "persist.security.efs.enabled";
    private static UserEnvironment sCurrentUser;
    private static boolean sUserRequired;
    private static final File DATA_DIRECTORY;
    private static final File SECURE_DATA_DIRECTORY;
    private static final File DOWNLOAD_CACHE_DIRECTORY;
    public static String DIRECTORY_MUSIC;
    public static String DIRECTORY_PODCASTS;
    public static String DIRECTORY_RINGTONES;
    public static String DIRECTORY_ALARMS;
    public static String DIRECTORY_NOTIFICATIONS;
    public static String DIRECTORY_PICTURES;
    public static String DIRECTORY_MOVIES;
    public static String DIRECTORY_DOWNLOADS;
    public static String DIRECTORY_DCIM;
    public static String DIRECTORY_DOCUMENTS;
    public static final String MEDIA_UNKNOWN = "unknown";
    public static final String MEDIA_REMOVED = "removed";
    public static final String MEDIA_UNMOUNTED = "unmounted";
    public static final String MEDIA_CHECKING = "checking";
    public static final String MEDIA_NOFS = "nofs";
    public static final String MEDIA_MOUNTED = "mounted";
    public static final String MEDIA_MOUNTED_READ_ONLY = "mounted_ro";
    public static final String MEDIA_SHARED = "shared";
    public static final String MEDIA_BAD_REMOVAL = "bad_removal";
    public static final String MEDIA_UNMOUNTABLE = "unmountable";

    public static void initForCurrentUser() {
        int userId = UserHandle.myUserId();
        sCurrentUser = new UserEnvironment(userId);
    }

    public static File getRootDirectory() {
        return DIR_ANDROID_ROOT;
    }

    public static File getOemDirectory() {
        return DIR_OEM_ROOT;
    }

    public static File getVendorDirectory() {
        return DIR_VENDOR_ROOT;
    }

    public static File getSystemSecureDirectory() {
        if (Environment.isEncryptedFilesystemEnabled()) {
            return new File(SECURE_DATA_DIRECTORY, "system");
        }
        return new File(DATA_DIRECTORY, "system");
    }

    public static File getSecureDataDirectory() {
        if (Environment.isEncryptedFilesystemEnabled()) {
            return SECURE_DATA_DIRECTORY;
        }
        return DATA_DIRECTORY;
    }

    public static File getMediaStorageDirectory() {
        Environment.throwIfUserRequired();
        return sCurrentUser.getMediaDir();
    }

    public static File getUserSystemDirectory(int userId) {
        return new File(new File(Environment.getSystemSecureDirectory(), "users"), Integer.toString(userId));
    }

    public static File getUserConfigDirectory(int userId) {
        return new File(new File(new File(Environment.getDataDirectory(), "misc"), "user"), Integer.toString(userId));
    }

    public static boolean isEncryptedFilesystemEnabled() {
        return SystemProperties.getBoolean(SYSTEM_PROPERTY_EFS_ENABLED, false);
    }

    public static File getDataDirectory() {
        return DATA_DIRECTORY;
    }

    public static File getExternalStorageDirectory() {
        Environment.throwIfUserRequired();
        return sCurrentUser.getExternalDirsForApp()[0];
    }

    public static File getLegacyExternalStorageDirectory() {
        return new File(System.getenv(ENV_EXTERNAL_STORAGE));
    }

    public static File getLegacyExternalStorageObbDirectory() {
        return Environment.buildPath(Environment.getLegacyExternalStorageDirectory(), "Android", DIR_OBB);
    }

    public static File getEmulatedStorageSource(int userId) {
        return new File(System.getenv(ENV_EMULATED_STORAGE_SOURCE), String.valueOf(userId));
    }

    public static File getEmulatedStorageObbSource() {
        return new File(System.getenv(ENV_EMULATED_STORAGE_SOURCE), DIR_OBB);
    }

    public static File getExternalStoragePublicDirectory(String type) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStoragePublicDirs(type)[0];
    }

    public static File[] buildExternalStorageAndroidDataDirs() {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAndroidDataDirs();
    }

    public static File[] buildExternalStorageAppDataDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppDataDirs(packageName);
    }

    public static File[] buildExternalStorageAppMediaDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppMediaDirs(packageName);
    }

    public static File[] buildExternalStorageAppObbDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppObbDirs(packageName);
    }

    public static File[] buildExternalStorageAppFilesDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppFilesDirs(packageName);
    }

    public static File[] buildExternalStorageAppCacheDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppCacheDirs(packageName);
    }

    public static File getDownloadCacheDirectory() {
        return DOWNLOAD_CACHE_DIRECTORY;
    }

    public static String getExternalStorageState() {
        File externalDir = sCurrentUser.getExternalDirsForApp()[0];
        return Environment.getExternalStorageState(externalDir);
    }

    @Deprecated
    public static String getStorageState(File path) {
        return Environment.getExternalStorageState(path);
    }

    public static String getExternalStorageState(File path) {
        StorageVolume volume = Environment.getStorageVolume(path);
        if (volume != null) {
            IMountService mountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
            try {
                return mountService.getVolumeState(volume.getPath());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return MEDIA_UNKNOWN;
    }

    public static boolean isExternalStorageRemovable() {
        if (Environment.isStorageDisabled()) {
            return false;
        }
        File externalDir = sCurrentUser.getExternalDirsForApp()[0];
        return Environment.isExternalStorageRemovable(externalDir);
    }

    public static boolean isExternalStorageRemovable(File path) {
        StorageVolume volume = Environment.getStorageVolume(path);
        if (volume != null) {
            return volume.isRemovable();
        }
        throw new IllegalArgumentException("Failed to find storage device at " + path);
    }

    public static boolean isExternalStorageEmulated() {
        if (Environment.isStorageDisabled()) {
            return false;
        }
        File externalDir = sCurrentUser.getExternalDirsForApp()[0];
        return Environment.isExternalStorageEmulated(externalDir);
    }

    public static boolean isExternalStorageEmulated(File path) {
        StorageVolume volume = Environment.getStorageVolume(path);
        if (volume != null) {
            return volume.isEmulated();
        }
        throw new IllegalArgumentException("Failed to find storage device at " + path);
    }

    static File getDirectory(String variableName, String defaultPath) {
        String path = System.getenv(variableName);
        return path == null ? new File(defaultPath) : new File(path);
    }

    private static String getCanonicalPathOrNull(String variableName) {
        String path = System.getenv(variableName);
        if (path == null) {
            return null;
        }
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            Log.w(TAG, "Unable to resolve canonical path for " + path);
            return null;
        }
    }

    public static void setUserRequired(boolean userRequired) {
        sUserRequired = userRequired;
    }

    private static void throwIfUserRequired() {
        if (sUserRequired) {
            Log.wtf(TAG, "Path requests must specify a user by using UserEnvironment", new Throwable());
        }
    }

    public static File[] buildPaths(File[] base, String ... segments) {
        File[] result = new File[base.length];
        for (int i = 0; i < base.length; ++i) {
            result[i] = Environment.buildPath(base[i], segments);
        }
        return result;
    }

    public static File buildPath(File base, String ... segments) {
        File cur = base;
        for (String segment : segments) {
            cur = cur == null ? new File(segment) : new File(cur, segment);
        }
        return cur;
    }

    private static boolean isStorageDisabled() {
        return SystemProperties.getBoolean("config.disable_storage", false);
    }

    private static StorageVolume getStorageVolume(File path) {
        try {
            path = path.getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
        try {
            StorageVolume[] volumes;
            IMountService mountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
            for (StorageVolume volume : volumes = mountService.getVolumeList()) {
                if (!FileUtils.contains(volume.getPathFile(), path)) continue;
                return volume;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public static File maybeTranslateEmulatedPathToInternal(File path) {
        if (!Environment.isExternalStorageEmulated() || CANONCIAL_EMULATED_STORAGE_TARGET == null) {
            return path;
        }
        try {
            File internalPath;
            String rawPath = path.getCanonicalPath();
            if (rawPath.startsWith(CANONCIAL_EMULATED_STORAGE_TARGET) && (internalPath = new File(DIR_MEDIA_STORAGE, rawPath.substring(CANONCIAL_EMULATED_STORAGE_TARGET.length()))).exists()) {
                return internalPath;
            }
        }
        catch (IOException e) {
            Log.w(TAG, "Failed to resolve canonical path for " + path);
        }
        return path;
    }

    static {
        Environment.initForCurrentUser();
        DATA_DIRECTORY = Environment.getDirectory("ANDROID_DATA", "/data");
        SECURE_DATA_DIRECTORY = Environment.getDirectory("ANDROID_SECURE_DATA", "/data/secure");
        DOWNLOAD_CACHE_DIRECTORY = Environment.getDirectory("DOWNLOAD_CACHE", "/cache");
        DIRECTORY_MUSIC = "Music";
        DIRECTORY_PODCASTS = "Podcasts";
        DIRECTORY_RINGTONES = "Ringtones";
        DIRECTORY_ALARMS = "Alarms";
        DIRECTORY_NOTIFICATIONS = "Notifications";
        DIRECTORY_PICTURES = "Pictures";
        DIRECTORY_MOVIES = "Movies";
        DIRECTORY_DOWNLOADS = "Download";
        DIRECTORY_DCIM = "DCIM";
        DIRECTORY_DOCUMENTS = "Documents";
    }

    public static class UserEnvironment {
        private final File[] mExternalDirsForVold;
        private final File[] mExternalDirsForApp;
        private final File mEmulatedDirForDirect;

        public UserEnvironment(int userId) {
            String rawExternalStorage = System.getenv(Environment.ENV_EXTERNAL_STORAGE);
            String rawEmulatedSource = System.getenv(Environment.ENV_EMULATED_STORAGE_SOURCE);
            String rawEmulatedTarget = System.getenv(Environment.ENV_EMULATED_STORAGE_TARGET);
            String rawMediaStorage = System.getenv(Environment.ENV_MEDIA_STORAGE);
            if (TextUtils.isEmpty(rawMediaStorage)) {
                rawMediaStorage = "/data/media";
            }
            ArrayList<File> externalForVold = Lists.newArrayList();
            ArrayList<File> externalForApp = Lists.newArrayList();
            if (!TextUtils.isEmpty(rawEmulatedTarget)) {
                String rawUserId = Integer.toString(userId);
                File emulatedSourceBase = new File(rawEmulatedSource);
                File emulatedTargetBase = new File(rawEmulatedTarget);
                File mediaBase = new File(rawMediaStorage);
                externalForVold.add(Environment.buildPath(emulatedSourceBase, rawUserId));
                externalForApp.add(Environment.buildPath(emulatedTargetBase, rawUserId));
                this.mEmulatedDirForDirect = Environment.buildPath(mediaBase, rawUserId);
            } else {
                if (TextUtils.isEmpty(rawExternalStorage)) {
                    Log.w(Environment.TAG, "EXTERNAL_STORAGE undefined; falling back to default");
                    rawExternalStorage = "/storage/sdcard0";
                }
                externalForVold.add(new File(rawExternalStorage));
                externalForApp.add(new File(rawExternalStorage));
                this.mEmulatedDirForDirect = new File(rawMediaStorage);
            }
            String rawSecondaryStorage = System.getenv(Environment.ENV_SECONDARY_STORAGE);
            if (!TextUtils.isEmpty(rawSecondaryStorage) && userId == 0) {
                for (String secondaryPath : rawSecondaryStorage.split(":")) {
                    externalForVold.add(new File(secondaryPath));
                    externalForApp.add(new File(secondaryPath));
                }
            }
            this.mExternalDirsForVold = externalForVold.toArray(new File[externalForVold.size()]);
            this.mExternalDirsForApp = externalForApp.toArray(new File[externalForApp.size()]);
        }

        @Deprecated
        public File getExternalStorageDirectory() {
            return this.mExternalDirsForApp[0];
        }

        @Deprecated
        public File getExternalStoragePublicDirectory(String type) {
            return this.buildExternalStoragePublicDirs(type)[0];
        }

        public File[] getExternalDirsForVold() {
            return this.mExternalDirsForVold;
        }

        public File[] getExternalDirsForApp() {
            return this.mExternalDirsForApp;
        }

        public File getMediaDir() {
            return this.mEmulatedDirForDirect;
        }

        public File[] buildExternalStoragePublicDirs(String type) {
            return Environment.buildPaths(this.mExternalDirsForApp, type);
        }

        public File[] buildExternalStorageAndroidDataDirs() {
            return Environment.buildPaths(this.mExternalDirsForApp, "Android", Environment.DIR_DATA);
        }

        public File[] buildExternalStorageAndroidObbDirs() {
            return Environment.buildPaths(this.mExternalDirsForApp, "Android", Environment.DIR_OBB);
        }

        public File[] buildExternalStorageAppDataDirs(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForApp, "Android", Environment.DIR_DATA, packageName);
        }

        public File[] buildExternalStorageAppDataDirsForVold(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForVold, "Android", Environment.DIR_DATA, packageName);
        }

        public File[] buildExternalStorageAppMediaDirs(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForApp, "Android", Environment.DIR_MEDIA, packageName);
        }

        public File[] buildExternalStorageAppMediaDirsForVold(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForVold, "Android", Environment.DIR_MEDIA, packageName);
        }

        public File[] buildExternalStorageAppObbDirs(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForApp, "Android", Environment.DIR_OBB, packageName);
        }

        public File[] buildExternalStorageAppObbDirsForVold(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForVold, "Android", Environment.DIR_OBB, packageName);
        }

        public File[] buildExternalStorageAppFilesDirs(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForApp, "Android", Environment.DIR_DATA, packageName, Environment.DIR_FILES);
        }

        public File[] buildExternalStorageAppCacheDirs(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForApp, "Android", Environment.DIR_DATA, packageName, Environment.DIR_CACHE);
        }
    }
}

