/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.net.wifi.p2p.WifiP2pGroup;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.LruCache;
import java.util.Collection;
import java.util.Map;

public class WifiP2pGroupList
implements Parcelable {
    private static final int CREDENTIAL_MAX_NUM = 32;
    private final LruCache<Integer, WifiP2pGroup> mGroups;
    private final GroupDeleteListener mListener;
    private boolean isClearCalled = false;
    public static final Parcelable.Creator<WifiP2pGroupList> CREATOR = new Parcelable.Creator<WifiP2pGroupList>(){

        @Override
        public WifiP2pGroupList createFromParcel(Parcel in) {
            WifiP2pGroupList grpList = new WifiP2pGroupList();
            int deviceCount = in.readInt();
            for (int i = 0; i < deviceCount; ++i) {
                grpList.add((WifiP2pGroup)in.readParcelable(null));
            }
            return grpList;
        }

        public WifiP2pGroupList[] newArray(int size) {
            return new WifiP2pGroupList[size];
        }
    };

    public WifiP2pGroupList() {
        this(null, null);
    }

    public WifiP2pGroupList(WifiP2pGroupList source, GroupDeleteListener listener) {
        this.mListener = listener;
        this.mGroups = new LruCache<Integer, WifiP2pGroup>(32){

            @Override
            protected void entryRemoved(boolean evicted, Integer netId, WifiP2pGroup oldValue, WifiP2pGroup newValue) {
                if (WifiP2pGroupList.this.mListener != null && !WifiP2pGroupList.this.isClearCalled) {
                    WifiP2pGroupList.this.mListener.onDeleteGroup(oldValue.getNetworkId());
                }
            }
        };
        if (source != null) {
            for (Map.Entry<Integer, WifiP2pGroup> item : source.mGroups.snapshot().entrySet()) {
                this.mGroups.put(item.getKey(), item.getValue());
            }
        }
    }

    public Collection<WifiP2pGroup> getGroupList() {
        return this.mGroups.snapshot().values();
    }

    public void add(WifiP2pGroup group) {
        this.mGroups.put(group.getNetworkId(), group);
    }

    public void remove(int netId) {
        this.mGroups.remove(netId);
    }

    void remove(String deviceAddress) {
        this.remove(this.getNetworkId(deviceAddress));
    }

    public boolean clear() {
        if (this.mGroups.size() == 0) {
            return false;
        }
        this.isClearCalled = true;
        this.mGroups.evictAll();
        this.isClearCalled = false;
        return true;
    }

    public int getNetworkId(String deviceAddress) {
        if (deviceAddress == null) {
            return -1;
        }
        Collection<WifiP2pGroup> groups = this.mGroups.snapshot().values();
        for (WifiP2pGroup grp : groups) {
            if (!deviceAddress.equalsIgnoreCase(grp.getOwner().deviceAddress)) continue;
            this.mGroups.get(grp.getNetworkId());
            return grp.getNetworkId();
        }
        return -1;
    }

    public int getNetworkId(String deviceAddress, String ssid) {
        if (deviceAddress == null || ssid == null) {
            return -1;
        }
        Collection<WifiP2pGroup> groups = this.mGroups.snapshot().values();
        for (WifiP2pGroup grp : groups) {
            if (!deviceAddress.equalsIgnoreCase(grp.getOwner().deviceAddress) || !ssid.equals(grp.getNetworkName())) continue;
            this.mGroups.get(grp.getNetworkId());
            return grp.getNetworkId();
        }
        return -1;
    }

    public String getOwnerAddr(int netId) {
        WifiP2pGroup grp = this.mGroups.get(netId);
        if (grp != null) {
            return grp.getOwner().deviceAddress;
        }
        return null;
    }

    public boolean contains(int netId) {
        Collection<WifiP2pGroup> groups = this.mGroups.snapshot().values();
        for (WifiP2pGroup grp : groups) {
            if (netId != grp.getNetworkId()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        Collection<WifiP2pGroup> groups = this.mGroups.snapshot().values();
        for (WifiP2pGroup grp : groups) {
            sbuf.append(grp).append("\n");
        }
        return sbuf.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Collection<WifiP2pGroup> groups = this.mGroups.snapshot().values();
        dest.writeInt(groups.size());
        for (WifiP2pGroup group : groups) {
            dest.writeParcelable(group, flags);
        }
    }

    public static interface GroupDeleteListener {
        public void onDeleteGroup(int var1);
    }
}

