/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.net.wifi.IWifiScanner;
import android.net.wifi.ScanResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class WifiScanner {
    public static final int WIFI_BAND_UNSPECIFIED = 0;
    public static final int WIFI_BAND_24_GHZ = 1;
    public static final int WIFI_BAND_5_GHZ = 2;
    public static final int WIFI_BAND_5_GHZ_DFS_ONLY = 4;
    public static final int WIFI_BAND_5_GHZ_WITH_DFS = 6;
    public static final int WIFI_BAND_BOTH = 3;
    public static final int WIFI_BAND_BOTH_WITH_DFS = 7;
    public static final int MIN_SCAN_PERIOD_MS = 1000;
    public static final int MAX_SCAN_PERIOD_MS = 1024000;
    public static final int REASON_SUCCEEDED = 0;
    public static final int REASON_UNSPECIFIED = -1;
    public static final int REASON_INVALID_LISTENER = -2;
    public static final int REASON_INVALID_REQUEST = -3;
    public static final int REASON_NOT_AUTHORIZED = -4;
    public static final String GET_AVAILABLE_CHANNELS_EXTRA = "Channels";
    public static final int REPORT_EVENT_AFTER_BUFFER_FULL = 0;
    public static final int REPORT_EVENT_AFTER_EACH_SCAN = 1;
    public static final int REPORT_EVENT_FULL_SCAN_RESULT = 2;
    private static final String TAG = "WifiScanner";
    private static final boolean DBG = true;
    private static final int BASE = 159744;
    public static final int CMD_SCAN = 159744;
    public static final int CMD_START_BACKGROUND_SCAN = 159746;
    public static final int CMD_STOP_BACKGROUND_SCAN = 159747;
    public static final int CMD_GET_SCAN_RESULTS = 159748;
    public static final int CMD_SCAN_RESULT = 159749;
    public static final int CMD_SET_HOTLIST = 159750;
    public static final int CMD_RESET_HOTLIST = 159751;
    public static final int CMD_AP_FOUND = 159753;
    public static final int CMD_AP_LOST = 159754;
    public static final int CMD_START_TRACKING_CHANGE = 159755;
    public static final int CMD_STOP_TRACKING_CHANGE = 159756;
    public static final int CMD_CONFIGURE_WIFI_CHANGE = 159757;
    public static final int CMD_WIFI_CHANGE_DETECTED = 159759;
    public static final int CMD_WIFI_CHANGES_STABILIZED = 159760;
    public static final int CMD_OP_SUCCEEDED = 159761;
    public static final int CMD_OP_FAILED = 159762;
    public static final int CMD_PERIOD_CHANGED = 159763;
    public static final int CMD_FULL_SCAN_RESULT = 159764;
    private Context mContext;
    private IWifiScanner mService;
    private static final int INVALID_KEY = 0;
    private static int sListenerKey = 1;
    private static final SparseArray sListenerMap = new SparseArray();
    private static final Object sListenerMapLock = new Object();
    private static AsyncChannel sAsyncChannel;
    private static CountDownLatch sConnected;
    private static final Object sThreadRefLock;
    private static int sThreadRefCount;
    private static HandlerThread sHandlerThread;

    public List<Integer> getAvailableChannels(int band) {
        try {
            Bundle bundle = this.mService.getAvailableChannels(band);
            return bundle.getIntegerArrayList(GET_AVAILABLE_CHANNELS_EXTRA);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void startBackgroundScan(ScanSettings settings, ScanListener listener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159746, 0, WifiScanner.putListener(listener), settings);
    }

    public void stopBackgroundScan(ScanListener listener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159747, 0, WifiScanner.removeListener(listener));
    }

    public ScanResult[] getScanResults() {
        this.validateChannel();
        Message reply = sAsyncChannel.sendMessageSynchronously(159748, 0);
        ScanResult[] results = (ScanResult[])reply.obj;
        return results;
    }

    public void configureWifiChange(int rssiSampleSize, int lostApSampleSize, int unchangedSampleSize, int minApsBreachingThreshold, int periodInMs, BssidInfo[] bssidInfos) {
        this.validateChannel();
        WifiChangeSettings settings = new WifiChangeSettings();
        settings.rssiSampleSize = rssiSampleSize;
        settings.lostApSampleSize = lostApSampleSize;
        settings.unchangedSampleSize = unchangedSampleSize;
        settings.minApsBreachingThreshold = minApsBreachingThreshold;
        settings.periodInMs = periodInMs;
        settings.bssidInfos = bssidInfos;
        this.configureWifiChange(settings);
    }

    public void startTrackingWifiChange(WifiChangeListener listener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159755, 0, WifiScanner.putListener(listener));
    }

    public void stopTrackingWifiChange(WifiChangeListener listener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159756, 0, WifiScanner.removeListener(listener));
    }

    public void configureWifiChange(WifiChangeSettings settings) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159757, 0, 0, settings);
    }

    public void startTrackingBssids(BssidInfo[] bssidInfos, int apLostThreshold, BssidListener listener) {
        this.validateChannel();
        HotlistSettings settings = new HotlistSettings();
        settings.bssidInfos = bssidInfos;
        sAsyncChannel.sendMessage(159750, 0, WifiScanner.putListener(listener), settings);
    }

    public void stopTrackingBssids(BssidListener listener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159751, 0, WifiScanner.removeListener(listener));
    }

    public WifiScanner(Context context, IWifiScanner service) {
        this.mContext = context;
        this.mService = service;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = sThreadRefLock;
        synchronized (object) {
            if (++sThreadRefCount == 1) {
                Messenger messenger = null;
                try {
                    messenger = this.mService.getMessenger();
                }
                catch (RemoteException e) {
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                if (messenger == null) {
                    sAsyncChannel = null;
                    return;
                }
                sHandlerThread = new HandlerThread(TAG);
                sAsyncChannel = new AsyncChannel();
                sConnected = new CountDownLatch(1);
                sHandlerThread.start();
                ServiceHandler handler = new ServiceHandler(sHandlerThread.getLooper());
                sAsyncChannel.connect(this.mContext, (Handler)handler, messenger);
                try {
                    sConnected.await();
                }
                catch (InterruptedException e) {
                    Log.e(TAG, "interrupted wait at init");
                }
            }
        }
    }

    private void validateChannel() {
        if (sAsyncChannel == null) {
            throw new IllegalStateException("No permission to access and change wifi or a bad initialization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int putListener(Object listener) {
        int key;
        if (listener == null) {
            return 0;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            do {
                ++sListenerKey;
            } while (key == 0);
            sListenerMap.put(key, listener);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            Object listener = sListenerMap.get(key);
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getListenerKey(Object listener) {
        if (listener == null) {
            return 0;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            int index = sListenerMap.indexOfValue(listener);
            if (index == -1) {
                return 0;
            }
            return sListenerMap.keyAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object removeListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            Object listener = sListenerMap.get(key);
            sListenerMap.remove(key);
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int removeListener(Object listener) {
        int key = WifiScanner.getListenerKey(listener);
        if (key == 0) {
            return key;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            sListenerMap.remove(key);
            return key;
        }
    }

    static {
        sThreadRefLock = new Object();
    }

    private static class ServiceHandler
    extends Handler {
        ServiceHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 69632: {
                    if (msg.arg1 == 0) {
                        sAsyncChannel.sendMessage(69633);
                    } else {
                        Log.e(WifiScanner.TAG, "Failed to set up channel connection");
                        sAsyncChannel = null;
                    }
                    sConnected.countDown();
                    return;
                }
                case 69634: {
                    return;
                }
                case 69636: {
                    Log.e(WifiScanner.TAG, "Channel connection lost");
                    sAsyncChannel = null;
                    this.getLooper().quit();
                    return;
                }
            }
            Object listener = WifiScanner.getListener(msg.arg2);
            if (listener == null) {
                Log.d(WifiScanner.TAG, "invalid listener key = " + msg.arg2);
                return;
            }
            Log.d(WifiScanner.TAG, "listener key = " + msg.arg2);
            switch (msg.what) {
                case 159761: {
                    ((ActionListener)listener).onSuccess();
                    break;
                }
                case 159762: {
                    OperationResult result = (OperationResult)msg.obj;
                    ((ActionListener)listener).onFailure(result.reason, result.description);
                    WifiScanner.removeListener(msg.arg2);
                    break;
                }
                case 159749: {
                    ((ScanListener)listener).onResults(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                case 159764: {
                    ScanResult result = (ScanResult)msg.obj;
                    ((ScanListener)listener).onFullResult(result);
                    return;
                }
                case 159763: {
                    ((ScanListener)listener).onPeriodChanged(msg.arg1);
                    return;
                }
                case 159753: {
                    ((BssidListener)listener).onFound(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                case 159759: {
                    ((WifiChangeListener)listener).onChanging(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                case 159760: {
                    ((WifiChangeListener)listener).onQuiescence(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                default: {
                    Log.d(WifiScanner.TAG, "Ignoring message " + msg.what);
                    return;
                }
            }
        }
    }

    public static class OperationResult
    implements Parcelable {
        public int reason;
        public String description;
        public static final Parcelable.Creator<OperationResult> CREATOR = new Parcelable.Creator<OperationResult>(){

            @Override
            public OperationResult createFromParcel(Parcel in) {
                int reason = in.readInt();
                String description = in.readString();
                return new OperationResult(reason, description);
            }

            public OperationResult[] newArray(int size) {
                return new OperationResult[size];
            }
        };

        public OperationResult(int reason, String description) {
            this.reason = reason;
            this.description = description;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.reason);
            dest.writeString(this.description);
        }
    }

    public static class HotlistSettings
    implements Parcelable {
        public BssidInfo[] bssidInfos;
        public int apLostThreshold;
        public static final Parcelable.Creator<HotlistSettings> CREATOR = new Parcelable.Creator<HotlistSettings>(){

            @Override
            public HotlistSettings createFromParcel(Parcel in) {
                HotlistSettings settings = new HotlistSettings();
                settings.apLostThreshold = in.readInt();
                int n = in.readInt();
                settings.bssidInfos = new BssidInfo[n];
                for (int i = 0; i < n; ++i) {
                    BssidInfo info = new BssidInfo();
                    info.bssid = in.readString();
                    info.low = in.readInt();
                    info.high = in.readInt();
                    info.frequencyHint = in.readInt();
                    settings.bssidInfos[i] = info;
                }
                return settings;
            }

            public HotlistSettings[] newArray(int size) {
                return new HotlistSettings[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.apLostThreshold);
            if (this.bssidInfos != null) {
                dest.writeInt(this.bssidInfos.length);
                for (int i = 0; i < this.bssidInfos.length; ++i) {
                    BssidInfo info = this.bssidInfos[i];
                    dest.writeString(info.bssid);
                    dest.writeInt(info.low);
                    dest.writeInt(info.high);
                    dest.writeInt(info.frequencyHint);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    public static interface BssidListener
    extends ActionListener {
        public void onFound(ScanResult[] var1);
    }

    public static interface WifiChangeListener
    extends ActionListener {
        public void onChanging(ScanResult[] var1);

        public void onQuiescence(ScanResult[] var1);
    }

    public static class WifiChangeSettings
    implements Parcelable {
        public int rssiSampleSize;
        public int lostApSampleSize;
        public int unchangedSampleSize;
        public int minApsBreachingThreshold;
        public int periodInMs;
        public BssidInfo[] bssidInfos;
        public static final Parcelable.Creator<WifiChangeSettings> CREATOR = new Parcelable.Creator<WifiChangeSettings>(){

            @Override
            public WifiChangeSettings createFromParcel(Parcel in) {
                WifiChangeSettings settings = new WifiChangeSettings();
                settings.rssiSampleSize = in.readInt();
                settings.lostApSampleSize = in.readInt();
                settings.unchangedSampleSize = in.readInt();
                settings.minApsBreachingThreshold = in.readInt();
                settings.periodInMs = in.readInt();
                int len = in.readInt();
                settings.bssidInfos = new BssidInfo[len];
                for (int i = 0; i < len; ++i) {
                    BssidInfo info = new BssidInfo();
                    info.bssid = in.readString();
                    info.low = in.readInt();
                    info.high = in.readInt();
                    info.frequencyHint = in.readInt();
                    settings.bssidInfos[i] = info;
                }
                return settings;
            }

            public WifiChangeSettings[] newArray(int size) {
                return new WifiChangeSettings[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.rssiSampleSize);
            dest.writeInt(this.lostApSampleSize);
            dest.writeInt(this.unchangedSampleSize);
            dest.writeInt(this.minApsBreachingThreshold);
            dest.writeInt(this.periodInMs);
            if (this.bssidInfos != null) {
                dest.writeInt(this.bssidInfos.length);
                for (int i = 0; i < this.bssidInfos.length; ++i) {
                    BssidInfo info = this.bssidInfos[i];
                    dest.writeString(info.bssid);
                    dest.writeInt(info.low);
                    dest.writeInt(info.high);
                    dest.writeInt(info.frequencyHint);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    public static class BssidInfo {
        public String bssid;
        public int low;
        public int high;
        public int frequencyHint;
    }

    public static interface ScanListener
    extends ActionListener {
        public void onPeriodChanged(int var1);

        public void onResults(ScanResult[] var1);

        public void onFullResult(ScanResult var1);
    }

    public static class ParcelableScanResults
    implements Parcelable {
        public ScanResult[] mResults;
        public static final Parcelable.Creator<ParcelableScanResults> CREATOR = new Parcelable.Creator<ParcelableScanResults>(){

            @Override
            public ParcelableScanResults createFromParcel(Parcel in) {
                int n = in.readInt();
                ScanResult[] results = new ScanResult[n];
                for (int i = 0; i < n; ++i) {
                    results[i] = ScanResult.CREATOR.createFromParcel(in);
                }
                return new ParcelableScanResults(results);
            }

            public ParcelableScanResults[] newArray(int size) {
                return new ParcelableScanResults[size];
            }
        };

        public ParcelableScanResults(ScanResult[] results) {
            this.mResults = results;
        }

        public ScanResult[] getResults() {
            return this.mResults;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mResults.length);
                for (int i = 0; i < this.mResults.length; ++i) {
                    ScanResult result = this.mResults[i];
                    result.writeToParcel(dest, flags);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    public static class ScanSettings
    implements Parcelable {
        public int band;
        public ChannelSpec[] channels;
        public int periodInMs;
        public int reportEvents;
        public int numBssidsPerScan;
        public static final Parcelable.Creator<ScanSettings> CREATOR = new Parcelable.Creator<ScanSettings>(){

            @Override
            public ScanSettings createFromParcel(Parcel in) {
                ScanSettings settings = new ScanSettings();
                settings.band = in.readInt();
                settings.periodInMs = in.readInt();
                settings.reportEvents = in.readInt();
                settings.numBssidsPerScan = in.readInt();
                int num_channels = in.readInt();
                settings.channels = new ChannelSpec[num_channels];
                for (int i = 0; i < num_channels; ++i) {
                    int frequency = in.readInt();
                    ChannelSpec spec = new ChannelSpec(frequency);
                    spec.dwellTimeMS = in.readInt();
                    spec.passive = in.readInt() == 1;
                    settings.channels[i] = spec;
                }
                return settings;
            }

            public ScanSettings[] newArray(int size) {
                return new ScanSettings[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.band);
            dest.writeInt(this.periodInMs);
            dest.writeInt(this.reportEvents);
            dest.writeInt(this.numBssidsPerScan);
            if (this.channels != null) {
                dest.writeInt(this.channels.length);
                for (int i = 0; i < this.channels.length; ++i) {
                    dest.writeInt(this.channels[i].frequency);
                    dest.writeInt(this.channels[i].dwellTimeMS);
                    dest.writeInt(this.channels[i].passive ? 1 : 0);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    public static class ChannelSpec {
        public int frequency;
        public boolean passive;
        public int dwellTimeMS;

        public ChannelSpec(int frequency) {
            this.frequency = frequency;
            this.passive = false;
            this.dwellTimeMS = 0;
        }
    }

    public static interface ActionListener {
        public void onSuccess();

        public void onFailure(int var1, String var2);
    }
}

