/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import android.net.dhcp.DhcpStateMachine;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;

class DhcpAckPacket
extends DhcpPacket {
    private final InetAddress mSrcIp;

    DhcpAckPacket(int transId, boolean broadcast, InetAddress serverAddress, InetAddress clientIp, byte[] clientMac) {
        super(transId, Inet4Address.ANY, clientIp, serverAddress, Inet4Address.ANY, clientMac, broadcast);
        this.mBroadcast = broadcast;
        this.mSrcIp = serverAddress;
    }

    @Override
    public String toString() {
        String s = super.toString();
        String dnsServers = " DNS servers: ";
        for (InetAddress dnsServer : this.mDnsServers) {
            dnsServers = dnsServers + dnsServer.toString() + " ";
        }
        return s + " ACK: your new IP " + this.mYourIp + ", netmask " + this.mSubnetMask + ", gateway " + this.mGateway + dnsServers + ", lease time " + this.mLeaseTime;
    }

    @Override
    public ByteBuffer buildPacket(int encap, short destUdp, short srcUdp) {
        ByteBuffer result = ByteBuffer.allocate(1500);
        InetAddress destIp = this.mBroadcast ? Inet4Address.ALL : this.mYourIp;
        InetAddress srcIp = this.mBroadcast ? Inet4Address.ANY : this.mSrcIp;
        this.fillInPacket(encap, destIp, srcIp, destUdp, srcUdp, result, (byte)2, this.mBroadcast);
        result.flip();
        return result;
    }

    @Override
    void finishPacket(ByteBuffer buffer) {
        this.addTlv(buffer, (byte)53, (byte)5);
        this.addTlv(buffer, (byte)54, this.mServerIdentifier);
        this.addTlv(buffer, (byte)51, this.mLeaseTime);
        if (this.mLeaseTime != null) {
            this.addTlv(buffer, (byte)58, this.mLeaseTime / 2);
        }
        this.addTlv(buffer, (byte)1, this.mSubnetMask);
        this.addTlv(buffer, (byte)3, this.mGateway);
        this.addTlv(buffer, (byte)15, this.mDomainName);
        this.addTlv(buffer, (byte)28, this.mBroadcastAddress);
        this.addTlv(buffer, (byte)6, this.mDnsServers);
        this.addTlvEnd(buffer);
    }

    private static final int getInt(Integer v) {
        if (v == null) {
            return 0;
        }
        return v;
    }

    @Override
    public void doNextOp(DhcpStateMachine machine) {
        machine.onAckReceived(this.mYourIp, this.mSubnetMask, this.mGateway, this.mDnsServers, this.mServerIdentifier, DhcpAckPacket.getInt(this.mLeaseTime));
    }
}

