/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkQualityInfo;
import android.os.SystemClock;
import android.util.Slog;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;

public class SamplingDataTracker {
    private static final boolean DBG = false;
    private static final String TAG = "SamplingDataTracker";
    private SamplingSnapshot mBeginningSample;
    private SamplingSnapshot mEndingSample;
    private SamplingSnapshot mLastSample;
    public final Object mSamplingDataLock = new Object();
    private final int MINIMUM_SAMPLING_INTERVAL = 15000;
    private final int MINIMUM_SAMPLED_PACKETS = 30;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getSamplingSnapshots(Map<String, SamplingSnapshot> mapIfaceToSample) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader("/proc/net/dev"));
            reader.readLine();
            reader.readLine();
            while ((line = reader.readLine()) != null) {
                String currentIface;
                String[] tokens = (line = line.trim()).split("[ ]+");
                if (tokens.length < 17 || !mapIfaceToSample.containsKey(currentIface = tokens[0].split(":")[0])) continue;
                try {
                    SamplingSnapshot ss = new SamplingSnapshot();
                    ss.mTxByteCount = Long.parseLong(tokens[1]);
                    ss.mTxPacketCount = Long.parseLong(tokens[2]);
                    ss.mTxPacketErrorCount = Long.parseLong(tokens[3]);
                    ss.mRxByteCount = Long.parseLong(tokens[9]);
                    ss.mRxPacketCount = Long.parseLong(tokens[10]);
                    ss.mRxPacketErrorCount = Long.parseLong(tokens[11]);
                    ss.mTimestamp = SystemClock.elapsedRealtime();
                    mapIfaceToSample.put(currentIface, ss);
                }
                catch (NumberFormatException e) {}
            }
        }
        catch (FileNotFoundException e) {
            Slog.e(TAG, "could not find /proc/net/dev");
        }
        catch (IOException e) {
            Slog.e(TAG, "could not read /proc/net/dev");
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                Slog.e(TAG, "could not close /proc/net/dev");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSampling(SamplingSnapshot s) {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            this.mLastSample = s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSampling(SamplingSnapshot s) {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mLastSample != null && s.mTimestamp - this.mLastSample.mTimestamp > 15000L && this.getSampledPacketCount(this.mLastSample, s) > 30L) {
                this.mBeginningSample = this.mLastSample;
                this.mEndingSample = s;
                this.mLastSample = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSamplingData() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            this.mLastSample = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSampledTxByteCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample != null && this.mEndingSample != null) {
                return this.mEndingSample.mTxByteCount - this.mBeginningSample.mTxByteCount;
            }
            return Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSampledTxPacketCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample != null && this.mEndingSample != null) {
                return this.mEndingSample.mTxPacketCount - this.mBeginningSample.mTxPacketCount;
            }
            return Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSampledTxPacketErrorCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample != null && this.mEndingSample != null) {
                return this.mEndingSample.mTxPacketErrorCount - this.mBeginningSample.mTxPacketErrorCount;
            }
            return Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSampledRxByteCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample != null && this.mEndingSample != null) {
                return this.mEndingSample.mRxByteCount - this.mBeginningSample.mRxByteCount;
            }
            return Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSampledRxPacketCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample != null && this.mEndingSample != null) {
                return this.mEndingSample.mRxPacketCount - this.mBeginningSample.mRxPacketCount;
            }
            return Long.MAX_VALUE;
        }
    }

    public long getSampledPacketCount() {
        return this.getSampledPacketCount(this.mBeginningSample, this.mEndingSample);
    }

    public long getSampledPacketCount(SamplingSnapshot begin, SamplingSnapshot end) {
        if (begin != null && end != null) {
            long rxPacketCount = end.mRxPacketCount - begin.mRxPacketCount;
            long txPacketCount = end.mTxPacketCount - begin.mTxPacketCount;
            return rxPacketCount + txPacketCount;
        }
        return Long.MAX_VALUE;
    }

    public long getSampledPacketErrorCount() {
        if (this.mBeginningSample != null && this.mEndingSample != null) {
            long rxPacketErrorCount = this.getSampledRxPacketErrorCount();
            long txPacketErrorCount = this.getSampledTxPacketErrorCount();
            return rxPacketErrorCount + txPacketErrorCount;
        }
        return Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSampledRxPacketErrorCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample != null && this.mEndingSample != null) {
                return this.mEndingSample.mRxPacketErrorCount - this.mBeginningSample.mRxPacketErrorCount;
            }
            return Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSampleTimestamp() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mEndingSample != null) {
                return this.mEndingSample.mTimestamp;
            }
            return Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSampleDuration() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample != null && this.mEndingSample != null) {
                return (int)(this.mEndingSample.mTimestamp - this.mBeginningSample.mTimestamp);
            }
            return Integer.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommonLinkQualityInfoFields(LinkQualityInfo li) {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            li.setLastDataSampleTime(this.getSampleTimestamp());
            li.setDataSampleDuration(this.getSampleDuration());
            li.setPacketCount(this.getSampledPacketCount());
            li.setPacketErrorCount(this.getSampledPacketErrorCount());
        }
    }

    public static class SamplingSnapshot {
        public long mTxByteCount;
        public long mRxByteCount;
        public long mTxPacketCount;
        public long mRxPacketCount;
        public long mTxPacketErrorCount;
        public long mRxPacketErrorCount;
        public long mTimestamp;
    }
}

