/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.os.Parcel;
import android.os.Parcelable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Objects;

public final class RouteInfo
implements Parcelable {
    private final IpPrefix mDestination;
    private final InetAddress mGateway;
    private final String mInterface;
    public static final int RTN_UNICAST = 1;
    public static final int RTN_UNREACHABLE = 7;
    public static final int RTN_THROW = 9;
    private final int mType;
    private final boolean mIsHost;
    private final boolean mHasGateway;
    public static final Parcelable.Creator<RouteInfo> CREATOR = new Parcelable.Creator<RouteInfo>(){

        @Override
        public RouteInfo createFromParcel(Parcel in) {
            IpPrefix dest = (IpPrefix)in.readParcelable(null);
            InetAddress gateway = null;
            byte[] addr = in.createByteArray();
            try {
                gateway = InetAddress.getByAddress(addr);
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            String iface = in.readString();
            int type = in.readInt();
            return new RouteInfo(dest, gateway, iface, type);
        }

        public RouteInfo[] newArray(int size) {
            return new RouteInfo[size];
        }
    };

    public RouteInfo(IpPrefix destination, InetAddress gateway, String iface, int type) {
        switch (type) {
            case 1: 
            case 7: 
            case 9: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown route type " + type);
            }
        }
        if (destination == null) {
            if (gateway != null) {
                destination = gateway instanceof Inet4Address ? new IpPrefix(Inet4Address.ANY, 0) : new IpPrefix(Inet6Address.ANY, 0);
            } else {
                throw new IllegalArgumentException("Invalid arguments passed in: " + gateway + "," + destination);
            }
        }
        if (gateway == null) {
            gateway = destination.getAddress() instanceof Inet4Address ? Inet4Address.ANY : Inet6Address.ANY;
        }
        boolean bl = this.mHasGateway = !gateway.isAnyLocalAddress();
        if (destination.getAddress() instanceof Inet4Address && !(gateway instanceof Inet4Address) || destination.getAddress() instanceof Inet6Address && !(gateway instanceof Inet6Address)) {
            throw new IllegalArgumentException("address family mismatch in RouteInfo constructor");
        }
        this.mDestination = destination;
        this.mGateway = gateway;
        this.mInterface = iface;
        this.mType = type;
        this.mIsHost = this.isHost();
    }

    public RouteInfo(IpPrefix destination, InetAddress gateway, String iface) {
        this(destination, gateway, iface, 1);
    }

    public RouteInfo(LinkAddress destination, InetAddress gateway, String iface) {
        this(destination == null ? null : new IpPrefix(destination.getAddress(), destination.getPrefixLength()), gateway, iface);
    }

    public RouteInfo(IpPrefix destination, InetAddress gateway) {
        this(destination, gateway, null);
    }

    public RouteInfo(LinkAddress destination, InetAddress gateway) {
        this(destination, gateway, null);
    }

    public RouteInfo(InetAddress gateway) {
        this((IpPrefix)null, gateway, null);
    }

    public RouteInfo(IpPrefix destination) {
        this(destination, null, null);
    }

    public RouteInfo(LinkAddress destination) {
        this(destination, null, null);
    }

    public RouteInfo(IpPrefix destination, int type) {
        this(destination, null, null, type);
    }

    public static RouteInfo makeHostRoute(InetAddress host, String iface) {
        return RouteInfo.makeHostRoute(host, null, iface);
    }

    public static RouteInfo makeHostRoute(InetAddress host, InetAddress gateway, String iface) {
        if (host == null) {
            return null;
        }
        if (host instanceof Inet4Address) {
            return new RouteInfo(new IpPrefix(host, 32), gateway, iface);
        }
        return new RouteInfo(new IpPrefix(host, 128), gateway, iface);
    }

    private boolean isHost() {
        return this.mDestination.getAddress() instanceof Inet4Address && this.mDestination.getPrefixLength() == 32 || this.mDestination.getAddress() instanceof Inet6Address && this.mDestination.getPrefixLength() == 128;
    }

    public IpPrefix getDestination() {
        return this.mDestination;
    }

    public LinkAddress getDestinationLinkAddress() {
        return new LinkAddress(this.mDestination.getAddress(), this.mDestination.getPrefixLength());
    }

    public InetAddress getGateway() {
        return this.mGateway;
    }

    public String getInterface() {
        return this.mInterface;
    }

    public int getType() {
        return this.mType;
    }

    public boolean isDefaultRoute() {
        return this.mType == 1 && this.mDestination.getPrefixLength() == 0;
    }

    public boolean isIPv4Default() {
        return this.isDefaultRoute() && this.mDestination.getAddress() instanceof Inet4Address;
    }

    public boolean isIPv6Default() {
        return this.isDefaultRoute() && this.mDestination.getAddress() instanceof Inet6Address;
    }

    public boolean isHostRoute() {
        return this.mIsHost;
    }

    public boolean hasGateway() {
        return this.mHasGateway;
    }

    public boolean matches(InetAddress destination) {
        if (destination == null) {
            return false;
        }
        InetAddress dstNet = NetworkUtils.getNetworkPart(destination, this.mDestination.getPrefixLength());
        return this.mDestination.getAddress().equals(dstNet);
    }

    public static RouteInfo selectBestRoute(Collection<RouteInfo> routes, InetAddress dest) {
        if (routes == null || dest == null) {
            return null;
        }
        RouteInfo bestRoute = null;
        for (RouteInfo route : routes) {
            if (!NetworkUtils.addressTypeMatches(route.mDestination.getAddress(), dest) || bestRoute != null && bestRoute.mDestination.getPrefixLength() >= route.mDestination.getPrefixLength() || !route.matches(dest)) continue;
            bestRoute = route;
        }
        return bestRoute;
    }

    public String toString() {
        String val = "";
        if (this.mDestination != null) {
            val = this.mDestination.toString();
        }
        if (this.mType == 7) {
            val = val + " unreachable";
        } else if (this.mType == 9) {
            val = val + " throw";
        } else {
            val = val + " ->";
            if (this.mGateway != null) {
                val = val + " " + this.mGateway.getHostAddress();
            }
            if (this.mInterface != null) {
                val = val + " " + this.mInterface;
            }
            if (this.mType != 1) {
                val = val + " unknown type " + this.mType;
            }
        }
        return val;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RouteInfo)) {
            return false;
        }
        RouteInfo target = (RouteInfo)obj;
        return Objects.equals(this.mDestination, target.getDestination()) && Objects.equals(this.mGateway, target.getGateway()) && Objects.equals(this.mInterface, target.getInterface()) && this.mType == target.getType();
    }

    public int hashCode() {
        return this.mDestination.hashCode() * 41 + (this.mGateway == null ? 0 : this.mGateway.hashCode() * 47) + (this.mInterface == null ? 0 : this.mInterface.hashCode() * 67) + this.mType * 71;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mDestination, flags);
        byte[] gatewayBytes = this.mGateway == null ? null : this.mGateway.getAddress();
        dest.writeByteArray(gatewayBytes);
        dest.writeString(this.mInterface);
        dest.writeInt(this.mType);
    }
}

