/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.media.tv.ITvInputService;
import android.media.tv.ITvInputServiceCallback;
import android.media.tv.ITvInputSession;
import android.media.tv.ITvInputSessionCallback;
import android.media.tv.ITvInputSessionWrapper;
import android.media.tv.TvContentRating;
import android.media.tv.TvInputHardwareInfo;
import android.media.tv.TvInputInfo;
import android.media.tv.TvInputManager;
import android.media.tv.TvTrackInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.WindowManager;
import com.android.internal.os.SomeArgs;
import java.util.HashSet;
import java.util.List;

public abstract class TvInputService
extends Service {
    private static final boolean DEBUG = false;
    private static final String TAG = "TvInputService";
    public static final String SERVICE_INTERFACE = "android.media.tv.TvInputService";
    public static final String SERVICE_META_DATA = "android.media.tv.input";
    private final Handler mServiceHandler = new ServiceHandler();
    private final RemoteCallbackList<ITvInputServiceCallback> mCallbacks = new RemoteCallbackList();
    private TvInputManager mTvInputManager;

    @Override
    public final IBinder onBind(Intent intent) {
        return new ITvInputService.Stub(){

            @Override
            public void registerCallback(ITvInputServiceCallback cb) {
                if (cb != null) {
                    TvInputService.this.mCallbacks.register(cb);
                }
            }

            @Override
            public void unregisterCallback(ITvInputServiceCallback cb) {
                if (cb != null) {
                    TvInputService.this.mCallbacks.unregister(cb);
                }
            }

            @Override
            public void createSession(InputChannel channel, ITvInputSessionCallback cb, String inputId) {
                if (channel == null) {
                    Log.w(TvInputService.TAG, "Creating session without input channel");
                }
                if (cb == null) {
                    return;
                }
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = channel;
                args.arg2 = cb;
                args.arg3 = inputId;
                TvInputService.this.mServiceHandler.obtainMessage(1, args).sendToTarget();
            }

            @Override
            public void notifyHardwareAdded(TvInputHardwareInfo hardwareInfo) {
                TvInputService.this.mServiceHandler.obtainMessage(3, hardwareInfo).sendToTarget();
            }

            @Override
            public void notifyHardwareRemoved(TvInputHardwareInfo hardwareInfo) {
                TvInputService.this.mServiceHandler.obtainMessage(4, hardwareInfo).sendToTarget();
            }

            @Override
            public void notifyHdmiDeviceAdded(HdmiDeviceInfo deviceInfo) {
                TvInputService.this.mServiceHandler.obtainMessage(5, deviceInfo).sendToTarget();
            }

            @Override
            public void notifyHdmiDeviceRemoved(HdmiDeviceInfo deviceInfo) {
                TvInputService.this.mServiceHandler.obtainMessage(6, deviceInfo).sendToTarget();
            }
        };
    }

    public final int getRegisteredCallbackCount() {
        return this.mCallbacks.getRegisteredCallbackCount();
    }

    public abstract Session onCreateSession(String var1);

    public TvInputInfo onHardwareAdded(TvInputHardwareInfo hardwareInfo) {
        return null;
    }

    public String onHardwareRemoved(TvInputHardwareInfo hardwareInfo) {
        return null;
    }

    public TvInputInfo onHdmiDeviceAdded(HdmiDeviceInfo deviceInfo) {
        return null;
    }

    public String onHdmiDeviceRemoved(HdmiDeviceInfo deviceInfo) {
        return null;
    }

    private boolean isPassthroughInput(String inputId) {
        TvInputInfo info;
        if (this.mTvInputManager == null) {
            this.mTvInputManager = (TvInputManager)this.getSystemService("tv_input");
        }
        return (info = this.mTvInputManager.getTvInputInfo(inputId)) != null && info.isPassthroughInput();
    }

    public static boolean isNavigationKey(int keyCode) {
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 61: 
            case 62: 
            case 66: 
            case 92: 
            case 93: 
            case 122: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    @SuppressLint(value={"HandlerLeak"})
    private final class ServiceHandler
    extends Handler {
        private static final int DO_CREATE_SESSION = 1;
        private static final int DO_NOTIFY_SESSION_CREATED = 2;
        private static final int DO_ADD_HARDWARE_TV_INPUT = 3;
        private static final int DO_REMOVE_HARDWARE_TV_INPUT = 4;
        private static final int DO_ADD_HDMI_TV_INPUT = 5;
        private static final int DO_REMOVE_HDMI_TV_INPUT = 6;

        private ServiceHandler() {
        }

        private void broadcastAddHardwareTvInput(int deviceId, TvInputInfo inputInfo) {
            int n = TvInputService.this.mCallbacks.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                try {
                    ((ITvInputServiceCallback)TvInputService.this.mCallbacks.getBroadcastItem(i)).addHardwareTvInput(deviceId, inputInfo);
                    continue;
                }
                catch (RemoteException e) {
                    Log.e(TvInputService.TAG, "Error while broadcasting.", e);
                }
            }
            TvInputService.this.mCallbacks.finishBroadcast();
        }

        private void broadcastAddHdmiTvInput(int id2, TvInputInfo inputInfo) {
            int n = TvInputService.this.mCallbacks.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                try {
                    ((ITvInputServiceCallback)TvInputService.this.mCallbacks.getBroadcastItem(i)).addHdmiTvInput(id2, inputInfo);
                    continue;
                }
                catch (RemoteException e) {
                    Log.e(TvInputService.TAG, "Error while broadcasting.", e);
                }
            }
            TvInputService.this.mCallbacks.finishBroadcast();
        }

        private void broadcastRemoveTvInput(String inputId) {
            int n = TvInputService.this.mCallbacks.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                try {
                    ((ITvInputServiceCallback)TvInputService.this.mCallbacks.getBroadcastItem(i)).removeTvInput(inputId);
                    continue;
                }
                catch (RemoteException e) {
                    Log.e(TvInputService.TAG, "Error while broadcasting.", e);
                }
            }
            TvInputService.this.mCallbacks.finishBroadcast();
        }

        @Override
        public final void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    InputChannel channel = (InputChannel)args.arg1;
                    ITvInputSessionCallback cb = (ITvInputSessionCallback)args.arg2;
                    String inputId = (String)args.arg3;
                    args.recycle();
                    Session sessionImpl = TvInputService.this.onCreateSession(inputId);
                    if (sessionImpl == null) {
                        try {
                            cb.onSessionCreated(null, null);
                        }
                        catch (RemoteException e) {
                            Log.e(TvInputService.TAG, "error in onSessionCreated");
                        }
                        return;
                    }
                    sessionImpl.setSessionCallback(cb);
                    ITvInputSessionWrapper stub = new ITvInputSessionWrapper(TvInputService.this, sessionImpl, channel);
                    if (sessionImpl instanceof HardwareSession) {
                        HardwareSession proxySession = (HardwareSession)sessionImpl;
                        String harewareInputId = proxySession.getHardwareInputId();
                        if (TextUtils.isEmpty(harewareInputId) || !TvInputService.this.isPassthroughInput(harewareInputId)) {
                            if (TextUtils.isEmpty(harewareInputId)) {
                                Log.w(TvInputService.TAG, "Hardware input id is not setup yet.");
                            } else {
                                Log.w(TvInputService.TAG, "Invalid hardware input id : " + harewareInputId);
                            }
                            sessionImpl.onRelease();
                            try {
                                cb.onSessionCreated(null, null);
                            }
                            catch (RemoteException e) {
                                Log.e(TvInputService.TAG, "error in onSessionCreated");
                            }
                            return;
                        }
                        proxySession.mProxySession = stub;
                        proxySession.mProxySessionCallback = cb;
                        proxySession.mServiceHandler = TvInputService.this.mServiceHandler;
                        TvInputManager manager = (TvInputManager)TvInputService.this.getSystemService("tv_input");
                        manager.createSession(harewareInputId, proxySession.mHardwareSessionCallback, TvInputService.this.mServiceHandler);
                    } else {
                        SomeArgs someArgs = SomeArgs.obtain();
                        someArgs.arg1 = stub;
                        someArgs.arg2 = cb;
                        someArgs.arg3 = null;
                        TvInputService.this.mServiceHandler.obtainMessage(2, someArgs).sendToTarget();
                    }
                    return;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    ITvInputSession stub = (ITvInputSession)args.arg1;
                    ITvInputSessionCallback cb = (ITvInputSessionCallback)args.arg2;
                    IBinder hardwareSessionToken = (IBinder)args.arg3;
                    try {
                        cb.onSessionCreated(stub, hardwareSessionToken);
                    }
                    catch (RemoteException e) {
                        Log.e(TvInputService.TAG, "error in onSessionCreated");
                    }
                    args.recycle();
                    return;
                }
                case 3: {
                    TvInputHardwareInfo hardwareInfo = (TvInputHardwareInfo)msg.obj;
                    TvInputInfo inputInfo = TvInputService.this.onHardwareAdded(hardwareInfo);
                    if (inputInfo != null) {
                        this.broadcastAddHardwareTvInput(hardwareInfo.getDeviceId(), inputInfo);
                    }
                    return;
                }
                case 4: {
                    TvInputHardwareInfo hardwareInfo = (TvInputHardwareInfo)msg.obj;
                    String inputId = TvInputService.this.onHardwareRemoved(hardwareInfo);
                    if (inputId != null) {
                        this.broadcastRemoveTvInput(inputId);
                    }
                    return;
                }
                case 5: {
                    HdmiDeviceInfo deviceInfo = (HdmiDeviceInfo)msg.obj;
                    TvInputInfo inputInfo = TvInputService.this.onHdmiDeviceAdded(deviceInfo);
                    if (inputInfo != null) {
                        this.broadcastAddHdmiTvInput(deviceInfo.getId(), inputInfo);
                    }
                    return;
                }
                case 6: {
                    HdmiDeviceInfo deviceInfo = (HdmiDeviceInfo)msg.obj;
                    String inputId = TvInputService.this.onHdmiDeviceRemoved(deviceInfo);
                    if (inputId != null) {
                        this.broadcastRemoveTvInput(inputId);
                    }
                    return;
                }
            }
            Log.w(TvInputService.TAG, "Unhandled message code: " + msg.what);
        }
    }

    public static abstract class HardwareSession
    extends Session {
        private TvInputManager.Session mHardwareSession;
        private ITvInputSession mProxySession;
        private ITvInputSessionCallback mProxySessionCallback;
        private Handler mServiceHandler;
        private final TvInputManager.SessionCallback mHardwareSessionCallback = new TvInputManager.SessionCallback(){

            @Override
            public void onSessionCreated(TvInputManager.Session session) {
                HardwareSession.this.mHardwareSession = session;
                SomeArgs args = SomeArgs.obtain();
                if (session != null) {
                    args.arg1 = HardwareSession.this.mProxySession;
                    args.arg2 = HardwareSession.this.mProxySessionCallback;
                    args.arg3 = session.getToken();
                } else {
                    args.arg1 = null;
                    args.arg2 = HardwareSession.this.mProxySessionCallback;
                    args.arg3 = null;
                    HardwareSession.this.onRelease();
                }
                HardwareSession.this.mServiceHandler.obtainMessage(2, args).sendToTarget();
            }

            @Override
            public void onVideoAvailable(TvInputManager.Session session) {
                if (HardwareSession.this.mHardwareSession == session) {
                    HardwareSession.this.onHardwareVideoAvailable();
                }
            }

            @Override
            public void onVideoUnavailable(TvInputManager.Session session, int reason) {
                if (HardwareSession.this.mHardwareSession == session) {
                    HardwareSession.this.onHardwareVideoUnavailable(reason);
                }
            }
        };

        public HardwareSession(Context context) {
            super(context);
        }

        public abstract String getHardwareInputId();

        @Override
        public final boolean onSetSurface(Surface surface) {
            Log.e(TvInputService.TAG, "onSetSurface() should not be called in HardwareProxySession.");
            return false;
        }

        public void onHardwareVideoAvailable() {
        }

        public void onHardwareVideoUnavailable(int reason) {
        }
    }

    public static abstract class Session
    implements KeyEvent.Callback {
        private final KeyEvent.DispatcherState mDispatcherState = new KeyEvent.DispatcherState();
        private final WindowManager mWindowManager;
        final Handler mHandler;
        private WindowManager.LayoutParams mWindowParams;
        private Surface mSurface;
        private View mOverlayView;
        private boolean mOverlayViewEnabled;
        private IBinder mWindowToken;
        private Rect mOverlayFrame;
        private ITvInputSessionCallback mSessionCallback;

        public Session(Context context) {
            this.mWindowManager = (WindowManager)context.getSystemService("window");
            this.mHandler = new Handler(context.getMainLooper());
        }

        public void setOverlayViewEnabled(final boolean enable) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (enable == Session.this.mOverlayViewEnabled) {
                        return;
                    }
                    Session.this.mOverlayViewEnabled = enable;
                    if (enable) {
                        if (Session.this.mWindowToken != null) {
                            Session.this.createOverlayView(Session.this.mWindowToken, Session.this.mOverlayFrame);
                        }
                    } else {
                        Session.this.removeOverlayView(false);
                    }
                }
            });
        }

        public void notifySessionEvent(final String eventType, final Bundle eventArgs) {
            if (eventType == null) {
                throw new IllegalArgumentException("eventType should not be null.");
            }
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onSessionEvent(eventType, eventArgs);
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in sending event (event=" + eventType + ")");
                    }
                }
            });
        }

        public void notifyChannelRetuned(final Uri channelUri) {
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onChannelRetuned(channelUri);
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyChannelRetuned");
                    }
                }
            });
        }

        public void notifyTracksChanged(final List<TvTrackInfo> tracks) {
            HashSet<String> trackIdSet = new HashSet<String>();
            for (TvTrackInfo track : tracks) {
                String trackId = track.getId();
                if (trackIdSet.contains(trackId)) {
                    throw new IllegalArgumentException("redundant track ID: " + trackId);
                }
                trackIdSet.add(trackId);
            }
            trackIdSet.clear();
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onTracksChanged(tracks);
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyTracksChanged");
                    }
                }
            });
        }

        public void notifyTrackSelected(final int type, final String trackId) {
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onTrackSelected(type, trackId);
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyTrackSelected");
                    }
                }
            });
        }

        public void notifyVideoAvailable() {
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onVideoAvailable();
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyVideoAvailable");
                    }
                }
            });
        }

        public void notifyVideoUnavailable(final int reason) {
            if (reason < 0 || reason > 3) {
                throw new IllegalArgumentException("Unknown reason: " + reason);
            }
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onVideoUnavailable(reason);
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyVideoUnavailable");
                    }
                }
            });
        }

        public void notifyContentAllowed() {
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onContentAllowed();
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyContentAllowed");
                    }
                }
            });
        }

        public void notifyContentBlocked(final TvContentRating rating) {
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onContentBlocked(rating.flattenToString());
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in notifyContentBlocked");
                    }
                }
            });
        }

        public void layoutSurface(final int left, final int top, final int right, final int bottm) {
            if (left > right || top > bottm) {
                throw new IllegalArgumentException("Invalid parameter");
            }
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onLayoutSurface(left, top, right, bottm);
                    }
                    catch (RemoteException e) {
                        Log.w(TvInputService.TAG, "error in layoutSurface");
                    }
                }
            });
        }

        public abstract void onRelease();

        public void onSetMain(boolean isMain) {
        }

        public abstract boolean onSetSurface(Surface var1);

        public void onSurfaceChanged(int format, int width, int height) {
        }

        public void onOverlayViewSizeChanged(int width, int height) {
        }

        public abstract void onSetStreamVolume(float var1);

        public abstract boolean onTune(Uri var1);

        public boolean onTune(Uri channelUri, Bundle params) {
            return this.onTune(channelUri);
        }

        public abstract void onSetCaptionEnabled(boolean var1);

        public void onUnblockContent(TvContentRating unblockedRating) {
        }

        public boolean onSelectTrack(int type, String trackId) {
            return false;
        }

        public void onAppPrivateCommand(String action, Bundle data) {
        }

        public View onCreateOverlayView() {
            return null;
        }

        @Override
        public boolean onKeyDown(int keyCode, KeyEvent event) {
            return false;
        }

        @Override
        public boolean onKeyLongPress(int keyCode, KeyEvent event) {
            return false;
        }

        @Override
        public boolean onKeyMultiple(int keyCode, int count, KeyEvent event) {
            return false;
        }

        @Override
        public boolean onKeyUp(int keyCode, KeyEvent event) {
            return false;
        }

        public boolean onTouchEvent(MotionEvent event) {
            return false;
        }

        public boolean onTrackballEvent(MotionEvent event) {
            return false;
        }

        public boolean onGenericMotionEvent(MotionEvent event) {
            return false;
        }

        void release() {
            this.removeOverlayView(true);
            this.onRelease();
            if (this.mSurface != null) {
                this.mSurface.release();
                this.mSurface = null;
            }
        }

        void setMain(boolean isMain) {
            this.onSetMain(isMain);
        }

        void setSurface(Surface surface) {
            this.onSetSurface(surface);
            if (this.mSurface != null) {
                this.mSurface.release();
            }
            this.mSurface = surface;
        }

        void dispatchSurfaceChanged(int format, int width, int height) {
            this.onSurfaceChanged(format, width, height);
        }

        void setStreamVolume(float volume) {
            this.onSetStreamVolume(volume);
        }

        void tune(Uri channelUri, Bundle params) {
            this.onTune(channelUri, params);
        }

        void setCaptionEnabled(boolean enabled) {
            this.onSetCaptionEnabled(enabled);
        }

        void selectTrack(int type, String trackId) {
            this.onSelectTrack(type, trackId);
        }

        void unblockContent(String unblockedRating) {
            this.onUnblockContent(TvContentRating.unflattenFromString(unblockedRating));
        }

        void appPrivateCommand(String action, Bundle data) {
            this.onAppPrivateCommand(action, data);
        }

        void createOverlayView(IBinder windowToken, Rect frame) {
            if (this.mOverlayView != null) {
                this.mWindowManager.removeView(this.mOverlayView);
                this.mOverlayView = null;
            }
            this.mWindowToken = windowToken;
            this.mOverlayFrame = frame;
            this.onOverlayViewSizeChanged(frame.right - frame.left, frame.bottom - frame.top);
            if (!this.mOverlayViewEnabled) {
                return;
            }
            this.mOverlayView = this.onCreateOverlayView();
            if (this.mOverlayView == null) {
                return;
            }
            int type = 1004;
            int flag = 536;
            this.mWindowParams = new WindowManager.LayoutParams(frame.right - frame.left, frame.bottom - frame.top, frame.left, frame.top, type, flag, -2);
            this.mWindowParams.privateFlags |= 0x40;
            this.mWindowParams.gravity = 0x800033;
            this.mWindowParams.token = windowToken;
            this.mWindowManager.addView(this.mOverlayView, this.mWindowParams);
        }

        void relayoutOverlayView(Rect frame) {
            if (this.mOverlayFrame == null || this.mOverlayFrame.width() != frame.width() || this.mOverlayFrame.height() != frame.height()) {
                this.onOverlayViewSizeChanged(frame.right - frame.left, frame.bottom - frame.top);
            }
            this.mOverlayFrame = frame;
            if (!this.mOverlayViewEnabled || this.mOverlayView == null) {
                return;
            }
            this.mWindowParams.x = frame.left;
            this.mWindowParams.y = frame.top;
            this.mWindowParams.width = frame.right - frame.left;
            this.mWindowParams.height = frame.bottom - frame.top;
            this.mWindowManager.updateViewLayout(this.mOverlayView, this.mWindowParams);
        }

        void removeOverlayView(boolean clearWindowToken) {
            if (clearWindowToken) {
                this.mWindowToken = null;
                this.mOverlayFrame = null;
            }
            if (this.mOverlayView != null) {
                this.mWindowManager.removeView(this.mOverlayView);
                this.mOverlayView = null;
                this.mWindowParams = null;
            }
        }

        int dispatchInputEvent(InputEvent event, InputEventReceiver receiver) {
            boolean isNavigationKey = false;
            if (event instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)event;
                isNavigationKey = TvInputService.isNavigationKey(keyEvent.getKeyCode());
                if (keyEvent.dispatch(this, this.mDispatcherState, this)) {
                    return 1;
                }
            } else if (event instanceof MotionEvent) {
                MotionEvent motionEvent = (MotionEvent)event;
                int source = motionEvent.getSource();
                if (motionEvent.isTouchEvent() ? this.onTouchEvent(motionEvent) : ((source & 4) != 0 ? this.onTrackballEvent(motionEvent) : this.onGenericMotionEvent(motionEvent))) {
                    return 1;
                }
            }
            if (this.mOverlayView == null || !this.mOverlayView.isAttachedToWindow()) {
                return 0;
            }
            if (!this.mOverlayView.hasWindowFocus()) {
                this.mOverlayView.getViewRootImpl().windowFocusChanged(true, true);
            }
            if (isNavigationKey && this.mOverlayView.hasFocusable()) {
                this.mOverlayView.getViewRootImpl().dispatchInputEvent(event);
                return 1;
            }
            this.mOverlayView.getViewRootImpl().dispatchInputEvent(event, receiver);
            return -1;
        }

        private void setSessionCallback(ITvInputSessionCallback callback) {
            this.mSessionCallback = callback;
        }

        private final void runOnMainThread(Runnable action) {
            if (this.mHandler.getLooper().isCurrentThread() && this.mSessionCallback != null) {
                action.run();
            } else {
                this.mHandler.post(action);
            }
        }
    }
}

