/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioMixingRule;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;

public class AudioPolicyConfig
implements Parcelable {
    private static final String TAG = "AudioPolicyConfig";
    ArrayList<AudioMix> mMixes;
    public static final Parcelable.Creator<AudioPolicyConfig> CREATOR = new Parcelable.Creator<AudioPolicyConfig>(){

        @Override
        public AudioPolicyConfig createFromParcel(Parcel p) {
            return new AudioPolicyConfig(p);
        }

        public AudioPolicyConfig[] newArray(int size) {
            return new AudioPolicyConfig[size];
        }
    };

    AudioPolicyConfig(ArrayList<AudioMix> mixes) {
        this.mMixes = mixes;
    }

    public void addMix(AudioMix mix) throws IllegalArgumentException {
        if (mix == null) {
            throw new IllegalArgumentException("Illegal null AudioMix argument");
        }
        this.mMixes.add(mix);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mMixes.size());
        for (AudioMix mix : this.mMixes) {
            dest.writeInt(mix.getRouteFlags());
            dest.writeInt(mix.getFormat().getSampleRate());
            dest.writeInt(mix.getFormat().getEncoding());
            dest.writeInt(mix.getFormat().getChannelMask());
            ArrayList<AudioMixingRule.AttributeMatchCriterion> criteria = mix.getRule().getCriteria();
            dest.writeInt(criteria.size());
            for (AudioMixingRule.AttributeMatchCriterion criterion : criteria) {
                dest.writeInt(criterion.mRule);
                dest.writeInt(criterion.mAttr.getUsage());
            }
        }
    }

    private AudioPolicyConfig(Parcel in) {
        this.mMixes = new ArrayList();
        int nbMixes = in.readInt();
        for (int i = 0; i < nbMixes; ++i) {
            AudioMix.Builder mixBuilder = new AudioMix.Builder();
            int routeFlags = in.readInt();
            mixBuilder.setRouteFlags(routeFlags);
            int sampleRate = in.readInt();
            int encoding = in.readInt();
            int channelMask = in.readInt();
            AudioFormat format = new AudioFormat.Builder().setSampleRate(sampleRate).setChannelMask(channelMask).setEncoding(encoding).build();
            mixBuilder.setFormat(format);
            int nbRules = in.readInt();
            AudioMixingRule.Builder ruleBuilder = new AudioMixingRule.Builder();
            for (int j = 0; j < nbRules; ++j) {
                int matchRule = in.readInt();
                if (matchRule == 2 || matchRule == 1) {
                    int usage = in.readInt();
                    AudioAttributes attr2 = new AudioAttributes.Builder().setUsage(usage).build();
                    ruleBuilder.addRule(attr2, matchRule);
                    continue;
                }
                Log.w(TAG, "Encountered unsupported rule, skipping");
                in.readInt();
            }
            mixBuilder.setMixingRule(ruleBuilder.build());
            this.mMixes.add(mixBuilder.build());
        }
    }

    public String toString() {
        String textDump = new String("android.media.audiopolicy.AudioPolicyConfig:\n");
        textDump = textDump + this.mMixes.size() + " AudioMix:\n";
        for (AudioMix mix : this.mMixes) {
            textDump = textDump + "* route flags=0x" + Integer.toHexString(mix.getRouteFlags()) + "\n";
            textDump = textDump + "  rate=" + mix.getFormat().getSampleRate() + "Hz\n";
            textDump = textDump + "  encoding=" + mix.getFormat().getEncoding() + "\n";
            textDump = textDump + "  channels=0x";
            textDump = textDump + Integer.toHexString(mix.getFormat().getChannelMask()).toUpperCase() + "\n";
            ArrayList<AudioMixingRule.AttributeMatchCriterion> criteria = mix.getRule().getCriteria();
            for (AudioMixingRule.AttributeMatchCriterion criterion : criteria) {
                switch (criterion.mRule) {
                    case 2: {
                        textDump = textDump + "  exclude usage ";
                        textDump = textDump + criterion.mAttr.usageToString();
                        break;
                    }
                    case 1: {
                        textDump = textDump + "  match usage ";
                        textDump = textDump + criterion.mAttr.usageToString();
                        break;
                    }
                    default: {
                        textDump = textDump + "invalid rule!";
                    }
                }
                textDump = textDump + "\n";
            }
        }
        return textDump;
    }
}

