/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.util.AndroidRuntimeException;
import android.util.Log;
import com.android.internal.app.IAppOpsService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class SoundPool {
    private final SoundPoolDelegate mImpl;

    public SoundPool(int maxStreams, int streamType, int srcQuality) {
        this(maxStreams, new AudioAttributes.Builder().setInternalLegacyStreamType(streamType).build());
    }

    private SoundPool(int maxStreams, AudioAttributes attributes) {
        this.mImpl = SystemProperties.getBoolean("config.disable_media", false) ? new SoundPoolStub() : new SoundPoolImpl(this, maxStreams, attributes);
    }

    public int load(String path, int priority) {
        return this.mImpl.load(path, priority);
    }

    public int load(Context context, int resId, int priority) {
        return this.mImpl.load(context, resId, priority);
    }

    public int load(AssetFileDescriptor afd, int priority) {
        return this.mImpl.load(afd, priority);
    }

    public int load(FileDescriptor fd, long offset, long length, int priority) {
        return this.mImpl.load(fd, offset, length, priority);
    }

    public final boolean unload(int soundID) {
        return this.mImpl.unload(soundID);
    }

    public final int play(int soundID, float leftVolume, float rightVolume, int priority, int loop, float rate) {
        return this.mImpl.play(soundID, leftVolume, rightVolume, priority, loop, rate);
    }

    public final void pause(int streamID) {
        this.mImpl.pause(streamID);
    }

    public final void resume(int streamID) {
        this.mImpl.resume(streamID);
    }

    public final void autoPause() {
        this.mImpl.autoPause();
    }

    public final void autoResume() {
        this.mImpl.autoResume();
    }

    public final void stop(int streamID) {
        this.mImpl.stop(streamID);
    }

    public final void setVolume(int streamID, float leftVolume, float rightVolume) {
        this.mImpl.setVolume(streamID, leftVolume, rightVolume);
    }

    public void setVolume(int streamID, float volume) {
        this.setVolume(streamID, volume, volume);
    }

    public final void setPriority(int streamID, int priority) {
        this.mImpl.setPriority(streamID, priority);
    }

    public final void setLoop(int streamID, int loop) {
        this.mImpl.setLoop(streamID, loop);
    }

    public final void setRate(int streamID, float rate) {
        this.mImpl.setRate(streamID, rate);
    }

    public void setOnLoadCompleteListener(OnLoadCompleteListener listener) {
        this.mImpl.setOnLoadCompleteListener(listener);
    }

    public final void release() {
        this.mImpl.release();
    }

    static class SoundPoolStub
    implements SoundPoolDelegate {
        @Override
        public int load(String path, int priority) {
            return 0;
        }

        @Override
        public int load(Context context, int resId, int priority) {
            return 0;
        }

        @Override
        public int load(AssetFileDescriptor afd, int priority) {
            return 0;
        }

        @Override
        public int load(FileDescriptor fd, long offset, long length, int priority) {
            return 0;
        }

        @Override
        public final boolean unload(int soundID) {
            return true;
        }

        @Override
        public final int play(int soundID, float leftVolume, float rightVolume, int priority, int loop, float rate) {
            return 0;
        }

        @Override
        public final void pause(int streamID) {
        }

        @Override
        public final void resume(int streamID) {
        }

        @Override
        public final void autoPause() {
        }

        @Override
        public final void autoResume() {
        }

        @Override
        public final void stop(int streamID) {
        }

        @Override
        public final void setVolume(int streamID, float leftVolume, float rightVolume) {
        }

        @Override
        public void setVolume(int streamID, float volume) {
        }

        @Override
        public final void setPriority(int streamID, int priority) {
        }

        @Override
        public final void setLoop(int streamID, int loop) {
        }

        @Override
        public final void setRate(int streamID, float rate) {
        }

        @Override
        public void setOnLoadCompleteListener(OnLoadCompleteListener listener) {
        }

        @Override
        public final void release() {
        }
    }

    static class SoundPoolImpl
    implements SoundPoolDelegate {
        private static final String TAG = "SoundPool";
        private static final boolean DEBUG = false;
        private long mNativeContext;
        private EventHandler mEventHandler;
        private OnLoadCompleteListener mOnLoadCompleteListener;
        private SoundPool mProxy;
        private final Object mLock;
        private final AudioAttributes mAttributes;
        private final IAppOpsService mAppOps;
        private static final int SAMPLE_LOADED = 1;

        public SoundPoolImpl(SoundPool proxy, int maxStreams, AudioAttributes attr2) {
            if (this.native_setup(new WeakReference<SoundPoolImpl>(this), maxStreams, attr2) != 0) {
                throw new RuntimeException("Native setup failed");
            }
            this.mLock = new Object();
            this.mProxy = proxy;
            this.mAttributes = attr2;
            IBinder b = ServiceManager.getService("appops");
            this.mAppOps = IAppOpsService.Stub.asInterface(b);
        }

        @Override
        public int load(String path, int priority) {
            if (path.startsWith("http:")) {
                return this._load(path, priority);
            }
            int id2 = 0;
            try {
                File f = new File(path);
                ParcelFileDescriptor fd = ParcelFileDescriptor.open(f, 0x10000000);
                if (fd != null) {
                    id2 = this._load(fd.getFileDescriptor(), 0L, f.length(), priority);
                    fd.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "error loading " + path);
            }
            return id2;
        }

        @Override
        public int load(Context context, int resId, int priority) {
            AssetFileDescriptor afd = context.getResources().openRawResourceFd(resId);
            int id2 = 0;
            if (afd != null) {
                id2 = this._load(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength(), priority);
                try {
                    afd.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            return id2;
        }

        @Override
        public int load(AssetFileDescriptor afd, int priority) {
            if (afd != null) {
                long len = afd.getLength();
                if (len < 0L) {
                    throw new AndroidRuntimeException("no length for fd");
                }
                return this._load(afd.getFileDescriptor(), afd.getStartOffset(), len, priority);
            }
            return 0;
        }

        @Override
        public int load(FileDescriptor fd, long offset, long length, int priority) {
            return this._load(fd, offset, length, priority);
        }

        private final native int _load(String var1, int var2);

        private final native int _load(FileDescriptor var1, long var2, long var4, int var6);

        @Override
        public final native boolean unload(int var1);

        @Override
        public final int play(int soundID, float leftVolume, float rightVolume, int priority, int loop, float rate) {
            if (this.isRestricted()) {
                rightVolume = 0.0f;
                leftVolume = 0.0f;
            }
            return this._play(soundID, leftVolume, rightVolume, priority, loop, rate);
        }

        public final native int _play(int var1, float var2, float var3, int var4, int var5, float var6);

        private boolean isRestricted() {
            try {
                int mode = this.mAppOps.checkAudioOperation(28, this.mAttributes.getUsage(), Process.myUid(), ActivityThread.currentPackageName());
                return mode != 0;
            }
            catch (RemoteException e) {
                return false;
            }
        }

        @Override
        public final native void pause(int var1);

        @Override
        public final native void resume(int var1);

        @Override
        public final native void autoPause();

        @Override
        public final native void autoResume();

        @Override
        public final native void stop(int var1);

        @Override
        public final void setVolume(int streamID, float leftVolume, float rightVolume) {
            if (this.isRestricted()) {
                return;
            }
            this._setVolume(streamID, leftVolume, rightVolume);
        }

        private final native void _setVolume(int var1, float var2, float var3);

        @Override
        public void setVolume(int streamID, float volume) {
            this.setVolume(streamID, volume, volume);
        }

        @Override
        public final native void setPriority(int var1, int var2);

        @Override
        public final native void setLoop(int var1, int var2);

        @Override
        public final native void setRate(int var1, float var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOnLoadCompleteListener(OnLoadCompleteListener listener) {
            Object object = this.mLock;
            synchronized (object) {
                Looper looper;
                this.mEventHandler = listener != null ? ((looper = Looper.myLooper()) != null ? new EventHandler(this.mProxy, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this.mProxy, looper) : null)) : null;
                this.mOnLoadCompleteListener = listener;
            }
        }

        private static void postEventFromNative(Object weakRef, int msg, int arg1, int arg2, Object obj) {
            SoundPoolImpl soundPoolImpl = (SoundPoolImpl)((WeakReference)weakRef).get();
            if (soundPoolImpl == null) {
                return;
            }
            if (soundPoolImpl.mEventHandler != null) {
                Message m = soundPoolImpl.mEventHandler.obtainMessage(msg, arg1, arg2, obj);
                soundPoolImpl.mEventHandler.sendMessage(m);
            }
        }

        @Override
        public final native void release();

        private final native int native_setup(Object var1, int var2, Object var3);

        protected void finalize() {
            this.release();
        }

        static {
            System.loadLibrary("soundpool");
        }

        private class EventHandler
        extends Handler {
            private SoundPool mSoundPool;

            public EventHandler(SoundPool soundPool, Looper looper) {
                super(looper);
                this.mSoundPool = soundPool;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        Object object = SoundPoolImpl.this.mLock;
                        synchronized (object) {
                            if (SoundPoolImpl.this.mOnLoadCompleteListener != null) {
                                SoundPoolImpl.this.mOnLoadCompleteListener.onLoadComplete(this.mSoundPool, msg.arg1, msg.arg2);
                            }
                            break;
                        }
                    }
                    default: {
                        Log.e(SoundPoolImpl.TAG, "Unknown message type " + msg.what);
                        return;
                    }
                }
            }
        }
    }

    static interface SoundPoolDelegate {
        public int load(String var1, int var2);

        public int load(Context var1, int var2, int var3);

        public int load(AssetFileDescriptor var1, int var2);

        public int load(FileDescriptor var1, long var2, long var4, int var6);

        public boolean unload(int var1);

        public int play(int var1, float var2, float var3, int var4, int var5, float var6);

        public void pause(int var1);

        public void resume(int var1);

        public void autoPause();

        public void autoResume();

        public void stop(int var1);

        public void setVolume(int var1, float var2, float var3);

        public void setVolume(int var1, float var2);

        public void setPriority(int var1, int var2);

        public void setLoop(int var1, int var2);

        public void setRate(int var1, float var2);

        public void setOnLoadCompleteListener(OnLoadCompleteListener var1);

        public void release();
    }

    public static interface OnLoadCompleteListener {
        public void onLoadComplete(SoundPool var1, int var2, int var3);
    }

    public static class Builder {
        private int mMaxStreams = 1;
        private AudioAttributes mAudioAttributes;

        public Builder setMaxStreams(int maxStreams) throws IllegalArgumentException {
            if (maxStreams <= 0) {
                throw new IllegalArgumentException("Strictly positive value required for the maximum number of streams");
            }
            this.mMaxStreams = maxStreams;
            return this;
        }

        public Builder setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
            if (attributes == null) {
                throw new IllegalArgumentException("Invalid null AudioAttributes");
            }
            this.mAudioAttributes = attributes;
            return this;
        }

        public SoundPool build() {
            if (this.mAudioAttributes == null) {
                this.mAudioAttributes = new AudioAttributes.Builder().setUsage(1).build();
            }
            return new SoundPool(this.mMaxStreams, this.mAudioAttributes);
        }
    }
}

