/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.IMediaHTTPConnection;
import android.net.NetworkUtils;
import android.os.IBinder;
import android.os.StrictMode;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class MediaHTTPConnection
extends IMediaHTTPConnection.Stub {
    private static final String TAG = "MediaHTTPConnection";
    private static final boolean VERBOSE = false;
    private long mCurrentOffset = -1L;
    private URL mURL = null;
    private Map<String, String> mHeaders = null;
    private HttpURLConnection mConnection = null;
    private long mTotalSize = -1L;
    private InputStream mInputStream = null;
    private boolean mAllowCrossDomainRedirect = true;
    private boolean mAllowCrossProtocolRedirect = true;
    private static final int HTTP_TEMP_REDIRECT = 307;
    private static final int MAX_REDIRECTS = 20;
    private long mNativeContext;

    public MediaHTTPConnection() {
        if (CookieHandler.getDefault() == null) {
            CookieHandler.setDefault(new CookieManager());
        }
        this.native_setup();
    }

    @Override
    public IBinder connect(String uri, String headers) {
        try {
            this.disconnect();
            this.mAllowCrossDomainRedirect = true;
            this.mURL = new URL(uri);
            this.mHeaders = this.convertHeaderStringToMap(headers);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return this.native_getIMemory();
    }

    private boolean parseBoolean(String val) {
        try {
            return Long.parseLong(val) != 0L;
        }
        catch (NumberFormatException e) {
            return "true".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val);
        }
    }

    private boolean filterOutInternalHeaders(String key, String val) {
        if (!"android-allow-cross-domain-redirect".equalsIgnoreCase(key)) {
            return false;
        }
        this.mAllowCrossProtocolRedirect = this.mAllowCrossDomainRedirect = this.parseBoolean(val);
        return true;
    }

    private Map<String, String> convertHeaderStringToMap(String headers) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String pair : pairs = headers.split("\r\n")) {
            String val;
            String key;
            int colonPos = pair.indexOf(":");
            if (colonPos < 0 || this.filterOutInternalHeaders(key = pair.substring(0, colonPos), val = pair.substring(colonPos + 1))) continue;
            map.put(key, val);
        }
        return map;
    }

    @Override
    public void disconnect() {
        this.teardownConnection();
        this.mHeaders = null;
        this.mURL = null;
    }

    private void teardownConnection() {
        if (this.mConnection != null) {
            this.mInputStream = null;
            this.mConnection.disconnect();
            this.mConnection = null;
            this.mCurrentOffset = -1L;
        }
    }

    private static final boolean isLocalHost(URL url) {
        if (url == null) {
            return false;
        }
        String host = url.getHost();
        if (host == null) {
            return false;
        }
        try {
            if (host.equalsIgnoreCase("localhost")) {
                return true;
            }
            if (NetworkUtils.numericToInetAddress(host).isLoopbackAddress()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    private void seekTo(long offset) throws IOException {
        this.teardownConnection();
        try {
            int response;
            int redirectCount = 0;
            URL url = this.mURL;
            boolean noProxy = MediaHTTPConnection.isLocalHost(url);
            while (true) {
                this.mConnection = noProxy ? (HttpURLConnection)url.openConnection(Proxy.NO_PROXY) : (HttpURLConnection)url.openConnection();
                this.mConnection.setInstanceFollowRedirects(this.mAllowCrossDomainRedirect);
                if (this.mHeaders != null) {
                    for (Map.Entry<String, String> entry : this.mHeaders.entrySet()) {
                        this.mConnection.setRequestProperty(entry.getKey(), entry.getValue());
                    }
                }
                if (offset > 0L) {
                    this.mConnection.setRequestProperty("Range", "bytes=" + offset + "-");
                }
                if ((response = this.mConnection.getResponseCode()) != 300 && response != 301 && response != 302 && response != 303 && response != 307) break;
                if (++redirectCount > 20) {
                    throw new NoRouteToHostException("Too many redirects: " + redirectCount);
                }
                String method = this.mConnection.getRequestMethod();
                if (response == 307 && !method.equals("GET") && !method.equals("HEAD")) {
                    throw new NoRouteToHostException("Invalid redirect");
                }
                String location = this.mConnection.getHeaderField("Location");
                if (location == null) {
                    throw new NoRouteToHostException("Invalid redirect");
                }
                url = new URL(this.mURL, location);
                if (!url.getProtocol().equals("https") && !url.getProtocol().equals("http")) {
                    throw new NoRouteToHostException("Unsupported protocol redirect");
                }
                boolean sameProtocol = this.mURL.getProtocol().equals(url.getProtocol());
                if (!this.mAllowCrossProtocolRedirect && !sameProtocol) {
                    throw new NoRouteToHostException("Cross-protocol redirects are disallowed");
                }
                boolean sameHost = this.mURL.getHost().equals(url.getHost());
                if (!this.mAllowCrossDomainRedirect && !sameHost) {
                    throw new NoRouteToHostException("Cross-domain redirects are disallowed");
                }
                if (response == 307) continue;
                this.mURL = url;
            }
            if (this.mAllowCrossDomainRedirect) {
                this.mURL = this.mConnection.getURL();
            }
            if (response == 206) {
                int lastSlashPos;
                String contentRange = this.mConnection.getHeaderField("Content-Range");
                this.mTotalSize = -1L;
                if (contentRange != null && (lastSlashPos = contentRange.lastIndexOf(47)) >= 0) {
                    String total = contentRange.substring(lastSlashPos + 1);
                    try {
                        this.mTotalSize = Long.parseLong(total);
                    }
                    catch (NumberFormatException e) {}
                }
            } else {
                if (response != 200) {
                    throw new IOException();
                }
                this.mTotalSize = this.mConnection.getContentLength();
            }
            if (offset > 0L && response != 206) {
                throw new IOException();
            }
            this.mInputStream = new BufferedInputStream(this.mConnection.getInputStream());
            this.mCurrentOffset = offset;
        }
        catch (IOException e) {
            this.mTotalSize = -1L;
            this.mInputStream = null;
            this.mConnection = null;
            this.mCurrentOffset = -1L;
            throw e;
        }
    }

    @Override
    public int readAt(long offset, int size) {
        return this.native_readAt(offset, size);
    }

    private int readAt(long offset, byte[] data, int size) {
        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
        StrictMode.setThreadPolicy(policy);
        try {
            int n;
            if (offset != this.mCurrentOffset) {
                this.seekTo(offset);
            }
            if ((n = this.mInputStream.read(data, 0, size)) == -1) {
                n = 0;
            }
            this.mCurrentOffset += (long)n;
            return n;
        }
        catch (NoRouteToHostException e) {
            Log.w(TAG, "readAt " + offset + " / " + size + " => " + e);
            return -1010;
        }
        catch (IOException e) {
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public long getSize() {
        if (this.mConnection == null) {
            try {
                this.seekTo(0L);
            }
            catch (IOException e) {
                return -1L;
            }
        }
        return this.mTotalSize;
    }

    @Override
    public String getMIMEType() {
        if (this.mConnection == null) {
            try {
                this.seekTo(0L);
            }
            catch (IOException e) {
                return "application/octet-stream";
            }
        }
        return this.mConnection.getContentType();
    }

    @Override
    public String getUri() {
        return this.mURL.toString();
    }

    @Override
    protected void finalize() {
        this.native_finalize();
    }

    private static final native void native_init();

    private final native void native_setup();

    private final native void native_finalize();

    private final native IBinder native_getIMemory();

    private final native int native_readAt(long var1, int var3);

    static {
        System.loadLibrary("media_jni");
        MediaHTTPConnection.native_init();
    }
}

