/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AppOpsManager;
import android.app.KeyguardManager;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.database.ContentObserver;
import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.HdmiPlaybackClient;
import android.hardware.hdmi.HdmiTvClient;
import android.media.AudioAttributes;
import android.media.AudioDevicePort;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioManagerInternal;
import android.media.AudioPort;
import android.media.AudioRoutesInfo;
import android.media.AudioSystem;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioRoutesObserver;
import android.media.IAudioService;
import android.media.IRemoteControlDisplay;
import android.media.IRingtonePlayer;
import android.media.IVolumeController;
import android.media.MediaFocusControl;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.media.audiopolicy.AudioPolicyConfig;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.Vibrator;
import android.provider.Settings;
import android.telecom.TelecomManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.MathUtils;
import android.util.Slog;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import com.android.internal.util.XmlUtils;
import com.android.server.LocalServices;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.xmlpull.v1.XmlPullParserException;

public class AudioService
extends IAudioService.Stub {
    private static final String TAG = "AudioService";
    protected static final boolean DEBUG_MODE = Log.isLoggable("AudioService.MOD", 3);
    protected static final boolean DEBUG_VOL = Log.isLoggable("AudioService.VOL", 3);
    private static final boolean DEBUG_SESSIONS = Log.isLoggable("AudioService.SESSIONS", 3);
    private static final boolean VOLUME_SETS_RINGER_MODE_SILENT = false;
    private static final boolean PREVENT_VOLUME_ADJUSTMENT_IF_SILENT = true;
    private static final int PERSIST_DELAY = 500;
    public static final int PLAY_SOUND_DELAY = 300;
    private static final int FLAG_ADJUST_VOLUME = 1;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final AppOpsManager mAppOps;
    private static final int PLATFORM_DEFAULT = 0;
    private static final int PLATFORM_VOICE = 1;
    private static final int PLATFORM_TELEVISION = 2;
    private final int mPlatformType;
    private final VolumeController mVolumeController = new VolumeController();
    private static final int SENDMSG_REPLACE = 0;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;
    private static final int MSG_SET_DEVICE_VOLUME = 0;
    private static final int MSG_PERSIST_VOLUME = 1;
    private static final int MSG_PERSIST_MASTER_VOLUME = 2;
    private static final int MSG_PERSIST_RINGER_MODE = 3;
    private static final int MSG_MEDIA_SERVER_DIED = 4;
    private static final int MSG_PLAY_SOUND_EFFECT = 5;
    private static final int MSG_BTA2DP_DOCK_TIMEOUT = 6;
    private static final int MSG_LOAD_SOUND_EFFECTS = 7;
    private static final int MSG_SET_FORCE_USE = 8;
    private static final int MSG_BT_HEADSET_CNCT_FAILED = 9;
    private static final int MSG_SET_ALL_VOLUMES = 10;
    private static final int MSG_PERSIST_MASTER_VOLUME_MUTE = 11;
    private static final int MSG_REPORT_NEW_ROUTES = 12;
    private static final int MSG_SET_FORCE_BT_A2DP_USE = 13;
    private static final int MSG_CHECK_MUSIC_ACTIVE = 14;
    private static final int MSG_BROADCAST_AUDIO_BECOMING_NOISY = 15;
    private static final int MSG_CONFIGURE_SAFE_MEDIA_VOLUME = 16;
    private static final int MSG_CONFIGURE_SAFE_MEDIA_VOLUME_FORCED = 17;
    private static final int MSG_PERSIST_SAFE_VOLUME_STATE = 18;
    private static final int MSG_BROADCAST_BT_CONNECTION_STATE = 19;
    private static final int MSG_UNLOAD_SOUND_EFFECTS = 20;
    private static final int MSG_SYSTEM_READY = 21;
    private static final int MSG_PERSIST_MUSIC_ACTIVE_MS = 22;
    private static final int MSG_PERSIST_MICROPHONE_MUTE = 23;
    private static final int MSG_SET_WIRED_DEVICE_CONNECTION_STATE = 100;
    private static final int MSG_SET_A2DP_SRC_CONNECTION_STATE = 101;
    private static final int MSG_SET_A2DP_SINK_CONNECTION_STATE = 102;
    private static final int BTA2DP_DOCK_TIMEOUT_MILLIS = 8000;
    private static final int BT_HEADSET_CNCT_TIMEOUT_MS = 3000;
    private AudioSystemThread mAudioSystemThread;
    private AudioHandler mAudioHandler;
    private VolumeStreamState[] mStreamStates;
    private SettingsObserver mSettingsObserver;
    private int mMode = 0;
    private final Object mSettingsLock = new Object();
    private SoundPool mSoundPool;
    private final Object mSoundEffectsLock = new Object();
    private static final int NUM_SOUNDPOOL_CHANNELS = 4;
    private static final int MAX_MASTER_VOLUME = 100;
    private static final int MAX_BATCH_VOLUME_ADJUST_STEPS = 4;
    private static final String SOUND_EFFECTS_PATH = "/media/audio/ui/";
    private static final List<String> SOUND_EFFECT_FILES = new ArrayList<String>();
    private final int[][] SOUND_EFFECT_FILES_MAP = new int[10][2];
    private static final int[] MAX_STREAM_VOLUME = new int[]{5, 7, 7, 15, 7, 7, 15, 7, 15, 15};
    private final int[] STREAM_VOLUME_ALIAS_VOICE = new int[]{0, 2, 2, 3, 4, 2, 6, 2, 2, 3};
    private final int[] STREAM_VOLUME_ALIAS_TELEVISION = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
    private final int[] STREAM_VOLUME_ALIAS_DEFAULT = new int[]{0, 2, 2, 3, 4, 2, 6, 2, 2, 3};
    private int[] mStreamVolumeAlias;
    private static final int[] STEAM_VOLUME_OPS = new int[]{34, 36, 35, 36, 37, 38, 39, 36, 36, 36};
    private final boolean mUseFixedVolume;
    private static final String[] STREAM_NAMES = new String[]{"STREAM_VOICE_CALL", "STREAM_SYSTEM", "STREAM_RING", "STREAM_MUSIC", "STREAM_ALARM", "STREAM_NOTIFICATION", "STREAM_BLUETOOTH_SCO", "STREAM_SYSTEM_ENFORCED", "STREAM_DTMF", "STREAM_TTS"};
    private final AudioSystem.ErrorCallback mAudioSystemCallback = new AudioSystem.ErrorCallback(){

        @Override
        public void onError(int error) {
            switch (error) {
                case 100: {
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 4, 1, 0, 0, null, 0);
                    break;
                }
            }
        }
    };
    private int mRingerMode;
    private int mRingerModeAffectedStreams = 0;
    private int mRingerModeMutedStreams;
    private int mMuteAffectedStreams;
    private int mVibrateSetting;
    private final boolean mHasVibrator;
    private final BroadcastReceiver mReceiver = new AudioServiceBroadcastReceiver();
    private final HashMap<Integer, String> mConnectedDevices = new HashMap();
    private int mForcedUseForComm;
    private final boolean mUseMasterVolume;
    private final int[] mMasterVolumeRamp;
    private final ArrayList<SetModeDeathHandler> mSetModeDeathHandlers = new ArrayList();
    private final ArrayList<ScoClient> mScoClients = new ArrayList();
    private BluetoothHeadset mBluetoothHeadset;
    private BluetoothDevice mBluetoothHeadsetDevice;
    private int mScoAudioState;
    private static final int SCO_STATE_INACTIVE = 0;
    private static final int SCO_STATE_ACTIVATE_REQ = 1;
    private static final int SCO_STATE_ACTIVE_INTERNAL = 3;
    private static final int SCO_STATE_DEACTIVATE_REQ = 5;
    private static final int SCO_STATE_ACTIVE_EXTERNAL = 2;
    private static final int SCO_STATE_DEACTIVATE_EXT_REQ = 4;
    private int mScoAudioMode;
    private static final int SCO_MODE_UNDEFINED = -1;
    private static final int SCO_MODE_VIRTUAL_CALL = 0;
    private static final int SCO_MODE_RAW = 1;
    private static final int SCO_MODE_VR = 2;
    private static final int SCO_MODE_MAX = 2;
    private int mScoConnectionState;
    private boolean mSystemReady;
    private SoundPoolCallback mSoundPoolCallBack;
    private SoundPoolListenerThread mSoundPoolListenerThread;
    private Looper mSoundPoolLooper = null;
    private static int sSoundEffectVolumeDb;
    private int mPrevVolDirection = 0;
    private KeyguardManager mKeyguardManager;
    private int mVolumeControlStream = -1;
    private final Object mForceControlStreamLock = new Object();
    private ForceControlStreamClient mForceControlStreamClient = null;
    private volatile IRingtonePlayer mRingtonePlayer;
    private int mDeviceOrientation = 0;
    private int mDeviceRotation = 0;
    private boolean mBluetoothA2dpEnabled;
    private final Object mBluetoothA2dpEnabledLock = new Object();
    final AudioRoutesInfo mCurAudioRoutes = new AudioRoutesInfo();
    final RemoteCallbackList<IAudioRoutesObserver> mRoutesObservers = new RemoteCallbackList();
    int mFixedVolumeDevices = 2890752;
    int mFullVolumeDevices = 0;
    private final boolean mMonitorOrientation;
    private final boolean mMonitorRotation;
    private boolean mDockAudioMediaEnabled = true;
    private int mDockState = 0;
    private StreamVolumeCommand mPendingVolumeCommand;
    private PowerManager.WakeLock mAudioEventWakeLock;
    private final MediaFocusControl mMediaFocusControl;
    private BluetoothA2dp mA2dp;
    private final Object mA2dpAvrcpLock = new Object();
    private boolean mAvrcpAbsVolSupported = false;
    private AudioOrientationEventListener mOrientationListener;
    private int mRmtSbmxFullVolRefCount = 0;
    private ArrayList<RmtSbmxFullVolDeathHandler> mRmtSbmxFullVolDeathHandlers = new ArrayList();
    private static final String TAG_AUDIO_ASSETS = "audio_assets";
    private static final String ATTR_VERSION = "version";
    private static final String TAG_GROUP = "group";
    private static final String ATTR_GROUP_NAME = "name";
    private static final String TAG_ASSET = "asset";
    private static final String ATTR_ASSET_ID = "id";
    private static final String ATTR_ASSET_FILE = "file";
    private static final String ASSET_FILE_VERSION = "1.0";
    private static final String GROUP_TOUCH_SOUNDS = "touch_sounds";
    private static final int SOUND_EFFECTS_LOAD_TIMEOUT_MS = 5000;
    private BluetoothProfile.ServiceListener mBluetoothProfileServiceListener = new BluetoothProfile.ServiceListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            switch (profile) {
                case 2: {
                    Object object = AudioService.this.mA2dpAvrcpLock;
                    synchronized (object) {
                        AudioService.this.mA2dp = (BluetoothA2dp)proxy;
                        List<BluetoothDevice> deviceList = AudioService.this.mA2dp.getConnectedDevices();
                        if (deviceList.size() > 0) {
                            BluetoothDevice btDevice = deviceList.get(0);
                            HashMap hashMap = AudioService.this.mConnectedDevices;
                            synchronized (hashMap) {
                                int state = AudioService.this.mA2dp.getConnectionState(btDevice);
                                int delay = AudioService.this.checkSendBecomingNoisyIntent(128, state == 2 ? 1 : 0);
                                AudioService.this.queueMsgUnderWakeLock(AudioService.this.mAudioHandler, 102, state, 0, btDevice, delay);
                            }
                        }
                        break;
                    }
                }
                case 10: {
                    List<BluetoothDevice> deviceList = proxy.getConnectedDevices();
                    if (deviceList.size() <= 0) break;
                    BluetoothDevice btDevice = deviceList.get(0);
                    HashMap hashMap = AudioService.this.mConnectedDevices;
                    synchronized (hashMap) {
                        int state = proxy.getConnectionState(btDevice);
                        AudioService.this.queueMsgUnderWakeLock(AudioService.this.mAudioHandler, 101, state, 0, btDevice, 0);
                        break;
                    }
                }
                case 1: {
                    ArrayList arrayList = AudioService.this.mScoClients;
                    synchronized (arrayList) {
                        AudioService.this.mAudioHandler.removeMessages(9);
                        AudioService.this.mBluetoothHeadset = (BluetoothHeadset)proxy;
                        List<BluetoothDevice> deviceList = AudioService.this.mBluetoothHeadset.getConnectedDevices();
                        if (deviceList.size() > 0) {
                            AudioService.this.mBluetoothHeadsetDevice = deviceList.get(0);
                        } else {
                            AudioService.this.mBluetoothHeadsetDevice = null;
                        }
                        AudioService.this.checkScoAudioState();
                        if (AudioService.this.mScoAudioState == 1 || AudioService.this.mScoAudioState == 5 || AudioService.this.mScoAudioState == 4) {
                            boolean status = false;
                            if (AudioService.this.mBluetoothHeadsetDevice != null) {
                                switch (AudioService.this.mScoAudioState) {
                                    case 1: {
                                        AudioService.this.mScoAudioState = 3;
                                        if (AudioService.this.mScoAudioMode == 1) {
                                            status = AudioService.this.mBluetoothHeadset.connectAudio();
                                            break;
                                        }
                                        if (AudioService.this.mScoAudioMode == 0) {
                                            status = AudioService.this.mBluetoothHeadset.startScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice);
                                            break;
                                        }
                                        if (AudioService.this.mScoAudioMode != 2) break;
                                        status = AudioService.this.mBluetoothHeadset.startVoiceRecognition(AudioService.this.mBluetoothHeadsetDevice);
                                        break;
                                    }
                                    case 5: {
                                        if (AudioService.this.mScoAudioMode == 1) {
                                            status = AudioService.this.mBluetoothHeadset.disconnectAudio();
                                            break;
                                        }
                                        if (AudioService.this.mScoAudioMode == 0) {
                                            status = AudioService.this.mBluetoothHeadset.stopScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice);
                                            break;
                                        }
                                        if (AudioService.this.mScoAudioMode != 2) break;
                                        status = AudioService.this.mBluetoothHeadset.stopVoiceRecognition(AudioService.this.mBluetoothHeadsetDevice);
                                        break;
                                    }
                                    case 4: {
                                        status = AudioService.this.mBluetoothHeadset.stopVoiceRecognition(AudioService.this.mBluetoothHeadsetDevice);
                                    }
                                }
                            }
                            if (!status) {
                                AudioService.sendMsg(AudioService.this.mAudioHandler, 9, 0, 0, 0, null, 0);
                            }
                        }
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(int profile) {
            switch (profile) {
                case 2: {
                    Object object = AudioService.this.mA2dpAvrcpLock;
                    synchronized (object) {
                        AudioService.this.mA2dp = null;
                        HashMap hashMap = AudioService.this.mConnectedDevices;
                        synchronized (hashMap) {
                            if (AudioService.this.mConnectedDevices.containsKey(128)) {
                                AudioService.this.makeA2dpDeviceUnavailableNow((String)AudioService.this.mConnectedDevices.get(128));
                            }
                        }
                    }
                }
                case 10: {
                    HashMap hashMap = AudioService.this.mConnectedDevices;
                    synchronized (hashMap) {
                        if (AudioService.this.mConnectedDevices.containsKey(-2147352576)) {
                            AudioService.this.makeA2dpSrcUnavailable((String)AudioService.this.mConnectedDevices.get(-2147352576));
                        }
                        break;
                    }
                }
                case 1: {
                    ArrayList arrayList = AudioService.this.mScoClients;
                    synchronized (arrayList) {
                        AudioService.this.mBluetoothHeadset = null;
                        break;
                    }
                }
            }
        }
    };
    int mBecomingNoisyIntentDevices = 163724;
    private String mDockAddress;
    private static final int SAFE_MEDIA_VOLUME_NOT_CONFIGURED = 0;
    private static final int SAFE_MEDIA_VOLUME_DISABLED = 1;
    private static final int SAFE_MEDIA_VOLUME_INACTIVE = 2;
    private static final int SAFE_MEDIA_VOLUME_ACTIVE = 3;
    private Integer mSafeMediaVolumeState;
    private int mMcc = 0;
    private int mSafeMediaVolumeIndex;
    private final int mSafeMediaVolumeDevices = 12;
    private int mMusicActiveMs;
    private static final int UNSAFE_VOLUME_MUSIC_ACTIVE_MS_MAX = 72000000;
    private static final int MUSIC_ACTIVE_POLL_PERIOD_MS = 60000;
    private static final int SAFE_VOLUME_CONFIGURE_TIMEOUT_MS = 30000;
    private boolean mHdmiSystemAudioSupported = false;
    private HdmiTvClient mHdmiTvClient;
    private HdmiControlManager mHdmiManager;
    private HdmiPlaybackClient mHdmiPlaybackClient;
    private boolean mHdmiCecSink;
    private MyDisplayStatusCallback mHdmiDisplayStatusCallback = new MyDisplayStatusCallback();
    private Boolean mCameraSoundForced;
    private static final String[] RINGER_MODE_NAMES;
    private HashMap<IBinder, AudioPolicyProxy> mAudioPolicies = new HashMap();

    private boolean isPlatformVoice() {
        return this.mPlatformType == 1;
    }

    private boolean isPlatformTelevision() {
        return this.mPlatformType == 2;
    }

    public AudioService(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.mPlatformType = this.mContext.getResources().getBoolean(17956931) ? 1 : (context.getPackageManager().hasSystemFeature("android.hardware.type.television") ? 2 : 0);
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mAudioEventWakeLock = pm.newWakeLock(1, "handleAudioEvent");
        Vibrator vibrator = (Vibrator)context.getSystemService("vibrator");
        this.mHasVibrator = vibrator == null ? false : vibrator.hasVibrator();
        AudioService.MAX_STREAM_VOLUME[0] = SystemProperties.getInt("ro.config.vc_call_vol_steps", MAX_STREAM_VOLUME[0]);
        AudioService.MAX_STREAM_VOLUME[3] = SystemProperties.getInt("ro.config.media_vol_steps", MAX_STREAM_VOLUME[3]);
        sSoundEffectVolumeDb = context.getResources().getInteger(17694724);
        this.mForcedUseForComm = 0;
        this.createAudioSystemThread();
        this.mMediaFocusControl = new MediaFocusControl(this.mAudioHandler.getLooper(), this.mContext, this.mVolumeController, this);
        AudioSystem.setErrorCallback(this.mAudioSystemCallback);
        boolean cameraSoundForced = this.mContext.getResources().getBoolean(17956963);
        this.mCameraSoundForced = new Boolean(cameraSoundForced);
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 4, cameraSoundForced ? 11 : 0, null, 0);
        this.mSafeMediaVolumeState = new Integer(Settings.Global.getInt(this.mContentResolver, "audio_safe_volume_state", 0));
        this.mSafeMediaVolumeIndex = this.mContext.getResources().getInteger(17694831) * 10;
        this.mUseFixedVolume = this.mContext.getResources().getBoolean(17956968);
        this.updateStreamVolumeAlias(false);
        this.readPersistedSettings();
        this.mSettingsObserver = new SettingsObserver();
        this.createStreamStates();
        AudioService.readAndSetLowRamDevice();
        this.mRingerModeMutedStreams = 0;
        this.setRingerModeInt(this.getRingerMode(), false);
        IntentFilter intentFilter = new IntentFilter("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        intentFilter.addAction("android.intent.action.DOCK_EVENT");
        intentFilter.addAction("android.media.action.USB_AUDIO_ACCESSORY_PLUG");
        intentFilter.addAction("android.media.action.USB_AUDIO_DEVICE_PLUG");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.mMonitorOrientation = SystemProperties.getBoolean("ro.audio.monitorOrientation", false);
        if (this.mMonitorOrientation) {
            Log.v(TAG, "monitoring device orientation");
            this.setOrientationForAudioSystem();
        }
        this.mMonitorRotation = SystemProperties.getBoolean("ro.audio.monitorRotation", false);
        if (this.mMonitorRotation) {
            this.mDeviceRotation = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
            Log.v(TAG, "monitoring device rotation, initial=" + this.mDeviceRotation);
            this.mOrientationListener = new AudioOrientationEventListener(this.mContext);
            this.mOrientationListener.enable();
            this.setRotationForAudioSystem();
        }
        context.registerReceiver(this.mReceiver, intentFilter);
        this.mUseMasterVolume = context.getResources().getBoolean(0x1120010);
        this.restoreMasterVolume();
        this.mMasterVolumeRamp = context.getResources().getIntArray(17235979);
        LocalServices.addService(AudioManagerInternal.class, new AudioServiceInternal());
    }

    public void systemReady() {
        AudioService.sendMsg(this.mAudioHandler, 21, 2, 0, 0, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSystemReady() {
        this.mSystemReady = true;
        AudioService.sendMsg(this.mAudioHandler, 7, 2, 0, 0, null, 0);
        this.mKeyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        this.mScoConnectionState = -1;
        this.resetBluetoothSco();
        this.getBluetoothHeadset();
        Intent newIntent = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
        newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", 0);
        this.sendStickyBroadcastToAll(newIntent);
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            adapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 2);
        }
        this.mHdmiManager = (HdmiControlManager)this.mContext.getSystemService("hdmi_control");
        if (this.mHdmiManager != null) {
            HdmiControlManager hdmiControlManager = this.mHdmiManager;
            synchronized (hdmiControlManager) {
                this.mHdmiTvClient = this.mHdmiManager.getTvClient();
                if (this.mHdmiTvClient != null) {
                    this.mFixedVolumeDevices &= 0xFFD3FFFD;
                }
                this.mHdmiPlaybackClient = this.mHdmiManager.getPlaybackClient();
                this.mHdmiCecSink = false;
            }
        }
        AudioService.sendMsg(this.mAudioHandler, 17, 0, 0, 0, null, 30000);
        StreamOverride.init(this.mContext);
    }

    private void createAudioSystemThread() {
        this.mAudioSystemThread = new AudioSystemThread();
        this.mAudioSystemThread.start();
        this.waitForAudioHandlerCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAudioHandlerCreation() {
        AudioService audioService = this;
        synchronized (audioService) {
            while (this.mAudioHandler == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Log.e(TAG, "Interrupted while waiting on volume handler.");
                }
            }
        }
    }

    private void checkAllAliasStreamVolumes() {
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            if (streamType != this.mStreamVolumeAlias[streamType]) {
                this.mStreamStates[streamType].setAllIndexes(this.mStreamStates[this.mStreamVolumeAlias[streamType]]);
            }
            if (this.mStreamStates[streamType].isMuted()) continue;
            this.mStreamStates[streamType].applyAllVolumes();
        }
    }

    private void checkAllFixedVolumeDevices() {
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            this.mStreamStates[streamType].checkFixedVolumeDevices();
        }
    }

    private void checkAllFixedVolumeDevices(int streamType) {
        this.mStreamStates[streamType].checkFixedVolumeDevices();
    }

    private void createStreamStates() {
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        this.mStreamStates = new VolumeStreamState[numStreamTypes];
        VolumeStreamState[] streams = this.mStreamStates;
        for (int i = 0; i < numStreamTypes; ++i) {
            streams[i] = new VolumeStreamState(Settings.System.VOLUME_SETTINGS[this.mStreamVolumeAlias[i]], i);
        }
        this.checkAllFixedVolumeDevices();
        this.checkAllAliasStreamVolumes();
    }

    private void dumpStreamStates(PrintWriter pw) {
        pw.println("\nStream volumes (device: index)");
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int i = 0; i < numStreamTypes; ++i) {
            pw.println("- " + STREAM_NAMES[i] + ":");
            this.mStreamStates[i].dump(pw);
            pw.println("");
        }
        pw.print("\n- mute affected streams = 0x");
        pw.println(Integer.toHexString(this.mMuteAffectedStreams));
    }

    public static String streamToString(int stream) {
        if (stream >= 0 && stream < STREAM_NAMES.length) {
            return STREAM_NAMES[stream];
        }
        if (stream == Integer.MIN_VALUE) {
            return "USE_DEFAULT_STREAM_TYPE";
        }
        return "UNKNOWN_STREAM_" + stream;
    }

    private void updateStreamVolumeAlias(boolean updateVolumes) {
        int dtmfStreamAlias;
        switch (this.mPlatformType) {
            case 1: {
                this.mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_VOICE;
                dtmfStreamAlias = 2;
                break;
            }
            case 2: {
                this.mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_TELEVISION;
                dtmfStreamAlias = 3;
                break;
            }
            default: {
                this.mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_DEFAULT;
                dtmfStreamAlias = 3;
            }
        }
        if (this.isPlatformTelevision()) {
            this.mRingerModeAffectedStreams = 0;
        } else if (this.isInCommunication()) {
            dtmfStreamAlias = 0;
            this.mRingerModeAffectedStreams &= 0xFFFFFEFF;
        } else {
            this.mRingerModeAffectedStreams |= 0x100;
        }
        this.mStreamVolumeAlias[8] = dtmfStreamAlias;
        if (updateVolumes) {
            this.mStreamStates[8].setAllIndexes(this.mStreamStates[dtmfStreamAlias]);
            this.setRingerModeInt(this.getRingerMode(), false);
            AudioService.sendMsg(this.mAudioHandler, 10, 2, 0, 0, this.mStreamStates[8], 0);
        }
    }

    private void readDockAudioSettings(ContentResolver cr) {
        boolean bl = this.mDockAudioMediaEnabled = Settings.Global.getInt(cr, "dock_audio_media_enabled", 0) == 1;
        this.mBecomingNoisyIntentDevices = this.mDockAudioMediaEnabled ? (this.mBecomingNoisyIntentDevices |= 0x800) : (this.mBecomingNoisyIntentDevices &= 0xFFFFF7FF);
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 3, this.mDockAudioMediaEnabled ? 8 : 0, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPersistedSettings() {
        boolean masterMute;
        ContentResolver cr = this.mContentResolver;
        int ringerModeFromSettings = Settings.Global.getInt(cr, "mode_ringer", 2);
        int ringerMode = ringerModeFromSettings;
        if (!AudioManager.isValidRingerMode(ringerMode)) {
            ringerMode = 2;
        }
        if (ringerMode == 1 && !this.mHasVibrator) {
            ringerMode = 0;
        }
        if (ringerMode != ringerModeFromSettings) {
            Settings.Global.putInt(cr, "mode_ringer", ringerMode);
        }
        if (this.mUseFixedVolume || this.isPlatformTelevision()) {
            ringerMode = 2;
        }
        Object object = this.mSettingsLock;
        synchronized (object) {
            this.mRingerMode = ringerMode;
            this.mVibrateSetting = AudioService.getValueForVibrateSetting(0, 1, this.mHasVibrator ? 2 : 0);
            this.mVibrateSetting = AudioService.getValueForVibrateSetting(this.mVibrateSetting, 0, this.mHasVibrator ? 2 : 0);
            this.updateRingerModeAffectedStreams();
            this.readDockAudioSettings(cr);
        }
        this.mMuteAffectedStreams = Settings.System.getIntForUser(cr, "mute_streams_affected", 14, -2);
        boolean bl = masterMute = Settings.System.getIntForUser(cr, "volume_master_mute", 0, -2) == 1;
        if (this.mUseFixedVolume) {
            masterMute = false;
            AudioSystem.setMasterVolume(1.0f);
        }
        AudioSystem.setMasterMute(masterMute);
        this.broadcastMasterMuteStatus(masterMute);
        boolean microphoneMute = Settings.System.getIntForUser(cr, "microphone_mute", 0, -2) == 1;
        AudioSystem.muteMicrophone(microphoneMute);
        this.broadcastRingerMode(ringerMode);
        this.broadcastVibrateSetting(0);
        this.broadcastVibrateSetting(1);
        this.mVolumeController.loadSettings(cr);
    }

    private int rescaleIndex(int index, int srcStream, int dstStream) {
        return (index * this.mStreamStates[dstStream].getMaxIndex() + this.mStreamStates[srcStream].getMaxIndex() / 2) / this.mStreamStates[srcStream].getMaxIndex();
    }

    @Override
    public void adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags, String callingPackage) {
        this.adjustSuggestedStreamVolume(direction, suggestedStreamType, flags, callingPackage, Binder.getCallingUid());
    }

    private void adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags, String callingPackage, int uid) {
        if (DEBUG_VOL) {
            Log.d(TAG, "adjustSuggestedStreamVolume() stream=" + suggestedStreamType + ", flags=" + flags);
        }
        int streamType = this.mVolumeControlStream != -1 ? this.mVolumeControlStream : this.getActiveStreamType(suggestedStreamType);
        int resolvedStream = this.mStreamVolumeAlias[streamType];
        if ((flags & 4) != 0 && resolvedStream != 2) {
            flags &= 0xFFFFFFFB;
        }
        if (this.mVolumeController.suppressAdjustment(resolvedStream, flags)) {
            direction = 0;
            flags &= 0xFFFFFFFB;
            flags &= 0xFFFFFFEF;
            if (DEBUG_VOL) {
                Log.d(TAG, "Volume controller suppressed adjustment");
            }
        }
        this.adjustStreamVolume(streamType, direction, flags, callingPackage, uid);
    }

    @Override
    public void adjustStreamVolume(int streamType, int direction, int flags, String callingPackage) {
        this.adjustStreamVolume(streamType, direction, flags, callingPackage, Binder.getCallingUid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustStreamVolume(int streamType, int direction, int flags, String callingPackage, int uid) {
        int step;
        if (this.mUseFixedVolume) {
            return;
        }
        if (DEBUG_VOL) {
            Log.d(TAG, "adjustStreamVolume() stream=" + streamType + ", dir=" + direction + ", flags=" + flags);
        }
        this.ensureValidDirection(direction);
        this.ensureValidStreamType(streamType);
        int streamTypeAlias = this.mStreamVolumeAlias[streamType];
        VolumeStreamState streamState = this.mStreamStates[streamTypeAlias];
        int device = this.getDeviceForStream(streamTypeAlias);
        int aliasIndex = streamState.getIndex(device);
        boolean adjustVolume = true;
        if ((device & 0x380) == 0 && (flags & 0x40) != 0) {
            return;
        }
        if (this.mAppOps.noteOp(STEAM_VOLUME_OPS[streamTypeAlias], uid, callingPackage) != 0) {
            return;
        }
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            this.mPendingVolumeCommand = null;
        }
        flags &= 0xFFFFFFDF;
        if (streamTypeAlias == 3 && (device & this.mFixedVolumeDevices) != 0) {
            flags |= 0x20;
            step = this.mSafeMediaVolumeState == 3 && (device & 0xC) != 0 ? this.mSafeMediaVolumeIndex : streamState.getMaxIndex();
            if (aliasIndex != 0) {
                aliasIndex = step;
            }
        } else {
            step = this.rescaleIndex(10, streamType, streamTypeAlias);
        }
        if ((flags & 2) != 0 || streamTypeAlias == this.getMasterStreamType()) {
            int result;
            int ringerMode = this.getRingerMode();
            if (ringerMode == 1) {
                flags &= 0xFFFFFFEF;
            }
            boolean bl = adjustVolume = ((result = this.checkForRingerModeChange(aliasIndex, direction, step)) & 1) != 0;
            if ((result & 0x80) != 0) {
                flags |= 0x80;
            }
        }
        int oldIndex = this.mStreamStates[streamType].getIndex(device);
        if (adjustVolume && direction != 0) {
            if (streamTypeAlias == 3 && (device & 0x380) != 0 && (flags & 0x40) == 0) {
                Object result = this.mA2dpAvrcpLock;
                synchronized (result) {
                    if (this.mA2dp != null && this.mAvrcpAbsVolSupported) {
                        this.mA2dp.adjustAvrcpAbsoluteVolume(direction);
                    }
                }
            }
            if (direction == 1 && !this.checkSafeMediaVolume(streamTypeAlias, aliasIndex + step, device)) {
                Log.e(TAG, "adjustStreamVolume() safe volume index = " + oldIndex);
                this.mVolumeController.postDisplaySafeVolumeWarning(flags);
            } else if (streamState.adjustIndex(direction * step, device)) {
                AudioService.sendMsg(this.mAudioHandler, 0, 2, device, 0, streamState, 0);
            }
            int newIndex = this.mStreamStates[streamType].getIndex(device);
            if (this.mHdmiManager != null) {
                HdmiControlManager hdmiControlManager = this.mHdmiManager;
                synchronized (hdmiControlManager) {
                    if (this.mHdmiTvClient != null && streamTypeAlias == 3 && (flags & 0x100) == 0 && oldIndex != newIndex) {
                        int maxIndex = this.getStreamMaxVolume(streamType);
                        HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
                        synchronized (hdmiTvClient) {
                            if (this.mHdmiSystemAudioSupported) {
                                this.mHdmiTvClient.setSystemAudioVolume((oldIndex + 5) / 10, (newIndex + 5) / 10, maxIndex);
                            }
                        }
                    }
                    if (this.mHdmiCecSink && streamTypeAlias == 3 && oldIndex != newIndex) {
                        HdmiPlaybackClient hdmiPlaybackClient = this.mHdmiPlaybackClient;
                        synchronized (hdmiPlaybackClient) {
                            int keyCode = direction == -1 ? 25 : 24;
                            this.mHdmiPlaybackClient.sendKeyEvent(keyCode, true);
                            this.mHdmiPlaybackClient.sendKeyEvent(keyCode, false);
                        }
                    }
                }
            }
        }
        int index = this.mStreamStates[streamType].getIndex(device);
        this.sendVolumeUpdate(streamType, oldIndex, index, flags);
    }

    @Override
    public void adjustMasterVolume(int steps, int flags, String callingPackage) {
        if (this.mUseFixedVolume) {
            return;
        }
        this.ensureValidSteps(steps);
        int volume = Math.round(AudioSystem.getMasterVolume() * 100.0f);
        int delta = 0;
        int numSteps = Math.abs(steps);
        int direction = steps > 0 ? 1 : -1;
        for (int i = 0; i < numSteps; ++i) {
            delta = this.findVolumeDelta(direction, volume);
            volume += delta;
        }
        this.setMasterVolume(volume, flags, callingPackage);
    }

    private void onSetStreamVolume(int streamType, int index, int flags, int device) {
        this.setStreamVolumeInt(this.mStreamVolumeAlias[streamType], index, device, false);
        if ((flags & 2) != 0 || this.mStreamVolumeAlias[streamType] == this.getMasterStreamType()) {
            int newRingerMode = index == 0 ? (this.mHasVibrator ? 1 : 2) : 2;
            this.setRingerMode(newRingerMode, false);
        }
    }

    @Override
    public void setStreamVolume(int streamType, int index, int flags, String callingPackage) {
        this.setStreamVolume(streamType, index, flags, callingPackage, Binder.getCallingUid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStreamVolume(int streamType, int index, int flags, String callingPackage, int uid) {
        int oldIndex;
        if (this.mUseFixedVolume) {
            return;
        }
        this.ensureValidStreamType(streamType);
        int streamTypeAlias = this.mStreamVolumeAlias[streamType];
        VolumeStreamState streamState = this.mStreamStates[streamTypeAlias];
        int device = this.getDeviceForStream(streamType);
        if ((device & 0x380) == 0 && (flags & 0x40) != 0) {
            return;
        }
        if (this.mAppOps.noteOp(STEAM_VOLUME_OPS[streamTypeAlias], uid, callingPackage) != 0) {
            return;
        }
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            Object object;
            this.mPendingVolumeCommand = null;
            oldIndex = streamState.getIndex(device);
            index = this.rescaleIndex(index * 10, streamType, streamTypeAlias);
            if (streamTypeAlias == 3 && (device & 0x380) != 0 && (flags & 0x40) == 0) {
                object = this.mA2dpAvrcpLock;
                synchronized (object) {
                    if (this.mA2dp != null && this.mAvrcpAbsVolSupported) {
                        this.mA2dp.setAvrcpAbsoluteVolume(index / 10);
                    }
                }
            }
            if (this.mHdmiManager != null) {
                object = this.mHdmiManager;
                synchronized (object) {
                    if (this.mHdmiTvClient != null && streamTypeAlias == 3 && (flags & 0x100) == 0 && oldIndex != index) {
                        int maxIndex = this.getStreamMaxVolume(streamType);
                        HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
                        synchronized (hdmiTvClient) {
                            if (this.mHdmiSystemAudioSupported) {
                                this.mHdmiTvClient.setSystemAudioVolume((oldIndex + 5) / 10, (index + 5) / 10, maxIndex);
                            }
                        }
                    }
                }
            }
            flags &= 0xFFFFFFDF;
            if (streamTypeAlias == 3 && (device & this.mFixedVolumeDevices) != 0) {
                flags |= 0x20;
                if (index != 0) {
                    index = this.mSafeMediaVolumeState == 3 && (device & 0xC) != 0 ? this.mSafeMediaVolumeIndex : streamState.getMaxIndex();
                }
            }
            if (!this.checkSafeMediaVolume(streamTypeAlias, index, device)) {
                this.mVolumeController.postDisplaySafeVolumeWarning(flags);
                this.mPendingVolumeCommand = new StreamVolumeCommand(streamType, index, flags, device);
            } else {
                this.onSetStreamVolume(streamType, index, flags, device);
                index = this.mStreamStates[streamType].getIndex(device);
            }
        }
        this.sendVolumeUpdate(streamType, oldIndex, index, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceVolumeControlStream(int streamType, IBinder cb) {
        Object object = this.mForceControlStreamLock;
        synchronized (object) {
            this.mVolumeControlStream = streamType;
            if (this.mVolumeControlStream == -1) {
                if (this.mForceControlStreamClient != null) {
                    this.mForceControlStreamClient.release();
                    this.mForceControlStreamClient = null;
                }
            } else {
                this.mForceControlStreamClient = new ForceControlStreamClient(cb);
            }
        }
    }

    private int findVolumeDelta(int direction, int volume) {
        int delta;
        block4: {
            block5: {
                delta = 0;
                if (direction != 1) break block5;
                if (volume == 100) {
                    return 0;
                }
                delta = this.mMasterVolumeRamp[1];
                for (int i = this.mMasterVolumeRamp.length - 1; i > 1; i -= 2) {
                    if (volume < this.mMasterVolumeRamp[i - 1]) continue;
                    delta = this.mMasterVolumeRamp[i];
                    break block4;
                }
                break block4;
            }
            if (direction != -1) break block4;
            if (volume == 0) {
                return 0;
            }
            int length = this.mMasterVolumeRamp.length;
            delta = -this.mMasterVolumeRamp[length - 1];
            for (int i = 2; i < length; i += 2) {
                if (volume > this.mMasterVolumeRamp[i]) continue;
                delta = -this.mMasterVolumeRamp[i - 1];
                break;
            }
        }
        return delta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBroadcastToAll(Intent intent) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStickyBroadcastToAll(Intent intent) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendVolumeUpdate(int streamType, int oldIndex, int index, int flags) {
        if (!this.isPlatformVoice() && streamType == 2) {
            streamType = 5;
        }
        if (this.mHdmiTvClient != null && streamType == 3) {
            HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
            synchronized (hdmiTvClient) {
                if (this.mHdmiSystemAudioSupported && (flags & 0x100) == 0) {
                    flags &= 0xFFFFFFFE;
                }
            }
        }
        this.mVolumeController.postVolumeChanged(streamType, flags);
        if ((flags & 0x20) == 0) {
            oldIndex = (oldIndex + 5) / 10;
            index = (index + 5) / 10;
            Intent intent = new Intent("android.media.VOLUME_CHANGED_ACTION");
            intent.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", streamType);
            intent.putExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", index);
            intent.putExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", oldIndex);
            this.sendBroadcastToAll(intent);
        }
    }

    private void sendMasterVolumeUpdate(int flags, int oldVolume, int newVolume) {
        this.mVolumeController.postMasterVolumeChanged(flags);
        Intent intent = new Intent("android.media.MASTER_VOLUME_CHANGED_ACTION");
        intent.putExtra("android.media.EXTRA_PREV_MASTER_VOLUME_VALUE", oldVolume);
        intent.putExtra("android.media.EXTRA_MASTER_VOLUME_VALUE", newVolume);
        this.sendBroadcastToAll(intent);
    }

    private void sendMasterMuteUpdate(boolean muted, int flags) {
        this.mVolumeController.postMasterMuteChanged(flags);
        this.broadcastMasterMuteStatus(muted);
    }

    private void broadcastMasterMuteStatus(boolean muted) {
        Intent intent = new Intent("android.media.MASTER_MUTE_CHANGED_ACTION");
        intent.putExtra("android.media.EXTRA_MASTER_VOLUME_MUTED", muted);
        intent.addFlags(0x24000000);
        this.sendStickyBroadcastToAll(intent);
    }

    private void setStreamVolumeInt(int streamType, int index, int device, boolean force) {
        VolumeStreamState streamState = this.mStreamStates[streamType];
        if (streamState.setIndex(index, device) || force) {
            AudioService.sendMsg(this.mAudioHandler, 0, 2, device, 0, streamState, 0);
        }
    }

    @Override
    public void setStreamSolo(int streamType, boolean state, IBinder cb) {
        if (this.mUseFixedVolume) {
            return;
        }
        for (int stream = 0; stream < this.mStreamStates.length; ++stream) {
            if (!this.isStreamAffectedByMute(stream) || stream == streamType) continue;
            this.mStreamStates[stream].mute(cb, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStreamMute(int streamType, boolean state, IBinder cb) {
        if (this.mUseFixedVolume) {
            return;
        }
        if (this.isStreamAffectedByMute(streamType)) {
            if (this.mHdmiManager != null) {
                HdmiControlManager hdmiControlManager = this.mHdmiManager;
                synchronized (hdmiControlManager) {
                    if (streamType == 3 && this.mHdmiTvClient != null) {
                        HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
                        synchronized (hdmiTvClient) {
                            if (this.mHdmiSystemAudioSupported) {
                                this.mHdmiTvClient.setSystemAudioMute(state);
                            }
                        }
                    }
                }
            }
            this.mStreamStates[streamType].mute(cb, state);
        }
    }

    @Override
    public boolean isStreamMute(int streamType) {
        return this.mStreamStates[streamType].isMuted();
    }

    private boolean discardRmtSbmxFullVolDeathHandlerFor(IBinder cb) {
        for (RmtSbmxFullVolDeathHandler handler : this.mRmtSbmxFullVolDeathHandlers) {
            if (!handler.isHandlerFor(cb)) continue;
            handler.forget();
            this.mRmtSbmxFullVolDeathHandlers.remove(handler);
            return true;
        }
        return false;
    }

    private boolean hasRmtSbmxFullVolDeathHandlerFor(IBinder cb) {
        Iterator<RmtSbmxFullVolDeathHandler> it = this.mRmtSbmxFullVolDeathHandlers.iterator();
        while (it.hasNext()) {
            if (!it.next().isHandlerFor(cb)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceRemoteSubmixFullVolume(boolean startForcing, IBinder cb) {
        if (cb == null) {
            return;
        }
        if (0 != this.mContext.checkCallingOrSelfPermission("android.permission.CAPTURE_AUDIO_OUTPUT")) {
            Log.w(TAG, "Trying to call forceRemoteSubmixFullVolume() without CAPTURE_AUDIO_OUTPUT");
            return;
        }
        ArrayList<RmtSbmxFullVolDeathHandler> arrayList = this.mRmtSbmxFullVolDeathHandlers;
        synchronized (arrayList) {
            boolean applyRequired = false;
            if (startForcing) {
                if (!this.hasRmtSbmxFullVolDeathHandlerFor(cb)) {
                    this.mRmtSbmxFullVolDeathHandlers.add(new RmtSbmxFullVolDeathHandler(cb));
                    if (this.mRmtSbmxFullVolRefCount == 0) {
                        this.mFullVolumeDevices |= 0x8000;
                        this.mFixedVolumeDevices |= 0x8000;
                        applyRequired = true;
                    }
                    ++this.mRmtSbmxFullVolRefCount;
                }
            } else if (this.discardRmtSbmxFullVolDeathHandlerFor(cb) && this.mRmtSbmxFullVolRefCount > 0) {
                --this.mRmtSbmxFullVolRefCount;
                if (this.mRmtSbmxFullVolRefCount == 0) {
                    this.mFullVolumeDevices &= 0xFFFF7FFF;
                    this.mFixedVolumeDevices &= 0xFFFF7FFF;
                    applyRequired = true;
                }
            }
            if (applyRequired) {
                this.checkAllFixedVolumeDevices(3);
                this.mStreamStates[3].applyAllVolumes();
            }
        }
    }

    @Override
    public void setMasterMute(boolean state, int flags, String callingPackage, IBinder cb) {
        if (this.mUseFixedVolume) {
            return;
        }
        if (this.mAppOps.noteOp(33, Binder.getCallingUid(), callingPackage) != 0) {
            return;
        }
        if (state != AudioSystem.getMasterMute()) {
            AudioSystem.setMasterMute(state);
            AudioService.sendMsg(this.mAudioHandler, 11, 0, state ? 1 : 0, UserHandle.getCallingUserId(), null, 500);
            this.sendMasterMuteUpdate(state, flags);
        }
    }

    @Override
    public boolean isMasterMute() {
        return AudioSystem.getMasterMute();
    }

    protected static int getMaxStreamVolume(int streamType) {
        return MAX_STREAM_VOLUME[streamType];
    }

    @Override
    public int getStreamVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        int device = this.getDeviceForStream(streamType);
        int index = this.mStreamStates[streamType].getIndex(device);
        if (this.mStreamStates[streamType].isMuted()) {
            index = 0;
        }
        if (index != 0 && this.mStreamVolumeAlias[streamType] == 3 && (device & this.mFixedVolumeDevices) != 0) {
            index = this.mStreamStates[streamType].getMaxIndex();
        }
        return (index + 5) / 10;
    }

    @Override
    public int getMasterVolume() {
        if (this.isMasterMute()) {
            return 0;
        }
        return this.getLastAudibleMasterVolume();
    }

    @Override
    public void setMasterVolume(int volume, int flags, String callingPackage) {
        if (this.mUseFixedVolume) {
            return;
        }
        if (this.mAppOps.noteOp(33, Binder.getCallingUid(), callingPackage) != 0) {
            return;
        }
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        this.doSetMasterVolume((float)volume / 100.0f, flags);
    }

    private void doSetMasterVolume(float volume, int flags) {
        if (!AudioSystem.getMasterMute()) {
            int oldVolume = this.getMasterVolume();
            AudioSystem.setMasterVolume(volume);
            int newVolume = this.getMasterVolume();
            if (newVolume != oldVolume) {
                AudioService.sendMsg(this.mAudioHandler, 2, 0, Math.round(volume * 1000.0f), 0, null, 500);
            }
            this.sendMasterVolumeUpdate(flags, oldVolume, newVolume);
        }
    }

    @Override
    public int getStreamMaxVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        return (this.mStreamStates[streamType].getMaxIndex() + 5) / 10;
    }

    @Override
    public int getMasterMaxVolume() {
        return 100;
    }

    @Override
    public int getLastAudibleStreamVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        int device = this.getDeviceForStream(streamType);
        return (this.mStreamStates[streamType].getIndex(device) + 5) / 10;
    }

    @Override
    public int getLastAudibleMasterVolume() {
        return Math.round(AudioSystem.getMasterVolume() * 100.0f);
    }

    @Override
    public int getMasterStreamType() {
        return this.mStreamVolumeAlias[1];
    }

    @Override
    public void setMicrophoneMute(boolean on, String callingPackage) {
        if (this.mAppOps.noteOp(44, Binder.getCallingUid(), callingPackage) != 0) {
            return;
        }
        if (!this.checkAudioSettingsPermission("setMicrophoneMute()")) {
            return;
        }
        AudioSystem.muteMicrophone(on);
        AudioService.sendMsg(this.mAudioHandler, 23, 0, on ? 1 : 0, UserHandle.getCallingUserId(), null, 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRingerMode() {
        Object object = this.mSettingsLock;
        synchronized (object) {
            return this.mRingerMode;
        }
    }

    private void ensureValidRingerMode(int ringerMode) {
        if (!AudioManager.isValidRingerMode(ringerMode)) {
            throw new IllegalArgumentException("Bad ringer mode " + ringerMode);
        }
    }

    @Override
    public void setRingerMode(int ringerMode, boolean checkZen) {
        if (this.mUseFixedVolume || this.isPlatformTelevision()) {
            return;
        }
        if (ringerMode == 1 && !this.mHasVibrator) {
            ringerMode = 0;
        }
        if (checkZen) {
            this.checkZen(ringerMode);
        }
        if (ringerMode != this.getRingerMode()) {
            this.setRingerModeInt(ringerMode, true);
            this.broadcastRingerMode(ringerMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkZen(int ringerMode) {
        int zen = Settings.Global.getInt(this.mContentResolver, "zen_mode", 0);
        if (ringerMode != 0 && zen != 0) {
            long ident = Binder.clearCallingIdentity();
            try {
                Settings.Global.putInt(this.mContentResolver, "zen_mode", 0);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRingerModeInt(int ringerMode, boolean persist) {
        Object object = this.mSettingsLock;
        synchronized (object) {
            this.mRingerMode = ringerMode;
        }
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
            if (this.isStreamMutedByRingerMode(streamType)) {
                if (this.isStreamAffectedByRingerMode(streamType) && ringerMode != 2) continue;
                if (this.isPlatformVoice() && this.mStreamVolumeAlias[streamType] == 2) {
                    VolumeStreamState volumeStreamState = this.mStreamStates[streamType];
                    synchronized (volumeStreamState) {
                        Set set = this.mStreamStates[streamType].mIndex.entrySet();
                        for (Map.Entry entry : set) {
                            if ((Integer)entry.getValue() != 0) continue;
                            entry.setValue(10);
                        }
                    }
                }
                this.mStreamStates[streamType].mute(null, false);
                this.mRingerModeMutedStreams &= ~(1 << streamType);
                continue;
            }
            if (!this.isStreamAffectedByRingerMode(streamType) || ringerMode == 2) continue;
            this.mStreamStates[streamType].mute(null, true);
            this.mRingerModeMutedStreams |= 1 << streamType;
        }
        if (persist) {
            AudioService.sendMsg(this.mAudioHandler, 3, 0, 0, 0, null, 500);
        }
    }

    private void restoreMasterVolume() {
        float volume;
        if (this.mUseFixedVolume) {
            AudioSystem.setMasterVolume(1.0f);
            return;
        }
        if (this.mUseMasterVolume && (volume = Settings.System.getFloatForUser(this.mContentResolver, "volume_master", -1.0f, -2)) >= 0.0f) {
            AudioSystem.setMasterVolume(volume);
        }
    }

    @Override
    public boolean shouldVibrate(int vibrateType) {
        if (!this.mHasVibrator) {
            return false;
        }
        switch (this.getVibrateSetting(vibrateType)) {
            case 1: {
                return this.getRingerMode() != 0;
            }
            case 2: {
                return this.getRingerMode() == 1;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    @Override
    public int getVibrateSetting(int vibrateType) {
        if (!this.mHasVibrator) {
            return 0;
        }
        return this.mVibrateSetting >> vibrateType * 2 & 3;
    }

    @Override
    public void setVibrateSetting(int vibrateType, int vibrateSetting) {
        if (!this.mHasVibrator) {
            return;
        }
        this.mVibrateSetting = AudioService.getValueForVibrateSetting(this.mVibrateSetting, vibrateType, vibrateSetting);
        this.broadcastVibrateSetting(vibrateType);
    }

    public static int getValueForVibrateSetting(int existingValue, int vibrateType, int vibrateSetting) {
        existingValue &= ~(3 << vibrateType * 2);
        return existingValue |= (vibrateSetting & 3) << vibrateType * 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMode(int mode, IBinder cb) {
        if (DEBUG_MODE) {
            Log.v(TAG, "setMode(mode=" + mode + ")");
        }
        if (!this.checkAudioSettingsPermission("setMode()")) {
            return;
        }
        if (mode == 2 && this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.w(TAG, "MODIFY_PHONE_STATE Permission Denial: setMode(MODE_IN_CALL) from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        if (mode < -1 || mode >= 4) {
            return;
        }
        int newModeOwnerPid = 0;
        ArrayList<SetModeDeathHandler> arrayList = this.mSetModeDeathHandlers;
        synchronized (arrayList) {
            if (mode == -1) {
                mode = this.mMode;
            }
            newModeOwnerPid = this.setModeInt(mode, cb, Binder.getCallingPid());
        }
        if (newModeOwnerPid != 0) {
            this.disconnectBluetoothSco(newModeOwnerPid);
        }
    }

    private int setModeInt(int mode, IBinder cb, int pid) {
        if (DEBUG_MODE) {
            Log.v(TAG, "setModeInt(mode=" + mode + ", pid=" + pid + ")");
        }
        int newModeOwnerPid = 0;
        if (cb == null) {
            Log.e(TAG, "setModeInt() called with null binder");
            return newModeOwnerPid;
        }
        SetModeDeathHandler hdlr = null;
        Iterator<SetModeDeathHandler> iter = this.mSetModeDeathHandlers.iterator();
        while (iter.hasNext()) {
            SetModeDeathHandler h = iter.next();
            if (h.getPid() != pid) continue;
            hdlr = h;
            iter.remove();
            hdlr.getBinder().unlinkToDeath(hdlr, 0);
            break;
        }
        int status = 0;
        do {
            if (mode == 0) {
                if (!this.mSetModeDeathHandlers.isEmpty()) {
                    hdlr = this.mSetModeDeathHandlers.get(0);
                    cb = hdlr.getBinder();
                    mode = hdlr.getMode();
                    if (DEBUG_MODE) {
                        Log.w(TAG, " using mode=" + mode + " instead due to death hdlr at pid=" + hdlr.mPid);
                    }
                }
            } else {
                if (hdlr == null) {
                    hdlr = new SetModeDeathHandler(cb, pid);
                }
                try {
                    cb.linkToDeath(hdlr, 0);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "setMode() could not link to " + cb + " binder death");
                }
                this.mSetModeDeathHandlers.add(0, hdlr);
                hdlr.setMode(mode);
            }
            if (mode != this.mMode) {
                status = AudioSystem.setPhoneState(mode);
                if (status == 0) {
                    if (DEBUG_MODE) {
                        Log.v(TAG, " mode successfully set to " + mode);
                    }
                    this.mMode = mode;
                    continue;
                }
                if (hdlr != null) {
                    this.mSetModeDeathHandlers.remove(hdlr);
                    cb.unlinkToDeath(hdlr, 0);
                }
                if (DEBUG_MODE) {
                    Log.w(TAG, " mode set to MODE_NORMAL after phoneState pb");
                }
                mode = 0;
                continue;
            }
            status = 0;
        } while (status != 0 && !this.mSetModeDeathHandlers.isEmpty());
        if (status == 0) {
            if (mode != 0) {
                if (this.mSetModeDeathHandlers.isEmpty()) {
                    Log.e(TAG, "setMode() different from MODE_NORMAL with empty mode client stack");
                } else {
                    newModeOwnerPid = this.mSetModeDeathHandlers.get(0).getPid();
                }
            }
            int streamType = this.getActiveStreamType(Integer.MIN_VALUE);
            int device = this.getDeviceForStream(streamType);
            int index = this.mStreamStates[this.mStreamVolumeAlias[streamType]].getIndex(device);
            this.setStreamVolumeInt(this.mStreamVolumeAlias[streamType], index, device, true);
            this.updateStreamVolumeAlias(true);
        }
        return newModeOwnerPid;
    }

    @Override
    public int getMode() {
        return this.mMode;
    }

    private void loadTouchSoundAssetDefaults() {
        SOUND_EFFECT_FILES.add("Effect_Tick.ogg");
        for (int i = 0; i < 10; ++i) {
            this.SOUND_EFFECT_FILES_MAP[i][0] = 0;
            this.SOUND_EFFECT_FILES_MAP[i][1] = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTouchSoundAssets() {
        block17: {
            XmlResourceParser parser = null;
            if (!SOUND_EFFECT_FILES.isEmpty()) {
                return;
            }
            this.loadTouchSoundAssetDefaults();
            try {
                String element;
                boolean inTouchSoundsGroup;
                block18: {
                    String name;
                    parser = this.mContext.getResources().getXml(0x1110001);
                    XmlUtils.beginDocument(parser, TAG_AUDIO_ASSETS);
                    String version = parser.getAttributeValue(null, ATTR_VERSION);
                    inTouchSoundsGroup = false;
                    if (!ASSET_FILE_VERSION.equals(version)) break block17;
                    do {
                        XmlUtils.nextElement(parser);
                        element = parser.getName();
                        if (element == null) break block18;
                    } while (!element.equals(TAG_GROUP) || !GROUP_TOUCH_SOUNDS.equals(name = parser.getAttributeValue(null, ATTR_GROUP_NAME)));
                    inTouchSoundsGroup = true;
                }
                while (inTouchSoundsGroup) {
                    XmlUtils.nextElement(parser);
                    element = parser.getName();
                    if (element == null) {
                        break;
                    }
                    if (!element.equals(TAG_ASSET)) break;
                    String id2 = parser.getAttributeValue(null, ATTR_ASSET_ID);
                    String file = parser.getAttributeValue(null, ATTR_ASSET_FILE);
                    try {
                        Field field = AudioManager.class.getField(id2);
                        int fx = field.getInt(null);
                    }
                    catch (Exception e) {
                        Log.w(TAG, "Invalid touch sound ID: " + id2);
                        continue;
                    }
                    int i = SOUND_EFFECT_FILES.indexOf(file);
                    if (i == -1) {
                        i = SOUND_EFFECT_FILES.size();
                        SOUND_EFFECT_FILES.add(file);
                    }
                    this.SOUND_EFFECT_FILES_MAP[fx][0] = i;
                }
            }
            catch (Resources.NotFoundException e) {
                Log.w(TAG, "audio assets file not found", e);
            }
            catch (XmlPullParserException e) {
                Log.w(TAG, "XML parser exception reading touch sound assets", e);
            }
            catch (IOException e) {
                Log.w(TAG, "I/O exception reading touch sound assets", e);
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
    }

    @Override
    public void playSoundEffect(int effectType) {
        this.playSoundEffectVolume(effectType, -1.0f);
    }

    @Override
    public void playSoundEffectVolume(int effectType, float volume) {
        if (effectType >= 10 || effectType < 0) {
            Log.w(TAG, "AudioService effectType value " + effectType + " out of range");
            return;
        }
        AudioService.sendMsg(this.mAudioHandler, 5, 2, effectType, (int)(volume * 1000.0f), null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadSoundEffects() {
        LoadSoundEffectReply reply;
        int attempts = 3;
        LoadSoundEffectReply loadSoundEffectReply = reply = new LoadSoundEffectReply();
        synchronized (loadSoundEffectReply) {
            AudioService.sendMsg(this.mAudioHandler, 7, 2, 0, 0, reply, 0);
            while (reply.mStatus == 1 && attempts-- > 0) {
                try {
                    reply.wait(5000L);
                }
                catch (InterruptedException e) {
                    Log.w(TAG, "loadSoundEffects Interrupted while waiting sound pool loaded.");
                }
            }
        }
        return reply.mStatus == 0;
    }

    @Override
    public void unloadSoundEffects() {
        AudioService.sendMsg(this.mAudioHandler, 20, 2, 0, 0, null, 0);
    }

    @Override
    public void reloadAudioSettings() {
        this.readAudioSettings(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAudioSettings(boolean userSwitch) {
        this.readPersistedSettings();
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            VolumeStreamState streamState = this.mStreamStates[streamType];
            if (userSwitch && this.mStreamVolumeAlias[streamType] == 3) continue;
            VolumeStreamState volumeStreamState = streamState;
            synchronized (volumeStreamState) {
                streamState.readSettings();
                if (streamState.isMuted() && (!this.isStreamAffectedByMute(streamType) && !this.isStreamMutedByRingerMode(streamType) || this.mUseFixedVolume)) {
                    int size = streamState.mDeathHandlers.size();
                    for (int i = 0; i < size; ++i) {
                        ((VolumeStreamState.VolumeDeathHandler)streamState.mDeathHandlers.get(i)).mMuteCount = 1;
                        ((VolumeStreamState.VolumeDeathHandler)streamState.mDeathHandlers.get(i)).mute(false);
                    }
                }
                continue;
            }
        }
        this.setRingerModeInt(this.getRingerMode(), false);
        this.checkAllFixedVolumeDevices();
        this.checkAllAliasStreamVolumes();
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            this.mMusicActiveMs = MathUtils.constrain(Settings.Secure.getIntForUser(this.mContentResolver, "unsafe_volume_music_active_ms", 0, -2), 0, 72000000);
            if (this.mSafeMediaVolumeState == 3) {
                this.enforceSafeMediaVolume();
            }
        }
    }

    @Override
    public void setSpeakerphoneOn(boolean on) {
        if (!this.checkAudioSettingsPermission("setSpeakerphoneOn()")) {
            return;
        }
        if (on) {
            if (this.mForcedUseForComm == 3) {
                AudioService.sendMsg(this.mAudioHandler, 8, 2, 2, 0, null, 0);
            }
            this.mForcedUseForComm = 1;
        } else if (this.mForcedUseForComm == 1) {
            this.mForcedUseForComm = 0;
        }
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 0, this.mForcedUseForComm, null, 0);
    }

    @Override
    public boolean isSpeakerphoneOn() {
        return this.mForcedUseForComm == 1;
    }

    @Override
    public void setBluetoothScoOn(boolean on) {
        if (!this.checkAudioSettingsPermission("setBluetoothScoOn()")) {
            return;
        }
        if (on) {
            this.mForcedUseForComm = 3;
        } else if (this.mForcedUseForComm == 3) {
            this.mForcedUseForComm = 0;
        }
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 0, this.mForcedUseForComm, null, 0);
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 2, this.mForcedUseForComm, null, 0);
    }

    @Override
    public boolean isBluetoothScoOn() {
        return this.mForcedUseForComm == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBluetoothA2dpOn(boolean on) {
        Object object = this.mBluetoothA2dpEnabledLock;
        synchronized (object) {
            this.mBluetoothA2dpEnabled = on;
            AudioService.sendMsg(this.mAudioHandler, 13, 2, 1, this.mBluetoothA2dpEnabled ? 0 : 10, null, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBluetoothA2dpOn() {
        Object object = this.mBluetoothA2dpEnabledLock;
        synchronized (object) {
            return this.mBluetoothA2dpEnabled;
        }
    }

    @Override
    public void startBluetoothSco(IBinder cb, int targetSdkVersion) {
        int scoAudioMode = targetSdkVersion < 18 ? 0 : -1;
        this.startBluetoothScoInt(cb, scoAudioMode);
    }

    @Override
    public void startBluetoothScoVirtualCall(IBinder cb) {
        this.startBluetoothScoInt(cb, 0);
    }

    void startBluetoothScoInt(IBinder cb, int scoAudioMode) {
        if (!this.checkAudioSettingsPermission("startBluetoothSco()") || !this.mSystemReady) {
            return;
        }
        ScoClient client = this.getScoClient(cb, true);
        long ident = Binder.clearCallingIdentity();
        client.incCount(scoAudioMode);
        Binder.restoreCallingIdentity(ident);
    }

    @Override
    public void stopBluetoothSco(IBinder cb) {
        if (!this.checkAudioSettingsPermission("stopBluetoothSco()") || !this.mSystemReady) {
            return;
        }
        ScoClient client = this.getScoClient(cb, false);
        long ident = Binder.clearCallingIdentity();
        if (client != null) {
            client.decCount();
        }
        Binder.restoreCallingIdentity(ident);
    }

    private void checkScoAudioState() {
        if (this.mBluetoothHeadset != null && this.mBluetoothHeadsetDevice != null && this.mScoAudioState == 0 && this.mBluetoothHeadset.getAudioState(this.mBluetoothHeadsetDevice) != 10) {
            this.mScoAudioState = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScoClient getScoClient(IBinder cb, boolean create) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            ScoClient client = null;
            int size = this.mScoClients.size();
            for (int i = 0; i < size; ++i) {
                client = this.mScoClients.get(i);
                if (client.getBinder() != cb) continue;
                return client;
            }
            if (create) {
                client = new ScoClient(cb);
                this.mScoClients.add(client);
            }
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllScoClients(int exceptPid, boolean stopSco) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            ScoClient savedClient = null;
            int size = this.mScoClients.size();
            for (int i = 0; i < size; ++i) {
                ScoClient cl = this.mScoClients.get(i);
                if (cl.getPid() != exceptPid) {
                    cl.clearCount(stopSco);
                    continue;
                }
                savedClient = cl;
            }
            this.mScoClients.clear();
            if (savedClient != null) {
                this.mScoClients.add(savedClient);
            }
        }
    }

    private boolean getBluetoothHeadset() {
        boolean result = false;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            result = adapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 1);
        }
        AudioService.sendMsg(this.mAudioHandler, 9, 0, 0, 0, null, result ? 3000 : 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectBluetoothSco(int exceptPid) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            this.checkScoAudioState();
            if (this.mScoAudioState == 2 || this.mScoAudioState == 4) {
                if (this.mBluetoothHeadsetDevice != null) {
                    if (this.mBluetoothHeadset != null) {
                        if (!this.mBluetoothHeadset.stopVoiceRecognition(this.mBluetoothHeadsetDevice)) {
                            AudioService.sendMsg(this.mAudioHandler, 9, 0, 0, 0, null, 0);
                        }
                    } else if (this.mScoAudioState == 2 && this.getBluetoothHeadset()) {
                        this.mScoAudioState = 4;
                    }
                }
            } else {
                this.clearAllScoClients(exceptPid, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetBluetoothSco() {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            this.clearAllScoClients(0, false);
            this.mScoAudioState = 0;
            this.broadcastScoConnectionState(0);
        }
    }

    private void broadcastScoConnectionState(int state) {
        AudioService.sendMsg(this.mAudioHandler, 19, 2, state, 0, null, 0);
    }

    private void onBroadcastScoConnectionState(int state) {
        if (state != this.mScoConnectionState) {
            Intent newIntent = new Intent("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
            newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", state);
            newIntent.putExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", this.mScoConnectionState);
            this.sendStickyBroadcastToAll(newIntent);
            this.mScoConnectionState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCheckMusicActive() {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            int device;
            if (this.mSafeMediaVolumeState == 2 && ((device = this.getDeviceForStream(3)) & 0xC) != 0) {
                AudioService.sendMsg(this.mAudioHandler, 14, 0, 0, 0, null, 60000);
                int index = this.mStreamStates[3].getIndex(device);
                if (AudioSystem.isStreamActive(3, 0) && index > this.mSafeMediaVolumeIndex) {
                    this.mMusicActiveMs += 60000;
                    if (this.mMusicActiveMs > 72000000) {
                        this.setSafeMediaVolumeEnabled(true);
                        this.mMusicActiveMs = 0;
                    }
                    this.saveMusicActiveMs();
                }
            }
        }
    }

    private void saveMusicActiveMs() {
        this.mAudioHandler.obtainMessage(22, this.mMusicActiveMs, 0).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConfigureSafeVolume(boolean force) {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            int mcc = this.mContext.getResources().getConfiguration().mcc;
            if (this.mMcc != mcc || this.mMcc == 0 && force) {
                int persistedState;
                boolean safeMediaVolumeEnabled;
                this.mSafeMediaVolumeIndex = this.mContext.getResources().getInteger(17694831) * 10;
                boolean bl = safeMediaVolumeEnabled = SystemProperties.getBoolean("audio.safemedia.force", false) || this.mContext.getResources().getBoolean(17956961);
                if (safeMediaVolumeEnabled) {
                    persistedState = 3;
                    if (this.mSafeMediaVolumeState != 2) {
                        if (this.mMusicActiveMs == 0) {
                            this.mSafeMediaVolumeState = 3;
                            this.enforceSafeMediaVolume();
                        } else {
                            this.mSafeMediaVolumeState = 2;
                        }
                    }
                } else {
                    persistedState = 1;
                    this.mSafeMediaVolumeState = 1;
                }
                this.mMcc = mcc;
                AudioService.sendMsg(this.mAudioHandler, 18, 2, persistedState, 0, null, 0);
            }
        }
    }

    private int checkForRingerModeChange(int oldIndex, int direction, int step) {
        int result = 1;
        int ringerMode = this.getRingerMode();
        switch (ringerMode) {
            case 2: {
                if (direction != -1) break;
                if (this.mHasVibrator) {
                    if (step > oldIndex || oldIndex >= 2 * step) break;
                    ringerMode = 1;
                    break;
                }
                if (oldIndex >= step) break;
                break;
            }
            case 1: {
                if (!this.mHasVibrator) {
                    Log.e(TAG, "checkForRingerModeChange() current ringer mode is vibratebut no vibrator is present");
                    break;
                }
                if (direction != -1 && direction == 1) {
                    ringerMode = 2;
                }
                result &= 0xFFFFFFFE;
                break;
            }
            case 0: {
                if (direction == 1) {
                    result |= 0x80;
                }
                result &= 0xFFFFFFFE;
                break;
            }
            default: {
                Log.e(TAG, "checkForRingerModeChange() wrong ringer mode: " + ringerMode);
            }
        }
        this.setRingerMode(ringerMode, false);
        this.mPrevVolDirection = direction;
        return result;
    }

    @Override
    public boolean isStreamAffectedByRingerMode(int streamType) {
        return (this.mRingerModeAffectedStreams & 1 << streamType) != 0;
    }

    private boolean isStreamMutedByRingerMode(int streamType) {
        return (this.mRingerModeMutedStreams & 1 << streamType) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateRingerModeAffectedStreams() {
        int ringerModeAffectedStreams = Settings.System.getIntForUser(this.mContentResolver, "mode_ringer_streams_affected", 166, -2);
        ringerModeAffectedStreams |= 0x26;
        switch (this.mPlatformType) {
            case 2: {
                ringerModeAffectedStreams = 0;
                break;
            }
            default: {
                ringerModeAffectedStreams &= 0xFFFFFFF7;
            }
        }
        Boolean bl = this.mCameraSoundForced;
        synchronized (bl) {
            ringerModeAffectedStreams = this.mCameraSoundForced.booleanValue() ? (ringerModeAffectedStreams &= 0xFFFFFF7F) : (ringerModeAffectedStreams |= 0x80);
        }
        ringerModeAffectedStreams = this.mStreamVolumeAlias[8] == 2 ? (ringerModeAffectedStreams |= 0x100) : (ringerModeAffectedStreams &= 0xFFFFFEFF);
        if (ringerModeAffectedStreams != this.mRingerModeAffectedStreams) {
            Settings.System.putIntForUser(this.mContentResolver, "mode_ringer_streams_affected", ringerModeAffectedStreams, -2);
            this.mRingerModeAffectedStreams = ringerModeAffectedStreams;
            return true;
        }
        return false;
    }

    public boolean isStreamAffectedByMute(int streamType) {
        return (this.mMuteAffectedStreams & 1 << streamType) != 0;
    }

    private void ensureValidDirection(int direction) {
        if (direction < -1 || direction > 1) {
            throw new IllegalArgumentException("Bad direction " + direction);
        }
    }

    private void ensureValidSteps(int steps) {
        if (Math.abs(steps) > 4) {
            throw new IllegalArgumentException("Bad volume adjust steps " + steps);
        }
    }

    private void ensureValidStreamType(int streamType) {
        if (streamType < 0 || streamType >= this.mStreamStates.length) {
            throw new IllegalArgumentException("Bad stream type " + streamType);
        }
    }

    private boolean isInCommunication() {
        boolean IsInCall = false;
        TelecomManager telecomManager = (TelecomManager)this.mContext.getSystemService("telecom");
        IsInCall = telecomManager.isInCall();
        return IsInCall || this.getMode() == 3;
    }

    private boolean isAfMusicActiveRecently(int delay_ms) {
        return AudioSystem.isStreamActive(3, delay_ms) || AudioSystem.isStreamActiveRemotely(3, delay_ms);
    }

    private int getActiveStreamType(int suggestedStreamType) {
        switch (this.mPlatformType) {
            case 1: {
                if (this.isInCommunication()) {
                    if (AudioSystem.getForceUse(0) == 3) {
                        return 6;
                    }
                    return 0;
                }
                if (suggestedStreamType == Integer.MIN_VALUE) {
                    if (this.isAfMusicActiveRecently(StreamOverride.sDelayMs)) {
                        if (DEBUG_VOL) {
                            Log.v(TAG, "getActiveStreamType: Forcing STREAM_MUSIC stream active");
                        }
                        return 3;
                    }
                    if (DEBUG_VOL) {
                        Log.v(TAG, "getActiveStreamType: Forcing STREAM_RING b/c default");
                    }
                    return 2;
                }
                if (!this.isAfMusicActiveRecently(0)) break;
                if (DEBUG_VOL) {
                    Log.v(TAG, "getActiveStreamType: Forcing STREAM_MUSIC stream active");
                }
                return 3;
            }
            case 2: {
                if (suggestedStreamType != Integer.MIN_VALUE) break;
                return 3;
            }
            default: {
                if (this.isInCommunication()) {
                    if (AudioSystem.getForceUse(0) == 3) {
                        if (DEBUG_VOL) {
                            Log.v(TAG, "getActiveStreamType: Forcing STREAM_BLUETOOTH_SCO");
                        }
                        return 6;
                    }
                    if (DEBUG_VOL) {
                        Log.v(TAG, "getActiveStreamType: Forcing STREAM_VOICE_CALL");
                    }
                    return 0;
                }
                if (AudioSystem.isStreamActive(5, StreamOverride.sDelayMs) || AudioSystem.isStreamActive(2, StreamOverride.sDelayMs)) {
                    if (DEBUG_VOL) {
                        Log.v(TAG, "getActiveStreamType: Forcing STREAM_NOTIFICATION");
                    }
                    return 5;
                }
                if (suggestedStreamType != Integer.MIN_VALUE) break;
                if (this.isAfMusicActiveRecently(StreamOverride.sDelayMs)) {
                    if (DEBUG_VOL) {
                        Log.v(TAG, "getActiveStreamType: forcing STREAM_MUSIC");
                    }
                    return 3;
                }
                if (DEBUG_VOL) {
                    Log.v(TAG, "getActiveStreamType: using STREAM_NOTIFICATION as default");
                }
                return 5;
            }
        }
        if (DEBUG_VOL) {
            Log.v(TAG, "getActiveStreamType: Returning suggested type " + suggestedStreamType);
        }
        return suggestedStreamType;
    }

    private void broadcastRingerMode(int ringerMode) {
        Intent broadcast = new Intent("android.media.RINGER_MODE_CHANGED");
        broadcast.putExtra("android.media.EXTRA_RINGER_MODE", ringerMode);
        broadcast.addFlags(0x24000000);
        this.sendStickyBroadcastToAll(broadcast);
    }

    private void broadcastVibrateSetting(int vibrateType) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent broadcast = new Intent("android.media.VIBRATE_SETTING_CHANGED");
            broadcast.putExtra("android.media.EXTRA_VIBRATE_TYPE", vibrateType);
            broadcast.putExtra("android.media.EXTRA_VIBRATE_SETTING", this.getVibrateSetting(vibrateType));
            this.sendBroadcastToAll(broadcast);
        }
    }

    private void queueMsgUnderWakeLock(Handler handler, int msg, int arg1, int arg2, Object obj, int delay) {
        long ident = Binder.clearCallingIdentity();
        this.mAudioEventWakeLock.acquire();
        Binder.restoreCallingIdentity(ident);
        AudioService.sendMsg(handler, msg, 2, arg1, arg2, obj, delay);
    }

    private static void sendMsg(Handler handler, int msg, int existingMsgPolicy, int arg1, int arg2, Object obj, int delay) {
        if (existingMsgPolicy == 0) {
            handler.removeMessages(msg);
        } else if (existingMsgPolicy == 1 && handler.hasMessages(msg)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(msg, arg1, arg2, obj), delay);
    }

    boolean checkAudioSettingsPermission(String method) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_SETTINGS") == 0) {
            return true;
        }
        String msg = "Audio Settings Permission Denial: " + method + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid();
        Log.w(TAG, msg);
        return false;
    }

    private int getDeviceForStream(int stream) {
        int device = AudioSystem.getDevicesForStream(stream);
        if ((device & device - 1) != 0) {
            device = (device & 2) != 0 ? 2 : ((device & 0x40000) != 0 ? 262144 : ((device & 0x80000) != 0 ? 524288 : ((device & 0x200000) != 0 ? 0x200000 : (device &= 0x380))));
        }
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWiredDeviceConnectionState(int device, int state, String name) {
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            int delay = this.checkSendBecomingNoisyIntent(device, state);
            this.queueMsgUnderWakeLock(this.mAudioHandler, 100, device, state, name, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBluetoothA2dpDeviceConnectionState(BluetoothDevice device, int state, int profile) {
        int delay;
        if (profile != 2 && profile != 10) {
            throw new IllegalArgumentException("invalid profile " + profile);
        }
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            delay = profile == 2 ? this.checkSendBecomingNoisyIntent(128, state == 2 ? 1 : 0) : 0;
            this.queueMsgUnderWakeLock(this.mAudioHandler, profile == 2 ? 102 : 101, state, 0, device, delay);
        }
        return delay;
    }

    private void makeA2dpDeviceAvailable(String address) {
        VolumeStreamState streamState = this.mStreamStates[3];
        AudioService.sendMsg(this.mAudioHandler, 0, 2, 128, 0, streamState, 0);
        this.setBluetoothA2dpOnInt(true);
        AudioSystem.setDeviceConnectionState(128, 1, address);
        AudioSystem.setParameters("A2dpSuspended=false");
        this.mConnectedDevices.put(new Integer(128), address);
    }

    private void onSendBecomingNoisyIntent() {
        this.sendBroadcastToAll(new Intent("android.media.AUDIO_BECOMING_NOISY"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeA2dpDeviceUnavailableNow(String address) {
        Object object = this.mA2dpAvrcpLock;
        synchronized (object) {
            this.mAvrcpAbsVolSupported = false;
        }
        AudioSystem.setDeviceConnectionState(128, 0, address);
        this.mConnectedDevices.remove(128);
        object = this.mCurAudioRoutes;
        synchronized (object) {
            if (this.mCurAudioRoutes.mBluetoothName != null) {
                this.mCurAudioRoutes.mBluetoothName = null;
                AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
            }
        }
    }

    private void makeA2dpDeviceUnavailableLater(String address) {
        AudioSystem.setParameters("A2dpSuspended=true");
        this.mConnectedDevices.remove(128);
        Message msg = this.mAudioHandler.obtainMessage(6, address);
        this.mAudioHandler.sendMessageDelayed(msg, 8000L);
    }

    private void makeA2dpSrcAvailable(String address) {
        AudioSystem.setDeviceConnectionState(-2147352576, 1, address);
        this.mConnectedDevices.put(new Integer(-2147352576), address);
    }

    private void makeA2dpSrcUnavailable(String address) {
        AudioSystem.setDeviceConnectionState(-2147352576, 0, address);
        this.mConnectedDevices.remove(-2147352576);
    }

    private void cancelA2dpDeviceTimeout() {
        this.mAudioHandler.removeMessages(6);
    }

    private boolean hasScheduledA2dpDockTimeout() {
        return this.mAudioHandler.hasMessages(6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSetA2dpSinkConnectionState(BluetoothDevice btDevice, int state) {
        if (DEBUG_VOL) {
            Log.d(TAG, "onSetA2dpSinkConnectionState btDevice=" + btDevice + "state=" + state);
        }
        if (btDevice == null) {
            return;
        }
        String address = btDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            boolean isConnected;
            boolean bl = isConnected = this.mConnectedDevices.containsKey(128) && this.mConnectedDevices.get(128).equals(address);
            if (isConnected && state != 2) {
                if (btDevice.isBluetoothDock()) {
                    if (state == 0) {
                        this.makeA2dpDeviceUnavailableLater(address);
                    }
                } else {
                    this.makeA2dpDeviceUnavailableNow(address);
                }
                AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
                synchronized (audioRoutesInfo) {
                    if (this.mCurAudioRoutes.mBluetoothName != null) {
                        this.mCurAudioRoutes.mBluetoothName = null;
                        AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
                    }
                }
            }
            if (!isConnected && state == 2) {
                if (btDevice.isBluetoothDock()) {
                    this.cancelA2dpDeviceTimeout();
                    this.mDockAddress = address;
                } else if (this.hasScheduledA2dpDockTimeout()) {
                    this.cancelA2dpDeviceTimeout();
                    this.makeA2dpDeviceUnavailableNow(this.mDockAddress);
                }
                this.makeA2dpDeviceAvailable(address);
                AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
                synchronized (audioRoutesInfo) {
                    String name = btDevice.getAliasName();
                    if (!TextUtils.equals(this.mCurAudioRoutes.mBluetoothName, name)) {
                        this.mCurAudioRoutes.mBluetoothName = name;
                        AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSetA2dpSourceConnectionState(BluetoothDevice btDevice, int state) {
        if (DEBUG_VOL) {
            Log.d(TAG, "onSetA2dpSourceConnectionState btDevice=" + btDevice + " state=" + state);
        }
        if (btDevice == null) {
            return;
        }
        String address = btDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            boolean isConnected;
            boolean bl = isConnected = this.mConnectedDevices.containsKey(-2147352576) && this.mConnectedDevices.get(-2147352576).equals(address);
            if (isConnected && state != 2) {
                this.makeA2dpSrcUnavailable(address);
            } else if (!isConnected && state == 2) {
                this.makeA2dpSrcAvailable(address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void avrcpSupportsAbsoluteVolume(String address, boolean support) {
        Object object = this.mA2dpAvrcpLock;
        synchronized (object) {
            this.mAvrcpAbsVolSupported = support;
            AudioService.sendMsg(this.mAudioHandler, 0, 2, 128, 0, this.mStreamStates[3], 0);
            AudioService.sendMsg(this.mAudioHandler, 0, 2, 128, 0, this.mStreamStates[2], 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleDeviceConnection(boolean connected, int device, String params) {
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            boolean isConnected;
            boolean bl = isConnected = this.mConnectedDevices.containsKey(device) && (params.isEmpty() || this.mConnectedDevices.get(device).equals(params));
            if (isConnected && !connected) {
                AudioSystem.setDeviceConnectionState(device, 0, this.mConnectedDevices.get(device));
                this.mConnectedDevices.remove(device);
                return true;
            }
            if (!isConnected && connected) {
                AudioSystem.setDeviceConnectionState(device, 1, params);
                this.mConnectedDevices.put(new Integer(device), params);
                return true;
            }
        }
        return false;
    }

    private int checkSendBecomingNoisyIntent(int device, int state) {
        int delay = 0;
        if (state == 0 && (device & this.mBecomingNoisyIntentDevices) != 0) {
            int devices = 0;
            for (int dev : this.mConnectedDevices.keySet()) {
                if ((dev & Integer.MIN_VALUE) != 0 || (dev & this.mBecomingNoisyIntentDevices) == 0) continue;
                devices |= dev;
            }
            if (devices == device) {
                AudioService.sendMsg(this.mAudioHandler, 15, 0, 0, 0, null, 0);
                delay = 1000;
            }
        }
        if (this.mAudioHandler.hasMessages(101) || this.mAudioHandler.hasMessages(102) || this.mAudioHandler.hasMessages(100)) {
            delay = 1000;
        }
        return delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDeviceConnectionIntent(int device, int state, String name) {
        Intent intent = new Intent();
        intent.putExtra("state", state);
        intent.putExtra(ATTR_GROUP_NAME, name);
        intent.addFlags(0x40000000);
        int connType = 0;
        if (device == 4) {
            connType = 1;
            intent.setAction("android.intent.action.HEADSET_PLUG");
            intent.putExtra("microphone", 1);
        } else if (device == 8 || device == 131072) {
            connType = 2;
            intent.setAction("android.intent.action.HEADSET_PLUG");
            intent.putExtra("microphone", 0);
        } else if (device == 2048) {
            connType = 4;
            intent.setAction("android.media.action.ANALOG_AUDIO_DOCK_PLUG");
        } else if (device == 4096) {
            connType = 4;
            intent.setAction("android.media.action.DIGITAL_AUDIO_DOCK_PLUG");
        } else if (device == 1024) {
            connType = 8;
            this.configureHdmiPlugIntent(intent, state);
        }
        AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
        synchronized (audioRoutesInfo) {
            if (connType != 0) {
                int newConn = this.mCurAudioRoutes.mMainType;
                newConn = state != 0 ? (newConn |= connType) : (newConn &= ~connType);
                if (newConn != this.mCurAudioRoutes.mMainType) {
                    this.mCurAudioRoutes.mMainType = newConn;
                    AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
                }
            }
        }
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerNative.broadcastStickyIntent(intent, null, -1);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSetWiredDeviceConnectionState(int device, int state, String name) {
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            if (state == 0 && (device == 4 || device == 8 || device == 131072)) {
                this.setBluetoothA2dpOnInt(true);
            }
            boolean isUsb = (device & 0xFFFF9FFF) == 0 || (device & Integer.MIN_VALUE) != 0 && (device & 0x7FFFE7FF) == 0;
            this.handleDeviceConnection(state == 1, device, isUsb ? name : "");
            if (state != 0) {
                if (device == 4 || device == 8 || device == 131072) {
                    this.setBluetoothA2dpOnInt(false);
                }
                if ((device & 0xC) != 0) {
                    AudioService.sendMsg(this.mAudioHandler, 14, 0, 0, 0, null, 60000);
                }
                if (this.isPlatformTelevision() && (device & 0x400) != 0) {
                    this.mFixedVolumeDevices |= 0x400;
                    this.checkAllFixedVolumeDevices();
                    if (this.mHdmiManager != null) {
                        HdmiControlManager hdmiControlManager = this.mHdmiManager;
                        synchronized (hdmiControlManager) {
                            if (this.mHdmiPlaybackClient != null) {
                                this.mHdmiCecSink = false;
                                this.mHdmiPlaybackClient.queryDisplayStatus(this.mHdmiDisplayStatusCallback);
                            }
                        }
                    }
                }
            } else if (this.isPlatformTelevision() && (device & 0x400) != 0 && this.mHdmiManager != null) {
                HdmiControlManager hdmiControlManager = this.mHdmiManager;
                synchronized (hdmiControlManager) {
                    this.mHdmiCecSink = false;
                }
            }
            if (!isUsb && device != -2147483632) {
                this.sendDeviceConnectionIntent(device, state, name);
            }
        }
    }

    private void configureHdmiPlugIntent(Intent intent, int state) {
        int[] portGeneration;
        ArrayList<AudioPort> ports;
        int status;
        intent.setAction("android.media.action.HDMI_AUDIO_PLUG");
        intent.putExtra("android.media.extra.AUDIO_PLUG_STATE", state);
        if (state == 1 && (status = AudioSystem.listAudioPorts(ports = new ArrayList<AudioPort>(), portGeneration = new int[1])) == 0) {
            for (AudioPort port : ports) {
                AudioDevicePort devicePort;
                if (!(port instanceof AudioDevicePort) || (devicePort = (AudioDevicePort)port).type() != 1024) continue;
                int[] formats = devicePort.formats();
                if (formats.length > 0) {
                    ArrayList<Integer> encodingList = new ArrayList<Integer>(1);
                    for (int format : formats) {
                        if (format == 0) continue;
                        encodingList.add(format);
                    }
                    int[] encodingArray = new int[encodingList.size()];
                    for (int i = 0; i < encodingArray.length; ++i) {
                        encodingArray[i] = (Integer)encodingList.get(i);
                    }
                    intent.putExtra("android.media.extra.ENCODINGS", encodingArray);
                }
                int maxChannels = 0;
                for (int mask : devicePort.channelMasks()) {
                    int channelCount = AudioFormat.channelCountFromOutChannelMask(mask);
                    if (channelCount <= maxChannels) continue;
                    maxChannels = channelCount;
                }
                intent.putExtra("android.media.extra.MAX_CHANNEL_COUNT", maxChannels);
            }
        }
    }

    @Override
    public boolean registerRemoteController(IRemoteControlDisplay rcd, int w, int h, ComponentName listenerComp) {
        return this.mMediaFocusControl.registerRemoteController(rcd, w, h, listenerComp);
    }

    @Override
    public boolean registerRemoteControlDisplay(IRemoteControlDisplay rcd, int w, int h) {
        return this.mMediaFocusControl.registerRemoteControlDisplay(rcd, w, h);
    }

    @Override
    public void unregisterRemoteControlDisplay(IRemoteControlDisplay rcd) {
        this.mMediaFocusControl.unregisterRemoteControlDisplay(rcd);
    }

    @Override
    public void remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay rcd, int w, int h) {
        this.mMediaFocusControl.remoteControlDisplayUsesBitmapSize(rcd, w, h);
    }

    @Override
    public void remoteControlDisplayWantsPlaybackPositionSync(IRemoteControlDisplay rcd, boolean wantsSync) {
        this.mMediaFocusControl.remoteControlDisplayWantsPlaybackPositionSync(rcd, wantsSync);
    }

    @Override
    public void setRemoteStreamVolume(int index) {
        this.enforceSelfOrSystemUI("set the remote stream volume");
        this.mMediaFocusControl.setRemoteStreamVolume(index);
    }

    @Override
    public int requestAudioFocus(int mainStreamType, int durationHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName) {
        return this.mMediaFocusControl.requestAudioFocus(mainStreamType, durationHint, cb, fd, clientId, callingPackageName);
    }

    @Override
    public int abandonAudioFocus(IAudioFocusDispatcher fd, String clientId) {
        return this.mMediaFocusControl.abandonAudioFocus(fd, clientId);
    }

    @Override
    public void unregisterAudioFocusClient(String clientId) {
        this.mMediaFocusControl.unregisterAudioFocusClient(clientId);
    }

    @Override
    public int getCurrentAudioFocus() {
        return this.mMediaFocusControl.getCurrentAudioFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConfigurationChanged(Context context) {
        try {
            int newOrientation;
            Configuration config = context.getResources().getConfiguration();
            if (this.mMonitorOrientation && (newOrientation = config.orientation) != this.mDeviceOrientation) {
                this.mDeviceOrientation = newOrientation;
                this.setOrientationForAudioSystem();
            }
            AudioService.sendMsg(this.mAudioHandler, 16, 0, 0, 0, null, 0);
            boolean cameraSoundForced = this.mContext.getResources().getBoolean(17956963);
            Object object = this.mSettingsLock;
            synchronized (object) {
                Boolean bl = this.mCameraSoundForced;
                synchronized (bl) {
                    if (cameraSoundForced != this.mCameraSoundForced) {
                        this.mCameraSoundForced = cameraSoundForced;
                        if (!this.isPlatformTelevision()) {
                            VolumeStreamState s = this.mStreamStates[7];
                            if (cameraSoundForced) {
                                s.setAllIndexesToMax();
                                this.mRingerModeAffectedStreams &= 0xFFFFFF7F;
                            } else {
                                s.setAllIndexes(this.mStreamStates[1]);
                                this.mRingerModeAffectedStreams |= 0x80;
                            }
                            this.setRingerModeInt(this.getRingerMode(), false);
                        }
                        AudioService.sendMsg(this.mAudioHandler, 8, 2, 4, cameraSoundForced ? 11 : 0, null, 0);
                        AudioService.sendMsg(this.mAudioHandler, 10, 2, 0, 0, this.mStreamStates[7], 0);
                    }
                }
            }
            this.mVolumeController.setLayoutDirection(config.getLayoutDirection());
        }
        catch (Exception e) {
            Log.e(TAG, "Error handling configuration change: ", e);
        }
    }

    private void setOrientationForAudioSystem() {
        switch (this.mDeviceOrientation) {
            case 2: {
                AudioSystem.setParameters("orientation=landscape");
                break;
            }
            case 1: {
                AudioSystem.setParameters("orientation=portrait");
                break;
            }
            case 3: {
                AudioSystem.setParameters("orientation=square");
                break;
            }
            case 0: {
                AudioSystem.setParameters("orientation=undefined");
                break;
            }
            default: {
                Log.e(TAG, "Unknown orientation");
            }
        }
    }

    private void setRotationForAudioSystem() {
        switch (this.mDeviceRotation) {
            case 0: {
                AudioSystem.setParameters("rotation=0");
                break;
            }
            case 1: {
                AudioSystem.setParameters("rotation=90");
                break;
            }
            case 2: {
                AudioSystem.setParameters("rotation=180");
                break;
            }
            case 3: {
                AudioSystem.setParameters("rotation=270");
                break;
            }
            default: {
                Log.e(TAG, "Unknown device rotation");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBluetoothA2dpOnInt(boolean on) {
        Object object = this.mBluetoothA2dpEnabledLock;
        synchronized (object) {
            this.mBluetoothA2dpEnabled = on;
            this.mAudioHandler.removeMessages(13);
            AudioSystem.setForceUse(1, this.mBluetoothA2dpEnabled ? 0 : 10);
        }
    }

    @Override
    public void setRingtonePlayer(IRingtonePlayer player) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REMOTE_AUDIO_PLAYBACK", null);
        this.mRingtonePlayer = player;
    }

    @Override
    public IRingtonePlayer getRingtonePlayer() {
        return this.mRingtonePlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver observer) {
        AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
        synchronized (audioRoutesInfo) {
            AudioRoutesInfo routes = new AudioRoutesInfo(this.mCurAudioRoutes);
            this.mRoutesObservers.register(observer);
            return routes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSafeMediaVolumeEnabled(boolean on) {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            if (this.mSafeMediaVolumeState != 0 && this.mSafeMediaVolumeState != 1) {
                if (on && this.mSafeMediaVolumeState == 2) {
                    this.mSafeMediaVolumeState = 3;
                    this.enforceSafeMediaVolume();
                } else if (!on && this.mSafeMediaVolumeState == 3) {
                    this.mSafeMediaVolumeState = 2;
                    this.mMusicActiveMs = 1;
                    this.saveMusicActiveMs();
                    AudioService.sendMsg(this.mAudioHandler, 14, 0, 0, 0, null, 60000);
                }
            }
        }
    }

    private void enforceSafeMediaVolume() {
        VolumeStreamState streamState = this.mStreamStates[3];
        int devices = 12;
        int i = 0;
        while (devices != 0) {
            int device;
            if (((device = 1 << i++) & devices) == 0) continue;
            int index = streamState.getIndex(device);
            if (index > this.mSafeMediaVolumeIndex) {
                streamState.setIndex(this.mSafeMediaVolumeIndex, device);
                AudioService.sendMsg(this.mAudioHandler, 0, 2, device, 0, streamState, 0);
            }
            devices &= ~device;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSafeMediaVolume(int streamType, int index, int device) {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            return this.mSafeMediaVolumeState != 3 || this.mStreamVolumeAlias[streamType] != 3 || (device & 0xC) == 0 || index <= this.mSafeMediaVolumeIndex;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableSafeMediaVolume() {
        this.enforceSelfOrSystemUI("disable the safe media volume");
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            this.setSafeMediaVolumeEnabled(false);
            if (this.mPendingVolumeCommand != null) {
                this.onSetStreamVolume(this.mPendingVolumeCommand.mStreamType, this.mPendingVolumeCommand.mIndex, this.mPendingVolumeCommand.mFlags, this.mPendingVolumeCommand.mDevice);
                this.mPendingVolumeCommand = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setHdmiSystemAudioSupported(boolean on) {
        int device = 0;
        if (this.mHdmiManager != null) {
            HdmiControlManager hdmiControlManager = this.mHdmiManager;
            synchronized (hdmiControlManager) {
                if (this.mHdmiTvClient == null) {
                    Log.w(TAG, "Only Hdmi-Cec enabled TV device supports system audio mode.");
                    return device;
                }
                HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
                synchronized (hdmiTvClient) {
                    if (this.mHdmiSystemAudioSupported != on) {
                        this.mHdmiSystemAudioSupported = on;
                        AudioSystem.setForceUse(5, on ? 12 : 0);
                    }
                    device = AudioSystem.getDevicesForStream(3);
                }
            }
        }
        return device;
    }

    @Override
    public boolean isHdmiSystemAudioSupported() {
        return this.mHdmiSystemAudioSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCameraSoundForced() {
        Boolean bl = this.mCameraSoundForced;
        synchronized (bl) {
            return this.mCameraSoundForced;
        }
    }

    private void dumpRingerMode(PrintWriter pw) {
        pw.println("\nRinger mode: ");
        pw.println("- mode: " + RINGER_MODE_NAMES[this.mRingerMode]);
        pw.print("- ringer mode affected streams = 0x");
        pw.println(Integer.toHexString(this.mRingerModeAffectedStreams));
        pw.print("- ringer mode muted streams = 0x");
        pw.println(Integer.toHexString(this.mRingerModeMutedStreams));
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        this.mMediaFocusControl.dump(pw);
        this.dumpStreamStates(pw);
        this.dumpRingerMode(pw);
        pw.println("\nAudio routes:");
        pw.print("  mMainType=0x");
        pw.println(Integer.toHexString(this.mCurAudioRoutes.mMainType));
        pw.print("  mBluetoothName=");
        pw.println(this.mCurAudioRoutes.mBluetoothName);
        pw.println("\nOther state:");
        pw.print("  mVolumeController=");
        pw.println(this.mVolumeController);
        pw.print("  mSafeMediaVolumeState=");
        pw.println(AudioService.safeMediaVolumeStateToString(this.mSafeMediaVolumeState));
        pw.print("  mSafeMediaVolumeIndex=");
        pw.println(this.mSafeMediaVolumeIndex);
        pw.print("  mPendingVolumeCommand=");
        pw.println(this.mPendingVolumeCommand);
        pw.print("  mMusicActiveMs=");
        pw.println(this.mMusicActiveMs);
        pw.print("  mMcc=");
        pw.println(this.mMcc);
    }

    private static String safeMediaVolumeStateToString(Integer state) {
        switch (state) {
            case 0: {
                return "SAFE_MEDIA_VOLUME_NOT_CONFIGURED";
            }
            case 1: {
                return "SAFE_MEDIA_VOLUME_DISABLED";
            }
            case 2: {
                return "SAFE_MEDIA_VOLUME_INACTIVE";
            }
            case 3: {
                return "SAFE_MEDIA_VOLUME_ACTIVE";
            }
        }
        return null;
    }

    private static void readAndSetLowRamDevice() {
        int status = AudioSystem.setLowRamDevice(ActivityManager.isLowRamDeviceStatic());
        if (status != 0) {
            Log.w(TAG, "AudioFlinger informed of device's low RAM attribute; status " + status);
        }
    }

    private void enforceSelfOrSystemUI(String action) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "Only SystemUI can " + action);
    }

    @Override
    public void setVolumeController(final IVolumeController controller) {
        this.enforceSelfOrSystemUI("set the volume controller");
        if (this.mVolumeController.isSameBinder(controller)) {
            return;
        }
        this.mVolumeController.postDismiss();
        if (controller != null) {
            try {
                controller.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                    @Override
                    public void binderDied() {
                        if (AudioService.this.mVolumeController.isSameBinder(controller)) {
                            Log.w(AudioService.TAG, "Current remote volume controller died, unregistering");
                            AudioService.this.setVolumeController(null);
                        }
                    }
                }, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mVolumeController.setController(controller);
        if (DEBUG_VOL) {
            Log.d(TAG, "Volume controller: " + this.mVolumeController);
        }
    }

    @Override
    public void notifyVolumeControllerVisible(IVolumeController controller, boolean visible) {
        this.enforceSelfOrSystemUI("notify about volume controller visibility");
        if (!this.mVolumeController.isSameBinder(controller)) {
            return;
        }
        this.mVolumeController.setVisible(visible);
        if (DEBUG_VOL) {
            Log.d(TAG, "Volume controller visible: " + visible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerAudioPolicy(AudioPolicyConfig policyConfig, IBinder cb) {
        boolean hasPermissionForPolicy;
        boolean bl = hasPermissionForPolicy = 0 == this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_ROUTING");
        if (!hasPermissionForPolicy) {
            Slog.w(TAG, "Can't register audio policy for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid() + ", need MODIFY_AUDIO_ROUTING");
            return false;
        }
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app = new AudioPolicyProxy(policyConfig, cb);
            try {
                cb.linkToDeath(app, 0);
                this.mAudioPolicies.put(cb, app);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Audio policy registration failed, could not link to " + cb + " binder death", e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAudioPolicyAsync(IBinder cb) {
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app = this.mAudioPolicies.remove(cb);
            if (app == null) {
                Slog.w(TAG, "Trying to unregister unknown audio policy for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid());
            } else {
                cb.unlinkToDeath(app, 0);
            }
        }
    }

    static {
        RINGER_MODE_NAMES = new String[]{"SILENT", "VIBRATE", "NORMAL"};
    }

    public class AudioPolicyProxy
    implements IBinder.DeathRecipient {
        private static final String TAG = "AudioPolicyProxy";
        AudioPolicyConfig mConfig;
        IBinder mToken;

        AudioPolicyProxy(AudioPolicyConfig config, IBinder token) {
            this.mConfig = config;
            this.mToken = token;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            HashMap hashMap = AudioService.this.mAudioPolicies;
            synchronized (hashMap) {
                Log.v(TAG, "audio policy " + this.mToken + " died");
                AudioService.this.mAudioPolicies.remove(this.mToken);
            }
        }
    }

    final class AudioServiceInternal
    extends AudioManagerInternal {
        AudioServiceInternal() {
        }

        @Override
        public void adjustSuggestedStreamVolumeForUid(int streamType, int direction, int flags, String callingPackage, int uid) {
            AudioService.this.adjustSuggestedStreamVolume(direction, streamType, flags, callingPackage, uid);
        }

        @Override
        public void adjustStreamVolumeForUid(int streamType, int direction, int flags, String callingPackage, int uid) {
            AudioService.this.adjustStreamVolume(streamType, direction, flags, callingPackage, uid);
        }

        @Override
        public void setStreamVolumeForUid(int streamType, int direction, int flags, String callingPackage, int uid) {
            AudioService.this.setStreamVolume(streamType, direction, flags, callingPackage, uid);
        }
    }

    public static class VolumeController {
        private static final String TAG = "VolumeController";
        private IVolumeController mController;
        private boolean mVisible;
        private long mNextLongPress;
        private int mLongPressTimeout;

        public void setController(IVolumeController controller) {
            this.mController = controller;
            this.mVisible = false;
        }

        public void loadSettings(ContentResolver cr) {
            this.mLongPressTimeout = Settings.Secure.getIntForUser(cr, "long_press_timeout", 500, -2);
        }

        public boolean suppressAdjustment(int resolvedStream, int flags) {
            boolean suppress = false;
            if (resolvedStream == 2 && this.mController != null) {
                long now = SystemClock.uptimeMillis();
                if ((flags & 1) != 0 && !this.mVisible) {
                    if (this.mNextLongPress < now) {
                        this.mNextLongPress = now + (long)this.mLongPressTimeout;
                    }
                    suppress = true;
                } else if (this.mNextLongPress > 0L) {
                    if (now > this.mNextLongPress) {
                        this.mNextLongPress = 0L;
                    } else {
                        suppress = true;
                    }
                }
            }
            return suppress;
        }

        public void setVisible(boolean visible) {
            this.mVisible = visible;
        }

        public boolean isSameBinder(IVolumeController controller) {
            return Objects.equals(this.asBinder(), VolumeController.binder(controller));
        }

        public IBinder asBinder() {
            return VolumeController.binder(this.mController);
        }

        private static IBinder binder(IVolumeController controller) {
            return controller == null ? null : controller.asBinder();
        }

        public String toString() {
            return "VolumeController(" + this.asBinder() + ",mVisible=" + this.mVisible + ")";
        }

        public void postDisplaySafeVolumeWarning(int flags) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.displaySafeVolumeWarning(flags);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling displaySafeVolumeWarning", e);
            }
        }

        public void postVolumeChanged(int streamType, int flags) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.volumeChanged(streamType, flags);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling volumeChanged", e);
            }
        }

        public void postMasterVolumeChanged(int flags) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.masterVolumeChanged(flags);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling masterVolumeChanged", e);
            }
        }

        public void postMasterMuteChanged(int flags) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.masterMuteChanged(flags);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling masterMuteChanged", e);
            }
        }

        public void setLayoutDirection(int layoutDirection) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.setLayoutDirection(layoutDirection);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling setLayoutDirection", e);
            }
        }

        public void postDismiss() {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.dismiss();
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling dismiss", e);
            }
        }
    }

    private static class StreamOverride
    implements AccessibilityManager.TouchExplorationStateChangeListener {
        private static final int DEFAULT_STREAM_TYPE_OVERRIDE_DELAY_MS = 5000;
        private static final int TOUCH_EXPLORE_STREAM_TYPE_OVERRIDE_DELAY_MS = 1000;
        static int sDelayMs;

        private StreamOverride() {
        }

        static void init(Context ctxt) {
            AccessibilityManager accessibilityManager = (AccessibilityManager)ctxt.getSystemService("accessibility");
            StreamOverride.updateDefaultStreamOverrideDelay(accessibilityManager.isTouchExplorationEnabled());
            accessibilityManager.addTouchExplorationStateChangeListener(new StreamOverride());
        }

        @Override
        public void onTouchExplorationStateChanged(boolean enabled) {
            StreamOverride.updateDefaultStreamOverrideDelay(enabled);
        }

        private static void updateDefaultStreamOverrideDelay(boolean touchExploreEnabled) {
            sDelayMs = touchExploreEnabled ? 1000 : 5000;
            if (DEBUG_VOL) {
                Log.d(AudioService.TAG, "Touch exploration enabled=" + touchExploreEnabled + " stream override delay is now " + sDelayMs + " ms");
            }
        }
    }

    private class MyDisplayStatusCallback
    implements HdmiPlaybackClient.DisplayStatusCallback {
        private MyDisplayStatusCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete(int status) {
            if (AudioService.this.mHdmiManager != null) {
                HdmiControlManager hdmiControlManager = AudioService.this.mHdmiManager;
                synchronized (hdmiControlManager) {
                    AudioService.this.mHdmiCecSink = status != -1;
                    if (AudioService.this.isPlatformTelevision() && !AudioService.this.mHdmiCecSink) {
                        AudioService.this.mFixedVolumeDevices &= 0xFFFFFBFF;
                    }
                    AudioService.this.checkAllFixedVolumeDevices();
                }
            }
        }
    }

    private class AudioServiceBroadcastReceiver
    extends BroadcastReceiver {
        private AudioServiceBroadcastReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.DOCK_EVENT")) {
                int config;
                int dockState = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
                switch (dockState) {
                    case 1: {
                        config = 7;
                        break;
                    }
                    case 2: {
                        config = 6;
                        break;
                    }
                    case 3: {
                        config = 8;
                        break;
                    }
                    case 4: {
                        config = 9;
                        break;
                    }
                    default: {
                        config = 0;
                    }
                }
                if (dockState != 3 && (dockState != 0 || AudioService.this.mDockState != 3)) {
                    AudioSystem.setForceUse(3, config);
                }
                AudioService.this.mDockState = dockState;
            } else if (action.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                boolean success;
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                int outDevice = 16;
                int inDevice = -2147483640;
                String address = null;
                BluetoothDevice btDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (btDevice == null) {
                    return;
                }
                address = btDevice.getAddress();
                BluetoothClass btClass = btDevice.getBluetoothClass();
                if (btClass != null) {
                    switch (btClass.getDeviceClass()) {
                        case 1028: 
                        case 1032: {
                            outDevice = 32;
                            break;
                        }
                        case 1056: {
                            outDevice = 64;
                        }
                    }
                }
                if (!BluetoothAdapter.checkBluetoothAddress(address)) {
                    address = "";
                }
                boolean connected = state == 2;
                boolean bl = success = AudioService.this.handleDeviceConnection(connected, outDevice, address) && AudioService.this.handleDeviceConnection(connected, inDevice, address);
                if (success) {
                    ArrayList arrayList = AudioService.this.mScoClients;
                    synchronized (arrayList) {
                        if (connected) {
                            AudioService.this.mBluetoothHeadsetDevice = btDevice;
                        } else {
                            AudioService.this.mBluetoothHeadsetDevice = null;
                            AudioService.this.resetBluetoothSco();
                        }
                    }
                }
            } else if (action.equals("android.media.action.USB_AUDIO_ACCESSORY_PLUG")) {
                int state = intent.getIntExtra("state", 0);
                int alsaCard = intent.getIntExtra("card", -1);
                int alsaDevice = intent.getIntExtra("device", -1);
                String params = alsaCard == -1 && alsaDevice == -1 ? "" : "card=" + alsaCard + ";device=" + alsaDevice;
                int outDevice = 8192;
                AudioService.this.setWiredDeviceConnectionState(outDevice, state, params);
            } else if (action.equals("android.media.action.USB_AUDIO_DEVICE_PLUG")) {
                String params;
                int isDisabled = Settings.Secure.getInt(AudioService.this.mContentResolver, "usb_audio_automatic_routing_disabled", 0);
                if (isDisabled != 0) {
                    return;
                }
                int state = intent.getIntExtra("state", 0);
                int alsaCard = intent.getIntExtra("card", -1);
                int alsaDevice = intent.getIntExtra("device", -1);
                boolean hasPlayback = intent.getBooleanExtra("hasPlayback", false);
                boolean hasCapture = intent.getBooleanExtra("hasCapture", false);
                boolean hasMIDI = intent.getBooleanExtra("hasMIDI", false);
                String string2 = params = alsaCard == -1 && alsaDevice == -1 ? "" : "card=" + alsaCard + ";device=" + alsaDevice;
                if (hasPlayback) {
                    int outDevice = 16384;
                    AudioService.this.setWiredDeviceConnectionState(outDevice, state, params);
                }
                if (hasCapture) {
                    int inDevice = -2147479552;
                    AudioService.this.setWiredDeviceConnectionState(inDevice, state, params);
                }
            } else if (action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                boolean broadcast = false;
                int scoAudioState = -1;
                ArrayList alsaDevice = AudioService.this.mScoClients;
                synchronized (alsaDevice) {
                    int btState = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                    if (!(AudioService.this.mScoClients.isEmpty() || AudioService.this.mScoAudioState != 3 && AudioService.this.mScoAudioState != 1 && AudioService.this.mScoAudioState != 5)) {
                        broadcast = true;
                    }
                    switch (btState) {
                        case 12: {
                            scoAudioState = 1;
                            if (AudioService.this.mScoAudioState == 3 || AudioService.this.mScoAudioState == 5 || AudioService.this.mScoAudioState == 4) break;
                            AudioService.this.mScoAudioState = 2;
                            break;
                        }
                        case 10: {
                            scoAudioState = 0;
                            AudioService.this.mScoAudioState = 0;
                            AudioService.this.clearAllScoClients(0, false);
                            break;
                        }
                        case 11: {
                            if (AudioService.this.mScoAudioState != 3 && AudioService.this.mScoAudioState != 5 && AudioService.this.mScoAudioState != 4) {
                                AudioService.this.mScoAudioState = 2;
                            }
                        }
                        default: {
                            broadcast = false;
                        }
                    }
                }
                if (broadcast) {
                    AudioService.this.broadcastScoConnectionState(scoAudioState);
                    Intent newIntent = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
                    newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", scoAudioState);
                    AudioService.this.sendStickyBroadcastToAll(newIntent);
                }
            } else if (action.equals("android.intent.action.SCREEN_ON")) {
                if (AudioService.this.mMonitorRotation) {
                    AudioService.this.mOrientationListener.onOrientationChanged(0);
                    AudioService.this.mOrientationListener.enable();
                }
                AudioSystem.setParameters("screen_state=on");
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                if (AudioService.this.mMonitorRotation) {
                    AudioService.this.mOrientationListener.disable();
                }
                AudioSystem.setParameters("screen_state=off");
            } else if (action.equals("android.intent.action.CONFIGURATION_CHANGED")) {
                AudioService.this.handleConfigurationChanged(context);
            } else if (action.equals("android.intent.action.USER_SWITCHED")) {
                AudioService.sendMsg(AudioService.this.mAudioHandler, 15, 0, 0, 0, null, 0);
                AudioService.this.mMediaFocusControl.discardAudioFocusOwner();
                AudioService.this.readAudioSettings(true);
                AudioService.sendMsg(AudioService.this.mAudioHandler, 10, 2, 0, 0, AudioService.this.mStreamStates[3], 0);
            }
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        SettingsObserver() {
            super(new Handler());
            AudioService.this.mContentResolver.registerContentObserver(Settings.System.getUriFor("mode_ringer_streams_affected"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("dock_audio_media_enabled"), false, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            Object object = AudioService.this.mSettingsLock;
            synchronized (object) {
                if (AudioService.this.updateRingerModeAffectedStreams()) {
                    AudioService.this.setRingerModeInt(AudioService.this.getRingerMode(), false);
                }
                AudioService.this.readDockAudioSettings(AudioService.this.mContentResolver);
            }
        }
    }

    private class AudioHandler
    extends Handler {
        private AudioHandler() {
        }

        private void setDeviceVolume(VolumeStreamState streamState, int device) {
            streamState.applyDeviceVolume(device);
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                if (streamType == streamState.mStreamType || AudioService.this.mStreamVolumeAlias[streamType] != streamState.mStreamType) continue;
                int streamDevice = AudioService.this.getDeviceForStream(streamType);
                if (device != streamDevice && AudioService.this.mAvrcpAbsVolSupported && (device & 0x380) != 0) {
                    AudioService.this.mStreamStates[streamType].applyDeviceVolume(device);
                }
                AudioService.this.mStreamStates[streamType].applyDeviceVolume(streamDevice);
            }
            AudioService.sendMsg(AudioService.this.mAudioHandler, 1, 2, device, 0, streamState, 500);
        }

        private void setAllVolumes(VolumeStreamState streamState) {
            streamState.applyAllVolumes();
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                if (streamType == streamState.mStreamType || AudioService.this.mStreamVolumeAlias[streamType] != streamState.mStreamType) continue;
                AudioService.this.mStreamStates[streamType].applyAllVolumes();
            }
        }

        private void persistVolume(VolumeStreamState streamState, int device) {
            if (AudioService.this.mUseFixedVolume) {
                return;
            }
            if (AudioService.this.isPlatformTelevision() && streamState.mStreamType != 3) {
                return;
            }
            Settings.System.putIntForUser(AudioService.this.mContentResolver, streamState.getSettingNameForDevice(device), (streamState.getIndex(device) + 5) / 10, -2);
        }

        private void persistRingerMode(int ringerMode) {
            if (AudioService.this.mUseFixedVolume) {
                return;
            }
            Settings.Global.putInt(AudioService.this.mContentResolver, "mode_ringer", ringerMode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean onLoadSoundEffects() {
            int status;
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                int effect;
                if (!AudioService.this.mSystemReady) {
                    Log.w(AudioService.TAG, "onLoadSoundEffects() called before boot complete");
                    return false;
                }
                if (AudioService.this.mSoundPool != null) {
                    return true;
                }
                AudioService.this.loadTouchSoundAssets();
                AudioService.this.mSoundPool = new SoundPool.Builder().setMaxStreams(4).setAudioAttributes(new AudioAttributes.Builder().setUsage(13).setContentType(4).build()).build();
                AudioService.this.mSoundPoolCallBack = null;
                AudioService.this.mSoundPoolListenerThread = new SoundPoolListenerThread();
                AudioService.this.mSoundPoolListenerThread.start();
                int attempts = 3;
                while (AudioService.this.mSoundPoolCallBack == null && attempts-- > 0) {
                    try {
                        AudioService.this.mSoundEffectsLock.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        Log.w(AudioService.TAG, "Interrupted while waiting sound pool listener thread.");
                    }
                }
                if (AudioService.this.mSoundPoolCallBack == null) {
                    Log.w(AudioService.TAG, "onLoadSoundEffects() SoundPool listener or thread creation error");
                    if (AudioService.this.mSoundPoolLooper != null) {
                        AudioService.this.mSoundPoolLooper.quit();
                        AudioService.this.mSoundPoolLooper = null;
                    }
                    AudioService.this.mSoundPoolListenerThread = null;
                    AudioService.this.mSoundPool.release();
                    AudioService.this.mSoundPool = null;
                    return false;
                }
                int[] poolId = new int[SOUND_EFFECT_FILES.size()];
                for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.size(); ++fileIdx) {
                    poolId[fileIdx] = -1;
                }
                int numSamples = 0;
                for (effect = 0; effect < 10; ++effect) {
                    if (AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1] == 0) continue;
                    if (poolId[AudioService.this.SOUND_EFFECT_FILES_MAP[effect][0]] == -1) {
                        String filePath = Environment.getRootDirectory() + AudioService.SOUND_EFFECTS_PATH + (String)SOUND_EFFECT_FILES.get(AudioService.this.SOUND_EFFECT_FILES_MAP[effect][0]);
                        int sampleId = AudioService.this.mSoundPool.load(filePath, 0);
                        if (sampleId <= 0) {
                            Log.w(AudioService.TAG, "Soundpool could not load file: " + filePath);
                            continue;
                        }
                        ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = sampleId;
                        poolId[((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][0]] = sampleId;
                        ++numSamples;
                        continue;
                    }
                    ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = poolId[AudioService.this.SOUND_EFFECT_FILES_MAP[effect][0]];
                }
                if (numSamples > 0) {
                    AudioService.this.mSoundPoolCallBack.setSamples(poolId);
                    attempts = 3;
                    status = 1;
                    while (status == 1 && attempts-- > 0) {
                        try {
                            AudioService.this.mSoundEffectsLock.wait(5000L);
                            status = AudioService.this.mSoundPoolCallBack.status();
                        }
                        catch (InterruptedException e) {
                            Log.w(AudioService.TAG, "Interrupted while waiting sound pool callback.");
                        }
                    }
                } else {
                    status = -1;
                }
                if (AudioService.this.mSoundPoolLooper != null) {
                    AudioService.this.mSoundPoolLooper.quit();
                    AudioService.this.mSoundPoolLooper = null;
                }
                AudioService.this.mSoundPoolListenerThread = null;
                if (status != 0) {
                    Log.w(AudioService.TAG, "onLoadSoundEffects(), Error " + status + " while loading samples");
                    for (effect = 0; effect < 10; ++effect) {
                        if (AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1] <= 0) continue;
                        ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = -1;
                    }
                    AudioService.this.mSoundPool.release();
                    AudioService.this.mSoundPool = null;
                }
            }
            return status == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onUnloadSoundEffects() {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                if (AudioService.this.mSoundPool == null) {
                    return;
                }
                int[] poolId = new int[SOUND_EFFECT_FILES.size()];
                for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.size(); ++fileIdx) {
                    poolId[fileIdx] = 0;
                }
                for (int effect = 0; effect < 10; ++effect) {
                    if (AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1] <= 0 || poolId[AudioService.this.SOUND_EFFECT_FILES_MAP[effect][0]] != 0) continue;
                    AudioService.this.mSoundPool.unload(AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1]);
                    ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = -1;
                    poolId[((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][0]] = -1;
                }
                AudioService.this.mSoundPool.release();
                AudioService.this.mSoundPool = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPlaySoundEffect(int effectType, int volume) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                this.onLoadSoundEffects();
                if (AudioService.this.mSoundPool == null) {
                    return;
                }
                float volFloat = volume < 0 ? (float)Math.pow(10.0, (float)sSoundEffectVolumeDb / 20.0f) : (float)volume / 1000.0f;
                if (AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][1] > 0) {
                    AudioService.this.mSoundPool.play(AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][1], volFloat, volFloat, 0, 0, 1.0f);
                } else {
                    MediaPlayer mediaPlayer = new MediaPlayer();
                    try {
                        String filePath = Environment.getRootDirectory() + AudioService.SOUND_EFFECTS_PATH + (String)SOUND_EFFECT_FILES.get(AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][0]);
                        mediaPlayer.setDataSource(filePath);
                        mediaPlayer.setAudioStreamType(1);
                        mediaPlayer.prepare();
                        mediaPlayer.setVolume(volFloat);
                        mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                            @Override
                            public void onCompletion(MediaPlayer mp) {
                                AudioHandler.this.cleanupPlayer(mp);
                            }
                        });
                        mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                            @Override
                            public boolean onError(MediaPlayer mp, int what, int extra) {
                                AudioHandler.this.cleanupPlayer(mp);
                                return true;
                            }
                        });
                        mediaPlayer.start();
                    }
                    catch (IOException ex) {
                        Log.w(AudioService.TAG, "MediaPlayer IOException: " + ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Log.w(AudioService.TAG, "MediaPlayer IllegalArgumentException: " + ex);
                    }
                    catch (IllegalStateException ex) {
                        Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + ex);
                    }
                }
            }
        }

        private void cleanupPlayer(MediaPlayer mp) {
            if (mp != null) {
                try {
                    mp.stop();
                    mp.release();
                }
                catch (IllegalStateException ex) {
                    Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + ex);
                }
            }
        }

        private void setForceUse(int usage, int config) {
            AudioSystem.setForceUse(usage, config);
        }

        private void onPersistSafeVolumeState(int state) {
            Settings.Global.putInt(AudioService.this.mContentResolver, "audio_safe_volume_state", state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.setDeviceVolume((VolumeStreamState)msg.obj, msg.arg1);
                    break;
                }
                case 10: {
                    this.setAllVolumes((VolumeStreamState)msg.obj);
                    break;
                }
                case 1: {
                    this.persistVolume((VolumeStreamState)msg.obj, msg.arg1);
                    break;
                }
                case 2: {
                    if (AudioService.this.mUseFixedVolume) {
                        return;
                    }
                    Settings.System.putFloatForUser(AudioService.this.mContentResolver, "volume_master", (float)msg.arg1 / 1000.0f, -2);
                    break;
                }
                case 11: {
                    if (AudioService.this.mUseFixedVolume) {
                        return;
                    }
                    Settings.System.putIntForUser(AudioService.this.mContentResolver, "volume_master_mute", msg.arg1, msg.arg2);
                    break;
                }
                case 3: {
                    this.persistRingerMode(AudioService.this.getRingerMode());
                    break;
                }
                case 4: {
                    if (!AudioService.this.mSystemReady || AudioSystem.checkAudioFlinger() != 0) {
                        Log.e(AudioService.TAG, "Media server died.");
                        AudioService.sendMsg(AudioService.this.mAudioHandler, 4, 1, 0, 0, null, 500);
                        break;
                    }
                    Log.e(AudioService.TAG, "Media server started.");
                    AudioSystem.setParameters("restarting=true");
                    AudioService.readAndSetLowRamDevice();
                    HashMap hashMap = AudioService.this.mConnectedDevices;
                    synchronized (hashMap) {
                        Set set = AudioService.this.mConnectedDevices.entrySet();
                        for (Map.Entry device : set) {
                            AudioSystem.setDeviceConnectionState((Integer)device.getKey(), 1, (String)device.getValue());
                        }
                    }
                    AudioSystem.setPhoneState(AudioService.this.mMode);
                    AudioSystem.setForceUse(0, AudioService.this.mForcedUseForComm);
                    AudioSystem.setForceUse(2, AudioService.this.mForcedUseForComm);
                    AudioSystem.setForceUse(4, AudioService.this.mCameraSoundForced != false ? 11 : 0);
                    int numStreamTypes = AudioSystem.getNumStreamTypes();
                    for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                        VolumeStreamState streamState = AudioService.this.mStreamStates[streamType];
                        AudioSystem.initStreamVolume(streamType, 0, (streamState.mIndexMax + 5) / 10);
                        streamState.applyAllVolumes();
                    }
                    AudioService.this.setRingerModeInt(AudioService.this.getRingerMode(), false);
                    AudioService.this.restoreMasterVolume();
                    if (AudioService.this.mMonitorOrientation) {
                        AudioService.this.setOrientationForAudioSystem();
                    }
                    if (AudioService.this.mMonitorRotation) {
                        AudioService.this.setRotationForAudioSystem();
                    }
                    Object streamType = AudioService.this.mBluetoothA2dpEnabledLock;
                    synchronized (streamType) {
                        AudioSystem.setForceUse(1, AudioService.this.mBluetoothA2dpEnabled ? 0 : 10);
                    }
                    streamType = AudioService.this.mSettingsLock;
                    synchronized (streamType) {
                        AudioSystem.setForceUse(3, AudioService.this.mDockAudioMediaEnabled ? 8 : 0);
                    }
                    if (AudioService.this.mHdmiManager != null) {
                        streamType = AudioService.this.mHdmiManager;
                        synchronized (streamType) {
                            if (AudioService.this.mHdmiTvClient != null) {
                                AudioService.this.setHdmiSystemAudioSupported(AudioService.this.mHdmiSystemAudioSupported);
                            }
                        }
                    }
                    AudioSystem.setParameters("restarting=false");
                    break;
                }
                case 20: {
                    this.onUnloadSoundEffects();
                    break;
                }
                case 7: {
                    LoadSoundEffectReply reply;
                    boolean loaded = this.onLoadSoundEffects();
                    if (msg.obj == null) break;
                    LoadSoundEffectReply device = reply = (LoadSoundEffectReply)msg.obj;
                    synchronized (device) {
                        reply.mStatus = loaded ? 0 : -1;
                        reply.notify();
                        break;
                    }
                }
                case 5: {
                    this.onPlaySoundEffect(msg.arg1, msg.arg2);
                    break;
                }
                case 6: {
                    HashMap reply = AudioService.this.mConnectedDevices;
                    synchronized (reply) {
                        AudioService.this.makeA2dpDeviceUnavailableNow((String)msg.obj);
                        break;
                    }
                }
                case 8: 
                case 13: {
                    this.setForceUse(msg.arg1, msg.arg2);
                    break;
                }
                case 9: {
                    AudioService.this.resetBluetoothSco();
                    break;
                }
                case 100: {
                    AudioService.this.onSetWiredDeviceConnectionState(msg.arg1, msg.arg2, (String)msg.obj);
                    AudioService.this.mAudioEventWakeLock.release();
                    break;
                }
                case 101: {
                    AudioService.this.onSetA2dpSourceConnectionState((BluetoothDevice)msg.obj, msg.arg1);
                    AudioService.this.mAudioEventWakeLock.release();
                    break;
                }
                case 102: {
                    AudioService.this.onSetA2dpSinkConnectionState((BluetoothDevice)msg.obj, msg.arg1);
                    AudioService.this.mAudioEventWakeLock.release();
                    break;
                }
                case 12: {
                    int N = AudioService.this.mRoutesObservers.beginBroadcast();
                    if (N > 0) {
                        AudioRoutesInfo routes;
                        AudioRoutesInfo audioRoutesInfo = AudioService.this.mCurAudioRoutes;
                        synchronized (audioRoutesInfo) {
                            routes = new AudioRoutesInfo(AudioService.this.mCurAudioRoutes);
                        }
                        while (N > 0) {
                            IAudioRoutesObserver obs = AudioService.this.mRoutesObservers.getBroadcastItem(--N);
                            try {
                                obs.dispatchAudioRoutesChanged(routes);
                            }
                            catch (RemoteException e) {}
                        }
                    }
                    AudioService.this.mRoutesObservers.finishBroadcast();
                    break;
                }
                case 14: {
                    AudioService.this.onCheckMusicActive();
                    break;
                }
                case 15: {
                    AudioService.this.onSendBecomingNoisyIntent();
                    break;
                }
                case 16: 
                case 17: {
                    AudioService.this.onConfigureSafeVolume(msg.what == 17);
                    break;
                }
                case 18: {
                    this.onPersistSafeVolumeState(msg.arg1);
                    break;
                }
                case 19: {
                    AudioService.this.onBroadcastScoConnectionState(msg.arg1);
                    break;
                }
                case 21: {
                    AudioService.this.onSystemReady();
                    break;
                }
                case 22: {
                    int musicActiveMs = msg.arg1;
                    Settings.Secure.putIntForUser(AudioService.this.mContentResolver, "unsafe_volume_music_active_ms", musicActiveMs, -2);
                    break;
                }
                case 23: {
                    Settings.System.putIntForUser(AudioService.this.mContentResolver, "microphone_mute", msg.arg1, msg.arg2);
                }
            }
        }
    }

    private class AudioSystemThread
    extends Thread {
        AudioSystemThread() {
            super(AudioService.TAG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Looper.prepare();
            AudioService audioService = AudioService.this;
            synchronized (audioService) {
                AudioService.this.mAudioHandler = new AudioHandler();
                AudioService.this.notify();
            }
            Looper.loop();
        }
    }

    public class VolumeStreamState {
        private final int mStreamType;
        private String mVolumeIndexSettingName;
        private int mIndexMax;
        private final ConcurrentHashMap<Integer, Integer> mIndex = new ConcurrentHashMap(8, 0.75f, 4);
        private ArrayList<VolumeDeathHandler> mDeathHandlers;

        private VolumeStreamState(String settingName, int streamType) {
            this.mVolumeIndexSettingName = settingName;
            this.mStreamType = streamType;
            this.mIndexMax = MAX_STREAM_VOLUME[streamType];
            AudioSystem.initStreamVolume(streamType, 0, this.mIndexMax);
            this.mIndexMax *= 10;
            this.mDeathHandlers = new ArrayList();
            this.readSettings();
        }

        public String getSettingNameForDevice(int device) {
            String name = this.mVolumeIndexSettingName;
            String suffix = AudioSystem.getOutputDeviceName(device);
            if (suffix.isEmpty()) {
                return name;
            }
            return name + "_" + suffix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readSettings() {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                if (AudioService.this.mUseFixedVolume) {
                    this.mIndex.put(0x40000000, this.mIndexMax);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (this.mStreamType == 1 || this.mStreamType == 7) {
                    int index = 10 * AudioManager.DEFAULT_STREAM_VOLUME[this.mStreamType];
                    Boolean bl = AudioService.this.mCameraSoundForced;
                    synchronized (bl) {
                        if (AudioService.this.mCameraSoundForced.booleanValue()) {
                            index = this.mIndexMax;
                        }
                    }
                    this.mIndex.put(0x40000000, index);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                int remainingDevices = 1077936127;
                int i = 0;
                while (remainingDevices != 0) {
                    int device = 1 << i;
                    if ((device & remainingDevices) != 0) {
                        remainingDevices &= ~device;
                        String name = this.getSettingNameForDevice(device);
                        int defaultIndex = device == 0x40000000 ? AudioManager.DEFAULT_STREAM_VOLUME[this.mStreamType] : -1;
                        int index = Settings.System.getIntForUser(AudioService.this.mContentResolver, name, defaultIndex, -2);
                        if (index != -1) {
                            this.mIndex.put(device, this.getValidIndex(10 * index));
                        }
                    }
                    ++i;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public void applyDeviceVolume(int device) {
            int index = this.isMuted() ? 0 : ((device & 0x380) != 0 && AudioService.this.mAvrcpAbsVolSupported || (device & AudioService.this.mFullVolumeDevices) != 0 ? (this.mIndexMax + 5) / 10 : (this.getIndex(device) + 5) / 10);
            AudioSystem.setStreamVolumeIndex(this.mStreamType, index, device);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyAllVolumes() {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                int index = this.isMuted() ? 0 : (this.getIndex(0x40000000) + 5) / 10;
                AudioSystem.setStreamVolumeIndex(this.mStreamType, index, 0x40000000);
                Set<Map.Entry<Integer, Integer>> set = this.mIndex.entrySet();
                for (Map.Entry<Integer, Integer> entry : set) {
                    int device = entry.getKey();
                    if (device == 0x40000000) continue;
                    index = this.isMuted() ? 0 : ((device & 0x380) != 0 && AudioService.this.mAvrcpAbsVolSupported || (device & AudioService.this.mFullVolumeDevices) != 0 ? (this.mIndexMax + 5) / 10 : (entry.getValue() + 5) / 10);
                    AudioSystem.setStreamVolumeIndex(this.mStreamType, index, device);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public boolean adjustIndex(int deltaIndex, int device) {
            return this.setIndex(this.getIndex(device) + deltaIndex, device);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setIndex(int index, int device) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                int oldIndex = this.getIndex(device);
                index = this.getValidIndex(index);
                Boolean bl = AudioService.this.mCameraSoundForced;
                synchronized (bl) {
                    if (this.mStreamType == 7 && AudioService.this.mCameraSoundForced.booleanValue()) {
                        index = this.mIndexMax;
                    }
                }
                this.mIndex.put(device, index);
                if (oldIndex != index) {
                    boolean currentDevice = device == AudioService.this.getDeviceForStream(this.mStreamType);
                    int numStreamTypes = AudioSystem.getNumStreamTypes();
                    for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                        if (streamType == this.mStreamType || AudioService.this.mStreamVolumeAlias[streamType] != this.mStreamType) continue;
                        int scaledIndex = AudioService.this.rescaleIndex(index, this.mStreamType, streamType);
                        AudioService.this.mStreamStates[streamType].setIndex(scaledIndex, device);
                        if (!currentDevice) continue;
                        AudioService.this.mStreamStates[streamType].setIndex(scaledIndex, AudioService.this.getDeviceForStream(streamType));
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return true;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getIndex(int device) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                Integer index = this.mIndex.get(device);
                if (index == null) {
                    index = this.mIndex.get(0x40000000);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return index;
            }
        }

        public int getMaxIndex() {
            return this.mIndexMax;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAllIndexes(VolumeStreamState srcStream) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                int srcStreamType = srcStream.getStreamType();
                int index = srcStream.getIndex(0x40000000);
                index = AudioService.this.rescaleIndex(index, srcStreamType, this.mStreamType);
                Set<Map.Entry<Integer, Integer>> set = this.mIndex.entrySet();
                for (Map.Entry<Integer, Integer> entry : set) {
                    entry.setValue(index);
                }
                set = srcStream.mIndex.entrySet();
                for (Map.Entry<Integer, Integer> entry : set) {
                    int device = entry.getKey();
                    index = entry.getValue();
                    index = AudioService.this.rescaleIndex(index, srcStreamType, this.mStreamType);
                    this.setIndex(index, device);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAllIndexesToMax() {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                Set<Map.Entry<Integer, Integer>> set = this.mIndex.entrySet();
                for (Map.Entry<Integer, Integer> entry : set) {
                    entry.setValue(this.mIndexMax);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mute(IBinder cb, boolean state) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                VolumeDeathHandler handler = this.getDeathHandler(cb, state);
                if (handler == null) {
                    Log.e(AudioService.TAG, "Could not get client death handler for stream: " + this.mStreamType);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                handler.mute(state);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        public int getStreamType() {
            return this.mStreamType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkFixedVolumeDevices() {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                if (AudioService.this.mStreamVolumeAlias[this.mStreamType] == 3) {
                    Set<Map.Entry<Integer, Integer>> set = this.mIndex.entrySet();
                    for (Map.Entry<Integer, Integer> entry : set) {
                        int device = entry.getKey();
                        int index = entry.getValue();
                        if ((device & AudioService.this.mFullVolumeDevices) != 0 || (device & AudioService.this.mFixedVolumeDevices) != 0 && index != 0) {
                            entry.setValue(this.mIndexMax);
                        }
                        this.applyDeviceVolume(device);
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private int getValidIndex(int index) {
            if (index < 0) {
                return 0;
            }
            if (AudioService.this.mUseFixedVolume || index > this.mIndexMax) {
                return this.mIndexMax;
            }
            return index;
        }

        private synchronized int muteCount() {
            int count = 0;
            int size = this.mDeathHandlers.size();
            for (int i = 0; i < size; ++i) {
                count += this.mDeathHandlers.get(i).mMuteCount;
            }
            return count;
        }

        private synchronized boolean isMuted() {
            return this.muteCount() != 0;
        }

        private VolumeDeathHandler getDeathHandler(IBinder cb, boolean state) {
            VolumeDeathHandler handler;
            int size = this.mDeathHandlers.size();
            for (int i = 0; i < size; ++i) {
                handler = this.mDeathHandlers.get(i);
                if (cb != handler.mICallback) continue;
                return handler;
            }
            if (state) {
                handler = new VolumeDeathHandler(cb);
            } else {
                Log.w(AudioService.TAG, "stream was not muted by this client");
                handler = null;
            }
            return handler;
        }

        private void dump(PrintWriter pw) {
            pw.print("   Mute count: ");
            pw.println(this.muteCount());
            pw.print("   Max: ");
            pw.println((this.mIndexMax + 5) / 10);
            pw.print("   Current: ");
            Set<Map.Entry<Integer, Integer>> set = this.mIndex.entrySet();
            Iterator<Map.Entry<Integer, Integer>> i = set.iterator();
            while (i.hasNext()) {
                String deviceName;
                Map.Entry<Integer, Integer> entry = i.next();
                int device = entry.getKey();
                pw.print(Integer.toHexString(device));
                String string2 = deviceName = device == 0x40000000 ? "default" : AudioSystem.getOutputDeviceName(device);
                if (!deviceName.isEmpty()) {
                    pw.print(" (");
                    pw.print(deviceName);
                    pw.print(")");
                }
                pw.print(": ");
                int index = (entry.getValue() + 5) / 10;
                pw.print(index);
                if (!i.hasNext()) continue;
                pw.print(", ");
            }
        }

        private class VolumeDeathHandler
        implements IBinder.DeathRecipient {
            private IBinder mICallback;
            private int mMuteCount;

            VolumeDeathHandler(IBinder cb) {
                this.mICallback = cb;
            }

            /*
             * Unable to fully structure code
             */
            public void mute(boolean state) {
                updateVolume = false;
                if (state) {
                    if (this.mMuteCount == 0) {
                        try {
                            if (this.mICallback != null) {
                                this.mICallback.linkToDeath(this, 0);
                            }
                            VolumeStreamState.access$2200(VolumeStreamState.this).add(this);
                            if (VolumeStreamState.access$300(VolumeStreamState.this)) ** GOTO lbl17
                            updateVolume = true;
                        }
                        catch (RemoteException e) {
                            this.binderDied();
                            return;
                        }
                    } else {
                        Log.w("AudioService", "stream: " + VolumeStreamState.access$4800(VolumeStreamState.this) + " was already muted by this client");
                    }
lbl17:
                    // 3 sources

                    ++this.mMuteCount;
                } else if (this.mMuteCount == 0) {
                    Log.e("AudioService", "unexpected unmute for stream: " + VolumeStreamState.access$4800(VolumeStreamState.this));
                } else {
                    --this.mMuteCount;
                    if (this.mMuteCount == 0) {
                        VolumeStreamState.access$2200(VolumeStreamState.this).remove(this);
                        if (this.mICallback != null) {
                            this.mICallback.unlinkToDeath(this, 0);
                        }
                        if (!VolumeStreamState.access$300(VolumeStreamState.this)) {
                            updateVolume = true;
                        }
                    }
                }
                if (updateVolume) {
                    AudioService.access$100(AudioService.access$000(AudioService.this), 10, 2, 0, 0, VolumeStreamState.this, 0);
                }
            }

            @Override
            public void binderDied() {
                Log.w(AudioService.TAG, "Volume service client died for stream: " + VolumeStreamState.this.mStreamType);
                if (this.mMuteCount != 0) {
                    this.mMuteCount = 1;
                    this.mute(false);
                }
            }
        }
    }

    private class ScoClient
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mCreatorPid;
        private int mStartcount;

        ScoClient(IBinder cb) {
            this.mCb = cb;
            this.mCreatorPid = Binder.getCallingPid();
            this.mStartcount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                Log.w(AudioService.TAG, "SCO client died");
                int index = AudioService.this.mScoClients.indexOf(this);
                if (index < 0) {
                    Log.w(AudioService.TAG, "unregistered SCO client died");
                } else {
                    this.clearCount(true);
                    AudioService.this.mScoClients.remove(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incCount(int scoAudioMode) {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                this.requestScoState(12, scoAudioMode);
                if (this.mStartcount == 0) {
                    try {
                        this.mCb.linkToDeath(this, 0);
                    }
                    catch (RemoteException e) {
                        Log.w(AudioService.TAG, "ScoClient  incCount() could not link to " + this.mCb + " binder death");
                    }
                }
                ++this.mStartcount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                if (this.mStartcount == 0) {
                    Log.w(AudioService.TAG, "ScoClient.decCount() already 0");
                } else {
                    --this.mStartcount;
                    if (this.mStartcount == 0) {
                        try {
                            this.mCb.unlinkToDeath(this, 0);
                        }
                        catch (NoSuchElementException e) {
                            Log.w(AudioService.TAG, "decCount() going to 0 but not registered to binder");
                        }
                    }
                    this.requestScoState(10, 0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCount(boolean stopSco) {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                if (this.mStartcount != 0) {
                    try {
                        this.mCb.unlinkToDeath(this, 0);
                    }
                    catch (NoSuchElementException e) {
                        Log.w(AudioService.TAG, "clearCount() mStartcount: " + this.mStartcount + " != 0 but not registered to binder");
                    }
                }
                this.mStartcount = 0;
                if (stopSco) {
                    this.requestScoState(10, 0);
                }
            }
        }

        public int getCount() {
            return this.mStartcount;
        }

        public IBinder getBinder() {
            return this.mCb;
        }

        public int getPid() {
            return this.mCreatorPid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int totalCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                int count = 0;
                int size = AudioService.this.mScoClients.size();
                for (int i = 0; i < size; ++i) {
                    count += ((ScoClient)AudioService.this.mScoClients.get(i)).getCount();
                }
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void requestScoState(int state, int scoAudioMode) {
            AudioService.this.checkScoAudioState();
            if (this.totalCount() == 0) {
                if (state == 12) {
                    AudioService.this.broadcastScoConnectionState(2);
                    ArrayList arrayList = AudioService.this.mSetModeDeathHandlers;
                    synchronized (arrayList) {
                        if (!(!AudioService.this.mSetModeDeathHandlers.isEmpty() && ((SetModeDeathHandler)AudioService.this.mSetModeDeathHandlers.get(0)).getPid() != this.mCreatorPid || AudioService.this.mScoAudioState != 0 && AudioService.this.mScoAudioState != 5)) {
                            if (AudioService.this.mScoAudioState == 0) {
                                AudioService.this.mScoAudioMode = scoAudioMode;
                                if (scoAudioMode == -1) {
                                    AudioService.this.mScoAudioMode = new Integer(Settings.Global.getInt(AudioService.this.mContentResolver, "bluetooth_sco_channel_" + AudioService.this.mBluetoothHeadsetDevice.getAddress(), 0));
                                    if (AudioService.this.mScoAudioMode > 2 || AudioService.this.mScoAudioMode < 0) {
                                        AudioService.this.mScoAudioMode = 0;
                                    }
                                }
                                if (AudioService.this.mBluetoothHeadset != null && AudioService.this.mBluetoothHeadsetDevice != null) {
                                    boolean status = false;
                                    if (AudioService.this.mScoAudioMode == 1) {
                                        status = AudioService.this.mBluetoothHeadset.connectAudio();
                                    } else if (AudioService.this.mScoAudioMode == 0) {
                                        status = AudioService.this.mBluetoothHeadset.startScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice);
                                    } else if (AudioService.this.mScoAudioMode == 2) {
                                        status = AudioService.this.mBluetoothHeadset.startVoiceRecognition(AudioService.this.mBluetoothHeadsetDevice);
                                    }
                                    if (status) {
                                        AudioService.this.mScoAudioState = 3;
                                    } else {
                                        AudioService.this.broadcastScoConnectionState(0);
                                    }
                                } else if (AudioService.this.getBluetoothHeadset()) {
                                    AudioService.this.mScoAudioState = 1;
                                }
                            } else {
                                AudioService.this.mScoAudioState = 3;
                                AudioService.this.broadcastScoConnectionState(1);
                            }
                        } else {
                            AudioService.this.broadcastScoConnectionState(0);
                        }
                    }
                } else if (state == 10 && (AudioService.this.mScoAudioState == 3 || AudioService.this.mScoAudioState == 1)) {
                    if (AudioService.this.mScoAudioState == 3) {
                        if (AudioService.this.mBluetoothHeadset != null && AudioService.this.mBluetoothHeadsetDevice != null) {
                            boolean status = false;
                            if (AudioService.this.mScoAudioMode == 1) {
                                status = AudioService.this.mBluetoothHeadset.disconnectAudio();
                            } else if (AudioService.this.mScoAudioMode == 0) {
                                status = AudioService.this.mBluetoothHeadset.stopScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice);
                            } else if (AudioService.this.mScoAudioMode == 2) {
                                status = AudioService.this.mBluetoothHeadset.stopVoiceRecognition(AudioService.this.mBluetoothHeadsetDevice);
                            }
                            if (!status) {
                                AudioService.this.mScoAudioState = 0;
                                AudioService.this.broadcastScoConnectionState(0);
                            }
                        } else if (AudioService.this.getBluetoothHeadset()) {
                            AudioService.this.mScoAudioState = 5;
                        }
                    } else {
                        AudioService.this.mScoAudioState = 0;
                        AudioService.this.broadcastScoConnectionState(0);
                    }
                }
            }
        }
    }

    private final class SoundPoolCallback
    implements SoundPool.OnLoadCompleteListener {
        int mStatus = 1;
        List<Integer> mSamples = new ArrayList<Integer>();

        private SoundPoolCallback() {
        }

        public int status() {
            return this.mStatus;
        }

        public void setSamples(int[] samples) {
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] <= 0) continue;
                this.mSamples.add(samples[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                int i = this.mSamples.indexOf(sampleId);
                if (i >= 0) {
                    this.mSamples.remove(i);
                }
                if (status != 0 || this.mSamples.isEmpty()) {
                    this.mStatus = status;
                    AudioService.this.mSoundEffectsLock.notify();
                }
            }
        }
    }

    class SoundPoolListenerThread
    extends Thread {
        public SoundPoolListenerThread() {
            super("SoundPoolListenerThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Looper.prepare();
            AudioService.this.mSoundPoolLooper = Looper.myLooper();
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                if (AudioService.this.mSoundPool != null) {
                    AudioService.this.mSoundPoolCallBack = new SoundPoolCallback();
                    AudioService.this.mSoundPool.setOnLoadCompleteListener(AudioService.this.mSoundPoolCallBack);
                }
                AudioService.this.mSoundEffectsLock.notify();
            }
            Looper.loop();
        }
    }

    class LoadSoundEffectReply {
        public int mStatus = 1;

        LoadSoundEffectReply() {
        }
    }

    private class SetModeDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mPid;
        private int mMode = 0;

        SetModeDeathHandler(IBinder cb, int pid) {
            this.mCb = cb;
            this.mPid = pid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            int newModeOwnerPid = 0;
            ArrayList arrayList = AudioService.this.mSetModeDeathHandlers;
            synchronized (arrayList) {
                Log.w(AudioService.TAG, "setMode() client died");
                int index = AudioService.this.mSetModeDeathHandlers.indexOf(this);
                if (index < 0) {
                    Log.w(AudioService.TAG, "unregistered setMode() client died");
                } else {
                    newModeOwnerPid = AudioService.this.setModeInt(0, this.mCb, this.mPid);
                }
            }
            if (newModeOwnerPid != 0) {
                long ident = Binder.clearCallingIdentity();
                AudioService.this.disconnectBluetoothSco(newModeOwnerPid);
                Binder.restoreCallingIdentity(ident);
            }
        }

        public int getPid() {
            return this.mPid;
        }

        public void setMode(int mode) {
            this.mMode = mode;
        }

        public int getMode() {
            return this.mMode;
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    private class RmtSbmxFullVolDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mICallback;

        RmtSbmxFullVolDeathHandler(IBinder cb) {
            this.mICallback = cb;
            try {
                cb.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Log.e(AudioService.TAG, "can't link to death", e);
            }
        }

        boolean isHandlerFor(IBinder cb) {
            return this.mICallback.equals(cb);
        }

        void forget() {
            try {
                this.mICallback.unlinkToDeath(this, 0);
            }
            catch (NoSuchElementException e) {
                Log.e(AudioService.TAG, "error unlinking to death", e);
            }
        }

        @Override
        public void binderDied() {
            Log.w(AudioService.TAG, "Recorder with remote submix at full volume died " + this.mICallback);
            AudioService.this.forceRemoteSubmixFullVolume(false, this.mICallback);
        }
    }

    private class ForceControlStreamClient
    implements IBinder.DeathRecipient {
        private IBinder mCb;

        ForceControlStreamClient(IBinder cb) {
            if (cb != null) {
                try {
                    cb.linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    Log.w(AudioService.TAG, "ForceControlStreamClient() could not link to " + cb + " binder death");
                    cb = null;
                }
            }
            this.mCb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = AudioService.this.mForceControlStreamLock;
            synchronized (object) {
                Log.w(AudioService.TAG, "SCO client died");
                if (AudioService.this.mForceControlStreamClient != this) {
                    Log.w(AudioService.TAG, "unregistered control stream client died");
                } else {
                    AudioService.this.mForceControlStreamClient = null;
                    AudioService.this.mVolumeControlStream = -1;
                }
            }
        }

        public void release() {
            if (this.mCb != null) {
                this.mCb.unlinkToDeath(this, 0);
                this.mCb = null;
            }
        }
    }

    class StreamVolumeCommand {
        public final int mStreamType;
        public final int mIndex;
        public final int mFlags;
        public final int mDevice;

        StreamVolumeCommand(int streamType, int index, int flags, int device) {
            this.mStreamType = streamType;
            this.mIndex = index;
            this.mFlags = flags;
            this.mDevice = device;
        }

        public String toString() {
            return "{streamType=" + this.mStreamType + ",index=" + this.mIndex + ",flags=" + this.mFlags + ",device=" + this.mDevice + '}';
        }
    }

    private class AudioOrientationEventListener
    extends OrientationEventListener {
        public AudioOrientationEventListener(Context context) {
            super(context);
        }

        @Override
        public void onOrientationChanged(int orientation) {
            int newRotation = ((WindowManager)AudioService.this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
            if (newRotation != AudioService.this.mDeviceRotation) {
                AudioService.this.mDeviceRotation = newRotation;
                AudioService.this.setRotationForAudioSystem();
            }
        }
    }
}

