/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioDevicePortConfig;
import android.media.AudioGain;
import android.media.AudioGainConfig;
import android.media.AudioHandle;
import android.media.AudioManager;
import android.media.AudioPort;

public class AudioDevicePort
extends AudioPort {
    private final int mType;
    private final String mAddress;

    AudioDevicePort(AudioHandle handle, int[] samplingRates, int[] channelMasks, int[] formats, AudioGain[] gains, int type, String address) {
        super(handle, AudioManager.isInputDevice(type) ? 1 : 2, samplingRates, channelMasks, formats, gains);
        this.mType = type;
        this.mAddress = address;
    }

    public int type() {
        return this.mType;
    }

    public String address() {
        return this.mAddress;
    }

    @Override
    public AudioDevicePortConfig buildConfig(int samplingRate, int channelMask, int format, AudioGainConfig gain) {
        return new AudioDevicePortConfig(this, samplingRate, channelMask, format, gain);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof AudioDevicePort)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        return "{" + super.toString() + ", mType:" + this.mType + ", mAddress: " + this.mAddress + "}";
    }
}

