/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.hardware.location.GeofenceHardwareCallback;
import android.hardware.location.GeofenceHardwareMonitorCallback;
import android.hardware.location.GeofenceHardwareMonitorEvent;
import android.hardware.location.GeofenceHardwareRequest;
import android.hardware.location.GeofenceHardwareRequestParcelable;
import android.hardware.location.IGeofenceHardware;
import android.hardware.location.IGeofenceHardwareCallback;
import android.hardware.location.IGeofenceHardwareMonitorCallback;
import android.location.Location;
import android.os.Build;
import android.os.RemoteException;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public final class GeofenceHardware {
    private IGeofenceHardware mService;
    static final int NUM_MONITORS = 2;
    public static final int MONITORING_TYPE_GPS_HARDWARE = 0;
    public static final int MONITORING_TYPE_FUSED_HARDWARE = 1;
    public static final int MONITOR_CURRENTLY_AVAILABLE = 0;
    public static final int MONITOR_CURRENTLY_UNAVAILABLE = 1;
    public static final int MONITOR_UNSUPPORTED = 2;
    public static final int GEOFENCE_ENTERED = 1;
    public static final int GEOFENCE_EXITED = 2;
    public static final int GEOFENCE_UNCERTAIN = 4;
    public static final int GEOFENCE_SUCCESS = 0;
    public static final int GEOFENCE_ERROR_TOO_MANY_GEOFENCES = 1;
    public static final int GEOFENCE_ERROR_ID_EXISTS = 2;
    public static final int GEOFENCE_ERROR_ID_UNKNOWN = 3;
    public static final int GEOFENCE_ERROR_INVALID_TRANSITION = 4;
    public static final int GEOFENCE_FAILURE = 5;
    public static final int GEOFENCE_ERROR_INSUFFICIENT_MEMORY = 6;
    public static final int SOURCE_TECHNOLOGY_GNSS = 1;
    public static final int SOURCE_TECHNOLOGY_WIFI = 2;
    public static final int SOURCE_TECHNOLOGY_SENSORS = 4;
    public static final int SOURCE_TECHNOLOGY_CELL = 8;
    public static final int SOURCE_TECHNOLOGY_BLUETOOTH = 16;
    private HashMap<GeofenceHardwareCallback, GeofenceHardwareCallbackWrapper> mCallbacks = new HashMap();
    private HashMap<GeofenceHardwareMonitorCallback, GeofenceHardwareMonitorCallbackWrapper> mMonitorCallbacks = new HashMap();

    public GeofenceHardware(IGeofenceHardware service) {
        this.mService = service;
    }

    public int[] getMonitoringTypes() {
        try {
            return this.mService.getMonitoringTypes();
        }
        catch (RemoteException remoteException) {
            return new int[0];
        }
    }

    public int getStatusOfMonitoringType(int monitoringType) {
        try {
            return this.mService.getStatusOfMonitoringType(monitoringType);
        }
        catch (RemoteException e) {
            return 2;
        }
    }

    public boolean addGeofence(int geofenceId, int monitoringType, GeofenceHardwareRequest geofenceRequest, GeofenceHardwareCallback callback) {
        try {
            if (geofenceRequest.getType() == 0) {
                return this.mService.addCircularFence(monitoringType, new GeofenceHardwareRequestParcelable(geofenceId, geofenceRequest), this.getCallbackWrapper(callback));
            }
            throw new IllegalArgumentException("Geofence Request type not supported");
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean removeGeofence(int geofenceId, int monitoringType) {
        try {
            return this.mService.removeGeofence(geofenceId, monitoringType);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean pauseGeofence(int geofenceId, int monitoringType) {
        try {
            return this.mService.pauseGeofence(geofenceId, monitoringType);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean resumeGeofence(int geofenceId, int monitoringType, int monitorTransition) {
        try {
            return this.mService.resumeGeofence(geofenceId, monitoringType, monitorTransition);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean registerForMonitorStateChangeCallback(int monitoringType, GeofenceHardwareMonitorCallback callback) {
        try {
            return this.mService.registerForMonitorStateChangeCallback(monitoringType, this.getMonitorCallbackWrapper(callback));
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean unregisterForMonitorStateChangeCallback(int monitoringType, GeofenceHardwareMonitorCallback callback) {
        boolean result = false;
        try {
            result = this.mService.unregisterForMonitorStateChangeCallback(monitoringType, this.getMonitorCallbackWrapper(callback));
            if (result) {
                this.removeMonitorCallback(callback);
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCallback(GeofenceHardwareCallback callback) {
        HashMap<GeofenceHardwareCallback, GeofenceHardwareCallbackWrapper> hashMap = this.mCallbacks;
        synchronized (hashMap) {
            this.mCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GeofenceHardwareCallbackWrapper getCallbackWrapper(GeofenceHardwareCallback callback) {
        HashMap<GeofenceHardwareCallback, GeofenceHardwareCallbackWrapper> hashMap = this.mCallbacks;
        synchronized (hashMap) {
            GeofenceHardwareCallbackWrapper wrapper = this.mCallbacks.get(callback);
            if (wrapper == null) {
                wrapper = new GeofenceHardwareCallbackWrapper(callback);
                this.mCallbacks.put(callback, wrapper);
            }
            return wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMonitorCallback(GeofenceHardwareMonitorCallback callback) {
        HashMap<GeofenceHardwareMonitorCallback, GeofenceHardwareMonitorCallbackWrapper> hashMap = this.mMonitorCallbacks;
        synchronized (hashMap) {
            this.mMonitorCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GeofenceHardwareMonitorCallbackWrapper getMonitorCallbackWrapper(GeofenceHardwareMonitorCallback callback) {
        HashMap<GeofenceHardwareMonitorCallback, GeofenceHardwareMonitorCallbackWrapper> hashMap = this.mMonitorCallbacks;
        synchronized (hashMap) {
            GeofenceHardwareMonitorCallbackWrapper wrapper = this.mMonitorCallbacks.get(callback);
            if (wrapper == null) {
                wrapper = new GeofenceHardwareMonitorCallbackWrapper(callback);
                this.mMonitorCallbacks.put(callback, wrapper);
            }
            return wrapper;
        }
    }

    class GeofenceHardwareCallbackWrapper
    extends IGeofenceHardwareCallback.Stub {
        private WeakReference<GeofenceHardwareCallback> mCallback;

        GeofenceHardwareCallbackWrapper(GeofenceHardwareCallback c) {
            this.mCallback = new WeakReference<GeofenceHardwareCallback>(c);
        }

        @Override
        public void onGeofenceTransition(int geofenceId, int transition2, Location location, long timestamp, int monitoringType) {
            GeofenceHardwareCallback c = (GeofenceHardwareCallback)this.mCallback.get();
            if (c != null) {
                c.onGeofenceTransition(geofenceId, transition2, location, timestamp, monitoringType);
            }
        }

        @Override
        public void onGeofenceAdd(int geofenceId, int status) {
            GeofenceHardwareCallback c = (GeofenceHardwareCallback)this.mCallback.get();
            if (c != null) {
                c.onGeofenceAdd(geofenceId, status);
            }
        }

        @Override
        public void onGeofenceRemove(int geofenceId, int status) {
            GeofenceHardwareCallback c = (GeofenceHardwareCallback)this.mCallback.get();
            if (c != null) {
                c.onGeofenceRemove(geofenceId, status);
                GeofenceHardware.this.removeCallback(c);
            }
        }

        @Override
        public void onGeofencePause(int geofenceId, int status) {
            GeofenceHardwareCallback c = (GeofenceHardwareCallback)this.mCallback.get();
            if (c != null) {
                c.onGeofencePause(geofenceId, status);
            }
        }

        @Override
        public void onGeofenceResume(int geofenceId, int status) {
            GeofenceHardwareCallback c = (GeofenceHardwareCallback)this.mCallback.get();
            if (c != null) {
                c.onGeofenceResume(geofenceId, status);
            }
        }
    }

    class GeofenceHardwareMonitorCallbackWrapper
    extends IGeofenceHardwareMonitorCallback.Stub {
        private WeakReference<GeofenceHardwareMonitorCallback> mCallback;

        GeofenceHardwareMonitorCallbackWrapper(GeofenceHardwareMonitorCallback c) {
            this.mCallback = new WeakReference<GeofenceHardwareMonitorCallback>(c);
        }

        @Override
        public void onMonitoringSystemChange(GeofenceHardwareMonitorEvent event) {
            GeofenceHardwareMonitorCallback c = (GeofenceHardwareMonitorCallback)this.mCallback.get();
            if (c == null) {
                return;
            }
            c.onMonitoringSystemChange(event.getMonitoringType(), event.getMonitoringStatus() == 0, event.getLocation());
            if (Build.VERSION.SDK_INT >= 21) {
                c.onMonitoringSystemChange(event);
            }
        }
    }
}

