/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.content.Context;
import android.hardware.location.ActivityChangedEvent;
import android.hardware.location.ActivityRecognitionEvent;
import android.hardware.location.IActivityRecognitionHardware;
import android.hardware.location.IActivityRecognitionHardwareSink;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;

public class ActivityRecognitionHardware
extends IActivityRecognitionHardware.Stub {
    private static final String TAG = "ActivityRecognitionHardware";
    private static final String HARDWARE_PERMISSION = "android.permission.LOCATION_HARDWARE";
    private static final int INVALID_ACTIVITY_TYPE = -1;
    private static final int NATIVE_SUCCESS_RESULT = 0;
    private static ActivityRecognitionHardware sSingletonInstance = null;
    private static final Object sSingletonInstanceLock = new Object();
    private final Context mContext;
    private final String[] mSupportedActivities;
    private final RemoteCallbackList<IActivityRecognitionHardwareSink> mSinks = new RemoteCallbackList();

    private ActivityRecognitionHardware(Context context) {
        this.nativeInitialize();
        this.mContext = context;
        this.mSupportedActivities = this.fetchSupportedActivities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActivityRecognitionHardware getInstance(Context context) {
        Object object = sSingletonInstanceLock;
        synchronized (object) {
            if (sSingletonInstance == null) {
                sSingletonInstance = new ActivityRecognitionHardware(context);
            }
            return sSingletonInstance;
        }
    }

    public static boolean isSupported() {
        return ActivityRecognitionHardware.nativeIsSupported();
    }

    @Override
    public String[] getSupportedActivities() {
        this.checkPermissions();
        return this.mSupportedActivities;
    }

    @Override
    public boolean isActivitySupported(String activity) {
        this.checkPermissions();
        int activityType = this.getActivityType(activity);
        return activityType != -1;
    }

    @Override
    public boolean registerSink(IActivityRecognitionHardwareSink sink) {
        this.checkPermissions();
        return this.mSinks.register(sink);
    }

    @Override
    public boolean unregisterSink(IActivityRecognitionHardwareSink sink) {
        this.checkPermissions();
        return this.mSinks.unregister(sink);
    }

    @Override
    public boolean enableActivityEvent(String activity, int eventType, long reportLatencyNs) {
        this.checkPermissions();
        int activityType = this.getActivityType(activity);
        if (activityType == -1) {
            return false;
        }
        int result = this.nativeEnableActivityEvent(activityType, eventType, reportLatencyNs);
        return result == 0;
    }

    @Override
    public boolean disableActivityEvent(String activity, int eventType) {
        this.checkPermissions();
        int activityType = this.getActivityType(activity);
        if (activityType == -1) {
            return false;
        }
        int result = this.nativeDisableActivityEvent(activityType, eventType);
        return result == 0;
    }

    @Override
    public boolean flush() {
        this.checkPermissions();
        int result = this.nativeFlush();
        return result == 0;
    }

    private void onActivityChanged(Event[] events) {
        if (events == null || events.length == 0) {
            Log.d(TAG, "No events to broadcast for onActivityChanged.");
            return;
        }
        int eventsLength = events.length;
        ActivityRecognitionEvent[] activityRecognitionEventArray = new ActivityRecognitionEvent[eventsLength];
        for (int i = 0; i < eventsLength; ++i) {
            Event event = events[i];
            String activityName = this.getActivityName(event.activity);
            activityRecognitionEventArray[i] = new ActivityRecognitionEvent(activityName, event.type, event.timestamp);
        }
        ActivityChangedEvent activityChangedEvent = new ActivityChangedEvent(activityRecognitionEventArray);
        int size = this.mSinks.beginBroadcast();
        for (int i = 0; i < size; ++i) {
            IActivityRecognitionHardwareSink sink = this.mSinks.getBroadcastItem(i);
            try {
                sink.onActivityChanged(activityChangedEvent);
                continue;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error delivering activity changed event.", e);
            }
        }
        this.mSinks.finishBroadcast();
    }

    private String getActivityName(int activityType) {
        if (activityType < 0 || activityType >= this.mSupportedActivities.length) {
            String message = String.format("Invalid ActivityType: %d, SupportedActivities: %d", activityType, this.mSupportedActivities.length);
            Log.e(TAG, message);
            return null;
        }
        return this.mSupportedActivities[activityType];
    }

    private int getActivityType(String activity) {
        if (TextUtils.isEmpty(activity)) {
            return -1;
        }
        int supportedActivitiesLength = this.mSupportedActivities.length;
        for (int i = 0; i < supportedActivitiesLength; ++i) {
            if (!activity.equals(this.mSupportedActivities[i])) continue;
            return i;
        }
        return -1;
    }

    private void checkPermissions() {
        String message = String.format("Permission '%s' not granted to access ActivityRecognitionHardware", HARDWARE_PERMISSION);
        this.mContext.enforceCallingPermission(HARDWARE_PERMISSION, message);
    }

    private String[] fetchSupportedActivities() {
        String[] supportedActivities = this.nativeGetSupportedActivities();
        if (supportedActivities != null) {
            return supportedActivities;
        }
        return new String[0];
    }

    private static native void nativeClassInit();

    private static native boolean nativeIsSupported();

    private native void nativeInitialize();

    private native void nativeRelease();

    private native String[] nativeGetSupportedActivities();

    private native int nativeEnableActivityEvent(int var1, int var2, long var3);

    private native int nativeDisableActivityEvent(int var1, int var2);

    private native int nativeFlush();

    static {
        ActivityRecognitionHardware.nativeClassInit();
    }

    private static class Event {
        public int activity;
        public int type;
        public long timestamp;

        private Event() {
        }
    }
}

