/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.util.Log;

public final class HdmiRecordSources {
    private static final String TAG = "HdmiRecordSources";
    private static final int RECORD_SOURCE_TYPE_OWN_SOURCE = 1;
    private static final int RECORD_SOURCE_TYPE_DIGITAL_SERVICE = 2;
    private static final int RECORD_SOURCE_TYPE_ANALOGUE_SERVICE = 3;
    private static final int RECORD_SOURCE_TYPE_EXTERNAL_PLUG = 4;
    private static final int RECORD_SOURCE_TYPE_EXTERNAL_PHYSICAL_ADDRESS = 5;
    public static final int DIGITAL_BROADCAST_TYPE_ARIB = 0;
    public static final int DIGITAL_BROADCAST_TYPE_ATSC = 1;
    public static final int DIGITAL_BROADCAST_TYPE_DVB = 2;
    public static final int DIGITAL_BROADCAST_TYPE_ARIB_BS = 8;
    public static final int DIGITAL_BROADCAST_TYPE_ARIB_CS = 9;
    public static final int DIGITAL_BROADCAST_TYPE_ARIB_T = 10;
    public static final int DIGITAL_BROADCAST_TYPE_ATSC_CABLE = 16;
    public static final int DIGITAL_BROADCAST_TYPE_ATSC_SATELLITE = 17;
    public static final int DIGITAL_BROADCAST_TYPE_ATSC_TERRESTRIAL = 18;
    public static final int DIGITAL_BROADCAST_TYPE_DVB_C = 24;
    public static final int DIGITAL_BROADCAST_TYPE_DVB_S = 25;
    public static final int DIGITAL_BROADCAST_TYPE_DVB_S2 = 26;
    public static final int DIGITAL_BROADCAST_TYPE_DVB_T = 27;
    private static final int CHANNEL_NUMBER_FORMAT_1_PART = 1;
    private static final int CHANNEL_NUMBER_FORMAT_2_PART = 2;
    public static final int ANALOGUE_BROADCAST_TYPE_CABLE = 0;
    public static final int ANALOGUE_BROADCAST_TYPE_SATELLITE = 1;
    public static final int ANALOGUE_BROADCAST_TYPE_TERRESTRIAL = 2;
    public static final int BROADCAST_SYSTEM_PAL_BG = 0;
    public static final int BROADCAST_SYSTEM_SECAM_LP = 1;
    public static final int BROADCAST_SYSTEM_PAL_M = 2;
    public static final int BROADCAST_SYSTEM_NTSC_M = 3;
    public static final int BROADCAST_SYSTEM_PAL_I = 4;
    public static final int BROADCAST_SYSTEM_SECAM_DK = 5;
    public static final int BROADCAST_SYSTEM_SECAM_BG = 6;
    public static final int BROADCAST_SYSTEM_SECAM_L = 7;
    public static final int BROADCAST_SYSTEM_PAL_DK = 8;
    public static final int BROADCAST_SYSTEM_PAL_OTHER_SYSTEM = 31;

    private HdmiRecordSources() {
    }

    public static OwnSource ofOwnSource() {
        return new OwnSource();
    }

    public static DigitalServiceSource ofDigitalChannelId(int broadcastSystem, DigitalChannelData data) {
        if (data == null) {
            throw new IllegalArgumentException("data should not be null.");
        }
        switch (broadcastSystem) {
            case 0: 
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new DigitalServiceSource(1, broadcastSystem, data);
            }
        }
        Log.w(TAG, "Invalid broadcast type:" + broadcastSystem);
        throw new IllegalArgumentException("Invalid broadcast system value:" + broadcastSystem);
    }

    public static DigitalServiceSource ofArib(int aribType, AribData data) {
        if (data == null) {
            throw new IllegalArgumentException("data should not be null.");
        }
        switch (aribType) {
            case 0: 
            case 8: 
            case 9: 
            case 10: {
                return new DigitalServiceSource(0, aribType, data);
            }
        }
        Log.w(TAG, "Invalid ARIB type:" + aribType);
        throw new IllegalArgumentException("type should not be null.");
    }

    public static DigitalServiceSource ofAtsc(int atscType, AtscData data) {
        if (data == null) {
            throw new IllegalArgumentException("data should not be null.");
        }
        switch (atscType) {
            case 1: 
            case 16: 
            case 17: 
            case 18: {
                return new DigitalServiceSource(0, atscType, data);
            }
        }
        Log.w(TAG, "Invalid ATSC type:" + atscType);
        throw new IllegalArgumentException("Invalid ATSC type:" + atscType);
    }

    public static DigitalServiceSource ofDvb(int dvbType, DvbData data) {
        if (data == null) {
            throw new IllegalArgumentException("data should not be null.");
        }
        switch (dvbType) {
            case 2: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new DigitalServiceSource(0, dvbType, data);
            }
        }
        Log.w(TAG, "Invalid DVB type:" + dvbType);
        throw new IllegalArgumentException("Invalid DVB type:" + dvbType);
    }

    public static AnalogueServiceSource ofAnalogue(int broadcastType, int frequency, int broadcastSystem) {
        if (broadcastType < 0 || broadcastType > 2) {
            Log.w(TAG, "Invalid Broadcast type:" + broadcastType);
            throw new IllegalArgumentException("Invalid Broadcast type:" + broadcastType);
        }
        if (frequency < 0 || frequency > 65535) {
            Log.w(TAG, "Invalid frequency value[0x0000-0xFFFF]:" + frequency);
            throw new IllegalArgumentException("Invalid frequency value[0x0000-0xFFFF]:" + frequency);
        }
        if (broadcastSystem < 0 || broadcastSystem > 31) {
            Log.w(TAG, "Invalid Broadcast system:" + broadcastSystem);
            throw new IllegalArgumentException("Invalid Broadcast system:" + broadcastSystem);
        }
        return new AnalogueServiceSource(broadcastType, frequency, broadcastSystem);
    }

    public static ExternalPlugData ofExternalPlug(int plugNumber) {
        if (plugNumber < 1 || plugNumber > 255) {
            Log.w(TAG, "Invalid plug number[1-255]" + plugNumber);
            throw new IllegalArgumentException("Invalid plug number[1-255]" + plugNumber);
        }
        return new ExternalPlugData(plugNumber);
    }

    public static ExternalPhysicalAddress ofExternalPhysicalAddress(int physicalAddress) {
        if ((physicalAddress & 0xFFFF0000) != 0) {
            Log.w(TAG, "Invalid physical address:" + physicalAddress);
            throw new IllegalArgumentException("Invalid physical address:" + physicalAddress);
        }
        return new ExternalPhysicalAddress(physicalAddress);
    }

    private static int threeFieldsToSixBytes(int first, int second, int third, byte[] data, int index) {
        HdmiRecordSources.shortToByteArray((short)first, data, index);
        HdmiRecordSources.shortToByteArray((short)second, data, index + 2);
        HdmiRecordSources.shortToByteArray((short)third, data, index + 4);
        return 6;
    }

    private static int shortToByteArray(short value, byte[] byteArray, int index) {
        byteArray[index] = (byte)(value >>> 8 & 0xFF);
        byteArray[index + 1] = (byte)(value & 0xFF);
        return 2;
    }

    public static boolean checkRecordSource(byte[] recordSource) {
        byte recordSourceType = recordSource[0];
        int extraDataSize = recordSource.length - 1;
        switch (recordSourceType) {
            case 1: {
                return extraDataSize == 0;
            }
            case 2: {
                return extraDataSize == 7;
            }
            case 3: {
                return extraDataSize == 4;
            }
            case 4: {
                return extraDataSize == 1;
            }
            case 5: {
                return extraDataSize == 2;
            }
        }
        return false;
    }

    public static final class ExternalPhysicalAddress
    extends RecordSource {
        static final int EXTRA_DATA_SIZE = 2;
        private final int mPhysicalAddress;

        private ExternalPhysicalAddress(int physicalAddress) {
            super(5, 2);
            this.mPhysicalAddress = physicalAddress;
        }

        @Override
        int extraParamToByteArray(byte[] data, int index) {
            HdmiRecordSources.shortToByteArray((short)this.mPhysicalAddress, data, index);
            return 2;
        }
    }

    public static final class ExternalPlugData
    extends RecordSource {
        static final int EXTRA_DATA_SIZE = 1;
        private final int mPlugNumber;

        private ExternalPlugData(int plugNumber) {
            super(4, 1);
            this.mPlugNumber = plugNumber;
        }

        @Override
        int extraParamToByteArray(byte[] data, int index) {
            data[index] = (byte)this.mPlugNumber;
            return 1;
        }
    }

    public static final class AnalogueServiceSource
    extends RecordSource {
        static final int EXTRA_DATA_SIZE = 4;
        private final int mBroadcastType;
        private final int mFrequency;
        private final int mBroadcastSystem;

        private AnalogueServiceSource(int broadcastType, int frequency, int broadcastSystem) {
            super(3, 4);
            this.mBroadcastType = broadcastType;
            this.mFrequency = frequency;
            this.mBroadcastSystem = broadcastSystem;
        }

        @Override
        protected int extraParamToByteArray(byte[] data, int index) {
            data[index] = (byte)this.mBroadcastType;
            HdmiRecordSources.shortToByteArray((short)this.mFrequency, data, index + 1);
            data[index + 3] = (byte)this.mBroadcastSystem;
            return 4;
        }
    }

    public static final class DigitalServiceSource
    extends RecordSource {
        private static final int DIGITAL_SERVICE_IDENTIFIED_BY_DIGITAL_ID = 0;
        private static final int DIGITAL_SERVICE_IDENTIFIED_BY_CHANNEL = 1;
        static final int EXTRA_DATA_SIZE = 7;
        private final int mIdentificationMethod;
        private final int mBroadcastSystem;
        private final DigitalServiceIdentification mIdentification;

        private DigitalServiceSource(int identificatinoMethod, int broadcastSystem, DigitalServiceIdentification identification) {
            super(2, 7);
            this.mIdentificationMethod = identificatinoMethod;
            this.mBroadcastSystem = broadcastSystem;
            this.mIdentification = identification;
        }

        @Override
        int extraParamToByteArray(byte[] data, int index) {
            data[index] = (byte)(this.mIdentificationMethod << 7 | this.mBroadcastSystem & 0x7F);
            this.mIdentification.toByteArray(data, index + 1);
            return 7;
        }
    }

    public static final class DigitalChannelData
    implements DigitalServiceIdentification {
        private ChannelIdentifier mChannelIdentifier;

        public static DigitalChannelData ofTwoNumbers(int majorNumber, int minorNumber) {
            return new DigitalChannelData(new ChannelIdentifier(2, majorNumber, minorNumber));
        }

        public static DigitalChannelData ofOneNumber(int number) {
            return new DigitalChannelData(new ChannelIdentifier(1, 0, number));
        }

        private DigitalChannelData(ChannelIdentifier id2) {
            this.mChannelIdentifier = id2;
        }

        @Override
        public int toByteArray(byte[] data, int index) {
            this.mChannelIdentifier.toByteArray(data, index);
            data[index + 4] = 0;
            data[index + 5] = 0;
            return 6;
        }
    }

    private static final class ChannelIdentifier {
        private final int mChannelNumberFormat;
        private final int mMajorChannelNumber;
        private final int mMinorChannelNumber;

        private ChannelIdentifier(int format, int majorNumber, int minorNumer) {
            this.mChannelNumberFormat = format;
            this.mMajorChannelNumber = majorNumber;
            this.mMinorChannelNumber = minorNumer;
        }

        private int toByteArray(byte[] data, int index) {
            data[index] = (byte)(this.mChannelNumberFormat << 2 | this.mMajorChannelNumber >>> 8 & 3);
            data[index + 1] = (byte)(this.mMajorChannelNumber & 0xFF);
            HdmiRecordSources.shortToByteArray((short)this.mMinorChannelNumber, data, index + 2);
            return 4;
        }
    }

    public static final class DvbData
    implements DigitalServiceIdentification {
        private final int mTransportStreamId;
        private final int mServiceId;
        private final int mOriginalNetworkId;

        public DvbData(int transportStreamId, int serviceId, int originalNetworkId) {
            this.mTransportStreamId = transportStreamId;
            this.mServiceId = serviceId;
            this.mOriginalNetworkId = originalNetworkId;
        }

        @Override
        public int toByteArray(byte[] data, int index) {
            return HdmiRecordSources.threeFieldsToSixBytes(this.mTransportStreamId, this.mServiceId, this.mOriginalNetworkId, data, index);
        }
    }

    public static final class AtscData
    implements DigitalServiceIdentification {
        private final int mTransportStreamId;
        private final int mProgramNumber;

        public AtscData(int transportStreamId, int programNumber) {
            this.mTransportStreamId = transportStreamId;
            this.mProgramNumber = programNumber;
        }

        @Override
        public int toByteArray(byte[] data, int index) {
            return HdmiRecordSources.threeFieldsToSixBytes(this.mTransportStreamId, this.mProgramNumber, 0, data, index);
        }
    }

    public static final class AribData
    implements DigitalServiceIdentification {
        private final int mTransportStreamId;
        private final int mServiceId;
        private final int mOriginalNetworkId;

        public AribData(int transportStreamId, int serviceId, int originalNetworkId) {
            this.mTransportStreamId = transportStreamId;
            this.mServiceId = serviceId;
            this.mOriginalNetworkId = originalNetworkId;
        }

        @Override
        public int toByteArray(byte[] data, int index) {
            return HdmiRecordSources.threeFieldsToSixBytes(this.mTransportStreamId, this.mServiceId, this.mOriginalNetworkId, data, index);
        }
    }

    private static interface DigitalServiceIdentification {
        public int toByteArray(byte[] var1, int var2);
    }

    public static final class OwnSource
    extends RecordSource {
        private static final int EXTRA_DATA_SIZE = 0;

        private OwnSource() {
            super(1, 0);
        }

        @Override
        int extraParamToByteArray(byte[] data, int index) {
            return 0;
        }
    }

    static abstract class RecordSource {
        protected final int mSourceType;
        protected final int mExtraDataSize;

        protected RecordSource(int sourceType, int extraDataSize) {
            this.mSourceType = sourceType;
            this.mExtraDataSize = extraDataSize;
        }

        abstract int extraParamToByteArray(byte[] var1, int var2);

        final int getDataSize(boolean includeType) {
            return includeType ? this.mExtraDataSize + 1 : this.mExtraDataSize;
        }

        final int toByteArray(boolean includeType, byte[] data, int index) {
            if (includeType) {
                data[index++] = (byte)this.mSourceType;
            }
            this.extraParamToByteArray(data, index);
            return this.getDataSize(includeType);
        }
    }
}

