/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.content.Context;
import android.hardware.display.DisplayManagerGlobal;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.WifiDisplayStatus;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.util.SparseArray;
import android.view.Display;
import android.view.Surface;
import java.util.ArrayList;

public final class DisplayManager {
    private static final String TAG = "DisplayManager";
    private static final boolean DEBUG = false;
    private final Context mContext;
    private final DisplayManagerGlobal mGlobal;
    private final Object mLock = new Object();
    private final SparseArray<Display> mDisplays = new SparseArray();
    private final ArrayList<Display> mTempDisplays = new ArrayList();
    public static final String ACTION_WIFI_DISPLAY_STATUS_CHANGED = "android.hardware.display.action.WIFI_DISPLAY_STATUS_CHANGED";
    public static final String EXTRA_WIFI_DISPLAY_STATUS = "android.hardware.display.extra.WIFI_DISPLAY_STATUS";
    public static final String DISPLAY_CATEGORY_PRESENTATION = "android.hardware.display.category.PRESENTATION";
    public static final int VIRTUAL_DISPLAY_FLAG_PUBLIC = 1;
    public static final int VIRTUAL_DISPLAY_FLAG_PRESENTATION = 2;
    public static final int VIRTUAL_DISPLAY_FLAG_SECURE = 4;
    public static final int VIRTUAL_DISPLAY_FLAG_OWN_CONTENT_ONLY = 8;
    public static final int VIRTUAL_DISPLAY_FLAG_AUTO_MIRROR = 16;

    public DisplayManager(Context context) {
        this.mContext = context;
        this.mGlobal = DisplayManagerGlobal.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Display getDisplay(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.getOrCreateDisplayLocked(displayId, false);
        }
    }

    public Display[] getDisplays() {
        return this.getDisplays(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Display[] getDisplays(String category) {
        int[] displayIds = this.mGlobal.getDisplayIds();
        Object object = this.mLock;
        synchronized (object) {
            Display[] displayArray;
            try {
                if (category == null) {
                    this.addAllDisplaysLocked(this.mTempDisplays, displayIds);
                } else if (category.equals(DISPLAY_CATEGORY_PRESENTATION)) {
                    this.addPresentationDisplaysLocked(this.mTempDisplays, displayIds, 3);
                    this.addPresentationDisplaysLocked(this.mTempDisplays, displayIds, 2);
                    this.addPresentationDisplaysLocked(this.mTempDisplays, displayIds, 4);
                    this.addPresentationDisplaysLocked(this.mTempDisplays, displayIds, 5);
                }
                displayArray = this.mTempDisplays.toArray(new Display[this.mTempDisplays.size()]);
                this.mTempDisplays.clear();
            }
            catch (Throwable throwable) {
                this.mTempDisplays.clear();
                throw throwable;
            }
            return displayArray;
        }
    }

    private void addAllDisplaysLocked(ArrayList<Display> displays, int[] displayIds) {
        for (int i = 0; i < displayIds.length; ++i) {
            Display display = this.getOrCreateDisplayLocked(displayIds[i], true);
            if (display == null) continue;
            displays.add(display);
        }
    }

    private void addPresentationDisplaysLocked(ArrayList<Display> displays, int[] displayIds, int matchType) {
        for (int i = 0; i < displayIds.length; ++i) {
            Display display = this.getOrCreateDisplayLocked(displayIds[i], true);
            if (display == null || (display.getFlags() & 8) == 0 || display.getType() != matchType) continue;
            displays.add(display);
        }
    }

    private Display getOrCreateDisplayLocked(int displayId, boolean assumeValid) {
        Display display = this.mDisplays.get(displayId);
        if (display == null) {
            display = this.mGlobal.getCompatibleDisplay(displayId, this.mContext.getDisplayAdjustments(displayId));
            if (display != null) {
                this.mDisplays.put(displayId, display);
            }
        } else if (!assumeValid && !display.isValid()) {
            display = null;
        }
        return display;
    }

    public void registerDisplayListener(DisplayListener listener, Handler handler) {
        this.mGlobal.registerDisplayListener(listener, handler);
    }

    public void unregisterDisplayListener(DisplayListener listener) {
        this.mGlobal.unregisterDisplayListener(listener);
    }

    public void startWifiDisplayScan() {
        this.mGlobal.startWifiDisplayScan();
    }

    public void stopWifiDisplayScan() {
        this.mGlobal.stopWifiDisplayScan();
    }

    public void connectWifiDisplay(String deviceAddress) {
        this.mGlobal.connectWifiDisplay(deviceAddress);
    }

    public void pauseWifiDisplay() {
        this.mGlobal.pauseWifiDisplay();
    }

    public void resumeWifiDisplay() {
        this.mGlobal.resumeWifiDisplay();
    }

    public void disconnectWifiDisplay() {
        this.mGlobal.disconnectWifiDisplay();
    }

    public boolean isHDMIConnected() {
        return this.mGlobal.isHDMIConnected();
    }

    public void setHDMIXOverScan(int xOverScan) {
        this.mGlobal.setHDMIXOverScan(xOverScan);
    }

    public int getHDMIXOverScan() {
        return this.mGlobal.getHDMIXOverScan();
    }

    public void setHDMIYOverScan(int yOverScan) {
        this.mGlobal.setHDMIYOverScan(yOverScan);
    }

    public int getHDMIYOverScan() {
        return this.mGlobal.getHDMIYOverScan();
    }

    public void setHDMIKeepRate(int keepRate) {
        this.mGlobal.setHDMIKeepRate(keepRate);
    }

    public void setHDMIResolution(int keepRate) {
        this.mGlobal.setHDMIResolution(keepRate);
    }

    public void setHDMIRotAngle(int rotAngle) {
        this.mGlobal.setHDMIRotAngle(rotAngle);
    }

    public void setHDMINavBarVisible(int navBarVisible) {
        this.mGlobal.setHDMINavBarVisible(navBarVisible);
    }

    public int getHDMIKeepRate() {
        return this.mGlobal.getHDMIKeepRate();
    }

    public int getHDMIResolution() {
        return this.mGlobal.getHDMIResolution();
    }

    public int getHDMIRotAngle() {
        return this.mGlobal.getHDMIRotAngle();
    }

    public int getHDMINavBarVisible() {
        return this.mGlobal.getHDMINavBarVisible();
    }

    public String getHDMIMode() {
        return this.mGlobal.getHDMIMode();
    }

    public String getHDMIName() {
        return this.mGlobal.getHDMIName();
    }

    public void renameWifiDisplay(String deviceAddress, String alias) {
        this.mGlobal.renameWifiDisplay(deviceAddress, alias);
    }

    public void forgetWifiDisplay(String deviceAddress) {
        this.mGlobal.forgetWifiDisplay(deviceAddress);
    }

    public WifiDisplayStatus getWifiDisplayStatus() {
        return this.mGlobal.getWifiDisplayStatus();
    }

    public VirtualDisplay createVirtualDisplay(String name, int width, int height, int densityDpi, Surface surface, int flags) {
        return this.createVirtualDisplay(name, width, height, densityDpi, surface, flags, null, null);
    }

    public VirtualDisplay createVirtualDisplay(String name, int width, int height, int densityDpi, Surface surface, int flags, VirtualDisplay.Callback callback, Handler handler) {
        return this.createVirtualDisplay(null, name, width, height, densityDpi, surface, flags, callback, handler);
    }

    public VirtualDisplay createVirtualDisplay(MediaProjection projection, String name, int width, int height, int densityDpi, Surface surface, int flags, VirtualDisplay.Callback callback, Handler handler) {
        return this.mGlobal.createVirtualDisplay(this.mContext, projection, name, width, height, densityDpi, surface, flags, callback, handler);
    }

    public static interface DisplayListener {
        public void onDisplayAdded(int var1);

        public void onDisplayRemoved(int var1);

        public void onDisplayChanged(int var1);
    }
}

