/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.HashCodeHelpers;
import com.android.internal.util.Preconditions;
import java.util.Arrays;

public final class ReprocessFormatsMap {
    private final int[] mEntry;
    private final int mInputCount;

    public ReprocessFormatsMap(int[] entry) {
        Preconditions.checkNotNull(entry, "entry must not be null");
        int numInputs = 0;
        int left = entry.length;
        int i = 0;
        while (i < entry.length) {
            int inputFormat = StreamConfigurationMap.checkArgumentFormatInternal(entry[i]);
            ++i;
            if (--left < 1) {
                throw new IllegalArgumentException(String.format("Input %x had no output format length listed", inputFormat));
            }
            int length = entry[i];
            --left;
            ++i;
            for (int j = 0; j < length; ++j) {
                int outputFormat = entry[i + j];
                StreamConfigurationMap.checkArgumentFormatInternal(outputFormat);
            }
            if (length > 0) {
                if (left < length) {
                    throw new IllegalArgumentException(String.format("Input %x had too few output formats listed (actual: %d, expected: %d)", inputFormat, left, length));
                }
                i += length;
                left -= length;
            }
            ++numInputs;
        }
        this.mEntry = entry;
        this.mInputCount = numInputs;
    }

    public int[] getInputs() {
        int[] inputs = new int[this.mInputCount];
        int left = this.mEntry.length;
        int i = 0;
        int j = 0;
        while (i < this.mEntry.length) {
            int format = this.mEntry[i];
            ++i;
            if (--left < 1) {
                throw new AssertionError((Object)String.format("Input %x had no output format length listed", format));
            }
            int length = this.mEntry[i];
            --left;
            ++i;
            if (length > 0) {
                if (left < length) {
                    throw new AssertionError((Object)String.format("Input %x had too few output formats listed (actual: %d, expected: %d)", format, left, length));
                }
                i += length;
                left -= length;
            }
            inputs[j] = format;
            ++j;
        }
        return StreamConfigurationMap.imageFormatToPublic(inputs);
    }

    public int[] getOutputs(int format) {
        int left = this.mEntry.length;
        int i = 0;
        while (i < this.mEntry.length) {
            int inputFormat = this.mEntry[i];
            ++i;
            if (--left < 1) {
                throw new AssertionError((Object)String.format("Input %x had no output format length listed", format));
            }
            int length = this.mEntry[i];
            ++i;
            if (length > 0 && --left < length) {
                throw new AssertionError((Object)String.format("Input %x had too few output formats listed (actual: %d, expected: %d)", format, left, length));
            }
            if (inputFormat == format) {
                int[] outputs = new int[length];
                for (int k = 0; k < length; ++k) {
                    outputs[k] = this.mEntry[i + k];
                }
                return StreamConfigurationMap.imageFormatToPublic(outputs);
            }
            i += length;
            left -= length;
        }
        throw new IllegalArgumentException(String.format("Input format %x was not one in #getInputs", format));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReprocessFormatsMap) {
            ReprocessFormatsMap other = (ReprocessFormatsMap)obj;
            return Arrays.equals(this.mEntry, other.mEntry);
        }
        return false;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mEntry);
    }
}

