/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal;

import android.hardware.camera2.marshal.MarshalHelpers;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MarshalRegistry {
    private static List<MarshalQueryable<?>> sRegisteredMarshalQueryables = new ArrayList();
    private static HashMap<MarshalToken<?>, Marshaler<?>> sMarshalerMap = new HashMap();

    public static <T> void registerMarshalQueryable(MarshalQueryable<T> queryable) {
        sRegisteredMarshalQueryables.add(queryable);
    }

    public static <T> Marshaler<T> getMarshaler(TypeReference<T> typeToken, int nativeType) {
        MarshalToken<T> marshalToken = new MarshalToken<T>(typeToken, nativeType);
        Marshaler<?> marshaler = sMarshalerMap.get(marshalToken);
        if (sRegisteredMarshalQueryables.size() == 0) {
            throw new AssertionError((Object)"No available query marshalers registered");
        }
        if (marshaler == null) {
            for (MarshalQueryable<?> potentialMarshaler : sRegisteredMarshalQueryables) {
                MarshalQueryable<?> castedPotential = potentialMarshaler;
                if (!castedPotential.isTypeMappingSupported(typeToken, nativeType)) continue;
                marshaler = castedPotential.createMarshaler(typeToken, nativeType);
                break;
            }
            if (marshaler == null) {
                throw new UnsupportedOperationException("Could not find marshaler that matches the requested combination of type reference " + typeToken + " and native type " + MarshalHelpers.toStringNativeType(nativeType));
            }
            sMarshalerMap.put(marshalToken, marshaler);
        }
        return marshaler;
    }

    private MarshalRegistry() {
        throw new AssertionError();
    }

    private static class MarshalToken<T> {
        final TypeReference<T> typeReference;
        final int nativeType;
        private final int hash;

        public MarshalToken(TypeReference<T> typeReference, int nativeType) {
            this.typeReference = typeReference;
            this.nativeType = nativeType;
            this.hash = typeReference.hashCode() ^ nativeType;
        }

        public boolean equals(Object other) {
            if (other instanceof MarshalToken) {
                MarshalToken otherToken = (MarshalToken)other;
                return this.typeReference.equals(otherToken.typeReference) && this.nativeType == otherToken.nativeType;
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

