/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.legacy.BurstHolder;
import android.hardware.camera2.utils.LongParcelable;
import android.util.Log;
import android.util.Pair;
import java.util.ArrayDeque;
import java.util.List;

public class RequestQueue {
    private static final String TAG = "RequestQueue";
    private static final long INVALID_FRAME = -1L;
    private BurstHolder mRepeatingRequest = null;
    private final ArrayDeque<BurstHolder> mRequestQueue = new ArrayDeque();
    private long mCurrentFrameNumber = 0L;
    private long mCurrentRepeatingFrameNumber = -1L;
    private int mCurrentRequestId = 0;
    private final List<Long> mJpegSurfaceIds;

    public RequestQueue(List<Long> jpegSurfaceIds) {
        this.mJpegSurfaceIds = jpegSurfaceIds;
    }

    public synchronized Pair<BurstHolder, Long> getNext() {
        BurstHolder next = this.mRequestQueue.poll();
        if (next == null && this.mRepeatingRequest != null) {
            next = this.mRepeatingRequest;
            this.mCurrentRepeatingFrameNumber = this.mCurrentFrameNumber + (long)next.getNumberOfRequests();
        }
        if (next == null) {
            return null;
        }
        Pair<BurstHolder, Long> ret = new Pair<BurstHolder, Long>(next, this.mCurrentFrameNumber);
        this.mCurrentFrameNumber += (long)next.getNumberOfRequests();
        return ret;
    }

    public synchronized long stopRepeating(int requestId) {
        long ret = -1L;
        if (this.mRepeatingRequest != null && this.mRepeatingRequest.getRequestId() == requestId) {
            this.mRepeatingRequest = null;
            ret = this.mCurrentRepeatingFrameNumber == -1L ? -1L : this.mCurrentRepeatingFrameNumber - 1L;
            this.mCurrentRepeatingFrameNumber = -1L;
            Log.i(TAG, "Repeating capture request cancelled.");
        } else {
            Log.e(TAG, "cancel failed: no repeating request exists for request id: " + requestId);
        }
        return ret;
    }

    public synchronized long stopRepeating() {
        if (this.mRepeatingRequest == null) {
            Log.e(TAG, "cancel failed: no repeating request exists.");
            return -1L;
        }
        return this.stopRepeating(this.mRepeatingRequest.getRequestId());
    }

    public synchronized int submit(List<CaptureRequest> requests, boolean repeating, LongParcelable frameNumber) {
        int requestId = this.mCurrentRequestId++;
        BurstHolder burst = new BurstHolder(requestId, repeating, requests, this.mJpegSurfaceIds);
        long ret = -1L;
        if (burst.isRepeating()) {
            Log.i(TAG, "Repeating capture request set.");
            if (this.mRepeatingRequest != null) {
                ret = this.mCurrentRepeatingFrameNumber == -1L ? -1L : this.mCurrentRepeatingFrameNumber - 1L;
            }
            this.mCurrentRepeatingFrameNumber = -1L;
            this.mRepeatingRequest = burst;
        } else {
            this.mRequestQueue.offer(burst);
            ret = this.calculateLastFrame(burst.getRequestId());
        }
        frameNumber.setNumber(ret);
        return requestId;
    }

    private long calculateLastFrame(int requestId) {
        long total = this.mCurrentFrameNumber;
        for (BurstHolder b : this.mRequestQueue) {
            total += (long)b.getNumberOfRequests();
            if (b.getRequestId() != requestId) continue;
            return total - 1L;
        }
        throw new IllegalStateException("At least one request must be in the queue to calculate frame number");
    }
}

