/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.util.AndroidException;

public class LegacyExceptionUtils {
    private static final String TAG = "LegacyExceptionUtils";

    public static int throwOnError(int errorFlag) throws BufferQueueAbandonedException {
        switch (errorFlag) {
            case 0: {
                return 0;
            }
            case -19: {
                throw new BufferQueueAbandonedException();
            }
        }
        if (errorFlag < 0) {
            throw new UnsupportedOperationException("Unknown error " + errorFlag);
        }
        return errorFlag;
    }

    private LegacyExceptionUtils() {
        throw new AssertionError();
    }

    public static class BufferQueueAbandonedException
    extends AndroidException {
        public BufferQueueAbandonedException() {
        }

        public BufferQueueAbandonedException(String name) {
            super(name);
        }

        public BufferQueueAbandonedException(String name, Throwable cause) {
            super(name, cause);
        }

        public BufferQueueAbandonedException(Exception cause) {
            super(cause);
        }
    }
}

