/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.pdf;

import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.OsConstants;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import libcore.io.IoUtils;
import libcore.io.Libcore;

public final class PdfEditor {
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final long mNativeDocument;
    private int mPageCount;
    private ParcelFileDescriptor mInput;

    public PdfEditor(ParcelFileDescriptor input) throws IOException {
        long size;
        if (input == null) {
            throw new NullPointerException("input cannot be null");
        }
        try {
            Libcore.os.lseek(input.getFileDescriptor(), 0L, OsConstants.SEEK_SET);
            size = Libcore.os.fstat((FileDescriptor)input.getFileDescriptor()).st_size;
        }
        catch (ErrnoException ee) {
            throw new IllegalArgumentException("file descriptor not seekable");
        }
        this.mInput = input;
        this.mNativeDocument = PdfEditor.nativeOpen(this.mInput.getFd(), size);
        this.mPageCount = PdfEditor.nativeGetPageCount(this.mNativeDocument);
        this.mCloseGuard.open("close");
    }

    public int getPageCount() {
        this.throwIfClosed();
        return this.mPageCount;
    }

    public void removePage(int pageIndex) {
        this.throwIfClosed();
        this.throwIfPageNotInDocument(pageIndex);
        this.mPageCount = PdfEditor.nativeRemovePage(this.mNativeDocument, pageIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ParcelFileDescriptor output) throws IOException {
        try {
            this.throwIfClosed();
            PdfEditor.nativeWrite(this.mNativeDocument, output.getFd());
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)output);
        }
    }

    public void close() {
        this.throwIfClosed();
        this.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            if (this.mInput != null) {
                this.doClose();
            }
        }
        finally {
            super.finalize();
        }
    }

    private void doClose() {
        PdfEditor.nativeClose(this.mNativeDocument);
        IoUtils.closeQuietly((AutoCloseable)this.mInput);
        this.mInput = null;
        this.mCloseGuard.close();
    }

    private void throwIfClosed() {
        if (this.mInput == null) {
            throw new IllegalStateException("Already closed");
        }
    }

    private void throwIfPageNotInDocument(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.mPageCount) {
            throw new IllegalArgumentException("Invalid page index");
        }
    }

    private static native long nativeOpen(int var0, long var1);

    private static native void nativeClose(long var0);

    private static native int nativeGetPageCount(long var0);

    private static native int nativeRemovePage(long var0, int var2);

    private static native void nativeWrite(long var0, int var2);
}

