/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.Ripple;
import android.graphics.drawable.RippleBackground;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import com.android.internal.R;
import java.io.IOException;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RippleDrawable
extends LayerDrawable {
    private static final PorterDuffXfermode DST_IN = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
    private static final PorterDuffXfermode SRC_ATOP = new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP);
    private static final PorterDuffXfermode SRC_OVER = new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER);
    public static final int RADIUS_AUTO = -1;
    private static final int MAX_RIPPLES = 10;
    private final Rect mTempRect = new Rect();
    private final Rect mHotspotBounds = new Rect();
    private final Rect mDrawingBounds = new Rect();
    private final Rect mDirtyBounds = new Rect();
    private RippleState mState;
    private Drawable mMask;
    private RippleBackground mBackground;
    private boolean mBackgroundActive;
    private Ripple mRipple;
    private boolean mRippleActive;
    private float mPendingX;
    private float mPendingY;
    private boolean mHasPending;
    private Ripple[] mExitingRipples;
    private int mExitingRipplesCount = 0;
    private Paint mRipplePaint;
    private Paint mMaskingPaint;
    private float mDensity = 1.0f;
    private boolean mOverrideBounds;
    private boolean mNeedsDraw;

    RippleDrawable() {
        this(new RippleState(null, null, null), null, null);
    }

    public RippleDrawable(ColorStateList color2, Drawable content, Drawable mask) {
        this(new RippleState(null, null, null), null, null);
        if (color2 == null) {
            throw new IllegalArgumentException("RippleDrawable requires a non-null color");
        }
        if (content != null) {
            this.addLayer(content, null, 0, 0, 0, 0, 0);
        }
        if (mask != null) {
            this.addLayer(mask, null, 16908334, 0, 0, 0, 0);
        }
        this.setColor(color2);
        this.ensurePadding();
        this.initializeFromState();
    }

    @Override
    public void jumpToCurrentState() {
        super.jumpToCurrentState();
        boolean needsDraw = false;
        if (this.mRipple != null) {
            needsDraw |= this.mRipple.isHardwareAnimating();
            this.mRipple.jump();
        }
        if (this.mBackground != null) {
            needsDraw |= this.mBackground.isHardwareAnimating();
            this.mBackground.jump();
        }
        this.mNeedsDraw = needsDraw |= this.cancelExitingRipples();
        this.invalidateSelf();
    }

    private boolean cancelExitingRipples() {
        boolean needsDraw = false;
        int count = this.mExitingRipplesCount;
        Object[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            needsDraw |= ripples[i].isHardwareAnimating();
            ((Ripple)ripples[i]).cancel();
        }
        if (ripples != null) {
            Arrays.fill(ripples, 0, count, null);
        }
        this.mExitingRipplesCount = 0;
        return needsDraw;
    }

    @Override
    public void setAlpha(int alpha) {
        super.setAlpha(alpha);
    }

    @Override
    public void setColorFilter(ColorFilter cf) {
        super.setColorFilter(cf);
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        boolean enabled = false;
        boolean pressed = false;
        boolean focused = false;
        for (int state : stateSet) {
            if (state == 16842910) {
                enabled = true;
            }
            if (state == 16842908) {
                focused = true;
            }
            if (state != 16842919) continue;
            pressed = true;
        }
        this.setRippleActive(enabled && pressed);
        this.setBackgroundActive(focused || enabled && pressed);
        return changed;
    }

    private void setRippleActive(boolean active) {
        if (this.mRippleActive != active) {
            this.mRippleActive = active;
            if (active) {
                this.tryRippleEnter();
            } else {
                this.tryRippleExit();
            }
        }
    }

    private void setBackgroundActive(boolean active) {
        if (this.mBackgroundActive != active) {
            this.mBackgroundActive = active;
            if (active) {
                this.tryBackgroundEnter();
            } else {
                this.tryBackgroundExit();
            }
        }
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        if (!this.mOverrideBounds) {
            this.mHotspotBounds.set(bounds);
            this.onHotspotBoundsChanged();
        }
        this.invalidateSelf();
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (!visible) {
            this.clearHotspots();
        } else if (changed) {
            if (this.mRippleActive) {
                this.tryRippleEnter();
            }
            if (this.mBackgroundActive) {
                this.tryBackgroundEnter();
            }
        }
        return changed;
    }

    @Override
    public boolean isProjected() {
        return this.getNumberOfLayers() == 0;
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    public void setColor(ColorStateList color2) {
        this.mState.mColor = color2;
        this.invalidateSelf();
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = RippleDrawable.obtainAttributes(r, theme, attrs, R.styleable.RippleDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.setPaddingMode(1);
        super.inflate(r, parser, attrs, theme);
        this.setTargetDensity(r.getDisplayMetrics());
        this.initializeFromState();
    }

    @Override
    public boolean setDrawableByLayerId(int id2, Drawable drawable2) {
        if (super.setDrawableByLayerId(id2, drawable2)) {
            if (id2 == 16908334) {
                this.mMask = drawable2;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setPaddingMode(int mode) {
        super.setPaddingMode(mode);
    }

    private void updateStateFromTypedArray(TypedArray a) throws XmlPullParserException {
        RippleState state = this.mState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mTouchThemeAttrs = a.extractThemeAttrs();
        ColorStateList color2 = a.getColorStateList(0);
        if (color2 != null) {
            this.mState.mColor = color2;
        }
        this.verifyRequiredAttributes(a);
    }

    private void verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.mState.mColor == null && (this.mState.mTouchThemeAttrs == null || this.mState.mTouchThemeAttrs[0] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <ripple> requires a valid color attribute");
        }
    }

    private void setTargetDensity(DisplayMetrics metrics) {
        if (this.mDensity != metrics.density) {
            this.mDensity = metrics.density;
            this.invalidateSelf();
        }
    }

    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        RippleState state = this.mState;
        if (state == null || state.mTouchThemeAttrs == null) {
            return;
        }
        TypedArray a = t.resolveAttributes(state.mTouchThemeAttrs, R.styleable.RippleDrawable);
        try {
            this.updateStateFromTypedArray(a);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        finally {
            a.recycle();
        }
        this.initializeFromState();
    }

    @Override
    public boolean canApplyTheme() {
        return super.canApplyTheme() || this.mState != null && this.mState.mTouchThemeAttrs != null;
    }

    @Override
    public void setHotspot(float x, float y) {
        if (this.mRipple == null || this.mBackground == null) {
            this.mPendingX = x;
            this.mPendingY = y;
            this.mHasPending = true;
        }
        if (this.mRipple != null) {
            this.mRipple.move(x, y);
        }
    }

    private void tryBackgroundEnter() {
        if (this.mBackground == null) {
            this.mBackground = new RippleBackground(this, this.mHotspotBounds);
        }
        int color2 = this.mState.mColor.getColorForState(this.getState(), 0);
        this.mBackground.setup(this.mState.mMaxRadius, color2, this.mDensity);
        this.mBackground.enter();
    }

    private void tryBackgroundExit() {
        if (this.mBackground != null) {
            this.mBackground.exit();
        }
    }

    private void tryRippleEnter() {
        if (this.mExitingRipplesCount >= 10) {
            return;
        }
        if (this.mRipple == null) {
            float y;
            float x;
            if (this.mHasPending) {
                this.mHasPending = false;
                x = this.mPendingX;
                y = this.mPendingY;
            } else {
                x = this.mHotspotBounds.exactCenterX();
                y = this.mHotspotBounds.exactCenterY();
            }
            this.mRipple = new Ripple(this, this.mHotspotBounds, x, y);
        }
        int color2 = this.mState.mColor.getColorForState(this.getState(), 0);
        this.mRipple.setup(this.mState.mMaxRadius, color2, this.mDensity);
        this.mRipple.enter();
    }

    private void tryRippleExit() {
        if (this.mRipple != null) {
            if (this.mExitingRipples == null) {
                this.mExitingRipples = new Ripple[10];
            }
            this.mExitingRipples[this.mExitingRipplesCount++] = this.mRipple;
            this.mRipple.exit();
            this.mRipple = null;
        }
    }

    private void clearHotspots() {
        boolean needsDraw = false;
        if (this.mRipple != null) {
            needsDraw |= this.mRipple.isHardwareAnimating();
            this.mRipple.cancel();
            this.mRipple = null;
        }
        if (this.mBackground != null) {
            needsDraw |= this.mBackground.isHardwareAnimating();
            this.mBackground.cancel();
            this.mBackground = null;
        }
        this.mNeedsDraw = needsDraw |= this.cancelExitingRipples();
        this.invalidateSelf();
    }

    @Override
    public void setHotspotBounds(int left, int top, int right, int bottom) {
        this.mOverrideBounds = true;
        this.mHotspotBounds.set(left, top, right, bottom);
        this.onHotspotBoundsChanged();
    }

    @Override
    public void getHotspotBounds(Rect outRect) {
        outRect.set(this.mHotspotBounds);
    }

    private void onHotspotBoundsChanged() {
        int count = this.mExitingRipplesCount;
        Ripple[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].onHotspotBoundsChanged();
        }
        if (this.mRipple != null) {
            this.mRipple.onHotspotBoundsChanged();
        }
        if (this.mBackground != null) {
            this.mBackground.onHotspotBoundsChanged();
        }
    }

    @Override
    public void getOutline(Outline outline) {
        LayerDrawable.LayerState state = this.mLayerState;
        LayerDrawable.ChildDrawable[] children = state.mChildren;
        int N = state.mNum;
        for (int i = 0; i < N; ++i) {
            if (children[i].mId == 16908334) continue;
            children[i].mDrawable.getOutline(outline);
            if (outline.isEmpty()) continue;
            return;
        }
    }

    @Override
    public void draw(Canvas canvas) {
        int rippleLayer;
        boolean hasMask = this.mMask != null;
        boolean drawNonMaskContent = this.mLayerState.mNum > (hasMask ? 1 : 0);
        boolean drawMask = hasMask && this.mMask.getOpacity() != -1;
        Rect bounds = this.getDirtyBounds();
        int saveCount = canvas.save(2);
        canvas.clipRect(bounds);
        int contentLayer = drawNonMaskContent ? this.drawContentLayer(canvas, bounds, SRC_OVER) : -1;
        PorterDuffXfermode xfermode = hasMask || !drawNonMaskContent ? SRC_OVER : SRC_ATOP;
        int backgroundLayer = this.drawBackgroundLayer(canvas, bounds, xfermode, drawMask);
        if (backgroundLayer >= 0) {
            if (drawMask) {
                this.drawMaskingLayer(canvas, bounds, DST_IN);
            }
            canvas.restoreToCount(backgroundLayer);
        }
        if ((rippleLayer = this.drawRippleLayer(canvas, bounds, xfermode)) >= 0) {
            if (drawMask) {
                this.drawMaskingLayer(canvas, bounds, DST_IN);
            }
            canvas.restoreToCount(rippleLayer);
        }
        if (contentLayer < 0 && backgroundLayer < 0 && rippleLayer < 0 && this.mNeedsDraw) {
            canvas.drawColor(0);
            this.invalidateSelf();
        }
        this.mNeedsDraw = false;
        canvas.restoreToCount(saveCount);
    }

    void removeRipple(Ripple ripple) {
        Ripple[] ripples = this.mExitingRipples;
        int count = this.mExitingRipplesCount--;
        int index = this.getRippleIndex(ripple);
        if (index >= 0) {
            System.arraycopy(ripples, index + 1, ripples, index, count - (index + 1));
            ripples[count - 1] = null;
            this.invalidateSelf();
        }
    }

    private int getRippleIndex(Ripple ripple) {
        Ripple[] ripples = this.mExitingRipples;
        int count = this.mExitingRipplesCount;
        for (int i = 0; i < count; ++i) {
            if (ripples[i] != ripple) continue;
            return i;
        }
        return -1;
    }

    private int drawContentLayer(Canvas canvas, Rect bounds, PorterDuffXfermode mode) {
        LayerDrawable.ChildDrawable[] array2 = this.mLayerState.mChildren;
        int count = this.mLayerState.mNum;
        boolean needsLayer = false;
        if ((this.mExitingRipplesCount > 0 || this.mBackground != null) && this.mMask == null) {
            for (int i = 0; i < count; ++i) {
                if (array2[i].mId == 16908334 || array2[i].mDrawable.getOpacity() == -1) continue;
                needsLayer = true;
                break;
            }
        }
        Paint maskingPaint = this.getMaskingPaint(mode);
        int restoreToCount = needsLayer ? canvas.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, maskingPaint) : -1;
        for (int i = 0; i < count; ++i) {
            if (array2[i].mId == 16908334) continue;
            array2[i].mDrawable.draw(canvas);
        }
        return restoreToCount;
    }

    private int drawBackgroundLayer(Canvas canvas, Rect bounds, PorterDuffXfermode mode, boolean drawMask) {
        int saveCount = -1;
        if (this.mBackground != null && this.mBackground.shouldDraw()) {
            if (drawMask || mode != SRC_OVER) {
                saveCount = canvas.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, this.getMaskingPaint(mode));
            }
            float x = this.mHotspotBounds.exactCenterX();
            float y = this.mHotspotBounds.exactCenterY();
            canvas.translate(x, y);
            this.mBackground.draw(canvas, this.getRipplePaint());
            canvas.translate(-x, -y);
        }
        return saveCount;
    }

    private int drawRippleLayer(Canvas canvas, Rect bounds, PorterDuffXfermode mode) {
        boolean drewRipples = false;
        int restoreToCount = -1;
        int restoreTranslate = -1;
        int count = this.mExitingRipplesCount;
        Ripple[] ripples = this.mExitingRipples;
        for (int i = 0; i <= count; ++i) {
            Ripple ripple;
            if (i < count) {
                ripple = ripples[i];
            } else {
                if (this.mRipple == null) continue;
                ripple = this.mRipple;
            }
            if (restoreToCount < 0) {
                Paint maskingPaint = this.getMaskingPaint(mode);
                int color2 = this.mState.mColor.getColorForState(this.getState(), 0);
                int alpha = Color.alpha(color2);
                maskingPaint.setAlpha(alpha / 2);
                restoreToCount = canvas.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, maskingPaint);
                restoreTranslate = canvas.save();
                canvas.translate(this.mHotspotBounds.exactCenterX(), this.mHotspotBounds.exactCenterY());
            }
            drewRipples |= ripple.draw(canvas, this.getRipplePaint());
        }
        if (restoreTranslate >= 0) {
            canvas.restoreToCount(restoreTranslate);
        }
        if (restoreToCount >= 0 && !drewRipples) {
            canvas.restoreToCount(restoreToCount);
            restoreToCount = -1;
        }
        return restoreToCount;
    }

    private int drawMaskingLayer(Canvas canvas, Rect bounds, PorterDuffXfermode mode) {
        int restoreToCount = canvas.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, this.getMaskingPaint(mode));
        canvas.drawColor(0);
        this.mMask.draw(canvas);
        return restoreToCount;
    }

    private Paint getRipplePaint() {
        if (this.mRipplePaint == null) {
            this.mRipplePaint = new Paint();
            this.mRipplePaint.setAntiAlias(true);
        }
        return this.mRipplePaint;
    }

    private Paint getMaskingPaint(PorterDuffXfermode xfermode) {
        if (this.mMaskingPaint == null) {
            this.mMaskingPaint = new Paint();
        }
        this.mMaskingPaint.setXfermode(xfermode);
        this.mMaskingPaint.setAlpha(255);
        return this.mMaskingPaint;
    }

    @Override
    public Rect getDirtyBounds() {
        if (this.isProjected()) {
            Rect drawingBounds = this.mDrawingBounds;
            Rect dirtyBounds = this.mDirtyBounds;
            dirtyBounds.set(drawingBounds);
            drawingBounds.setEmpty();
            int cX = (int)this.mHotspotBounds.exactCenterX();
            int cY = (int)this.mHotspotBounds.exactCenterY();
            Rect rippleBounds = this.mTempRect;
            Ripple[] activeRipples = this.mExitingRipples;
            int N = this.mExitingRipplesCount;
            for (int i = 0; i < N; ++i) {
                activeRipples[i].getBounds(rippleBounds);
                rippleBounds.offset(cX, cY);
                drawingBounds.union(rippleBounds);
            }
            RippleBackground background = this.mBackground;
            if (background != null) {
                background.getBounds(rippleBounds);
                rippleBounds.offset(cX, cY);
                drawingBounds.union(rippleBounds);
            }
            dirtyBounds.union(drawingBounds);
            dirtyBounds.union(super.getDirtyBounds());
            return dirtyBounds;
        }
        return this.getBounds();
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return this.mState;
    }

    @Override
    public Drawable mutate() {
        super.mutate();
        this.mState = (RippleState)this.mLayerState;
        return this;
    }

    @Override
    RippleState createConstantState(LayerDrawable.LayerState state, Resources res) {
        return new RippleState(state, this, res);
    }

    public void setMaxRadius(int maxRadius) {
        if (maxRadius != -1 && maxRadius < 0) {
            throw new IllegalArgumentException("maxRadius must be RADIUS_AUTO or >= 0");
        }
        this.mState.mMaxRadius = maxRadius;
    }

    public int getMaxRadius() {
        return this.mState.mMaxRadius;
    }

    private RippleDrawable(RippleState state, Resources res, Resources.Theme theme) {
        RippleState ns;
        boolean needsTheme = false;
        if (theme != null && state != null && state.canApplyTheme()) {
            ns = new RippleState((LayerDrawable.LayerState)state, this, res);
            needsTheme = true;
        } else {
            ns = state == null ? new RippleState(null, this, res) : new RippleState((LayerDrawable.LayerState)state, this, res);
        }
        if (res != null) {
            this.mDensity = res.getDisplayMetrics().density;
        }
        this.mState = ns;
        this.mLayerState = ns;
        if (ns.mNum > 0) {
            this.ensurePadding();
        }
        if (needsTheme) {
            this.applyTheme(theme);
        }
        this.initializeFromState();
    }

    private void initializeFromState() {
        this.mMask = this.findDrawableByLayerId(16908334);
    }

    static class RippleState
    extends LayerDrawable.LayerState {
        int[] mTouchThemeAttrs;
        ColorStateList mColor = ColorStateList.valueOf(-65281);
        int mMaxRadius = -1;

        public RippleState(LayerDrawable.LayerState orig, RippleDrawable owner, Resources res) {
            super(orig, owner, res);
            if (orig != null && orig instanceof RippleState) {
                RippleState origs = (RippleState)orig;
                this.mTouchThemeAttrs = origs.mTouchThemeAttrs;
                this.mColor = origs.mColor;
                this.mMaxRadius = origs.mMaxRadius;
            }
        }

        @Override
        public boolean canApplyTheme() {
            return this.mTouchThemeAttrs != null || super.canApplyTheme();
        }

        @Override
        public Drawable newDrawable() {
            return new RippleDrawable(this, null, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new RippleDrawable(this, res, null);
        }

        @Override
        public Drawable newDrawable(Resources res, Resources.Theme theme) {
            return new RippleDrawable(this, res, theme);
        }
    }
}

