/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.os.SystemClock;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimationDrawable
extends DrawableContainer
implements Runnable,
Animatable {
    private final AnimationState mAnimationState;
    private int mCurFrame = -1;
    private boolean mRunning;
    private boolean mAnimating;
    private boolean mMutated;

    public AnimationDrawable() {
        this(null, null);
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (visible) {
            if (restart || changed) {
                boolean startFromZero = restart || this.mCurFrame < 0 || this.mCurFrame >= this.mAnimationState.getChildCount();
                this.setFrame(startFromZero ? 0 : this.mCurFrame, true, this.mAnimating);
            }
        } else {
            this.unscheduleSelf(this);
        }
        return changed;
    }

    @Override
    public void start() {
        this.mAnimating = true;
        if (!this.isRunning()) {
            this.run();
        }
    }

    @Override
    public void stop() {
        this.mAnimating = false;
        if (this.isRunning()) {
            this.unscheduleSelf(this);
        }
    }

    @Override
    public boolean isRunning() {
        return this.mRunning;
    }

    @Override
    public void run() {
        this.nextFrame(false);
    }

    @Override
    public void unscheduleSelf(Runnable what) {
        this.mCurFrame = -1;
        this.mRunning = false;
        super.unscheduleSelf(what);
    }

    public int getNumberOfFrames() {
        return this.mAnimationState.getChildCount();
    }

    public Drawable getFrame(int index) {
        return this.mAnimationState.getChild(index);
    }

    public int getDuration(int i) {
        return this.mAnimationState.mDurations[i];
    }

    public boolean isOneShot() {
        return this.mAnimationState.mOneShot;
    }

    public void setOneShot(boolean oneShot) {
        this.mAnimationState.mOneShot = oneShot;
    }

    public void addFrame(Drawable frame, int duration) {
        this.mAnimationState.addFrame(frame, duration);
        if (this.mCurFrame < 0) {
            this.setFrame(0, true, false);
        }
    }

    private void nextFrame(boolean unschedule) {
        int next = this.mCurFrame + 1;
        int N = this.mAnimationState.getChildCount();
        if (next >= N) {
            next = 0;
        }
        this.setFrame(next, unschedule, !this.mAnimationState.mOneShot || next < N - 1);
    }

    private void setFrame(int frame, boolean unschedule, boolean animate) {
        if (frame >= this.mAnimationState.getChildCount()) {
            return;
        }
        this.mAnimating = animate;
        this.mCurFrame = frame;
        this.selectDrawable(frame);
        if (unschedule || animate) {
            this.unscheduleSelf(this);
        }
        if (animate) {
            this.mCurFrame = frame;
            this.mRunning = true;
            this.scheduleSelf(this, SystemClock.uptimeMillis() + (long)this.mAnimationState.mDurations[frame]);
        }
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        TypedArray a = AnimationDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimationDrawable);
        super.inflateWithAttributes(r, parser, a, 0);
        this.mAnimationState.setVariablePadding(a.getBoolean(1, false));
        this.mAnimationState.mOneShot = a.getBoolean(2, false);
        a.recycle();
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            Drawable dr;
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            a = AnimationDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimationDrawableItem);
            int duration = a.getInt(0, -1);
            if (duration < 0) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'duration' attribute");
            }
            int drawableRes = a.getResourceId(1, 0);
            a.recycle();
            if (drawableRes != 0) {
                dr = r.getDrawable(drawableRes, theme);
            } else {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or child tag" + " defining a drawable");
                }
                dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
            }
            this.mAnimationState.addFrame(dr, duration);
            if (dr == null) continue;
            dr.setCallback(this);
        }
        this.setFrame(0, true, false);
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            AnimationState.access$002(this.mAnimationState, (int[])this.mAnimationState.mDurations.clone());
            this.mMutated = true;
        }
        return this;
    }

    private AnimationDrawable(AnimationState state, Resources res) {
        AnimationState as;
        this.mAnimationState = as = new AnimationState(state, this, res);
        this.setConstantState(as);
        if (state != null) {
            this.setFrame(0, true, false);
        }
    }

    private static final class AnimationState
    extends DrawableContainer.DrawableContainerState {
        private int[] mDurations;
        private boolean mOneShot;

        AnimationState(AnimationState orig, AnimationDrawable owner, Resources res) {
            super(orig, owner, res);
            if (orig != null) {
                this.mDurations = orig.mDurations;
                this.mOneShot = orig.mOneShot;
            } else {
                this.mDurations = new int[this.getCapacity()];
                this.mOneShot = true;
            }
        }

        @Override
        public Drawable newDrawable() {
            return new AnimationDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new AnimationDrawable(this, res);
        }

        public void addFrame(Drawable dr, int dur) {
            int pos = super.addChild(dr);
            this.mDurations[pos] = dur;
        }

        @Override
        public void growArray(int oldSize, int newSize) {
            super.growArray(oldSize, newSize);
            int[] newDurations = new int[newSize];
            System.arraycopy((int[])this.mDurations, (int)0, (int[])newDurations, (int)0, (int)oldSize);
            this.mDurations = newDurations;
        }

        static /* synthetic */ int[] access$002(AnimationState x0, int[] x1) {
            x0.mDurations = x1;
            return x1;
        }
    }
}

