/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.GestureUtils;
import android.gesture.Instance;
import android.gesture.Learner;
import android.gesture.Prediction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeMap;

class InstanceLearner
extends Learner {
    private static final Comparator<Prediction> sComparator = new Comparator<Prediction>(){

        @Override
        public int compare(Prediction object1, Prediction object2) {
            double score1 = object1.score;
            double score2 = object2.score;
            if (score1 > score2) {
                return -1;
            }
            if (score1 < score2) {
                return 1;
            }
            return 0;
        }
    };

    InstanceLearner() {
    }

    @Override
    ArrayList<Prediction> classify(int sequenceType, int orientationType, float[] vector) {
        ArrayList<Prediction> predictions = new ArrayList<Prediction>();
        ArrayList<Instance> instances = this.getInstances();
        int count = instances.size();
        TreeMap<String, Double> label2score = new TreeMap<String, Double>();
        for (int i = 0; i < count; ++i) {
            Instance sample = instances.get(i);
            if (sample.vector.length != vector.length) continue;
            double distance = sequenceType == 2 ? (double)GestureUtils.minimumCosineDistance(sample.vector, vector, orientationType) : (double)GestureUtils.squaredEuclideanDistance(sample.vector, vector);
            double weight = distance == 0.0 ? Double.MAX_VALUE : 1.0 / distance;
            Double score = (Double)label2score.get(sample.label);
            if (score != null && !(weight > score)) continue;
            label2score.put(sample.label, weight);
        }
        for (String name : label2score.keySet()) {
            double score = (Double)label2score.get(name);
            predictions.add(new Prediction(name, score));
        }
        Collections.sort(predictions, sComparator);
        return predictions;
    }
}

