/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.ui;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.util.Log;
import android.view.Surface;

public class SurfaceTargetFilter
extends Filter {
    private final int RENDERMODE_STRETCH = 0;
    private final int RENDERMODE_FIT = 1;
    private final int RENDERMODE_FILL_CROP = 2;
    @GenerateFinalPort(name="surface")
    private Surface mSurface;
    @GenerateFieldPort(name="owidth")
    private int mScreenWidth;
    @GenerateFieldPort(name="oheight")
    private int mScreenHeight;
    @GenerateFieldPort(name="renderMode", hasDefault=true)
    private String mRenderModeString;
    private ShaderProgram mProgram;
    private GLEnvironment mGlEnv;
    private GLFrame mScreen;
    private int mRenderMode = 1;
    private float mAspectRatio = 1.0f;
    private int mSurfaceId = -1;
    private boolean mLogVerbose = Log.isLoggable("SurfaceRenderFilter", 2);
    private static final String TAG = "SurfaceRenderFilter";

    public SurfaceTargetFilter(String name) {
        super(name);
    }

    @Override
    public void setupPorts() {
        if (this.mSurface == null) {
            throw new RuntimeException("NULL Surface passed to SurfaceTargetFilter");
        }
        this.addMaskedInputPort("frame", ImageFormat.create(3));
    }

    public void updateRenderMode() {
        if (this.mRenderModeString != null) {
            if (this.mRenderModeString.equals("stretch")) {
                this.mRenderMode = 0;
            } else if (this.mRenderModeString.equals("fit")) {
                this.mRenderMode = 1;
            } else if (this.mRenderModeString.equals("fill_crop")) {
                this.mRenderMode = 2;
            } else {
                throw new RuntimeException("Unknown render mode '" + this.mRenderModeString + "'!");
            }
        }
        this.updateTargetRect();
    }

    @Override
    public void prepare(FilterContext context) {
        this.mGlEnv = context.getGLEnvironment();
        this.mProgram = ShaderProgram.createIdentity(context);
        this.mProgram.setSourceRect(0.0f, 1.0f, 1.0f, -1.0f);
        this.mProgram.setClearsOutput(true);
        this.mProgram.setClearColor(0.0f, 0.0f, 0.0f);
        MutableFrameFormat screenFormat = ImageFormat.create(this.mScreenWidth, this.mScreenHeight, 3, 3);
        this.mScreen = (GLFrame)context.getFrameManager().newBoundFrame(screenFormat, 101, 0L);
        this.updateRenderMode();
    }

    @Override
    public void open(FilterContext context) {
        this.registerSurface();
    }

    @Override
    public void process(FilterContext context) {
        int target;
        if (this.mLogVerbose) {
            Log.v(TAG, "Starting frame processing");
        }
        Frame input = this.pullInput("frame");
        boolean createdFrame = false;
        float currentAspectRatio = (float)input.getFormat().getWidth() / (float)input.getFormat().getHeight();
        if (currentAspectRatio != this.mAspectRatio) {
            if (this.mLogVerbose) {
                Log.v(TAG, "New aspect ratio: " + currentAspectRatio + ", previously: " + this.mAspectRatio);
            }
            this.mAspectRatio = currentAspectRatio;
            this.updateTargetRect();
        }
        Frame gpuFrame = null;
        if (this.mLogVerbose) {
            Log.v(TAG, "Got input format: " + input.getFormat());
        }
        if ((target = input.getFormat().getTarget()) != 3) {
            gpuFrame = context.getFrameManager().duplicateFrameToTarget(input, 3);
            createdFrame = true;
        } else {
            gpuFrame = input;
        }
        this.mGlEnv.activateSurfaceWithId(this.mSurfaceId);
        this.mProgram.process(gpuFrame, (Frame)this.mScreen);
        this.mGlEnv.swapBuffers();
        if (createdFrame) {
            gpuFrame.release();
        }
    }

    @Override
    public void fieldPortValueUpdated(String name, FilterContext context) {
        this.mScreen.setViewport(0, 0, this.mScreenWidth, this.mScreenHeight);
        this.updateTargetRect();
    }

    @Override
    public void close(FilterContext context) {
        this.unregisterSurface();
    }

    @Override
    public void tearDown(FilterContext context) {
        if (this.mScreen != null) {
            this.mScreen.release();
        }
    }

    private void updateTargetRect() {
        if (this.mScreenWidth > 0 && this.mScreenHeight > 0 && this.mProgram != null) {
            float screenAspectRatio = (float)this.mScreenWidth / (float)this.mScreenHeight;
            float relativeAspectRatio = screenAspectRatio / this.mAspectRatio;
            switch (this.mRenderMode) {
                case 0: {
                    this.mProgram.setTargetRect(0.0f, 0.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    if (relativeAspectRatio > 1.0f) {
                        this.mProgram.setTargetRect(0.5f - 0.5f / relativeAspectRatio, 0.0f, 1.0f / relativeAspectRatio, 1.0f);
                        break;
                    }
                    this.mProgram.setTargetRect(0.0f, 0.5f - 0.5f * relativeAspectRatio, 1.0f, relativeAspectRatio);
                    break;
                }
                case 2: {
                    if (relativeAspectRatio > 1.0f) {
                        this.mProgram.setTargetRect(0.0f, 0.5f - 0.5f * relativeAspectRatio, 1.0f, relativeAspectRatio);
                        break;
                    }
                    this.mProgram.setTargetRect(0.5f - 0.5f / relativeAspectRatio, 0.0f, 1.0f / relativeAspectRatio, 1.0f);
                }
            }
        }
    }

    private void registerSurface() {
        this.mSurfaceId = this.mGlEnv.registerSurface(this.mSurface);
        if (this.mSurfaceId < 0) {
            throw new RuntimeException("Could not register Surface: " + this.mSurface);
        }
    }

    private void unregisterSurface() {
        if (this.mSurfaceId > 0) {
            this.mGlEnv.unregisterSurfaceId(this.mSurfaceId);
        }
    }
}

