/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.ui;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.FilterSurfaceView;
import android.filterfw.core.Frame;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.util.Log;
import android.view.SurfaceHolder;

public class SurfaceRenderFilter
extends Filter
implements SurfaceHolder.Callback {
    private final int RENDERMODE_STRETCH = 0;
    private final int RENDERMODE_FIT = 1;
    private final int RENDERMODE_FILL_CROP = 2;
    @GenerateFinalPort(name="surfaceView")
    private FilterSurfaceView mSurfaceView;
    @GenerateFieldPort(name="renderMode", hasDefault=true)
    private String mRenderModeString;
    private boolean mIsBound = false;
    private ShaderProgram mProgram;
    private GLFrame mScreen;
    private int mRenderMode = 1;
    private float mAspectRatio = 1.0f;
    private int mScreenWidth;
    private int mScreenHeight;
    private boolean mLogVerbose = Log.isLoggable("SurfaceRenderFilter", 2);
    private static final String TAG = "SurfaceRenderFilter";

    public SurfaceRenderFilter(String name) {
        super(name);
    }

    @Override
    public void setupPorts() {
        if (this.mSurfaceView == null) {
            throw new RuntimeException("NULL SurfaceView passed to SurfaceRenderFilter");
        }
        this.addMaskedInputPort("frame", ImageFormat.create(3));
    }

    public void updateRenderMode() {
        if (this.mRenderModeString != null) {
            if (this.mRenderModeString.equals("stretch")) {
                this.mRenderMode = 0;
            } else if (this.mRenderModeString.equals("fit")) {
                this.mRenderMode = 1;
            } else if (this.mRenderModeString.equals("fill_crop")) {
                this.mRenderMode = 2;
            } else {
                throw new RuntimeException("Unknown render mode '" + this.mRenderModeString + "'!");
            }
        }
        this.updateTargetRect();
    }

    @Override
    public void prepare(FilterContext context) {
        this.mProgram = ShaderProgram.createIdentity(context);
        this.mProgram.setSourceRect(0.0f, 1.0f, 1.0f, -1.0f);
        this.mProgram.setClearsOutput(true);
        this.mProgram.setClearColor(0.0f, 0.0f, 0.0f);
        this.updateRenderMode();
        MutableFrameFormat screenFormat = ImageFormat.create(this.mSurfaceView.getWidth(), this.mSurfaceView.getHeight(), 3, 3);
        this.mScreen = (GLFrame)context.getFrameManager().newBoundFrame(screenFormat, 101, 0L);
    }

    @Override
    public void open(FilterContext context) {
        this.mSurfaceView.unbind();
        this.mSurfaceView.bindToListener(this, context.getGLEnvironment());
    }

    @Override
    public void process(FilterContext context) {
        int target;
        GLEnvironment glEnv;
        if (!this.mIsBound) {
            Log.w(TAG, this + ": Ignoring frame as there is no surface to render to!");
            return;
        }
        if (this.mLogVerbose) {
            Log.v(TAG, "Starting frame processing");
        }
        if ((glEnv = this.mSurfaceView.getGLEnv()) != context.getGLEnvironment()) {
            throw new RuntimeException("Surface created under different GLEnvironment!");
        }
        Frame input = this.pullInput("frame");
        boolean createdFrame = false;
        float currentAspectRatio = (float)input.getFormat().getWidth() / (float)input.getFormat().getHeight();
        if (currentAspectRatio != this.mAspectRatio) {
            if (this.mLogVerbose) {
                Log.v(TAG, "New aspect ratio: " + currentAspectRatio + ", previously: " + this.mAspectRatio);
            }
            this.mAspectRatio = currentAspectRatio;
            this.updateTargetRect();
        }
        Frame gpuFrame = null;
        if (this.mLogVerbose) {
            Log.v(TAG, "Got input format: " + input.getFormat());
        }
        if ((target = input.getFormat().getTarget()) != 3) {
            gpuFrame = context.getFrameManager().duplicateFrameToTarget(input, 3);
            createdFrame = true;
        } else {
            gpuFrame = input;
        }
        glEnv.activateSurfaceWithId(this.mSurfaceView.getSurfaceId());
        this.mProgram.process(gpuFrame, (Frame)this.mScreen);
        glEnv.swapBuffers();
        if (createdFrame) {
            gpuFrame.release();
        }
    }

    @Override
    public void fieldPortValueUpdated(String name, FilterContext context) {
        this.updateTargetRect();
    }

    @Override
    public void close(FilterContext context) {
        this.mSurfaceView.unbind();
    }

    @Override
    public void tearDown(FilterContext context) {
        if (this.mScreen != null) {
            this.mScreen.release();
        }
    }

    @Override
    public synchronized void surfaceCreated(SurfaceHolder holder) {
        this.mIsBound = true;
    }

    @Override
    public synchronized void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (this.mScreen != null) {
            this.mScreenWidth = width;
            this.mScreenHeight = height;
            this.mScreen.setViewport(0, 0, this.mScreenWidth, this.mScreenHeight);
            this.updateTargetRect();
        }
    }

    @Override
    public synchronized void surfaceDestroyed(SurfaceHolder holder) {
        this.mIsBound = false;
    }

    private void updateTargetRect() {
        if (this.mScreenWidth > 0 && this.mScreenHeight > 0 && this.mProgram != null) {
            float screenAspectRatio = (float)this.mScreenWidth / (float)this.mScreenHeight;
            float relativeAspectRatio = screenAspectRatio / this.mAspectRatio;
            switch (this.mRenderMode) {
                case 0: {
                    this.mProgram.setTargetRect(0.0f, 0.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    if (relativeAspectRatio > 1.0f) {
                        this.mProgram.setTargetRect(0.5f - 0.5f / relativeAspectRatio, 0.0f, 1.0f / relativeAspectRatio, 1.0f);
                        break;
                    }
                    this.mProgram.setTargetRect(0.0f, 0.5f - 0.5f * relativeAspectRatio, 1.0f, relativeAspectRatio);
                    break;
                }
                case 2: {
                    if (relativeAspectRatio > 1.0f) {
                        this.mProgram.setTargetRect(0.0f, 0.5f - 0.5f * relativeAspectRatio, 1.0f, relativeAspectRatio);
                        break;
                    }
                    this.mProgram.setTargetRect(0.5f - 0.5f / relativeAspectRatio, 0.0f, 1.0f / relativeAspectRatio, 1.0f);
                }
            }
        }
    }
}

