/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.graphics.Color;

public class TintFilter
extends Filter {
    @GenerateFieldPort(name="tint", hasDefault=true)
    private int mTint = -16776961;
    @GenerateFieldPort(name="tile_size", hasDefault=true)
    private int mTileSize = 640;
    private Program mProgram;
    private int mTarget = 0;
    private final String mTintShader = "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform vec3 tint;\nuniform vec3 color_ratio;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  float avg_color = dot(color_ratio, color.rgb);\n  vec3 new_color = min(0.8 * avg_color + 0.2 * tint, 1.0);\n  gl_FragColor = vec4(new_color.rgb, color.a);\n}\n";

    public TintFilter(String name) {
        super(name);
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }

    @Override
    public FrameFormat getOutputFormat(String portName, FrameFormat inputFormat) {
        return inputFormat;
    }

    public void initProgram(FilterContext context, int target) {
        switch (target) {
            case 3: {
                ShaderProgram shaderProgram = new ShaderProgram(context, "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform vec3 tint;\nuniform vec3 color_ratio;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  float avg_color = dot(color_ratio, color.rgb);\n  vec3 new_color = min(0.8 * avg_color + 0.2 * tint, 1.0);\n  gl_FragColor = vec4(new_color.rgb, color.a);\n}\n");
                shaderProgram.setMaximumTileSize(this.mTileSize);
                this.mProgram = shaderProgram;
                break;
            }
            default: {
                throw new RuntimeException("Filter Sharpen does not support frames of target " + target + "!");
            }
        }
        this.mTarget = target;
    }

    @Override
    public void fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mProgram != null) {
            this.updateParameters();
        }
    }

    @Override
    public void process(FilterContext context) {
        Frame input = this.pullInput("image");
        FrameFormat inputFormat = input.getFormat();
        if (this.mProgram == null || inputFormat.getTarget() != this.mTarget) {
            this.initProgram(context, inputFormat.getTarget());
            this.initParameters();
        }
        Frame output = context.getFrameManager().newFrame(inputFormat);
        this.mProgram.process(input, output);
        this.pushOutput("image", output);
        output.release();
    }

    private void initParameters() {
        float[] color_ratio = new float[]{0.21f, 0.71f, 0.07f};
        this.mProgram.setHostValue("color_ratio", color_ratio);
        this.updateParameters();
    }

    private void updateParameters() {
        float[] tint_color = new float[]{(float)Color.red(this.mTint) / 255.0f, (float)Color.green(this.mTint) / 255.0f, (float)Color.blue(this.mTint) / 255.0f};
        this.mProgram.setHostValue("tint", tint_color);
    }
}

