/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.util.Log;
import dalvik.system.PathClassLoader;
import java.lang.reflect.Constructor;
import java.util.HashSet;

public class FilterFactory {
    private static FilterFactory mSharedFactory;
    private HashSet<String> mPackages = new HashSet();
    private static ClassLoader mCurrentClassLoader;
    private static HashSet<String> mLibraries;
    private static Object mClassLoaderGuard;
    private static final String TAG = "FilterFactory";
    private static boolean mLogVerbose;

    public static FilterFactory sharedFactory() {
        if (mSharedFactory == null) {
            mSharedFactory = new FilterFactory();
        }
        return mSharedFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFilterLibrary(String libraryPath) {
        if (mLogVerbose) {
            Log.v(TAG, "Adding filter library " + libraryPath);
        }
        Object object = mClassLoaderGuard;
        synchronized (object) {
            if (mLibraries.contains(libraryPath)) {
                if (mLogVerbose) {
                    Log.v(TAG, "Library already added");
                }
                return;
            }
            mLibraries.add(libraryPath);
            mCurrentClassLoader = new PathClassLoader(libraryPath, mCurrentClassLoader);
        }
    }

    public void addPackage(String packageName) {
        if (mLogVerbose) {
            Log.v(TAG, "Adding package " + packageName);
        }
        this.mPackages.add(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter createFilterByClassName(String className, String filterName) {
        if (mLogVerbose) {
            Log.v(TAG, "Looking up class " + className);
        }
        Class<?> filterClass = null;
        for (String packageName : this.mPackages) {
            try {
                if (mLogVerbose) {
                    Log.v(TAG, "Trying " + packageName + "." + className);
                }
                Object object = mClassLoaderGuard;
                synchronized (object) {
                    filterClass = mCurrentClassLoader.loadClass(packageName + "." + className);
                }
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (filterClass == null) continue;
            break;
        }
        if (filterClass == null) {
            throw new IllegalArgumentException("Unknown filter class '" + className + "'!");
        }
        return this.createFilterByClass(filterClass, filterName);
    }

    public Filter createFilterByClass(Class filterClass, String filterName) {
        try {
            filterClass.asSubclass(Filter.class);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Attempting to allocate class '" + filterClass + "' which is not a subclass of Filter!");
        }
        Constructor filterConstructor = null;
        try {
            filterConstructor = filterClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The filter class '" + filterClass + "' does not have a constructor of the form <init>(String name)!");
        }
        Filter filter = null;
        try {
            filter = (Filter)filterConstructor.newInstance(filterName);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (filter == null) {
            throw new IllegalArgumentException("Could not construct the filter '" + filterName + "'!");
        }
        return filter;
    }

    static {
        mCurrentClassLoader = Thread.currentThread().getContextClassLoader();
        mLibraries = new HashSet();
        mClassLoaderGuard = new Object();
        mLogVerbose = Log.isLoggable(TAG, 2);
    }
}

