/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.util.Log;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleNativeHeap
extends ChunkHandler {
    public static final int CHUNK_NHGT = DdmHandleNativeHeap.type((String)"NHGT");
    private static DdmHandleNativeHeap mInstance = new DdmHandleNativeHeap();

    private DdmHandleNativeHeap() {
    }

    public static void register() {
        DdmServer.registerHandler((int)CHUNK_NHGT, (ChunkHandler)mInstance);
    }

    public void connected() {
    }

    public void disconnected() {
    }

    public Chunk handleChunk(Chunk request) {
        Log.i("ddm-nativeheap", "Handling " + DdmHandleNativeHeap.name((int)request.type) + " chunk");
        int type = request.type;
        if (type == CHUNK_NHGT) {
            return this.handleNHGT(request);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name((int)type));
    }

    private Chunk handleNHGT(Chunk request) {
        byte[] data = this.getLeakInfo();
        if (data != null) {
            Log.i("ddm-nativeheap", "Sending " + data.length + " bytes");
            return new Chunk(ChunkHandler.type((String)"NHGT"), data, 0, data.length);
        }
        return DdmHandleNativeHeap.createFailChunk((int)1, (String)"Something went wrong");
    }

    private native byte[] getLeakInfo();
}

