/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetFileDescriptor;
import android.content.res.StringBlock;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.util.SparseArray;
import android.util.TypedValue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public final class AssetManager
implements AutoCloseable {
    public static final int ACCESS_UNKNOWN = 0;
    public static final int ACCESS_RANDOM = 1;
    public static final int ACCESS_STREAMING = 2;
    public static final int ACCESS_BUFFER = 3;
    private static final String TAG = "AssetManager";
    private static final boolean localLOGV = false;
    private static final boolean DEBUG_REFS = false;
    private static final Object sSync = new Object();
    static AssetManager sSystem = null;
    private final TypedValue mValue = new TypedValue();
    private final long[] mOffsets = new long[2];
    private long mObject;
    private StringBlock[] mStringBlocks = null;
    private int mNumRefs = 1;
    private boolean mOpen = true;
    private HashMap<Long, RuntimeException> mRefStacks;
    static final int STYLE_NUM_ENTRIES = 6;
    static final int STYLE_TYPE = 0;
    static final int STYLE_DATA = 1;
    static final int STYLE_ASSET_COOKIE = 2;
    static final int STYLE_RESOURCE_ID = 3;
    static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    static final int STYLE_DENSITY = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetManager() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.init(false);
            AssetManager.ensureSystemAssets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureSystemAssets() {
        Object object = sSync;
        synchronized (object) {
            if (sSystem == null) {
                AssetManager system = new AssetManager(true);
                system.makeStringBlocks(null);
                sSystem = system;
            }
        }
    }

    private AssetManager(boolean isSystem) {
        this.init(true);
    }

    public static AssetManager getSystem() {
        AssetManager.ensureSystemAssets();
        return sSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (this.mOpen) {
                this.mOpen = false;
                this.decRefsLocked(this.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CharSequence getResourceText(int ident) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            TypedValue tmpValue = this.mValue;
            int block = this.loadResourceValue(ident, (short)0, tmpValue, true);
            if (block >= 0) {
                if (tmpValue.type == 3) {
                    return this.mStringBlocks[block].get(tmpValue.data);
                }
                return tmpValue.coerceToString();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CharSequence getResourceBagText(int ident, int bagEntryId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            TypedValue tmpValue = this.mValue;
            int block = this.loadResourceBagValue(ident, bagEntryId, tmpValue, true);
            if (block >= 0) {
                if (tmpValue.type == 3) {
                    return this.mStringBlocks[block].get(tmpValue.data);
                }
                return tmpValue.coerceToString();
            }
        }
        return null;
    }

    final String[] getResourceStringArray(int id2) {
        String[] retArray = this.getArrayStringResource(id2);
        return retArray;
    }

    final boolean getResourceValue(int ident, int density, TypedValue outValue, boolean resolveRefs) {
        int block = this.loadResourceValue(ident, (short)density, outValue, resolveRefs);
        if (block >= 0) {
            if (outValue.type != 3) {
                return true;
            }
            outValue.string = this.mStringBlocks[block].get(outValue.data);
            return true;
        }
        return false;
    }

    final CharSequence[] getResourceTextArray(int id2) {
        int[] rawInfoArray = this.getArrayStringInfo(id2);
        int rawInfoArrayLen = rawInfoArray.length;
        int infoArrayLen = rawInfoArrayLen / 2;
        CharSequence[] retArray = new CharSequence[infoArrayLen];
        int i = 0;
        int j = 0;
        while (i < rawInfoArrayLen) {
            int block = rawInfoArray[i];
            int index = rawInfoArray[i + 1];
            retArray[j] = index >= 0 ? this.mStringBlocks[block].get(index) : null;
            i += 2;
            ++j;
        }
        return retArray;
    }

    final boolean getThemeValue(long theme, int ident, TypedValue outValue, boolean resolveRefs) {
        int block = AssetManager.loadThemeAttributeValue(theme, ident, outValue, resolveRefs);
        if (block >= 0) {
            if (outValue.type != 3) {
                return true;
            }
            StringBlock[] blocks = this.mStringBlocks;
            if (blocks == null) {
                this.ensureStringBlocks();
                blocks = this.mStringBlocks;
            }
            outValue.string = blocks[block].get(outValue.data);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureStringBlocks() {
        if (this.mStringBlocks == null) {
            AssetManager assetManager = this;
            synchronized (assetManager) {
                if (this.mStringBlocks == null) {
                    this.makeStringBlocks(AssetManager.sSystem.mStringBlocks);
                }
            }
        }
    }

    final void makeStringBlocks(StringBlock[] seed) {
        int seedNum = seed != null ? seed.length : 0;
        int num = this.getStringBlockCount();
        this.mStringBlocks = new StringBlock[num];
        for (int i = 0; i < num; ++i) {
            this.mStringBlocks[i] = i < seedNum ? seed[i] : new StringBlock(this.getNativeStringBlock(i), true);
        }
    }

    final CharSequence getPooledStringForCookie(int cookie, int id2) {
        return this.mStringBlocks[cookie - 1].get(id2);
    }

    public final InputStream open(String fileName) throws IOException {
        return this.open(fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InputStream open(String fileName, int accessMode) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long asset = this.openAsset(fileName, accessMode);
            if (asset != 0L) {
                AssetInputStream res = new AssetInputStream(asset);
                this.incRefsLocked(res.hashCode());
                return res;
            }
        }
        throw new FileNotFoundException("Asset file: " + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AssetFileDescriptor openFd(String fileName) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            ParcelFileDescriptor pfd = this.openAssetFd(fileName, this.mOffsets);
            if (pfd != null) {
                return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
            }
        }
        throw new FileNotFoundException("Asset file: " + fileName);
    }

    public final native String[] list(String var1) throws IOException;

    public final InputStream openNonAsset(String fileName) throws IOException {
        return this.openNonAsset(0, fileName, 2);
    }

    public final InputStream openNonAsset(String fileName, int accessMode) throws IOException {
        return this.openNonAsset(0, fileName, accessMode);
    }

    public final InputStream openNonAsset(int cookie, String fileName) throws IOException {
        return this.openNonAsset(cookie, fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InputStream openNonAsset(int cookie, String fileName, int accessMode) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long asset = this.openNonAssetNative(cookie, fileName, accessMode);
            if (asset != 0L) {
                AssetInputStream res = new AssetInputStream(asset);
                this.incRefsLocked(res.hashCode());
                return res;
            }
        }
        throw new FileNotFoundException("Asset absolute file: " + fileName);
    }

    public final AssetFileDescriptor openNonAssetFd(String fileName) throws IOException {
        return this.openNonAssetFd(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AssetFileDescriptor openNonAssetFd(int cookie, String fileName) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            ParcelFileDescriptor pfd = this.openNonAssetFdNative(cookie, fileName, this.mOffsets);
            if (pfd != null) {
                return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
            }
        }
        throw new FileNotFoundException("Asset absolute file: " + fileName);
    }

    public final XmlResourceParser openXmlResourceParser(String fileName) throws IOException {
        return this.openXmlResourceParser(0, fileName);
    }

    public final XmlResourceParser openXmlResourceParser(int cookie, String fileName) throws IOException {
        XmlBlock block = this.openXmlBlockAsset(cookie, fileName);
        XmlResourceParser rp = block.newParser();
        block.close();
        return rp;
    }

    final XmlBlock openXmlBlockAsset(String fileName) throws IOException {
        return this.openXmlBlockAsset(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final XmlBlock openXmlBlockAsset(int cookie, String fileName) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long xmlBlock = this.openXmlAssetNative(cookie, fileName);
            if (xmlBlock != 0L) {
                XmlBlock res = new XmlBlock(this, xmlBlock);
                this.incRefsLocked(res.hashCode());
                return res;
            }
        }
        throw new FileNotFoundException("Asset XML file: " + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void xmlBlockGone(int id2) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.decRefsLocked(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long createTheme() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long res = this.newTheme();
            this.incRefsLocked(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void releaseTheme(long theme) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.deleteTheme(theme);
            this.decRefsLocked(theme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int addAssetPath(String path) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            int res = this.addAssetPathNative(path);
            this.makeStringBlocks(this.mStringBlocks);
            return res;
        }
    }

    private final native int addAssetPathNative(String var1);

    public final native int addOverlayPath(String var1);

    public final int[] addAssetPaths(String[] paths) {
        if (paths == null) {
            return null;
        }
        int[] cookies = new int[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            cookies[i] = this.addAssetPath(paths[i]);
        }
        return cookies;
    }

    public final native boolean isUpToDate();

    public final native void setLocale(String var1);

    public final native String[] getLocales();

    public final native void setConfiguration(int var1, int var2, String var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17);

    final native int getResourceIdentifier(String var1, String var2, String var3);

    final native String getResourceName(int var1);

    final native String getResourcePackageName(int var1);

    final native String getResourceTypeName(int var1);

    final native String getResourceEntryName(int var1);

    private final native long openAsset(String var1, int var2);

    private final native ParcelFileDescriptor openAssetFd(String var1, long[] var2) throws IOException;

    private final native long openNonAssetNative(int var1, String var2, int var3);

    private native ParcelFileDescriptor openNonAssetFdNative(int var1, String var2, long[] var3) throws IOException;

    private final native void destroyAsset(long var1);

    private final native int readAssetChar(long var1);

    private final native int readAsset(long var1, byte[] var3, int var4, int var5);

    private final native long seekAsset(long var1, long var3, int var5);

    private final native long getAssetLength(long var1);

    private final native long getAssetRemainingLength(long var1);

    private final native int loadResourceValue(int var1, short var2, TypedValue var3, boolean var4);

    private final native int loadResourceBagValue(int var1, int var2, TypedValue var3, boolean var4);

    static final native boolean applyStyle(long var0, int var2, int var3, long var4, int[] var6, int[] var7, int[] var8);

    static final native boolean resolveAttrs(long var0, int var2, int var3, int[] var4, int[] var5, int[] var6, int[] var7);

    final native boolean retrieveAttributes(long var1, int[] var3, int[] var4, int[] var5);

    final native int getArraySize(int var1);

    final native int retrieveArray(int var1, int[] var2);

    private final native int getStringBlockCount();

    private final native long getNativeStringBlock(int var1);

    public final native String getCookieName(int var1);

    public final native SparseArray<String> getAssignedPackageIdentifiers();

    public static final native int getGlobalAssetCount();

    public static final native String getAssetAllocations();

    public static final native int getGlobalAssetManagerCount();

    private final native long newTheme();

    private final native void deleteTheme(long var1);

    static final native void applyThemeStyle(long var0, int var2, boolean var3);

    static final native void copyTheme(long var0, long var2);

    static final native int loadThemeAttributeValue(long var0, int var2, TypedValue var3, boolean var4);

    static final native void dumpTheme(long var0, int var2, String var3, String var4);

    private final native long openXmlAssetNative(int var1, String var2);

    private final native String[] getArrayStringResource(int var1);

    private final native int[] getArrayStringInfo(int var1);

    final native int[] getArrayIntResource(int var1);

    final native int[] getStyleAttributes(int var1);

    private final native void init(boolean var1);

    private final native void destroy();

    private final void incRefsLocked(long id2) {
        ++this.mNumRefs;
    }

    private final void decRefsLocked(long id2) {
        --this.mNumRefs;
        if (this.mNumRefs == 0) {
            this.destroy();
        }
    }

    public final class AssetInputStream
    extends InputStream {
        private long mAsset;
        private long mLength;
        private long mMarkPos;

        public final int getAssetInt() {
            throw new UnsupportedOperationException();
        }

        public final long getNativeAsset() {
            return this.mAsset;
        }

        private AssetInputStream(long asset) {
            this.mAsset = asset;
            this.mLength = AssetManager.this.getAssetLength(asset);
        }

        @Override
        public final int read() throws IOException {
            return AssetManager.this.readAssetChar(this.mAsset);
        }

        @Override
        public final boolean markSupported() {
            return true;
        }

        @Override
        public final int available() throws IOException {
            long len = AssetManager.this.getAssetRemainingLength(this.mAsset);
            return len > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void close() throws IOException {
            AssetManager assetManager = AssetManager.this;
            synchronized (assetManager) {
                if (this.mAsset != 0L) {
                    AssetManager.this.destroyAsset(this.mAsset);
                    this.mAsset = 0L;
                    AssetManager.this.decRefsLocked(this.hashCode());
                }
            }
        }

        @Override
        public final void mark(int readlimit) {
            this.mMarkPos = AssetManager.this.seekAsset(this.mAsset, 0L, 0);
        }

        @Override
        public final void reset() throws IOException {
            AssetManager.this.seekAsset(this.mAsset, this.mMarkPos, -1);
        }

        @Override
        public final int read(byte[] b) throws IOException {
            return AssetManager.this.readAsset(this.mAsset, b, 0, b.length);
        }

        @Override
        public final int read(byte[] b, int off, int len) throws IOException {
            return AssetManager.this.readAsset(this.mAsset, b, off, len);
        }

        @Override
        public final long skip(long n) throws IOException {
            long pos = AssetManager.this.seekAsset(this.mAsset, 0L, 0);
            if (pos + n > this.mLength) {
                n = this.mLength - pos;
            }
            if (n > 0L) {
                AssetManager.this.seekAsset(this.mAsset, n, 0);
            }
            return n;
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

