/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class LimitedLengthInputStream
extends FilterInputStream {
    private final long mEnd;
    private long mOffset;

    public LimitedLengthInputStream(InputStream in, long offset, long length) throws IOException {
        super(in);
        if (in == null) {
            throw new IOException("in == null");
        }
        if (offset < 0L) {
            throw new IOException("offset < 0");
        }
        if (length < 0L) {
            throw new IOException("length < 0");
        }
        if (length > Long.MAX_VALUE - offset) {
            throw new IOException("offset + length > Long.MAX_VALUE");
        }
        this.mEnd = offset + length;
        this.skip(offset);
        this.mOffset = offset;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.mOffset >= this.mEnd) {
            return -1;
        }
        ++this.mOffset;
        return super.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int byteCount) throws IOException {
        if (this.mOffset >= this.mEnd) {
            return -1;
        }
        int arrayLength = buffer.length;
        Arrays.checkOffsetAndCount((int)arrayLength, (int)offset, (int)byteCount);
        if (this.mOffset > Long.MAX_VALUE - (long)byteCount) {
            throw new IOException("offset out of bounds: " + this.mOffset + " + " + byteCount);
        }
        if (this.mOffset + (long)byteCount > this.mEnd) {
            byteCount = (int)(this.mEnd - this.mOffset);
        }
        int numRead = super.read(buffer, offset, byteCount);
        this.mOffset += (long)numRead;
        return numRead;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }
}

