/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.Parcel;
import android.os.Parcelable;

public final class BluetoothMasInstance
implements Parcelable {
    private final int mId;
    private final String mName;
    private final int mChannel;
    private final int mMsgTypes;
    public static final Parcelable.Creator<BluetoothMasInstance> CREATOR = new Parcelable.Creator<BluetoothMasInstance>(){

        @Override
        public BluetoothMasInstance createFromParcel(Parcel in) {
            return new BluetoothMasInstance(in.readInt(), in.readString(), in.readInt(), in.readInt());
        }

        public BluetoothMasInstance[] newArray(int size) {
            return new BluetoothMasInstance[size];
        }
    };

    public BluetoothMasInstance(int id2, String name, int channel, int msgTypes) {
        this.mId = id2;
        this.mName = name;
        this.mChannel = channel;
        this.mMsgTypes = msgTypes;
    }

    public boolean equals(Object o) {
        if (o instanceof BluetoothMasInstance) {
            return this.mId == ((BluetoothMasInstance)o).mId;
        }
        return false;
    }

    public int hashCode() {
        return this.mId + (this.mChannel << 8) + (this.mMsgTypes << 16);
    }

    public String toString() {
        return Integer.toString(this.mId) + ":" + this.mName + ":" + this.mChannel + ":" + Integer.toHexString(this.mMsgTypes);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mId);
        out.writeString(this.mName);
        out.writeInt(this.mChannel);
        out.writeInt(this.mMsgTypes);
    }

    public int getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public int getChannel() {
        return this.mChannel;
    }

    public int getMsgTypes() {
        return this.mMsgTypes;
    }

    public boolean msgSupported(int msg) {
        return (this.mMsgTypes & msg) != 0;
    }

    public static final class MessageType {
        public static final int EMAIL = 1;
        public static final int SMS_GSM = 2;
        public static final int SMS_CDMA = 4;
        public static final int MMS = 8;
    }
}

