/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.appwidget.AppWidgetManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

public class AppWidgetProvider
extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        Bundle extras;
        String action = intent.getAction();
        if ("android.appwidget.action.APPWIDGET_UPDATE".equals(action)) {
            int[] appWidgetIds;
            Bundle extras2 = intent.getExtras();
            if (extras2 != null && (appWidgetIds = extras2.getIntArray("appWidgetIds")) != null && appWidgetIds.length > 0) {
                this.onUpdate(context, AppWidgetManager.getInstance(context), appWidgetIds);
            }
        } else if ("android.appwidget.action.APPWIDGET_DELETED".equals(action)) {
            Bundle extras3 = intent.getExtras();
            if (extras3 != null && extras3.containsKey("appWidgetId")) {
                int appWidgetId = extras3.getInt("appWidgetId");
                this.onDeleted(context, new int[]{appWidgetId});
            }
        } else if ("android.appwidget.action.APPWIDGET_UPDATE_OPTIONS".equals(action)) {
            Bundle extras4 = intent.getExtras();
            if (extras4 != null && extras4.containsKey("appWidgetId") && extras4.containsKey("appWidgetOptions")) {
                int appWidgetId = extras4.getInt("appWidgetId");
                Bundle widgetExtras = extras4.getBundle("appWidgetOptions");
                this.onAppWidgetOptionsChanged(context, AppWidgetManager.getInstance(context), appWidgetId, widgetExtras);
            }
        } else if ("android.appwidget.action.APPWIDGET_ENABLED".equals(action)) {
            this.onEnabled(context);
        } else if ("android.appwidget.action.APPWIDGET_DISABLED".equals(action)) {
            this.onDisabled(context);
        } else if ("android.appwidget.action.APPWIDGET_RESTORED".equals(action) && (extras = intent.getExtras()) != null) {
            int[] oldIds = extras.getIntArray("appWidgetOldIds");
            int[] newIds = extras.getIntArray("appWidgetIds");
            if (oldIds != null && oldIds.length > 0) {
                this.onRestored(context, oldIds, newIds);
                this.onUpdate(context, AppWidgetManager.getInstance(context), newIds);
            }
        }
    }

    public void onUpdate(Context context, AppWidgetManager appWidgetManager, int[] appWidgetIds) {
    }

    public void onAppWidgetOptionsChanged(Context context, AppWidgetManager appWidgetManager, int appWidgetId, Bundle newOptions) {
    }

    public void onDeleted(Context context, int[] appWidgetIds) {
    }

    public void onEnabled(Context context) {
    }

    public void onDisabled(Context context) {
    }

    public void onRestored(Context context, int[] oldWidgetIds, int[] newWidgetIds) {
    }
}

