/*
 * Decompiled with CFR 0.152.
 */
package android.app.job;

import android.app.job.IJobCallback;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;

public class JobParameters
implements Parcelable {
    private final int jobId;
    private final PersistableBundle extras;
    private final IBinder callback;
    private final boolean overrideDeadlineExpired;
    public static final Parcelable.Creator<JobParameters> CREATOR = new Parcelable.Creator<JobParameters>(){

        @Override
        public JobParameters createFromParcel(Parcel in) {
            return new JobParameters(in);
        }

        public JobParameters[] newArray(int size) {
            return new JobParameters[size];
        }
    };

    public JobParameters(IBinder callback, int jobId, PersistableBundle extras, boolean overrideDeadlineExpired) {
        this.jobId = jobId;
        this.extras = extras;
        this.callback = callback;
        this.overrideDeadlineExpired = overrideDeadlineExpired;
    }

    public int getJobId() {
        return this.jobId;
    }

    public PersistableBundle getExtras() {
        return this.extras;
    }

    public boolean isOverrideDeadlineExpired() {
        return this.overrideDeadlineExpired;
    }

    public IJobCallback getCallback() {
        return IJobCallback.Stub.asInterface(this.callback);
    }

    private JobParameters(Parcel in) {
        this.jobId = in.readInt();
        this.extras = in.readPersistableBundle();
        this.callback = in.readStrongBinder();
        this.overrideDeadlineExpired = in.readInt() == 1;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.jobId);
        dest.writePersistableBundle(this.extras);
        dest.writeStrongBinder(this.callback);
        dest.writeInt(this.overrideDeadlineExpired ? 1 : 0);
    }
}

