/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.content.Context;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;

class FileBackupHelperBase {
    private static final String TAG = "FileBackupHelperBase";
    long mPtr = FileBackupHelperBase.ctor();
    Context mContext;
    boolean mExceptionLogged;

    FileBackupHelperBase(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            FileBackupHelperBase.dtor(this.mPtr);
        }
        finally {
            super.finalize();
        }
    }

    static void performBackup_checked(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState, String[] files, String[] keys) {
        if (files.length == 0) {
            return;
        }
        for (String f : files) {
            if (f.charAt(0) == '/') continue;
            throw new RuntimeException("files must have all absolute paths: " + f);
        }
        if (files.length != keys.length) {
            throw new RuntimeException("files.length=" + files.length + " keys.length=" + keys.length);
        }
        FileDescriptor oldStateFd = oldState != null ? oldState.getFileDescriptor() : null;
        FileDescriptor newStateFd = newState.getFileDescriptor();
        if (newStateFd == null) {
            throw new NullPointerException();
        }
        int err = FileBackupHelperBase.performBackup_native(oldStateFd, data.mBackupWriter, newStateFd, files, keys);
        if (err != 0) {
            throw new RuntimeException("Backup failed 0x" + Integer.toHexString(err));
        }
    }

    boolean writeFile(File f, BackupDataInputStream in) {
        int result = -1;
        File parent = f.getParentFile();
        parent.mkdirs();
        result = FileBackupHelperBase.writeFile_native(this.mPtr, f.getAbsolutePath(), in.mData.mBackupReader);
        if (result != 0 && !this.mExceptionLogged) {
            Log.e(TAG, "Failed restoring file '" + f + "' for app '" + this.mContext.getPackageName() + "' result=0x" + Integer.toHexString(result));
            this.mExceptionLogged = true;
        }
        return result == 0;
    }

    public void writeNewStateDescription(ParcelFileDescriptor fd) {
        int result = FileBackupHelperBase.writeSnapshot_native(this.mPtr, fd.getFileDescriptor());
    }

    boolean isKeyInList(String key, String[] list) {
        for (String s : list) {
            if (!s.equals(key)) continue;
            return true;
        }
        return false;
    }

    private static native long ctor();

    private static native void dtor(long var0);

    private static native int performBackup_native(FileDescriptor var0, long var1, FileDescriptor var3, String[] var4, String[] var5);

    private static native int writeFile_native(long var0, String var2, long var3);

    private static native int writeSnapshot_native(long var0, FileDescriptor var2);
}

