/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.app.Application;
import android.app.IActivityManager;
import android.app.Notification;
import android.content.ComponentCallbacks2;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public abstract class Service
extends ContextWrapper
implements ComponentCallbacks2 {
    private static final String TAG = "Service";
    public static final int START_CONTINUATION_MASK = 15;
    public static final int START_STICKY_COMPATIBILITY = 0;
    public static final int START_STICKY = 1;
    public static final int START_NOT_STICKY = 2;
    public static final int START_REDELIVER_INTENT = 3;
    public static final int START_TASK_REMOVED_COMPLETE = 1000;
    public static final int START_FLAG_REDELIVERY = 1;
    public static final int START_FLAG_RETRY = 2;
    private ActivityThread mThread = null;
    private String mClassName = null;
    private IBinder mToken = null;
    private Application mApplication = null;
    private IActivityManager mActivityManager = null;
    private boolean mStartCompatibility = false;

    public Service() {
        super(null);
    }

    public final Application getApplication() {
        return this.mApplication;
    }

    public void onCreate() {
    }

    @Deprecated
    public void onStart(Intent intent, int startId) {
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.onStart(intent, startId);
        return this.mStartCompatibility ? 0 : 1;
    }

    public void onDestroy() {
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
    }

    @Override
    public void onLowMemory() {
    }

    @Override
    public void onTrimMemory(int level) {
    }

    public abstract IBinder onBind(Intent var1);

    public boolean onUnbind(Intent intent) {
        return false;
    }

    public void onRebind(Intent intent) {
    }

    public void onTaskRemoved(Intent rootIntent) {
    }

    public final void stopSelf() {
        this.stopSelf(-1);
    }

    public final void stopSelf(int startId) {
        if (this.mActivityManager == null) {
            return;
        }
        try {
            this.mActivityManager.stopServiceToken(new ComponentName((Context)this, this.mClassName), this.mToken, startId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public final boolean stopSelfResult(int startId) {
        if (this.mActivityManager == null) {
            return false;
        }
        try {
            return this.mActivityManager.stopServiceToken(new ComponentName((Context)this, this.mClassName), this.mToken, startId);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Deprecated
    public final void setForeground(boolean isForeground) {
        Log.w(TAG, "setForeground: ignoring old API call on " + this.getClass().getName());
    }

    public final void startForeground(int id2, Notification notification) {
        try {
            this.mActivityManager.setServiceForeground(new ComponentName((Context)this, this.mClassName), this.mToken, id2, notification, true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public final void stopForeground(boolean removeNotification) {
        try {
            this.mActivityManager.setServiceForeground(new ComponentName((Context)this, this.mClassName), this.mToken, 0, null, removeNotification);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.println("nothing to dump");
    }

    public final void attach(Context context, ActivityThread thread, String className, IBinder token, Application application, Object activityManager) {
        this.attachBaseContext(context);
        this.mThread = thread;
        this.mClassName = className;
        this.mToken = token;
        this.mApplication = application;
        this.mActivityManager = (IActivityManager)activityManager;
        this.mStartCompatibility = this.getApplicationInfo().targetSdkVersion < 5;
    }

    final String getClassName() {
        return this.mClassName;
    }
}

