01 /**********************************************************************
02 * 文件名称： can_msg.h
03 * 功能描述： CAN报文结构体定义
04 * 文件目的： 此文件是定义CAN接收和发送报文的结构体，
05 *            从STM32的代码中copy过来，用于应用层的发送和接收报文的定义。
06 * 修改日期             版本号        修改人           修改内容
07 * -----------------------------------------------
08 * 2020/05/13         V1.0             bert            创建
09 ***********************************************************************/
10 #ifndef _CAN_MSG_H
11 #define _CAN_MSG_H
12 
13 
14 /**
15 * 数据类型宏定义
16 */
17 typedef unsigned           char uint8_t;
18 typedef unsigned short     int uint16_t;
19 typedef unsigned           int uint32_t;
20 
21 /**
22 * CAN报文ID类型
23 */
24 #define CAN_Id_Standard             ((uint32_t)0x00000000)  /* 标准帧Standard Id */
25 #define CAN_Id_Extended             ((uint32_t)0x00000004)  /* 扩展帧Extended Id */
26 
27 #define CAN_ID_STD                  CAN_Id_Standard           
28 #define CAN_ID_EXT                  CAN_Id_Extended
29 
30 /**
31 * CAN报文类型
32 */
33 #define CAN_RTR_Data                ((uint32_t)0x00000000)  /* 数据帧 Data frame */
34 #define CAN_RTR_Remote              ((uint32_t)0x00000002)  /* 远程帧 Remote frame */
35 
36 #define CAN_RTR_DATA     CAN_RTR_Data         
37 #define CAN_RTR_REMOTE   CAN_RTR_Remote
38 
39 /** 
40 * @brief  CAN Tx message structure definition  
41 * CAN发送报文结构定义
42 */
43 typedef struct
44 {
45   uint32_t StdId;  /* CAN标准帧ID，占11bit，范围：0~0x7FF */ 
46   uint32_t ExtId;  /* CAN扩展帧ID，占29bit，范围：0~0x1FFFFFFF */ 
47   uint8_t IDE;     /* CAN报文ID类型，CAN_ID_STD 或 CAN_ID_EXT */
48   uint8_t RTR;     /* CAN报文类型，CAN_RTR_DATA 或 CAN_RTR_REMOTE */ 
49   uint8_t DLC;     /* CAN报文数据长度， 范围：0~8  */ 
50   uint8_t Data[8]; /* CAN报文数据内容，每个字节范围：0~0xFF*/
51 } CanTxMsg;
52 
53 /** 
54 * @brief  CAN Rx message structure definition  
55 * CAN接收报文结构定义
56 */
57 typedef struct
58 {
59   uint32_t StdId;  /* CAN标准帧ID，范围：0~0x7FF */ 
60   uint32_t ExtId;  /* CAN扩展帧ID，范围：0~0x1FFFFFFF */ 
61   uint8_t IDE;     /* CAN报文ID类型，CAN_ID_STD 或 CAN_ID_EXT */
62   uint8_t RTR;     /* CAN报文类型，CAN_RTR_DATA 或 CAN_RTR_REMOTE */ 
63   uint8_t DLC;     /* CAN报文数据长度， 范围：0~8  */ 
64   uint8_t Data[8]; /* CAN报文数据内容，每个字节范围：0~0xFF*/
65   uint8_t FMI;     /* 过滤模式，总共有14中，定义有宏，其值依次为0x1,0x2,0x4,0x8,0x10,0x20,0x40……,此处可以不考虑，忽略*/
66 } CanRxMsg;
67 
68 
69 #endif
70 
