01 /**********************************************************************
02 * 文件名称： app_controller.h
03 * 功能描述： CAN控制器接口实现头文件
04 * 文件目的： 主要进行函数声明
05 * 修改日期             版本号        修改人           修改内容
06 * -----------------------------------------------
07 * 2020/05/13         V1.0             bert            创建
08 ***********************************************************************/
09 #ifndef _CAN_CONTROLLER_H
10 #define _CAN_CONTROLLER_H
11
12 /**************头文件**************************************************/
13 #include "stm32f4xx_conf.h"
14
15
16 /**************宏定义**************************************************/
17 /* NULL 定义*/
18 #ifndef NULL
19 #define NULL  (void*)0
20 #endif
21
22 /* 指针类型定义 */
23 typedef void ( *pCanInterrupt ) ( void );
24
25 /* CAN端口号定义*/
26 enum
27 {
28     CAN_PORT_NONE = 0,
29     CAN_PORT_CAN1,
30     CAN_PORT_CAN2,
31     CAN_PORT_MAX
32 };
33
34 /* CAN通信抽象结构体定义*/
35 typedef struct _CAN_COMM_STRUCT
36 {
37     /* CAN硬件名称 */
38     char name[10];
39     /* CAN端口号，裸机里为端口号;linux应用里作为socket套接口 */
40     int  can_port;
41     /* CAN控制器配置函数，返回端口号赋值给can_port */
42     int  (*can_set_controller)( void );
43     /* CAN接口中断创建，在linux中对应创建接收线程 */
44     void (*can_set_interrput)( int can_port , pCanInterrupt callback );
45     /* CAN读取报文接口 */
46     void (*can_read)( int can_port , CanRxMsg* recv_msg);
47     /* CAN发送报文接口*/
48     void (*can_write)( int can_port , CanTxMsg send_msg);
49 }CAN_COMM_STRUCT, *pCAN_COMM_STRUCT;
50
51
52
53 /**************函数声明**************************************************/
54 extern int register_can_controller(const pCAN_COMM_STRUCT p_can_controller);
55 void CAN1_contoller_add(void);
56
57
58 #endif
59
60 /***********************************************************************
61 ****************End Of File*********************************************
62 ***********************************************************************/

