/**********************************************************************
* ļƣ can_controller.c
*  CANṹܵľʵֺ
*            ҪʵֵӲĽӿڷװ
* ļĿģ CANײĳ
* ޸             汾        ޸           ޸
* -----------------------------------------------
* 2020/05/13         V1.0             bert            
***********************************************************************/

/**************ͷļ**************************************************/
#include "can_controller.h"
#include "string.h"

/**************궨**************************************************/
#define CAN_BAUD_NUM    3		//òʸ

/**************ȫֱ*********************************************/
const unsigned int CAN1_baud_table[CAN_BAUD_NUM][5] = 
{
    //ʣ CAN_SJW     CAN_BS1        CAN_BS2    CAN_Prescaler 
	{250,   CAN_SJW_1tq,    CAN_BS1_15tq,   CAN_BS2_5tq,    8},		    //250k  ok
	{500,   CAN_SJW_1tq,    CAN_BS1_15tq,   CAN_BS2_5tq,    4},			//500K	ok
	{1000,  CAN_SJW_1tq,    CAN_BS1_15tq,   CAN_BS2_5tq,    2},			//1000K	ok
};

pCanInterrupt    g_pCanInterrupt = NULL;


/***************************************************************/
int register_can_controller(const pCAN_COMM_STRUCT p_can_controller);



/***********************************************************************
****************CANӿʵִ*******************************
***********************************************************************/

/**********************************************************************
* ƣ void CAN_Baud_Process(unsigned int Baud,CAN_InitTypeDef *CAN_InitStructure)
*  㲨
*  
*  
*   ֵ 
* ע    ⣺CANʱΪ42M
* CAN_SJW : CAN_SJW_1tq - CAN_SJW_4tq	  ܱκһλγ
* CAN_BS1 : CAN_BS1_1tq - CAN_BS1_16tq
* CAN_BS2 : CAN_BS2_1tq - CAN_BS2_8tq
* CAN_Prescaler : 1 - 1024
* 	˵
* CAN_SJW + CAN_BS1 / (CAN_SJW + CAN_BS1 + CAN_BS2)
* 	0.75     baud > 800k
* 	0.80     baud > 500k
* 	0.875    baud <= 500k
* 	baud = 42M / (CAN_SJW + CAN_BS1 + CAN_BS2) / CAN_Prescaler
* ޸             汾        ޸           ޸
* -----------------------------------------------
* 2020/05/13         V1.0             bert            
***********************************************************************/
void CAN_Baud_Process(unsigned int Baud,CAN_InitTypeDef *CAN_InitStructure)
{
	unsigned int i = 0;
	for(i = 0;i < CAN_BAUD_NUM;i ++)
	{
		if(Baud == CAN1_baud_table[i][0])
		{
			CAN_InitStructure->CAN_SJW = CAN1_baud_table[i][1];
			CAN_InitStructure->CAN_BS1 = CAN1_baud_table[i][2];
			CAN_InitStructure->CAN_BS2 = CAN1_baud_table[i][3];
			CAN_InitStructure->CAN_Prescaler = CAN1_baud_table[i][4];
			return;	
		}
	}	
}


/**********************************************************************
* ƣ int CAN_Set_Controller( void )
*  ƬڲCANʼGPIO(TX,RXCANʱӣʣ
*  
*  
*   ֵ int can_port:ضӦCANͨţsocketcanе׽ӿ
* ޸             汾        ޸           ޸
* -----------------------------------------------
* 2020/05/13         V1.0             bert            
***********************************************************************/
int CAN_Set_Controller( void )
{
    /* STM32 GPIOṹ */
    GPIO_InitTypeDef       GPIO_InitStructure;
    /* STM32 CANṹ */
    CAN_InitTypeDef        CAN_InitStructure;
    /* STM32 CANṹ */
    CAN_FilterInitTypeDef  CAN_FilterInitStructure;

    /*************************************************************/
    /*CANGPIOã˴ΪCAN_TX, CAN_RX*/
    
    /*ʹGPIOʱ*/
    RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOD, ENABLE);
    /*ʼܽ*/
    GPIO_InitStructure.GPIO_Pin     = GPIO_Pin_0 ;
    GPIO_InitStructure.GPIO_Mode    = GPIO_Mode_AF;
    GPIO_InitStructure.GPIO_Speed   = GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_OType   = GPIO_OType_PP;
    GPIO_InitStructure.GPIO_PuPd    = GPIO_PuPd_UP;
    GPIO_Init(GPIOD, &GPIO_InitStructure);

    GPIO_InitStructure.GPIO_Pin     = GPIO_Pin_1;
    GPIO_InitStructure.GPIO_Mode    = GPIO_Mode_AF;
    GPIO_InitStructure.GPIO_Speed   = GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_OType   = GPIO_OType_PP;
    GPIO_InitStructure.GPIO_PuPd    = GPIO_PuPd_UP;
    GPIO_Init(GPIOD, &GPIO_InitStructure);
    /*GPIOΪCANģʽ*/
    GPIO_PinAFConfig(GPIOD, GPIO_PinSource0, GPIO_AF_CAN1);
    GPIO_PinAFConfig(GPIOD, GPIO_PinSource1, GPIO_AF_CAN1); 
    
    /*************************************************************/
    /*CANã˴Ϊʣʵ*/

    /* ʹCANʱ */
    RCC_APB1PeriphClockCmd(RCC_APB1Periph_CAN1, ENABLE);

    /* ʼCANģʽ*/
    CAN_DeInit(CAN1);
    CAN_StructInit(&CAN_InitStructure);
    CAN_InitStructure.CAN_TTCM = DISABLE;
    CAN_InitStructure.CAN_ABOM = DISABLE;
    CAN_InitStructure.CAN_AWUM = DISABLE;
    CAN_InitStructure.CAN_NART = DISABLE;
    CAN_InitStructure.CAN_RFLM = DISABLE;
    CAN_InitStructure.CAN_TXFP = DISABLE;
    CAN_InitStructure.CAN_Mode = CAN_Mode_Normal;//CANģʽ

    /* ʼCAN */
    CAN_Baud_Process(500,&CAN_InitStructure);
    CAN_Init(CAN1, &CAN_InitStructure);  
    

    /*************************************************************/
    /* ʼCAN */
    CAN_FilterInitStructure.CAN_FilterNumber = 0;	                    /* CAN1˲Ŵ013 */
    CAN_FilterInitStructure.CAN_FilterMode = CAN_FilterMode_IdMask;	    /* ˲ģʽ */
    CAN_FilterInitStructure.CAN_FilterScale = CAN_FilterScale_32bit;
    CAN_FilterInitStructure.CAN_FilterIdHigh = 0x0000;
    CAN_FilterInitStructure.CAN_FilterIdLow = 0x0000;
    CAN_FilterInitStructure.CAN_FilterMaskIdHigh = 0x0000;	    /* κID */
    CAN_FilterInitStructure.CAN_FilterMaskIdLow = 0x0000;		/* κID */
    CAN_FilterInitStructure.CAN_FilterFIFOAssignment = 0;	    
                                                     
    CAN_FilterInitStructure.CAN_FilterActivation = ENABLE;
    CAN_FilterInit(&CAN_FilterInitStructure);       
 
    /*************************************************************/
    /* CAN󣬷صǰõCANĶ˿ںţ˴Ҫlinux socketcanе׽ӿ */
    
    
    return CAN_PORT_CAN1;
    /*************************************************************/
}

/**********************************************************************
* ƣ void CAN_Set_Interrupt(int can_port,  pCanInterrupt callback)
*  ʹCANжϴӦõĵĻصصҪӦòĹ
*  can_port,˿ں
*            callback жϾ崦ӦùܵĻص
*  
*   ֵ 
* ޸             汾        ޸           ޸
* -----------------------------------------------
* 2020/05/13         V1.0             bert            
***********************************************************************/
void CAN_Set_Interrupt(int can_port,  pCanInterrupt callback)
{
    NVIC_InitTypeDef NVIC_InitStructure;
    
    /* CAN˿ںж */
    switch( can_port )
    {
        case CAN_PORT_CAN1:
        {	
            /* ʼصӿں */
            if ( NULL != callback ) 
            {
                g_pCanInterrupt = callback;
            }
    
            /* ʹCAN0_RXжϣlinux socket canƴ߳ */
            NVIC_InitStructure.NVIC_IRQChannel = CAN1_RX0_IRQn; 
            NVIC_PriorityGroupConfig(NVIC_PriorityGroup_4);
            NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
            NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
            NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
            NVIC_Init(&NVIC_InitStructure);
            CAN_ITConfig(CAN1, CAN_IT_FMP0, ENABLE);
        }
        break;
        
        default:
            break;
        
    }
    return ;
}


/**********************************************************************
* ƣ void CAN_Read(int can_port, CanRxMsg* recv_msg)
*  CANȡռĴȡյı
*  can_port,˿ں     
*  recv_msgձ
*   ֵ 
* ޸             汾        ޸           ޸
* -----------------------------------------------
* 2020/05/13         V1.0             bert            
***********************************************************************/
void CAN_Read(int can_port, CanRxMsg* recv_msg)
{ 
    switch( can_port )
    {
        case CAN_PORT_CAN1:
        {
            /* FIFOжȡCAN */
            CAN_Receive(CAN1,CAN_FIFO0, recv_msg);
        }
        break;
        
        default:
            break;
    }
    return ;
}
 
/**********************************************************************
* ƣ void CAN_Write(int can_port, CanTxMsg send_msg)
*  CANķͽӿڣ÷ͼĴͱ
*  can_port,˿ں     
*  send_msgͱ
*   ֵ 
* ޸             汾        ޸           ޸
* -----------------------------------------------
* 2020/05/13         V1.0             bert            
***********************************************************************/
void CAN_Write(int can_port, CanTxMsg send_msg)
{
    unsigned char i;
    uint8_t transmit_mailbox = 0;
    CanTxMsg TxMessage;
    
    switch( can_port )
    {
        case CAN_PORT_CAN1:
        {
            TxMessage.StdId = send_msg.StdId;	  // ׼ʶΪ0x000~0x7FF
            TxMessage.ExtId = 0x0000;             // չʶ0x0000
            TxMessage.IDE   = CAN_ID_STD;         // ʹñ׼ʶ
            TxMessage.RTR   = CAN_RTR_DATA;       // Ϊ֡ 
            TxMessage.DLC   = send_msg.DLC;       // ݳ, canĹ涨ݳΪ8ֽ
            
            for(i=0; i<TxMessage.DLC; i++)
            {
                TxMessage.Data[i] = send_msg.Data[i];
            }
            transmit_mailbox = CAN_Transmit(CAN1,&TxMessage);  /* Ϣ͵0,1,2û뷢no_box */	
        }
        break;
        
        default:
            break;
    }
    return ;
}

/**********************************************************************
* ƣ void CAN1_RX0_IRQHandler(void)
*  CANжϺ
*    
*  
*   ֵ 
* ޸             汾        ޸           ޸
* -----------------------------------------------
* 2020/05/13         V1.0             bert            
***********************************************************************/
void CAN1_RX0_IRQHandler(void)
{
    /* صڣִлص */
    if( g_pCanInterrupt != NULL)
    {
        g_pCanInterrupt();
    }  
    
    /* ж */
    CAN_ClearITPendingBit(CAN1,CAN_IT_FMP0);  
}


/**********************************************************************
* ƣ     can1_controller
*  CAN1ṹʼ
* ޸             汾        ޸           ޸
* -----------------------------------------------
* 2020/05/13         V1.0             bert            
***********************************************************************/
CAN_COMM_STRUCT can1_controller = {
    .name                   = "can0",
	.can_port               = CAN_PORT_CAN1,        
	.can_set_controller     = CAN_Set_Controller,
    .can_set_interrput      = CAN_Set_Interrupt,
    .can_read               = CAN_Read,
    .can_write              = CAN_Write, 
};


/**********************************************************************
* ƣ void CAN1_contoller_add(void)
*  CANṹעӿڣӦòʹcan1_controllerǰ
*    
*  
*   ֵ 
* ޸             汾        ޸           ޸
* -----------------------------------------------
* 2020/05/13         V1.0             bert            
***********************************************************************/
void CAN1_contoller_add(void)
{
    /*can1_controllerݸӦò*/
    register_can_controller( &can1_controller );
}


/***********************************************************************
****************End Of File*********************************************
***********************************************************************/




