/**********************************************************************
* ļƣ app_can.c
*  CANӦò룬ʵֹ£
*            1ڷCANģ
*            2ձģת
* ļĿģ CANĵĻͺͽմ
* ޸             汾        ޸           ޸
* -----------------------------------------------
* 2020/05/13         V1.0             bert            
***********************************************************************/


/**************ͷļ**************************************************/
#include "app_can.h"
#include "can_controller.h"
#include <string.h>


/**************궨**************************************************/
/* вڷ͵CANID */
#define TX_CAN_ID           0X101   

/* вԽյCANID */
#define RX_CAN_ID           0x201   

/* нյԱΪRX_CAN_IDıģIDΪRX_TO_TX_CAN_IDΪIDıתȥ */
#define RX_TO_TX_CAN_ID     0X301   


/**************ȫֱ*********************************************/
/** 
* CANӦòýṹָ
*/
static CAN_COMM_STRUCT gCAN_COMM_STRUCT;

/** 
*CANӦòCANĺ洢CANϢ
*/
static CanRxMsg  g_CAN1_Rx_Message;

/** 
*CANӦòCANı־
*/
static unsigned char g_CAN1_Rx_Flag =0; 


/***************************************************************/
/** 
*CANжлصMCUжϴضĺ壬
*˴жϺcan_controller.cУжеľ崦ݷŵapp_can.cӦУ
*˴ΪصΪlinux socketȣlinux socketʹûصǽ̺߳
*/
void CAN_RX_IRQHandler_Callback(void);




/***********************************************************************
****************Ӧò**********************************************
***********************************************************************/

/**********************************************************************
* ƣ int register_can_controller(const pCAN_COMM_STRUCT p_can_controller)
*  ӦòCAN1ṹע
*  p_can_controllerCANṹ
*  
*   ֵ 
* ޸             汾        ޸           ޸
* -----------------------------------------------
* 2020/05/13         V1.0             bert            
***********************************************************************/
int register_can_controller(const pCAN_COMM_STRUCT p_can_controller)
{
    /* жϴp_can_controllerΪǿգĿȷṹʵ*/
    if( p_can_controller != NULL )
    {
        /* Ĳp_can_controllerֵӦòṹgCAN_COMM_STRUCT */
        
        /*˿ںţsocketcan׽ӿ*/
        gCAN_COMM_STRUCT.can_port              = p_can_controller->can_port; 
        /*CANú*/
        gCAN_COMM_STRUCT.can_set_controller    = p_can_controller->can_set_controller; 
        /*CANж*/
        gCAN_COMM_STRUCT.can_set_interrput     = p_can_controller->can_set_interrput;
        /*CANĶ*/
        gCAN_COMM_STRUCT.can_read              = p_can_controller->can_read;
        /*CANķͺ*/
        gCAN_COMM_STRUCT.can_write             = p_can_controller->can_write;
        return 1;
    }
	return 0;
}

/**********************************************************************
* ƣ void app_can_init(void)
*  CANӦòʼ
*  
*  
*   ֵ 
* ޸             汾        ޸           ޸
* -----------------------------------------------
* 2020/05/13         V1.0             bert            
***********************************************************************/
void app_can_init(void)
{
    /** 
    * ӦòCAN1ṹע
    */
    CAN1_contoller_add();
    
    /*
    *can_set_controllerCANã
    *can_portlinux socketcanе׽ӿڣƬΪԶCANͨ 
    */
    gCAN_COMM_STRUCT.can_port = gCAN_COMM_STRUCT.can_set_controller();
    /** 
    * can_set_interrputCANжϣsocketcanеĽ߳
    */
    gCAN_COMM_STRUCT.can_set_interrput( gCAN_COMM_STRUCT.can_port, CAN_RX_IRQHandler_Callback );
}


/**********************************************************************
* ƣ void app_can_tx_test(void)
*  CANӦò㱨ķͺڲڷͱ
*  
*  
*   ֵ 
* ޸             汾        ޸           ޸
* -----------------------------------------------
* 2020/05/13         V1.0             bert            
***********************************************************************/
void app_can_tx_test(void)
{
    // 10msΪ׼CANԳ
    
    unsigned char i=0;
    
    /* ͱĶ */
    CanTxMsg TxMessage;
    
    /* ͱһֽΪ */
    static unsigned char tx_counter = 0;
    
    /* 10msΪ׼ͨtimerøôдΪ1*/  
    static unsigned int timer =0;
    if(timer++>100)
    {
        timer = 0;
    }
    else
    {
        return ;
    }
    
    /* ͱı䣬˱1 */
    TxMessage.StdId = TX_CAN_ID;	      /* ׼ʶΪ0x000~0x7FF */
    TxMessage.ExtId = 0x0000;             /* չʶ0x0000 */
    TxMessage.IDE   = CAN_ID_STD;         /* ʹñ׼ʶ */
    TxMessage.RTR   = CAN_RTR_DATA;       /* Ϊ֡  */
    TxMessage.DLC   = 8;                  /* ݳ, canĹ涨ݳΪ8ֽ */
    
    /* ݣ˴ԸʵӦ */
    TxMessage.Data[0] = tx_counter++;       /* ʶķͼ */
    for(i=1; i<TxMessage.DLC; i++)
    {
        TxMessage.Data[i] = i;            
    }
    
    /*  can_writeCAN */
    gCAN_COMM_STRUCT.can_write(gCAN_COMM_STRUCT.can_port, TxMessage);
    
}


/**********************************************************************
* ƣ void app_can_rx_test(void)
*  CANӦòձĴڴжϺнյı
*  
*  
*   ֵ 
* ޸             汾        ޸           ޸
* -----------------------------------------------
* 2020/05/13         V1.0             bert            
***********************************************************************/
void app_can_rx_test(void)
{
    unsigned char i=0;
    
    /* ͱĶ */
    CanTxMsg TxMessage;
    
    /* ͱһֽΪ */
    static unsigned char rx_counter = 0;
      
    
    if( g_CAN1_Rx_Flag == 1)
    {
        g_CAN1_Rx_Flag = 0;
        
        /* ͱı䣬˱1 */
        TxMessage.StdId = RX_TO_TX_CAN_ID;	  /* ׼ʶΪ0x000~0x7FF */
        TxMessage.ExtId = 0x0000;             /* չʶ0x0000 */
        TxMessage.IDE   = CAN_ID_STD;         /* ʹñ׼ʶ */
        TxMessage.RTR   = CAN_RTR_DATA;       /* Ϊ֡  */
        TxMessage.DLC   = 8;                  /* ݳ, canĹ涨ݳΪ8ֽ */
        
        /* ݣ˴ԸʵӦ */
        TxMessage.Data[0] = rx_counter++;      /* ʶķͼ */
        for(i=1; i<TxMessage.DLC; i++)
        {
            TxMessage.Data[i] = g_CAN1_Rx_Message.Data[i];            
        }
        
        /*  can_writeCAN */
        gCAN_COMM_STRUCT.can_write(gCAN_COMM_STRUCT.can_port, TxMessage);
    }
}

/**********************************************************************
* ƣ void CAN_RX_IRQHandler_Callback(void)
*  CAN1жϺlinuxп̣߳ʱȥCAN
*  
*  
*   ֵ 
* ޸             汾        ޸           ޸
* -----------------------------------------------
* 2020/05/13         V1.0             bert            
***********************************************************************/
void CAN_RX_IRQHandler_Callback(void)
{
    /* ձĶ */
    CanRxMsg RxMessage; 
    
    /* ձ */
    memset( &RxMessage, 0, sizeof(CanRxMsg) );
   
    /* ͨcan_readӿڶȡĴѾյı */
    gCAN_COMM_STRUCT.can_read(gCAN_COMM_STRUCT.can_port, &RxMessage);

    /* ȡCANĴ濽ȫֱĽṹg_CAN1_Rx_Message */
    memcpy(&g_CAN1_Rx_Message, &RxMessage, sizeof( CanRxMsg ) );
    
    /* õǰɱ־жϵǰձIDΪRX_CAN_IDg_CAN1_Rx_Flag=1*/
    if( g_CAN1_Rx_Message.StdId == RX_CAN_ID )
    {
        g_CAN1_Rx_Flag = 1;  
    }
}


/***********************************************************************
****************End Of File*********************************************
***********************************************************************/





