#ifndef _SYSTICK_H
#define _SYSTICK_H

#include "..\CMSIS\stm32f4xx.h" 



/**********************************************************************************************************
*                                          SYS TICK DEFINES
**********************************************************************************************************/

#define  OS_CPU_CM3_NVIC_ST_CTRL    (*((volatile unsigned int *)0xE000E010uL)) /* SysTick Ctrl & Status Reg. */
#define  OS_CPU_CM3_NVIC_ST_RELOAD  (*((volatile unsigned int *)0xE000E014uL)) /* SysTick Reload  Value Reg. */
#define  OS_CPU_CM3_NVIC_ST_CURRENT (*((volatile unsigned int *)0xE000E018uL)) /* SysTick Current Value Reg. */
#define  OS_CPU_CM3_NVIC_ST_CAL     (*((volatile unsigned int *)0xE000E01CuL)) /* SysTick Cal     Value Reg. */
#define  OS_CPU_CM3_NVIC_PRIO_ST    (*((volatile unsigned char *)0xE000ED23uL)) /* SysTick Handler Prio  Reg. */

#define  OS_CPU_CM3_NVIC_ST_CTRL_COUNT                    0x00010000uL   /* Count flag.                */
#define  OS_CPU_CM3_NVIC_ST_CTRL_CLK_SRC                  0x00000004uL   /* Clock Source.              */
#define  OS_CPU_CM3_NVIC_ST_CTRL_INTEN                    0x00000002uL   /* Interrupt enable.          */
#define  OS_CPU_CM3_NVIC_ST_CTRL_ENABLE                   0x00000001uL   /* Counter mode.              */
#define  OS_CPU_CM3_NVIC_PRIO_MIN                               0xFFu    /* Min handler prio.          */

/**********************************************************************************************************
*                                          
**********************************************************************************************************/
typedef struct 
{
    unsigned int sys_1ms;
    unsigned int sys_2ms;
    unsigned int sys_5ms;
    unsigned int sys_10ms;
}SYS_BASE_STRUCT;

typedef struct
{
    unsigned char sys_10ms_task;
    unsigned char sys_20ms_task;
    unsigned char sys_50ms_task;
    unsigned char sys_100ms_task;
}SYS_BASE_TASK_STRUCT;

extern SYS_BASE_TASK_STRUCT gSysBaseTask;


/**********************************************************************************************************
*                                          
**********************************************************************************************************/
void  Systick_OsPeriod_Init (unsigned int ms);
void  System_TimeUpdate(void);
    
void  Systick_DrvInit (unsigned int cnts);
void  Systick_DrvISR (void);



/**********************************************************************************************************
*                                         
**********************************************************************************************************/

#endif






