#include "systick.h"


/*********************************************************************************************************
*                                          INITIALIZE SYS TICK
* Description: Initialize the SysTick.
*
* Arguments  : cnts          is the number of SysTick counts between two OS tick interrupts.
*
* Note(s)    : 1) This function MUST be called after OSStart() & after processor initialization.
*********************************************************************************************************/
void  Systick_DrvInit (unsigned int cnts)
{
		/* Set prio of SysTick handler to min prio.           */  
    OS_CPU_CM3_NVIC_ST_RELOAD = cnts - 1u;	
	
		/* Enable timer.                                      */ 
    OS_CPU_CM3_NVIC_PRIO_ST   = OS_CPU_CM3_NVIC_PRIO_MIN;          

		/* Enable timer interrupt.   	                       */
    OS_CPU_CM3_NVIC_ST_CTRL  |= OS_CPU_CM3_NVIC_ST_CTRL_CLK_SRC | OS_CPU_CM3_NVIC_ST_CTRL_ENABLE;                        
    OS_CPU_CM3_NVIC_ST_CTRL  |= OS_CPU_CM3_NVIC_ST_CTRL_INTEN;
}

void  Systick_OsPeriod_Init (unsigned int ms)
{
    unsigned int TICKS_PER_SEC = 1000/ms;
    SysTick_Config(SystemCoreClock/TICKS_PER_SEC - 1);
}




