﻿#include "lcd_controller_manager.h"
#include "lcd_manager.h"
#include "lcd_7_0.h"

#define LCD_NUM 5

static p_lcd_params p_array_lcd[LCD_NUM];
static p_lcd_params g_p_lcd_selected;
/**********************************************************************
 * 函数名称： delay
 * 功能描述： 提供延时函数
 * 输入参数： 延时数值
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/26	     V1.0	  zh(angenao)	      创建
 ***********************************************************************/

void delay(volatile int d)
{
	while (d--);
}

/**********************************************************************
 * 函数名称： register_lcd
 * 功能描述： 注册LCD屏幕参数结构体
 * 输入参数： LCD屏幕参数结构体
 * 输出参数： 无
 * 返 回 值： 正常返回0
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/26	     V1.0	  zh(angenao)	      创建
 ***********************************************************************/

int register_lcd(p_lcd_params plcd)
{
	int i;
	for (i = 0; i < LCD_NUM; i++)
	{
		if (!p_array_lcd[i])
		{
			p_array_lcd[i] = plcd;
			return i;
		}
	}
	return -1;		
}

int select_lcd(char *name)
{
	int i;
	for (i = 0; i < LCD_NUM; i++)
	{
		if (p_array_lcd[i] && !strcmp(p_array_lcd[i]->name, name))
		{
			g_p_lcd_selected = p_array_lcd[i];
			return i;
		}
	}
	return -1;		
}		  			 		  						  					  				 	   		  	  	 	  
/**********************************************************************
 * 函数名称： get_lcd_params
 * 功能描述： 获取LCD屏幕相关参数
 * 输入参数： 无
 * 输出参数： 显存地址，分辨率x，分辨率y
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/26	     V1.0	  zh(angenao)	      创建
 ***********************************************************************/

void get_lcd_params(unsigned int *fb_base, int *xres, int *yres, int *bpp)
{
	*fb_base = g_p_lcd_selected->fb_base;
	*xres = g_p_lcd_selected->xres;
	*yres = g_p_lcd_selected->yres;
	*bpp = g_p_lcd_selected->bpp;
}

/**********************************************************************
 * 函数名称： lcd_enable
 * 功能描述： 调用下层的选中的LCD控制器的使能函数
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/26	     V1.0	  zh(angenao)	      创建
 ***********************************************************************/

void lcd_enable(void)
{
	lcd_controller_enable();
}
/**********************************************************************
 * 函数名称： lcd_disable
 * 功能描述： 调用下层的选中的LCD控制器的失能函数
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 正常返回0
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/26	     V1.0	  zh(angenao)	      创建
 ***********************************************************************/

void lcd_disable(void)
{
	lcd_controller_disable();
}
/**********************************************************************
 * 函数名称： lcd_init
 * 功能描述： LCD相关的初始化总入口
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 正常返回0
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/26	     V1.0	  zh(angenao)	      创建
 ***********************************************************************/

void lcd_init(void)
{
	/*添加LCD屏幕参数*/		
	lcd_7_0_add();
	
	/*添加LCD控制器*/		
	lcd_contoller_add();

	/*选择Imx6ull的LCD控制器*/		
	select_lcd_controller("Imx6ull");

	/*选择LCD屏幕参数*/		
	select_lcd("lcd_7.0");

	lcd_controller_init(g_p_lcd_selected);
}

