﻿#ifndef _LCD_MANAGER_H_
#define _LCD_MANAGER_H_

enum {
	NORMAL = 0,
	INVERT = 1,
};

/* NORMAL : 正常
 * INVERT : 取反
 */
typedef struct pins_polarity {
	int de;    /* normal: 高电平使能数据 */
	int vclk;  /* normal: 在下降沿获取数据 */
	int hsync; /* normal:高脉冲 */
	int vsync; /* normal:高脉冲  */
}pins_polarity, *p_pins_polarity;

typedef struct time_sequence {
	/* 垂直方向 */
	int tvp; /*  vysnc脉冲宽度 */
	int tvb; /*上边黑框 , Vertical Back porch */
	int tvf; /*下边黑框, Vertical Front porch */

	/* 水平方向 */
	int thp; /* hsync脉冲宽度 */
	int thb; /* 左边黑框 ,Horizontal Back porch */
	int thf; /* 右边黑框,Horizontal Front porch */

	int vclk;
}time_sequence, *p_time_sequence;


typedef struct lcd_params {
	
	char *name;
	
	/*引脚极性参数*/
	pins_polarity pins_pol;

	/*时序参数*/
	time_sequence time_seq;

	/*分辨率*/
	int xres;
	int yres;
	int bpp;

	/*显存*/
	unsigned int fb_base;
	
}lcd_params, *p_lcd_params;

/**********************************************************************
 * 函数名称： delay
 * 功能描述： 提供延时函数
 * 输入参数： 延时数值
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/26	     V1.0	  zh(angenao)	      创建
 ***********************************************************************/

void delay(volatile int d);

/**********************************************************************
 * 函数名称： register_lcd
 * 功能描述： 注册LCD屏幕参数结构体
 * 输入参数： LCD屏幕参数结构体
 * 输出参数： 无
 * 返 回 值： 正常返回0
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/26	     V1.0	  zh(angenao)	      创建
 ***********************************************************************/

int register_lcd(p_lcd_params plcd);

/**********************************************************************
 * 函数名称： get_lcd_params
 * 功能描述： 获取LCD屏幕相关参数
 * 输入参数： 无
 * 输出参数： 显存地址，分辨率x，分辨率y
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/26	     V1.0	  zh(angenao)	      创建
 ***********************************************************************/

void get_lcd_params(unsigned int *fb_base, int *xres, int *yres, int *bpp);

/**********************************************************************
 * 函数名称： lcd_enable
 * 功能描述： 调用下层的选中的LCD控制器的使能函数
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/26	     V1.0	  zh(angenao)	      创建
 ***********************************************************************/

void lcd_enable(void);
/**********************************************************************
 * 函数名称： lcd_disable
 * 功能描述： 调用下层的选中的LCD控制器的失能函数
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 正常返回0
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/26	     V1.0	  zh(angenao)	      创建
 ***********************************************************************/

void lcd_disable(void);
/**********************************************************************
 * 函数名称： lcd_init
 * 功能描述： LCD相关的初始化总入口
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 正常返回0
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/26	     V1.0	  zh(angenao)	      创建
 ***********************************************************************/

void lcd_init(void);

#endif 


